/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api.marker;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.marker.ExtrudeMarker;
import de.bluecolored.bluemap.api.marker.HtmlMarker;
import de.bluecolored.bluemap.api.marker.Line;
import de.bluecolored.bluemap.api.marker.LineMarker;
import de.bluecolored.bluemap.api.marker.Marker;
import de.bluecolored.bluemap.api.marker.POIMarker;
import de.bluecolored.bluemap.api.marker.Shape;
import de.bluecolored.bluemap.api.marker.ShapeMarker;
import java.util.Collection;
import java.util.Optional;

public interface MarkerSet {
    public String getId();

    public String getLabel();

    public void setLabel(String var1);

    public boolean isToggleable();

    public void setToggleable(boolean var1);

    default public boolean isDefautHidden() {
        return this.isDefaultHidden();
    }

    public boolean isDefaultHidden();

    public void setDefaultHidden(boolean var1);

    public Collection<Marker> getMarkers();

    public Optional<Marker> getMarker(String var1);

    public POIMarker createPOIMarker(String var1, BlueMapMap var2, Vector3d var3);

    default public POIMarker createPOIMarker(String id, BlueMapMap map, double posX, double posY, double posZ) {
        return this.createPOIMarker(id, map, new Vector3d(posX, posY, posZ));
    }

    public HtmlMarker createHtmlMarker(String var1, BlueMapMap var2, Vector3d var3, String var4);

    default public HtmlMarker createHtmlMarker(String id, BlueMapMap map, double posX, double posY, double posZ, String html) {
        return this.createHtmlMarker(id, map, new Vector3d(posX, posY, posZ), html);
    }

    public ShapeMarker createShapeMarker(String var1, BlueMapMap var2, Vector3d var3, Shape var4, float var5);

    default public ShapeMarker createShapeMarker(String id, BlueMapMap map, double posX, double posY, double posZ, Shape shape, float y) {
        return this.createShapeMarker(id, map, new Vector3d(posX, posY, posZ), shape, y);
    }

    default public ShapeMarker createShapeMarker(String id, BlueMapMap map, Shape shape, float y) {
        Vector2d center = shape.getMin().add(shape.getMax()).div(2.0f);
        return this.createShapeMarker(id, map, new Vector3d(center.getX(), (double)y, center.getY()), shape, y);
    }

    public ExtrudeMarker createExtrudeMarker(String var1, BlueMapMap var2, Vector3d var3, Shape var4, float var5, float var6);

    default public ExtrudeMarker createExtrudeMarker(String id, BlueMapMap map, double posX, double posY, double posZ, Shape shape, float minY, float maxY) {
        return this.createExtrudeMarker(id, map, new Vector3d(posX, posY, posZ), shape, minY, maxY);
    }

    default public ExtrudeMarker createExtrudeMarker(String id, BlueMapMap map, Shape shape, float minY, float maxY) {
        Vector2d center = shape.getMin().add(shape.getMax()).div(2.0f);
        float y = (minY + maxY) / 2.0f;
        return this.createExtrudeMarker(id, map, new Vector3d(center.getX(), (double)y, center.getY()), shape, minY, maxY);
    }

    public LineMarker createLineMarker(String var1, BlueMapMap var2, Vector3d var3, Line var4);

    default public LineMarker createLineMarker(String id, BlueMapMap map, double posX, double posY, double posZ, Line line) {
        return this.createLineMarker(id, map, new Vector3d(posX, posY, posZ), line);
    }

    default public LineMarker createLineMarker(String id, BlueMapMap map, Line line) {
        Vector3d center = line.getMin().add(line.getMax()).div(2.0f);
        return this.createLineMarker(id, map, center, line);
    }

    default public boolean removeMarker(Marker marker) {
        return this.removeMarker(marker.getId());
    }

    public boolean removeMarker(String var1);
}

