/*
 * Decompiled with CFR 0.152.
 */
package lib.blockIo;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import lib.blockIo.Helper;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.ECKey;
import org.bouncycastle.util.encoders.Hex;
import org.json.simple.JSONObject;

public class Key
extends ECKey {
    public static ECKey fromWif(String PrivKey) throws Exception {
        byte[] extendedKeyBytes = Base58.decodeChecked((String)PrivKey);
        if ((extendedKeyBytes = Arrays.copyOfRange(extendedKeyBytes, 1, extendedKeyBytes.length - 1)).length == 33) {
            if (extendedKeyBytes[32] != 1) {
                throw new Exception("Invalid compression flag");
            }
            extendedKeyBytes = Arrays.copyOfRange(extendedKeyBytes, 0, extendedKeyBytes.length - 1);
        }
        if (extendedKeyBytes.length != 32) {
            throw new Exception("Invalid WIF payload length");
        }
        return ECKey.fromPrivate((byte[])extendedKeyBytes);
    }

    public static ECKey dynamicExtractKey(JSONObject userKey, String secretPin) throws Exception {
        JSONObject algorithm;
        JSONObject jSONObject = algorithm = userKey.get((Object)"algorithm") == null ? new JSONObject() : (JSONObject)userKey.get((Object)"algorithm");
        if (algorithm.isEmpty()) {
            algorithm = new JSONObject();
            algorithm.put((Object)"pbkdf2_salt", (Object)"");
            algorithm.put((Object)"pbkdf2_iterations", (Object)2048);
            algorithm.put((Object)"pbkdf2_hash_function", (Object)"SHA256");
            algorithm.put((Object)"pbkdf2_phase1_key_length", (Object)16);
            algorithm.put((Object)"pbkdf2_phase2_key_length", (Object)32);
            algorithm.put((Object)"aes_iv", null);
            algorithm.put((Object)"aes_cipher", (Object)"AES-256-ECB");
            algorithm.put((Object)"aes_auth_tag", null);
            algorithm.put((Object)"aes_auth_data", null);
        }
        String B64Key = Helper.pinToAesKey(secretPin, algorithm.get((Object)"pbkdf2_salt").toString(), Integer.parseInt(algorithm.get((Object)"pbkdf2_iterations").toString()), Integer.parseInt(algorithm.get((Object)"pbkdf2_phase1_key_length").toString()), Integer.parseInt(algorithm.get((Object)"pbkdf2_phase2_key_length").toString()), algorithm.get((Object)"pbkdf2_hash_function").toString());
        String Decrypted = Helper.decrypt(userKey.get((Object)"encrypted_passphrase").toString(), B64Key, algorithm.get((Object)"aes_iv") == null ? null : algorithm.get((Object)"aes_iv").toString(), algorithm.get((Object)"aes_cipher") == null ? null : algorithm.get((Object)"aes_cipher").toString(), algorithm.get((Object)"aes_auth_tag") == null ? null : algorithm.get((Object)"aes_auth_tag").toString(), algorithm.get((Object)"aes_auth_data") == null ? null : algorithm.get((Object)"aes_auth_data").toString());
        return Key.extractKeyFromPassphrase(Decrypted);
    }

    public static ECKey extractKeyFromEncryptedPassphrase(String encryptedData, String b64Key) throws Exception {
        String decrypted = Helper.decrypt(encryptedData, b64Key);
        return Key.extractKeyFromPassphrase(decrypted);
    }

    public static ECKey extractKeyFromPassphrase(String hexPass) throws NoSuchAlgorithmException {
        byte[] unHexlified = Hex.decode((String)hexPass);
        byte[] hashed = Helper.sha256Hash(unHexlified);
        return ECKey.fromPrivate((byte[])hashed);
    }

    public static ECKey extractKeyFromPassphraseString(String pass) throws NoSuchAlgorithmException {
        byte[] password = pass.getBytes(StandardCharsets.UTF_8);
        byte[] hashed = Helper.sha256Hash(password);
        return ECKey.fromPrivate((byte[])hashed);
    }

    public static ECKey fromHex(String privKeyHex) {
        byte[] hexBytes = Hex.decode((String)String.format("%64s", privKeyHex).replace(' ', '0'));
        return ECKey.fromPrivate((byte[])hexBytes);
    }
}

