/*
 * Decompiled with CFR 0.152.
 */
package lib.blockIo;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import lib.blockIo.Helper;
import lib.blockIo.JsonUtils;
import lib.blockIo.Key;
import lib.blockIo.Options;
import okhttp3.ConnectionSpec;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.TlsVersion;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionWitness;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bouncycastle.util.encoders.Hex;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.libdohj.params.DogecoinMainNetParams;
import org.libdohj.params.DogecoinTestNet3Params;
import org.libdohj.params.LitecoinMainNetParams;
import org.libdohj.params.LitecoinTestNet3Params;

public class BlockIo {
    private OkHttpClient RestClient;
    private String ApiUrl;
    private Options Opts;
    private String ApiKey;
    private int Version;
    private String Server;
    private String Port;
    private String Pin;
    private String AesKey;
    private int DefaultVersion = 2;
    private String DefaultServer = "";
    private String DefaultPort = "";
    private String Host = "block.io";
    private String UserAgent;
    private NetworkParameters networkParams = null;
    HashMap<String, ECKey> userKeys = new HashMap();

    public BlockIo(String apiKey) throws Exception {
        this(apiKey, null, 2, new Options());
    }

    public BlockIo(String apiKey, String pin) throws Exception {
        this(apiKey, pin, 2, new Options());
    }

    public BlockIo(String apiKey, String pin, int version) throws Exception {
        this(apiKey, pin, version, new Options());
    }

    public BlockIo(String apiKey, String pin, int version, Options opts) throws Exception {
        String libVersion = this.getClass().getPackage().getImplementationVersion();
        this.UserAgent = String.join((CharSequence)":", "java", "block_io", libVersion);
        this.Opts = opts;
        this.Pin = pin == null || pin.equals("") ? null : pin;
        this.AesKey = null;
        this.ApiUrl = null;
        this.ApiKey = apiKey;
        this.Version = version;
        this.Server = this.DefaultServer;
        this.Port = this.DefaultPort;
        if (this.Pin != null) {
            this.AesKey = Helper.pinToAesKey(this.Pin);
        }
        if (!this.Opts.getApiUrl().equals("")) {
            this.ApiUrl = this.Opts.getApiUrl() + "/api/v2";
        }
        Object serverString = !this.Server.equals("") ? this.Server + "." : this.Server;
        Object portString = !this.Port.equals("") ? ":" + this.Port : this.Port;
        this.ApiUrl = this.ApiUrl == null ? "https://" + (String)serverString + this.Host + (String)portString + "/api/v" + this.Version : this.ApiUrl;
        ConnectionSpec requireTls12 = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
        this.RestClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(requireTls12, ConnectionSpec.CLEARTEXT)).build();
    }

    public JSONObject CreateAndSignTransaction(JSONObject data) throws Exception {
        return this.CreateAndSignTransaction(data, new String[0]);
    }

    public JSONObject CreateAndSignTransaction(JSONObject data, String[] keys) throws Exception {
        String networkString;
        String status = data.containsKey((Object)"status") ? data.get((Object)"status").toString() : "";
        JSONObject dataObj = (JSONObject)data.get((Object)"data");
        String string = networkString = dataObj.containsKey((Object)"network") ? dataObj.get((Object)"network").toString() : "";
        if (this.networkParams == null && !status.equals("") && status.equals("success") && !dataObj.isEmpty() && !networkString.equals("")) {
            this.networkParams = this.getNetwork(networkString);
        }
        JSONArray inputs = (JSONArray)dataObj.get((Object)"inputs");
        JSONArray outputs = (JSONArray)dataObj.get((Object)"outputs");
        JSONArray inputAddressData = (JSONArray)dataObj.get((Object)"input_address_data");
        Transaction tx = new Transaction(this.networkParams);
        for (Object input : inputs) {
            JSONObject curInput = (JSONObject)input;
            Sha256Hash preTxId = Sha256Hash.wrap((String)curInput.get((Object)"previous_txid").toString());
            int outputIndex = Integer.parseInt(curInput.get((Object)"previous_output_index").toString());
            tx.addInput(preTxId, (long)outputIndex, ScriptBuilder.createEmpty()).clearScriptBytes();
        }
        for (Object output : outputs) {
            JSONObject curOutput = (JSONObject)output;
            Address receivingAddr = Address.fromString((NetworkParameters)this.networkParams, (String)curOutput.get((Object)"receiving_address").toString());
            Coin outputValue = Coin.parseCoin((String)curOutput.get((Object)"output_value").toString());
            tx.addOutput(outputValue, receivingAddr);
        }
        String txHex = Helper.txToHexString(tx);
        HashMap<String, JSONObject> addressDataMap = new HashMap<String, JSONObject>();
        HashMap<String, Script> addressScriptMap = new HashMap<String, Script>();
        for (Object inputAddressDatum : inputAddressData) {
            Script redeem;
            JSONObject curInputAddrData = (JSONObject)inputAddressDatum;
            JSONObject curAddrData = new JSONObject();
            String curAddrType = curInputAddrData.get((Object)"address_type").toString();
            int requiredSigs = Integer.parseInt(curInputAddrData.get((Object)"required_signatures").toString());
            JSONArray pubkeys = (JSONArray)curInputAddrData.get((Object)"public_keys");
            curAddrData.put((Object)"required_signatures", (Object)requiredSigs);
            curAddrData.put((Object)"public_keys", (Object)pubkeys);
            curAddrData.put((Object)"address_type", (Object)curAddrType);
            addressDataMap.put(curInputAddrData.get((Object)"address").toString(), curAddrData);
            ArrayList<ECKey> pubkeyList = new ArrayList<ECKey>();
            for (Object pubkey : pubkeys) {
                ECKey curPubKey = ECKey.fromPublicOnly((byte[])Hex.decode((String)pubkey.toString()));
                pubkeyList.add(curPubKey);
            }
            if (curAddrType.equals("P2WSH-over-P2SH") || curAddrType.equals("WITNESS_V0") || curAddrType.equals("P2SH")) {
                redeem = ScriptBuilder.createMultiSigOutputScript((int)requiredSigs, pubkeyList);
            } else if (curAddrType.equals("P2PKH") || curAddrType.equals("P2WPKH") || curAddrType.equals("P2WPKH-over-P2SH")) {
                redeem = ScriptBuilder.createP2PKHOutputScript((ECKey)((ECKey)pubkeyList.get(0)));
            } else {
                throw new Exception("Unrecognized address type: " + curAddrType);
            }
            addressScriptMap.put(curInputAddrData.get((Object)"address").toString(), redeem);
        }
        if (keys.length > 0) {
            for (String key : keys) {
                ECKey userKey = Key.fromHex(key);
                this.userKeys.put(userKey.getPublicKeyAsHex(), userKey);
            }
        }
        if (dataObj.containsKey((Object)"user_key") && !this.userKeys.containsKey(((JSONObject)dataObj.get((Object)"user_key")).get((Object)"public_key").toString())) {
            if (this.Pin != null) {
                String pubkeyStr = ((JSONObject)dataObj.get((Object)"user_key")).get((Object)"public_key").toString();
                ECKey key = Key.dynamicExtractKey((JSONObject)dataObj.get((Object)"user_key"), this.Pin);
                if (!key.getPublicKeyAsHex().equals(pubkeyStr)) {
                    throw new Exception("Fail: Invalid Secret PIN provided.");
                }
                this.userKeys.put(pubkeyStr, key);
            } else {
                throw new Exception("Fail: No PIN provided to decrypt private key.");
            }
        }
        if (dataObj.containsKey((Object)"expected_unsigned_txid") && !dataObj.get((Object)"expected_unsigned_txid").toString().equals(tx.getTxId().toString())) {
            throw new Exception("Expected unsigned transaction ID mismatch. Please report this error to support@block.io.");
        }
        boolean isTxFullySigned = true;
        JSONArray signatures = new JSONArray();
        for (Object input : inputs) {
            Script inputScript;
            JSONObject curInput = (JSONObject)input;
            String curAddr = curInput.get((Object)"spending_address").toString();
            Script curAddrScript = (Script)addressScriptMap.get(curAddr);
            String curAddrType = ((JSONObject)addressDataMap.get(curAddr)).get((Object)"address_type").toString();
            int addrRequiredSigs = Integer.parseInt(((JSONObject)addressDataMap.get(curAddr)).get((Object)"required_signatures").toString());
            JSONArray curPubKeys = (JSONArray)((JSONObject)addressDataMap.get(curAddr)).get((Object)"public_keys");
            int curSigCount = 0;
            int inputIte = Integer.parseInt(curInput.get((Object)"input_index").toString());
            Coin inputValue = Coin.parseCoin((String)curInput.get((Object)"input_value").toString());
            Sha256Hash sigHash = curAddrType.equals("P2WSH-over-P2SH") || curAddrType.equals("WITNESS_V0") || curAddrType.equals("P2WPKH") || curAddrType.equals("P2WPKH-over-P2SH") ? tx.hashForWitnessSignature(inputIte, curAddrScript, inputValue, Transaction.SigHash.ALL, false) : tx.hashForSignature(inputIte, curAddrScript, Transaction.SigHash.ALL, false);
            ArrayList<TransactionSignature> txSigList = new ArrayList<TransactionSignature>();
            ArrayList<ECKey> curKeys = new ArrayList<ECKey>();
            for (Object pubkey : curPubKeys) {
                String pubkeyStr = pubkey.toString();
                if (!this.userKeys.containsKey(pubkeyStr)) continue;
                ECKey key = this.userKeys.get(pubkeyStr);
                ECKey.ECDSASignature sig = key.sign(sigHash);
                TransactionSignature txSig = new TransactionSignature(sig, Transaction.SigHash.ALL, false);
                txSigList.add(txSig);
                curKeys.add(key);
                JSONObject sigObj = new JSONObject();
                sigObj.put((Object)"input_index", (Object)inputIte);
                sigObj.put((Object)"public_key", (Object)pubkeyStr);
                sigObj.put((Object)"signature", (Object)Hex.toHexString((byte[])txSig.encodeToDER()));
                signatures.add((Object)sigObj);
                ++curSigCount;
            }
            if (curAddrType.equals("P2WSH-over-P2SH")) {
                tx.getInput((long)inputIte).setScriptSig(Helper.createBlockIoP2WSHScript(curAddrScript));
                tx.getInput((long)inputIte).setWitness(Helper.redeemP2WSH(txSigList, curAddrScript));
            } else if (curAddrType.equals("WITNESS_V0")) {
                tx.getInput((long)inputIte).setWitness(Helper.redeemP2WSH(txSigList, curAddrScript));
            } else if (curAddrType.equals("P2WPKH")) {
                tx.getInput((long)inputIte).setWitness(TransactionWitness.redeemP2WPKH((TransactionSignature)txSigList.get(0), (ECKey)((ECKey)curKeys.get(0))));
            } else if (curAddrType.equals("P2WPKH-over-P2SH")) {
                Script redeem = ScriptBuilder.createP2WPKHOutputScript((ECKey)((ECKey)curKeys.get(0)));
                tx.getInput((long)inputIte).setScriptSig(Helper.createBlockIoP2WPKHScript(redeem));
                tx.getInput((long)inputIte).setWitness(TransactionWitness.redeemP2WPKH((TransactionSignature)txSigList.get(0), (ECKey)((ECKey)curKeys.get(0))));
            } else if (curAddrType.equals("P2SH")) {
                inputScript = ScriptBuilder.createP2SHMultiSigInputScript(txSigList, (Script)curAddrScript);
                tx.getInput((long)inputIte).setScriptSig(inputScript);
            } else {
                inputScript = ScriptBuilder.createInputScript((TransactionSignature)txSigList.get(0), (ECKey)((ECKey)curKeys.get(0)));
                tx.getInput((long)inputIte).setScriptSig(inputScript);
            }
            if (curSigCount >= addrRequiredSigs) continue;
            isTxFullySigned = false;
        }
        JSONObject createAndSignResponse = new JSONObject();
        if (isTxFullySigned) {
            txHex = Helper.txToHexString(tx);
            signatures = null;
        }
        createAndSignResponse.put((Object)"tx_type", (Object)dataObj.get((Object)"tx_type").toString());
        createAndSignResponse.put((Object)"tx_hex", (Object)txHex);
        createAndSignResponse.put((Object)"signatures", (Object)signatures);
        this.userKeys.clear();
        return createAndSignResponse;
    }

    public JSONObject SummarizePreparedTransaction(JSONObject data) {
        JSONObject dataObj = (JSONObject)data.get((Object)"data");
        JSONArray inputs = (JSONArray)dataObj.get((Object)"inputs");
        JSONArray outputs = (JSONArray)dataObj.get((Object)"outputs");
        double inputSum = 0.0;
        double blockIoFee = 0.0;
        double changeAmount = 0.0;
        double outputSum = 0.0;
        for (Object input : inputs) {
            String inputValue = ((JSONObject)input).get((Object)"input_value").toString();
            inputSum += Double.parseDouble(inputValue);
        }
        for (Object output : outputs) {
            String outputCategory = ((JSONObject)output).get((Object)"output_category").toString();
            String value = ((JSONObject)output).get((Object)"output_value").toString();
            if (outputCategory.equals("blockio-fee")) {
                blockIoFee += Double.parseDouble(value);
                continue;
            }
            if (outputCategory.equals("change")) {
                changeAmount += Double.parseDouble(value);
                continue;
            }
            outputSum += Double.parseDouble(value);
        }
        double networkFee = inputSum - outputSum - changeAmount - blockIoFee;
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setMinimumFractionDigits(8);
        JSONObject response = new JSONObject();
        response.put((Object)"network", dataObj.get((Object)"network"));
        response.put((Object)"network_fee", (Object)format.format(networkFee));
        response.put((Object)"blockio_fee", (Object)format.format(blockIoFee));
        response.put((Object)"total_amount_to_send", (Object)format.format(outputSum));
        return response;
    }

    private NetworkParameters getNetwork(String networkString) {
        switch (networkString) {
            case "LTC": {
                return LitecoinMainNetParams.get();
            }
            case "DOGE": {
                return DogecoinMainNetParams.get();
            }
            case "BTCTEST": {
                return NetworkParameters.fromID((String)"org.bitcoin.test");
            }
            case "LTCTEST": {
                return LitecoinTestNet3Params.get();
            }
            case "DOGETEST": {
                return DogecoinTestNet3Params.get();
            }
        }
        return NetworkParameters.fromID((String)"org.bitcoin.production");
    }

    private JSONObject _prepare_sweep_transaction(String method, String path, JSONObject args) throws Exception {
        if (args.get((Object)"private_key") == null) {
            throw new Exception("Missing mandatory private_key argument.");
        }
        if (args.get((Object)"to_address") == null) {
            throw new Exception("Missing mandatory to_address argument.");
        }
        String privKeyStr = args.get((Object)"private_key").toString();
        ECKey keyFromWif = Key.fromWif(privKeyStr);
        args.put((Object)"public_key", (Object)keyFromWif.getPublicKeyAsHex());
        args.put((Object)"private_key", (Object)"");
        this.userKeys.put(keyFromWif.getPublicKeyAsHex(), keyFromWif);
        return this._request(method, path, args.toJSONString());
    }

    private JSONObject _request(String method, String path, String args) throws Exception {
        Request request;
        Request.Builder builder = new Request.Builder().addHeader("User-Agent", this.UserAgent).url(this.constructUrl(path));
        if (method.equals("POST")) {
            MediaType type = MediaType.get((String)"application/json; charset=utf-8");
            RequestBody body = RequestBody.create((String)args, (MediaType)type);
            request = builder.addHeader("Accept", "application/json").post(body).build();
        } else {
            request = builder.build();
        }
        Response response = this.RestClient.newCall(request).execute();
        assert (response.body() != null);
        String res = Objects.requireNonNull(response.body()).string();
        this.RestClient.dispatcher().executorService().shutdown();
        this.RestClient.connectionPool().evictAll();
        return JsonUtils.parseJson(res);
    }

    private String constructUrl(String path) {
        return this.ApiUrl + "/" + path + "?api_key=" + this.ApiKey;
    }

    public JSONObject GetNewAddress(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_new_address", argsJson);
    }

    public JSONObject GetBalance(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("GET", "get_balance", argsJson);
    }

    public JSONObject GetMyAddresses(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_my_addresses", argsJson);
    }

    public JSONObject GetAddressReceived(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_address_received", argsJson);
    }

    public JSONObject GetAddressByLabel(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_address_by_label", argsJson);
    }

    public JSONObject GetAddressBalance(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_address_balance", argsJson);
    }

    public JSONObject CreateUser(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "create_user", argsJson);
    }

    public JSONObject GetUsers(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_users", argsJson);
    }

    public JSONObject GetUserBalance(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_user_balance", argsJson);
    }

    public JSONObject GetUserAddress(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_user_address", argsJson);
    }

    public JSONObject GetUserReceived(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_user_received", argsJson);
    }

    public JSONObject GetTransactions(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_transactions", argsJson);
    }

    public JSONObject GetNewDtrustAddress(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_new_dtrust_address", argsJson);
    }

    public JSONObject GetMyDtrustAddresses(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_my_dtrust_addresses", argsJson);
    }

    public JSONObject GetDtrustAddressByLabel(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_dtrust_address_by_label", argsJson);
    }

    public JSONObject GetDtrustTransactions(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_dtrust_transactions", argsJson);
    }

    public JSONObject GetDtrustAddressBalance(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_dtrust_address_balance", argsJson);
    }

    public JSONObject GetNetworkFeeEstimate(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_network_fee_estimate", argsJson);
    }

    public JSONObject ArchiveAddress(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "archive_address", argsJson);
    }

    public JSONObject UnarchiveAddress(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "unarchive_address", argsJson);
    }

    public JSONObject GetMyArchivedAddresses(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_my_archived_addresses", argsJson);
    }

    public JSONObject ArchiveDtrustAddress(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "archive_dtrust_address", argsJson);
    }

    public JSONObject UnarchiveDtrustAddress(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "unarchive_dtrust_address", argsJson);
    }

    public JSONObject GetMyArchivedDtrustAddresses(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_my_archived_dtrust_addresses", argsJson);
    }

    public JSONObject GetDtrustNetworkFeeEstimate(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_dtrust_network_fee_estimate", argsJson);
    }

    public JSONObject CreateNotification(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "create_notification", argsJson);
    }

    public JSONObject DisableNotification(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "disable_notification", argsJson);
    }

    public JSONObject EnableNotification(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "enable_notification", argsJson);
    }

    public JSONObject GetNotifications(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_notifications", argsJson);
    }

    public JSONObject GetRecentNotificationEvents(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_recent_notification_events", argsJson);
    }

    public JSONObject DeleteNotification(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "delete_notification", argsJson);
    }

    public JSONObject ValidateApiKey(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "validate_api_key", argsJson);
    }

    public JSONObject SignTransation(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "sign_transaction", argsJson);
    }

    public JSONObject FinalizeTransaction(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "finalize_transaction", argsJson);
    }

    public JSONObject GetMyAddressesWithoutBalances(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_my_addresses_without_balances", argsJson);
    }

    public JSONObject GetRawTransaction(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_raw_transaction", argsJson);
    }

    public JSONObject GetDtrustBalance(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_dtrust_balance", argsJson);
    }

    public JSONObject ArchiveAddresses(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "archive_addresses", argsJson);
    }

    public JSONObject UnarchiveAddresses(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "unarchive_addresses", argsJson);
    }

    public JSONObject ArchiveDtrustAddresses(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "archive_dtrust_addresses", argsJson);
    }

    public JSONObject UnarchiveDtrustAddresses(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "unarchive_dtrust_addresses", argsJson);
    }

    public JSONObject IsValidAddress(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "is_valid_address", argsJson);
    }

    public JSONObject GetCurrentPrice(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_current_price", argsJson);
    }

    public JSONObject GetAccountInfo(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "get_account_info", argsJson);
    }

    public JSONObject PrepareTransaction(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "prepare_transaction", argsJson);
    }

    public JSONObject PrepareDtrustTransaction(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "prepare_dtrust_transaction", argsJson);
    }

    public JSONObject SubmitTransaction(JSONObject args) throws Exception {
        String argsJson = args != null ? args.toJSONString() : "";
        return this._request("POST", "submit_transaction", argsJson);
    }

    public JSONObject PrepareSweepTransaction(JSONObject args) throws Exception {
        return this._prepare_sweep_transaction("POST", "prepare_sweep_transaction", args);
    }
}

