/*
 * Decompiled with CFR 0.152.
 */
package com.blackcat.currencyedittext;

import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import com.blackcat.currencyedittext.CurrencyEditText;
import com.blackcat.currencyedittext.CurrencyTextFormatter;
import java.util.Currency;
import java.util.Locale;

class CurrencyTextWatcher
implements TextWatcher {
    private CurrencyEditText editText;
    private Locale defaultLocale;
    private boolean ignoreIteration;
    private String lastGoodInput;
    double CURRENCY_DECIMAL_DIVISOR;
    final int CURSOR_SPACING_COMPENSATION = 2;
    final int MAX_RAW_INPUT_LENGTH = 15;

    public CurrencyTextWatcher(CurrencyEditText textBox) {
        this(textBox, Locale.US);
    }

    public CurrencyTextWatcher(CurrencyEditText textBox, Locale defaultLocale) {
        this.editText = textBox;
        this.lastGoodInput = "";
        this.ignoreIteration = false;
        this.defaultLocale = defaultLocale;
        try {
            this.CURRENCY_DECIMAL_DIVISOR = (int)Math.pow(10.0, Currency.getInstance(this.editText.getLocale()).getDefaultFractionDigits());
        }
        catch (IllegalArgumentException e) {
            Log.e((String)"CurrencyTextWatcher", (String)("Unsupported locale provided, defaulting to Locale.US. Error: " + e.getMessage()));
            this.CURRENCY_DECIMAL_DIVISOR = (int)Math.pow(10.0, Currency.getInstance(defaultLocale).getDefaultFractionDigits());
        }
    }

    public void afterTextChanged(Editable editable) {
        if (!this.ignoreIteration) {
            String textToDisplay;
            this.ignoreIteration = true;
            String newText = editable.toString();
            String string = newText = this.editText.areNegativeValuesAllowed() ? newText.replaceAll("[^0-9/-]", "") : newText.replaceAll("[^0-9]", "");
            if (!newText.equals("") && newText.length() < 15 && !newText.equals("-")) {
                this.editText.setValueInLowestDenom(Long.valueOf(newText));
            }
            try {
                textToDisplay = CurrencyTextFormatter.formatText(newText, this.editText.getCurrency(), this.editText.getLocale(), this.defaultLocale);
            }
            catch (IllegalArgumentException exception) {
                textToDisplay = this.lastGoodInput;
            }
            this.editText.setText(textToDisplay);
            this.lastGoodInput = textToDisplay;
            int cursorPosition = this.editText.getText().length();
            if (textToDisplay.length() > 0 && Character.isDigit(textToDisplay.charAt(0))) {
                cursorPosition -= 2;
            }
            this.editText.setSelection(cursorPosition);
        } else {
            this.ignoreIteration = false;
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence charSequence, int start, int before, int count) {
    }
}

