/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.domain.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.whatsapp.api.domain.messages.BodyComponent;
import com.whatsapp.api.domain.messages.ButtonComponent;
import com.whatsapp.api.domain.messages.HeaderComponent;
import com.whatsapp.api.domain.messages.Parameter;
import com.whatsapp.api.domain.messages.type.ComponentType;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ButtonComponent.class, name="button"), @JsonSubTypes.Type(value=HeaderComponent.class, name="header"), @JsonSubTypes.Type(value=BodyComponent.class, name="body")})
public abstract class Component<T extends Component<T>> {
    @JsonProperty(value="type")
    private final ComponentType type;
    @JsonProperty(value="parameters")
    private List<Parameter> parameters;

    @JsonCreator
    protected Component(ComponentType type) {
        this.type = type;
    }

    public ComponentType getType() {
        return this.type;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Component<T> setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Component<T> addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
        return this;
    }
}

