/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.impl;

import com.whatsapp.api.WhatsappApiServiceGenerator;
import com.whatsapp.api.configuration.ApiVersion;
import com.whatsapp.api.configuration.WhatsappApiConfig;
import com.whatsapp.api.domain.config.CommerceDataItem;
import com.whatsapp.api.domain.config.GraphCommerceSettings;
import com.whatsapp.api.domain.phone.PhoneNumber;
import com.whatsapp.api.domain.phone.PhoneNumbers;
import com.whatsapp.api.domain.phone.RequestCode;
import com.whatsapp.api.domain.phone.VerifyCode;
import com.whatsapp.api.domain.response.Response;
import com.whatsapp.api.domain.templates.MessageTemplate;
import com.whatsapp.api.domain.templates.response.MessageTemplates;
import com.whatsapp.api.domain.templates.response.Template;
import com.whatsapp.api.service.WhatsappBusinessManagementApiService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class WhatsappBusinessManagementApi {
    private final ApiVersion apiVersion;
    private final WhatsappBusinessManagementApiService whatsappBusinessManagementApiService;

    public WhatsappBusinessManagementApi(String token) {
        this.apiVersion = WhatsappApiConfig.getApiVersion();
        this.whatsappBusinessManagementApiService = WhatsappApiServiceGenerator.createService(WhatsappBusinessManagementApiService.class, token);
    }

    public WhatsappBusinessManagementApi(String token, ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        this.whatsappBusinessManagementApiService = WhatsappApiServiceGenerator.createService(WhatsappBusinessManagementApiService.class, token);
    }

    public Template createMessageTemplate(String whatsappBusinessAccountId, MessageTemplate messageTemplate) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.createMessageTemplate(this.apiVersion.getValue(), whatsappBusinessAccountId, messageTemplate));
    }

    public Template updateMessageTemplate(String whatsappBusinessAccountId, String messageTemplateId, MessageTemplate messageTemplate) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.updateMessageTemplate(this.apiVersion.getValue(), whatsappBusinessAccountId, messageTemplateId, messageTemplate));
    }

    public Response deleteMessageTemplate(String whatsappBusinessAccountId, String name) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.deleteMessageTemplate(this.apiVersion.getValue(), whatsappBusinessAccountId, name));
    }

    public MessageTemplates retrieveTemplates(String whatsappBusinessAccountId) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrieveTemplates(this.apiVersion.getValue(), whatsappBusinessAccountId));
    }

    public MessageTemplates retrieveTemplates(String whatsappBusinessAccountId, int limit) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrieveTemplates(this.apiVersion.getValue(), whatsappBusinessAccountId, Map.of("limit", limit)));
    }

    public MessageTemplates retrieveTemplates(String whatsappBusinessAccountId, String templateName) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrieveTemplates(this.apiVersion.getValue(), whatsappBusinessAccountId, Map.of("name", templateName)));
    }

    public MessageTemplates retrieveTemplates(String whatsappBusinessAccountId, int limit, String after) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrieveTemplates(this.apiVersion.getValue(), whatsappBusinessAccountId, Map.of("limit", limit, "after", after)));
    }

    public PhoneNumber retrievePhoneNumber(String phoneNumberId) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrievePhoneNumber(this.apiVersion.getValue(), phoneNumberId, new HashMap<String, Object>()));
    }

    public PhoneNumber retrievePhoneNumber(String phoneNumberId, String ... fields) {
        Objects.requireNonNull(fields, "fields cannot be null");
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrievePhoneNumber(this.apiVersion.getValue(), phoneNumberId, Map.of("fields", String.join((CharSequence)",", fields))));
    }

    public PhoneNumbers retrievePhoneNumbers(String whatsappBusinessAccountId) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.retrievePhoneNumbers(this.apiVersion.getValue(), whatsappBusinessAccountId));
    }

    public Response requestCode(String phoneNumberId, RequestCode requestCode) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.requestCode(this.apiVersion.getValue(), phoneNumberId, requestCode));
    }

    public Response verifyCode(String phoneNumberId, VerifyCode verifyCode) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.verifyCode(this.apiVersion.getValue(), phoneNumberId, verifyCode));
    }

    public GraphCommerceSettings getWhatsappCommerceSettings(String phoneNumberId, String ... fields) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.getWhatsappCommerceSettings(this.apiVersion.getValue(), phoneNumberId, Map.of("fields", String.join((CharSequence)",", fields))));
    }

    public Response updateWhatsappCommerceSettings(String phoneNumberId, CommerceDataItem commerceDataItem) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessManagementApiService.updateWhatsappCommerceSettings(this.apiVersion.getValue(), phoneNumberId, commerceDataItem));
    }
}

