/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.impl;

import com.whatsapp.api.WhatsappApiServiceGenerator;
import com.whatsapp.api.domain.media.FileType;
import com.whatsapp.api.domain.media.Media;
import com.whatsapp.api.domain.media.MediaFile;
import com.whatsapp.api.domain.media.UploadResponse;
import com.whatsapp.api.domain.messages.Message;
import com.whatsapp.api.domain.messages.ReadMessage;
import com.whatsapp.api.domain.messages.response.MessageResponse;
import com.whatsapp.api.domain.phone.TwoStepCode;
import com.whatsapp.api.domain.response.Response;
import com.whatsapp.api.service.WhatsappBusinessCloudApiService;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class WhatsappBusinessCloudApi {
    private final WhatsappBusinessCloudApiService whatsappBusinessCloudApiService;

    public WhatsappBusinessCloudApi(String token) {
        this.whatsappBusinessCloudApiService = WhatsappApiServiceGenerator.createService(WhatsappBusinessCloudApiService.class, token);
    }

    public MessageResponse sendMessage(String phoneNumberId, Message message) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.sendMessage(phoneNumberId, message));
    }

    public UploadResponse uploadMedia(String phoneNumberId, String fileName, FileType fileType, byte[] file) {
        RequestBody requestFile = MultipartBody.create((byte[])file, (MediaType)MediaType.parse((String)fileType.getType()));
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)fileName, (RequestBody)requestFile);
        MultipartBody.Part messageProduct = MultipartBody.Part.createFormData((String)"messaging_product", (String)"whatsapp");
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.uploadMedia(phoneNumberId, body, messageProduct));
    }

    public Media retrieveMediaUrl(String mediaId) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.retrieveMediaUrl(mediaId));
    }

    public MediaFile downloadMediaFile(String url) {
        return WhatsappApiServiceGenerator.executeDownloadSync(this.whatsappBusinessCloudApiService.downloadMediaFile(url));
    }

    public Response deleteMedia(String mediaId) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.deleteMedia(mediaId));
    }

    public Response markMessageAsRead(String phoneNumberId, ReadMessage message) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.markMessageAsRead(phoneNumberId, message));
    }

    public Response twoStepVerification(String phoneNumberId, TwoStepCode twoStepCode) {
        return WhatsappApiServiceGenerator.executeSync(this.whatsappBusinessCloudApiService.twoStepVerification(phoneNumberId, twoStepCode));
    }
}

