/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api;

import com.whatsapp.api.configuration.WhatsappApiConfig;
import com.whatsapp.api.domain.errors.Error;
import com.whatsapp.api.domain.errors.WhatsappApiError;
import com.whatsapp.api.domain.media.MediaFile;
import com.whatsapp.api.exception.WhatsappApiException;
import com.whatsapp.api.interceptor.AuthenticationInterceptor;
import com.whatsapp.api.utils.proxy.CustomHttpProxySelector;
import com.whatsapp.api.utils.proxy.CustomProxyAuthenticator;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.ProxySelector;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class WhatsappApiServiceGenerator {
    static OkHttpClient sharedClient;
    private static final Converter.Factory converterFactory;
    private static final Converter<ResponseBody, WhatsappApiError> errorBodyConverter;

    private WhatsappApiServiceGenerator() {
        throw new IllegalStateException("Cannot instantiate WhatsappApiServiceGenerator is an utility class!");
    }

    public static void setHttpProxy(String host, int port, String username, String pwd) {
        Objects.requireNonNull(host, "Host cannot be null");
        Objects.requireNonNull(Integer.valueOf(port), "Http Port cannot be null");
        CustomHttpProxySelector proxySelector = new CustomHttpProxySelector(host, port);
        if (username == null || pwd == null) {
            sharedClient = sharedClient.newBuilder().proxySelector((ProxySelector)proxySelector).build();
            return;
        }
        CustomProxyAuthenticator proxyAuthenticator = new CustomProxyAuthenticator(username, pwd);
        sharedClient = sharedClient.newBuilder().authenticator((Authenticator)proxyAuthenticator).build();
    }

    public static <S> S createService(Class<S> serviceClass, String token, String baseUrl) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory(converterFactory);
        if (token == null) {
            retrofitBuilder.client(sharedClient);
        } else {
            AuthenticationInterceptor interceptor = new AuthenticationInterceptor(token);
            OkHttpClient adaptedClient = sharedClient.newBuilder().addInterceptor((Interceptor)interceptor).build();
            retrofitBuilder.client(adaptedClient);
        }
        Retrofit retrofit = retrofitBuilder.build();
        return (S)retrofit.create(serviceClass);
    }

    public static <S> S createService(Class<S> serviceClass, String token) {
        String baseUrl = WhatsappApiConfig.BASE_DOMAIN;
        return WhatsappApiServiceGenerator.createService(serviceClass, token, baseUrl);
    }

    public static <T> T executeSync(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            WhatsappApiError apiError = WhatsappApiServiceGenerator.getWhatsappApiError(response);
            throw new WhatsappApiException(apiError);
        }
        catch (IOException e) {
            throw new WhatsappApiException(e);
        }
    }

    public static <T> MediaFile executeDownloadSync(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                String fileName = Objects.requireNonNull(response.headers().get("Content-Disposition")).split("=")[1];
                ResponseBody body = (ResponseBody)response.body();
                assert (body != null);
                return new MediaFile(fileName, body.bytes());
            }
            if (response.code() == 404) {
                Error error = new Error(404, null, 404, null, "Not found", null, null, null, false, null, null);
                throw new WhatsappApiException(new WhatsappApiError(error));
            }
            WhatsappApiError apiError = WhatsappApiServiceGenerator.getWhatsappApiError(response);
            throw new WhatsappApiException(apiError);
        }
        catch (IOException e) {
            throw new WhatsappApiException(e);
        }
    }

    public static WhatsappApiError getWhatsappApiError(Response<?> response) throws WhatsappApiException, IOException {
        Objects.requireNonNull(errorBodyConverter);
        ResponseBody responseBody = response.errorBody();
        Objects.requireNonNull(responseBody);
        return (WhatsappApiError)errorBodyConverter.convert((Object)responseBody);
    }

    public static OkHttpClient getSharedClient() {
        return sharedClient;
    }

    static {
        converterFactory = JacksonConverterFactory.create();
        errorBodyConverter = converterFactory.responseBodyConverter(WhatsappApiError.class, new Annotation[0], null);
        sharedClient = new OkHttpClient.Builder().callTimeout(20L, TimeUnit.SECONDS).pingInterval(20L, TimeUnit.SECONDS).build();
    }
}

