/*
 * Decompiled with CFR 0.152.
 */
package com.whatsapp.api.domain.messages;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.whatsapp.api.domain.messages.Contact;
import com.whatsapp.api.domain.messages.ContactMessage;
import com.whatsapp.api.domain.messages.InteractiveMessage;
import com.whatsapp.api.domain.messages.TemplateMessage;
import com.whatsapp.api.domain.messages.TextMessage;
import com.whatsapp.api.domain.messages.type.MessageType;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Message {
    @JsonProperty(value="messaging_product")
    private final String messagingProduct = "whatsapp";
    @JsonProperty(value="recipient_type")
    private final String recipientType = "individual";
    @JsonProperty(value="interactive")
    public InteractiveMessage interactiveMessage;
    @JsonProperty(value="to")
    private String to;
    @JsonProperty(value="type")
    private MessageType type;
    @JsonProperty(value="text")
    private TextMessage textMessage;
    @JsonProperty(value="contacts")
    private List<Contact> contactMessage;
    @JsonProperty(value="template")
    private TemplateMessage templateMessage;

    private Message() {
    }

    private Message(String to, MessageType type) {
        this.to = to;
        this.type = type;
    }

    public String getMessagingProduct() {
        return "whatsapp";
    }

    public String getRecipientType() {
        return "individual";
    }

    public static class MessageBuilder {
        private String to;

        private MessageBuilder() {
        }

        public static MessageBuilder builder() {
            return new MessageBuilder();
        }

        public MessageBuilder setTo(String to) {
            this.to = to;
            return this;
        }

        public Message buildTextMessage(TextMessage textMessage) {
            Message message = new Message(this.to, MessageType.TEXT);
            message.textMessage = textMessage;
            return message;
        }

        public Message buildContactMessage(ContactMessage contactMessage) {
            Message message = new Message(this.to, MessageType.CONTACTS);
            message.contactMessage = contactMessage.getContacts();
            return message;
        }

        public Message buildTemplateMessage(TemplateMessage templateMessage) {
            Message message = new Message(this.to, MessageType.TEMPLATE);
            message.templateMessage = templateMessage;
            return message;
        }

        public Message buildInteractiveMessage(InteractiveMessage interactiveMessage) {
            Message message = new Message(this.to, MessageType.INTERACTIVE);
            message.interactiveMessage = interactiveMessage;
            return message;
        }
    }
}

