/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.configure.PickerOptions;
import com.bigkoo.pickerview.view.BasePickerView;
import com.bigkoo.pickerview.view.WheelOptions;
import java.util.List;

public class OptionsPickerView<T>
extends BasePickerView
implements View.OnClickListener {
    private WheelOptions<T> wheelOptions;
    private static final String TAG_SUBMIT = "submit";
    private static final String TAG_CANCEL = "cancel";

    public OptionsPickerView(PickerOptions pickerOptions) {
        super(pickerOptions.context);
        this.mPickerOptions = pickerOptions;
        this.initView(pickerOptions.context);
    }

    private void initView(Context context) {
        this.setDialogOutSideCancelable();
        this.initViews();
        this.initAnim();
        this.initEvents();
        if (this.mPickerOptions.customListener == null) {
            LayoutInflater.from((Context)context).inflate(this.mPickerOptions.layoutRes, this.contentContainer);
            TextView tvTitle = (TextView)this.findViewById(R.id.tvTitle);
            RelativeLayout rv_top_bar = (RelativeLayout)this.findViewById(R.id.rv_topbar);
            Button btnSubmit = (Button)this.findViewById(R.id.btnSubmit);
            Button btnCancel = (Button)this.findViewById(R.id.btnCancel);
            btnSubmit.setTag((Object)TAG_SUBMIT);
            btnCancel.setTag((Object)TAG_CANCEL);
            btnSubmit.setOnClickListener((View.OnClickListener)this);
            btnCancel.setOnClickListener((View.OnClickListener)this);
            btnSubmit.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mPickerOptions.textContentConfirm) ? context.getResources().getString(R.string.pickerview_submit) : this.mPickerOptions.textContentConfirm));
            btnCancel.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mPickerOptions.textContentCancel) ? context.getResources().getString(R.string.pickerview_cancel) : this.mPickerOptions.textContentCancel));
            tvTitle.setText((CharSequence)(TextUtils.isEmpty((CharSequence)this.mPickerOptions.textContentTitle) ? "" : this.mPickerOptions.textContentTitle));
            btnSubmit.setTextColor(this.mPickerOptions.textColorConfirm);
            btnCancel.setTextColor(this.mPickerOptions.textColorCancel);
            tvTitle.setTextColor(this.mPickerOptions.textColorTitle);
            rv_top_bar.setBackgroundColor(this.mPickerOptions.bgColorTitle);
            btnSubmit.setTextSize((float)this.mPickerOptions.textSizeSubmitCancel);
            btnCancel.setTextSize((float)this.mPickerOptions.textSizeSubmitCancel);
            tvTitle.setTextSize((float)this.mPickerOptions.textSizeTitle);
        } else {
            this.mPickerOptions.customListener.customLayout(LayoutInflater.from((Context)context).inflate(this.mPickerOptions.layoutRes, this.contentContainer));
        }
        LinearLayout optionsPicker = (LinearLayout)this.findViewById(R.id.optionspicker);
        optionsPicker.setBackgroundColor(this.mPickerOptions.bgColorWheel);
        this.wheelOptions = new WheelOptions((View)optionsPicker, this.mPickerOptions.isRestoreItem);
        if (this.mPickerOptions.optionsSelectChangeListener != null) {
            this.wheelOptions.setOptionsSelectChangeListener(this.mPickerOptions.optionsSelectChangeListener);
        }
        this.wheelOptions.setTextContentSize(this.mPickerOptions.textSizeContent);
        this.wheelOptions.setItemsVisible(this.mPickerOptions.itemsVisibleCount);
        this.wheelOptions.setAlphaGradient(this.mPickerOptions.isAlphaGradient);
        this.wheelOptions.setLabels(this.mPickerOptions.label1, this.mPickerOptions.label2, this.mPickerOptions.label3);
        this.wheelOptions.setTextXOffset(this.mPickerOptions.x_offset_one, this.mPickerOptions.x_offset_two, this.mPickerOptions.x_offset_three);
        this.wheelOptions.setCyclic(this.mPickerOptions.cyclic1, this.mPickerOptions.cyclic2, this.mPickerOptions.cyclic3);
        this.wheelOptions.setTypeface(this.mPickerOptions.font);
        this.setOutSideCancelable(this.mPickerOptions.cancelable);
        this.wheelOptions.setDividerColor(this.mPickerOptions.dividerColor);
        this.wheelOptions.setDividerType(this.mPickerOptions.dividerType);
        this.wheelOptions.setLineSpacingMultiplier(this.mPickerOptions.lineSpacingMultiplier);
        this.wheelOptions.setTextColorOut(this.mPickerOptions.textColorOut);
        this.wheelOptions.setTextColorCenter(this.mPickerOptions.textColorCenter);
        this.wheelOptions.isCenterLabel(this.mPickerOptions.isCenterLabel);
    }

    public void setTitleText(String text) {
        TextView tvTitle = (TextView)this.findViewById(R.id.tvTitle);
        if (tvTitle != null) {
            tvTitle.setText((CharSequence)text);
        }
    }

    public void setSelectOptions(int option1) {
        this.mPickerOptions.option1 = option1;
        this.reSetCurrentItems();
    }

    public void setSelectOptions(int option1, int option2) {
        this.mPickerOptions.option1 = option1;
        this.mPickerOptions.option2 = option2;
        this.reSetCurrentItems();
    }

    public void setSelectOptions(int option1, int option2, int option3) {
        this.mPickerOptions.option1 = option1;
        this.mPickerOptions.option2 = option2;
        this.mPickerOptions.option3 = option3;
        this.reSetCurrentItems();
    }

    private void reSetCurrentItems() {
        if (this.wheelOptions != null) {
            this.wheelOptions.setCurrentItems(this.mPickerOptions.option1, this.mPickerOptions.option2, this.mPickerOptions.option3);
        }
    }

    public void setPicker(List<T> optionsItems) {
        this.setPicker(optionsItems, null, null);
    }

    public void setPicker(List<T> options1Items, List<List<T>> options2Items) {
        this.setPicker(options1Items, options2Items, null);
    }

    public void setPicker(List<T> options1Items, List<List<T>> options2Items, List<List<List<T>>> options3Items) {
        this.wheelOptions.setPicker(options1Items, options2Items, options3Items);
        this.reSetCurrentItems();
    }

    public void setNPicker(List<T> options1Items, List<T> options2Items, List<T> options3Items) {
        this.wheelOptions.setLinkage(false);
        this.wheelOptions.setNPicker(options1Items, options2Items, options3Items);
        this.reSetCurrentItems();
    }

    public void onClick(View v) {
        String tag = (String)v.getTag();
        if (tag.equals(TAG_SUBMIT)) {
            this.returnData();
        } else if (tag.equals(TAG_CANCEL) && this.mPickerOptions.cancelListener != null) {
            this.mPickerOptions.cancelListener.onClick(v);
        }
        this.dismiss();
    }

    public void returnData() {
        if (this.mPickerOptions.optionsSelectListener != null) {
            int[] optionsCurrentItems = this.wheelOptions.getCurrentItems();
            this.mPickerOptions.optionsSelectListener.onOptionsSelect(optionsCurrentItems[0], optionsCurrentItems[1], optionsCurrentItems[2], this.clickView);
        }
    }

    @Override
    public boolean isDialog() {
        return this.mPickerOptions.isDialog;
    }
}

