/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.bigkoo.pickerview.R;
import com.bigkoo.pickerview.configure.PickerOptions;
import com.bigkoo.pickerview.listener.OnDismissListener;
import com.bigkoo.pickerview.utils.PickerViewAnimateUtil;

public class BasePickerView {
    private Context context;
    protected ViewGroup contentContainer;
    private ViewGroup rootView;
    private ViewGroup dialogView;
    protected PickerOptions mPickerOptions;
    private OnDismissListener onDismissListener;
    private boolean dismissing;
    private Animation outAnim;
    private Animation inAnim;
    private boolean isShowing;
    protected int animGravity = 80;
    private Dialog mDialog;
    protected View clickView;
    private boolean isAnim = true;
    private View.OnKeyListener onKeyBackListener = new View.OnKeyListener(){

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (keyCode == 4 && event.getAction() == 0 && BasePickerView.this.isShowing()) {
                BasePickerView.this.dismiss();
                return true;
            }
            return false;
        }
    };
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                BasePickerView.this.dismiss();
            }
            return false;
        }
    };

    public BasePickerView(Context context) {
        this.context = context;
    }

    protected void initViews() {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        if (this.isDialog()) {
            this.dialogView = (ViewGroup)layoutInflater.inflate(R.layout.layout_basepickerview, null, false);
            this.dialogView.setBackgroundColor(0);
            this.contentContainer = (ViewGroup)this.dialogView.findViewById(R.id.content_container);
            params.leftMargin = 30;
            params.rightMargin = 30;
            this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)params);
            this.createDialog();
            this.dialogView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BasePickerView.this.dismiss();
                }
            });
        } else {
            if (this.mPickerOptions.decorView == null) {
                this.mPickerOptions.decorView = (ViewGroup)((Activity)this.context).getWindow().getDecorView();
            }
            this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.layout_basepickerview, this.mPickerOptions.decorView, false);
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            if (this.mPickerOptions.outSideColor != -1) {
                this.rootView.setBackgroundColor(this.mPickerOptions.outSideColor);
            }
            this.contentContainer = (ViewGroup)this.rootView.findViewById(R.id.content_container);
            this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.setKeyBackCancelable(true);
    }

    protected void initAnim() {
        this.inAnim = this.getInAnimation();
        this.outAnim = this.getOutAnimation();
    }

    protected void initEvents() {
    }

    public void show(View v, boolean isAnim) {
        this.clickView = v;
        this.isAnim = isAnim;
        this.show();
    }

    public void show(boolean isAnim) {
        this.show(null, isAnim);
    }

    public void show(View v) {
        this.clickView = v;
        this.show();
    }

    public void show() {
        if (this.isDialog()) {
            this.showDialog();
        } else {
            if (this.isShowing()) {
                return;
            }
            this.isShowing = true;
            this.onAttached((View)this.rootView);
            this.rootView.requestFocus();
        }
    }

    private void onAttached(View view) {
        this.mPickerOptions.decorView.addView(view);
        if (this.isAnim) {
            this.contentContainer.startAnimation(this.inAnim);
        }
    }

    public boolean isShowing() {
        if (this.isDialog()) {
            return false;
        }
        return this.rootView.getParent() != null || this.isShowing;
    }

    public void dismiss() {
        if (this.isDialog()) {
            this.dismissDialog();
        } else {
            if (this.dismissing) {
                return;
            }
            if (this.isAnim) {
                this.outAnim.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationStart(Animation animation) {
                    }

                    public void onAnimationEnd(Animation animation) {
                        BasePickerView.this.dismissImmediately();
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }
                });
                this.contentContainer.startAnimation(this.outAnim);
            } else {
                this.dismissImmediately();
            }
            this.dismissing = true;
        }
    }

    public void dismissImmediately() {
        this.mPickerOptions.decorView.post(new Runnable(){

            @Override
            public void run() {
                BasePickerView.this.mPickerOptions.decorView.removeView((View)BasePickerView.this.rootView);
                BasePickerView.this.isShowing = false;
                BasePickerView.this.dismissing = false;
                if (BasePickerView.this.onDismissListener != null) {
                    BasePickerView.this.onDismissListener.onDismiss(BasePickerView.this);
                }
            }
        });
    }

    private Animation getInAnimation() {
        int res = PickerViewAnimateUtil.getAnimationResource(this.animGravity, true);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    private Animation getOutAnimation() {
        int res = PickerViewAnimateUtil.getAnimationResource(this.animGravity, false);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public BasePickerView setOnDismissListener(OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    public void setKeyBackCancelable(boolean isCancelable) {
        ViewGroup View2 = this.isDialog() ? this.dialogView : this.rootView;
        View2.setFocusable(isCancelable);
        View2.setFocusableInTouchMode(isCancelable);
        if (isCancelable) {
            View2.setOnKeyListener(this.onKeyBackListener);
        } else {
            View2.setOnKeyListener(null);
        }
    }

    protected BasePickerView setOutSideCancelable(boolean isCancelable) {
        if (this.rootView != null) {
            View view = this.rootView.findViewById(R.id.outmost_container);
            if (isCancelable) {
                view.setOnTouchListener(this.onCancelableTouchListener);
            } else {
                view.setOnTouchListener(null);
            }
        }
        return this;
    }

    public void setDialogOutSideCancelable() {
        if (this.mDialog != null) {
            this.mDialog.setCancelable(this.mPickerOptions.cancelable);
        }
    }

    public View findViewById(int id2) {
        return this.contentContainer.findViewById(id2);
    }

    public void createDialog() {
        if (this.dialogView != null) {
            this.mDialog = new Dialog(this.context, R.style.custom_dialog2);
            this.mDialog.setCancelable(this.mPickerOptions.cancelable);
            this.mDialog.setContentView((View)this.dialogView);
            Window dialogWindow = this.mDialog.getWindow();
            if (dialogWindow != null) {
                dialogWindow.setWindowAnimations(R.style.picker_view_scale_anim);
                dialogWindow.setGravity(17);
            }
            this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    if (BasePickerView.this.onDismissListener != null) {
                        BasePickerView.this.onDismissListener.onDismiss(BasePickerView.this);
                    }
                }
            });
        }
    }

    private void showDialog() {
        if (this.mDialog != null) {
            this.mDialog.show();
        }
    }

    private void dismissDialog() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    public ViewGroup getDialogContainerLayout() {
        return this.contentContainer;
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public boolean isDialog() {
        return false;
    }
}

