/*
 * Decompiled with CFR 0.152.
 */
package com.aspsine.irecyclerview;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.aspsine.irecyclerview.RefreshHeaderLayout;

public class WrapperAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected static final int REFRESH_HEADER = Integer.MIN_VALUE;
    protected static final int HEADER = -2147483647;
    protected static final int FOOTER = 0x7FFFFFFE;
    protected static final int LOAD_MORE_FOOTER = Integer.MAX_VALUE;
    private final RecyclerView.Adapter mAdapter;
    private final RefreshHeaderLayout mRefreshHeaderContainer;
    private final FrameLayout mLoadMoreFooterContainer;
    private final LinearLayout mHeaderContainer;
    private final LinearLayout mFooterContainer;
    private RecyclerView.AdapterDataObserver mObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            WrapperAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            WrapperAdapter.this.notifyItemRangeChanged(positionStart + 2, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            WrapperAdapter.this.notifyItemRangeChanged(positionStart + 2, itemCount, payload);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            WrapperAdapter.this.notifyItemRangeInserted(positionStart + 2, itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            WrapperAdapter.this.notifyItemRangeRemoved(positionStart + 2, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            WrapperAdapter.this.notifyDataSetChanged();
        }
    };

    public WrapperAdapter(RecyclerView.Adapter adapter, RefreshHeaderLayout refreshHeaderContainer, LinearLayout headerContainer, LinearLayout footerContainer, FrameLayout loadMoreFooterContainer) {
        this.mAdapter = adapter;
        this.mRefreshHeaderContainer = refreshHeaderContainer;
        this.mHeaderContainer = headerContainer;
        this.mFooterContainer = footerContainer;
        this.mLoadMoreFooterContainer = loadMoreFooterContainer;
        this.mAdapter.registerAdapterDataObserver(this.mObserver);
    }

    public RecyclerView.Adapter getAdapter() {
        return this.mAdapter;
    }

    public void onAttachedToRecyclerView(final RecyclerView recyclerView) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            final GridLayoutManager.SpanSizeLookup spanSizeLookup = gridLayoutManager.getSpanSizeLookup();
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    WrapperAdapter wrapperAdapter = (WrapperAdapter)recyclerView.getAdapter();
                    if (WrapperAdapter.this.isFullSpanType(wrapperAdapter.getItemViewType(position))) {
                        return gridLayoutManager.getSpanCount();
                    }
                    if (spanSizeLookup != null) {
                        return spanSizeLookup.getSpanSize(position - 2);
                    }
                    return 1;
                }
            });
        }
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        ViewGroup.LayoutParams layoutParams;
        super.onViewAttachedToWindow(holder);
        int position = holder.getAdapterPosition();
        int type = this.getItemViewType(position);
        if (this.isFullSpanType(type) && (layoutParams = holder.itemView.getLayoutParams()) instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams lp = (StaggeredGridLayoutManager.LayoutParams)layoutParams;
            lp.setFullSpan(true);
        }
    }

    private boolean isFullSpanType(int type) {
        return type == Integer.MIN_VALUE || type == -2147483647 || type == 0x7FFFFFFE || type == Integer.MAX_VALUE;
    }

    public int getItemCount() {
        return this.mAdapter.getItemCount() + 4;
    }

    public int getItemViewType(int position) {
        if (position == 0) {
            return Integer.MIN_VALUE;
        }
        if (position == 1) {
            return -2147483647;
        }
        if (1 < position && position < this.mAdapter.getItemCount() + 2) {
            return this.mAdapter.getItemViewType(position - 2);
        }
        if (position == this.mAdapter.getItemCount() + 2) {
            return 0x7FFFFFFE;
        }
        if (position == this.mAdapter.getItemCount() + 3) {
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Wrong type! Position = " + position);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == Integer.MIN_VALUE) {
            return new RefreshHeaderContainerViewHolder((View)this.mRefreshHeaderContainer);
        }
        if (viewType == -2147483647) {
            return new HeaderContainerViewHolder((View)this.mHeaderContainer);
        }
        if (viewType == 0x7FFFFFFE) {
            return new FooterContainerViewHolder((View)this.mFooterContainer);
        }
        if (viewType == Integer.MAX_VALUE) {
            return new LoadMoreFooterContainerViewHolder((View)this.mLoadMoreFooterContainer);
        }
        return this.mAdapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (1 < position && position < this.mAdapter.getItemCount() + 2) {
            this.mAdapter.onBindViewHolder(holder, position - 2);
        }
    }

    static class LoadMoreFooterContainerViewHolder
    extends RecyclerView.ViewHolder {
        public LoadMoreFooterContainerViewHolder(View itemView) {
            super(itemView);
        }
    }

    static class FooterContainerViewHolder
    extends RecyclerView.ViewHolder {
        public FooterContainerViewHolder(View itemView) {
            super(itemView);
        }
    }

    static class HeaderContainerViewHolder
    extends RecyclerView.ViewHolder {
        public HeaderContainerViewHolder(View itemView) {
            super(itemView);
        }
    }

    static class RefreshHeaderContainerViewHolder
    extends RecyclerView.ViewHolder {
        public RefreshHeaderContainerViewHolder(View itemView) {
            super(itemView);
        }
    }
}

