/*
 * Decompiled with CFR 0.152.
 */
package com.aspsine.irecyclerview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.view.MotionEventCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.aspsine.irecyclerview.OnLoadMoreListener;
import com.aspsine.irecyclerview.OnLoadMoreScrollListener;
import com.aspsine.irecyclerview.OnRefreshListener;
import com.aspsine.irecyclerview.R;
import com.aspsine.irecyclerview.RefreshHeaderLayout;
import com.aspsine.irecyclerview.RefreshTrigger;
import com.aspsine.irecyclerview.SimpleAnimatorListener;
import com.aspsine.irecyclerview.WrapperAdapter;

public class IRecyclerView
extends RecyclerView {
    private static final String TAG = IRecyclerView.class.getSimpleName();
    private static final int STATUS_DEFAULT = 0;
    private static final int STATUS_SWIPING_TO_REFRESH = 1;
    private static final int STATUS_RELEASE_TO_REFRESH = 2;
    private static final int STATUS_REFRESHING = 3;
    private static final boolean DEBUG = false;
    ValueAnimator mScrollAnimator;
    private int mStatus;
    private boolean mRefreshEnabled;
    private boolean mLoadMoreEnabled;
    private int mRefreshFinalMoveOffset;
    private OnRefreshListener mOnRefreshListener;
    private OnLoadMoreListener mOnLoadMoreListener;
    private OnLoadMoreScrollListener mOnLoadMoreScrollListener;
    private RefreshHeaderLayout mRefreshHeaderContainer;
    private FrameLayout mLoadMoreFooterContainer;
    private LinearLayout mHeaderViewContainer;
    private LinearLayout mFooterViewContainer;
    private View mRefreshHeaderView;
    RefreshTrigger mRefreshTrigger = new RefreshTrigger(){

        @Override
        public void onStart(boolean automatic, int headerHeight, int finalHeight) {
            if (IRecyclerView.this.mRefreshHeaderView != null && IRecyclerView.this.mRefreshHeaderView instanceof RefreshTrigger) {
                RefreshTrigger trigger = (RefreshTrigger)IRecyclerView.this.mRefreshHeaderView;
                trigger.onStart(automatic, headerHeight, finalHeight);
            }
        }

        @Override
        public void onMove(boolean finished, boolean automatic, int moved) {
            if (IRecyclerView.this.mRefreshHeaderView != null && IRecyclerView.this.mRefreshHeaderView instanceof RefreshTrigger) {
                RefreshTrigger trigger = (RefreshTrigger)IRecyclerView.this.mRefreshHeaderView;
                trigger.onMove(finished, automatic, moved);
            }
        }

        @Override
        public void onRefresh() {
            if (IRecyclerView.this.mRefreshHeaderView != null && IRecyclerView.this.mRefreshHeaderView instanceof RefreshTrigger) {
                RefreshTrigger trigger = (RefreshTrigger)IRecyclerView.this.mRefreshHeaderView;
                trigger.onRefresh();
            }
        }

        @Override
        public void onRelease() {
            if (IRecyclerView.this.mRefreshHeaderView != null && IRecyclerView.this.mRefreshHeaderView instanceof RefreshTrigger) {
                RefreshTrigger trigger = (RefreshTrigger)IRecyclerView.this.mRefreshHeaderView;
                trigger.onRelease();
            }
        }

        @Override
        public void onComplete() {
            if (IRecyclerView.this.mRefreshHeaderView != null && IRecyclerView.this.mRefreshHeaderView instanceof RefreshTrigger) {
                RefreshTrigger trigger = (RefreshTrigger)IRecyclerView.this.mRefreshHeaderView;
                trigger.onComplete();
            }
        }

        @Override
        public void onReset() {
            if (IRecyclerView.this.mRefreshHeaderView != null && IRecyclerView.this.mRefreshHeaderView instanceof RefreshTrigger) {
                RefreshTrigger trigger = (RefreshTrigger)IRecyclerView.this.mRefreshHeaderView;
                trigger.onReset();
            }
        }
    };
    ValueAnimator.AnimatorUpdateListener mAnimatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            int height = (Integer)animation.getAnimatedValue();
            IRecyclerView.this.setRefreshHeaderContainerHeight(height);
            switch (IRecyclerView.this.mStatus) {
                case 1: {
                    IRecyclerView.this.mRefreshTrigger.onMove(false, true, height);
                    break;
                }
                case 2: {
                    IRecyclerView.this.mRefreshTrigger.onMove(false, true, height);
                    break;
                }
                case 3: {
                    IRecyclerView.this.mRefreshTrigger.onMove(true, true, height);
                }
            }
        }
    };
    Animator.AnimatorListener mAnimationListener = new SimpleAnimatorListener(){

        @Override
        public void onAnimationEnd(Animator animation) {
            int lastStatus = IRecyclerView.this.mStatus;
            switch (IRecyclerView.this.mStatus) {
                case 1: {
                    ((IRecyclerView)IRecyclerView.this).mRefreshHeaderContainer.getLayoutParams().height = 0;
                    IRecyclerView.this.mRefreshHeaderContainer.requestLayout();
                    IRecyclerView.this.setStatus(0);
                    break;
                }
                case 2: {
                    ((IRecyclerView)IRecyclerView.this).mRefreshHeaderContainer.getLayoutParams().height = IRecyclerView.this.mRefreshHeaderView.getMeasuredHeight();
                    IRecyclerView.this.mRefreshHeaderContainer.requestLayout();
                    IRecyclerView.this.setStatus(3);
                    if (IRecyclerView.this.mOnRefreshListener == null) break;
                    IRecyclerView.this.mOnRefreshListener.onRefresh();
                    IRecyclerView.this.mRefreshTrigger.onRefresh();
                    break;
                }
                case 3: {
                    ((IRecyclerView)IRecyclerView.this).mRefreshHeaderContainer.getLayoutParams().height = 0;
                    IRecyclerView.this.mRefreshHeaderContainer.requestLayout();
                    IRecyclerView.this.setStatus(0);
                    IRecyclerView.this.mRefreshTrigger.onReset();
                }
            }
        }
    };
    private View mLoadMoreFooterView;
    private int mActivePointerId = -1;
    private int mLastTouchX = 0;
    private int mLastTouchY = 0;

    public IRecyclerView(Context context) {
        this(context, null);
    }

    public IRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        boolean loadMoreEnabled;
        boolean refreshEnabled;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IRecyclerView, defStyle, 0);
        int refreshHeaderLayoutRes = -1;
        int loadMoreFooterLayoutRes = -1;
        int refreshFinalMoveOffset = -1;
        try {
            refreshEnabled = a.getBoolean(R.styleable.IRecyclerView_refreshEnabled, false);
            loadMoreEnabled = a.getBoolean(R.styleable.IRecyclerView_loadMoreEnabled, false);
            refreshHeaderLayoutRes = a.getResourceId(R.styleable.IRecyclerView_refreshHeaderLayout, -1);
            loadMoreFooterLayoutRes = a.getResourceId(R.styleable.IRecyclerView_loadMoreFooterLayout, -1);
            refreshFinalMoveOffset = a.getDimensionPixelOffset(R.styleable.IRecyclerView_refreshFinalMoveOffset, -1);
        }
        finally {
            a.recycle();
        }
        this.setRefreshEnabled(refreshEnabled);
        this.setLoadMoreEnabled(loadMoreEnabled);
        if (refreshHeaderLayoutRes != -1) {
            this.setRefreshHeaderView(refreshHeaderLayoutRes);
        }
        if (loadMoreFooterLayoutRes != -1) {
            this.setLoadMoreFooterView(loadMoreFooterLayoutRes);
        }
        if (refreshFinalMoveOffset != -1) {
            this.setRefreshFinalMoveOffset(refreshFinalMoveOffset);
        }
        this.setStatus(0);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        super.onMeasure(widthSpec, heightSpec);
        if (this.mRefreshHeaderView != null && this.mRefreshHeaderView.getMeasuredHeight() > this.mRefreshFinalMoveOffset) {
            this.mRefreshFinalMoveOffset = 0;
        }
    }

    public void setRefreshEnabled(boolean enabled) {
        this.mRefreshEnabled = enabled;
    }

    public void setLoadMoreEnabled(boolean enabled) {
        this.mLoadMoreEnabled = enabled;
        if (this.mLoadMoreEnabled) {
            if (this.mOnLoadMoreScrollListener == null) {
                this.mOnLoadMoreScrollListener = new OnLoadMoreScrollListener(){

                    @Override
                    public void onLoadMore(RecyclerView recyclerView) {
                        if (IRecyclerView.this.mOnLoadMoreListener != null && IRecyclerView.this.mStatus == 0) {
                            IRecyclerView.this.mOnLoadMoreListener.onLoadMore(IRecyclerView.this.mLoadMoreFooterView);
                        }
                    }
                };
            } else {
                this.removeOnScrollListener(this.mOnLoadMoreScrollListener);
            }
            this.addOnScrollListener(this.mOnLoadMoreScrollListener);
        } else if (this.mOnLoadMoreScrollListener != null) {
            this.removeOnScrollListener(this.mOnLoadMoreScrollListener);
        }
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mOnRefreshListener = listener;
    }

    public void setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mOnLoadMoreListener = listener;
    }

    public void setRefreshing(boolean refreshing) {
        if (this.mStatus == 0 && refreshing) {
            this.startScrollDefaultStatusToRefreshingStatus();
        } else if (this.mStatus == 3 && !refreshing) {
            this.startScrollRefreshingStatusToDefaultStatus();
        } else {
            Log.e((String)TAG, (String)("isRefresh = " + refreshing + " current status = " + this.mStatus));
        }
    }

    public void setRefreshFinalMoveOffset(int refreshFinalMoveOffset) {
        this.mRefreshFinalMoveOffset = refreshFinalMoveOffset;
    }

    public void setRefreshHeaderView(View refreshHeaderView) {
        if (!this.isRefreshTrigger(refreshHeaderView)) {
            throw new ClassCastException("Refresh header view must be an implement of RefreshTrigger");
        }
        if (this.mRefreshHeaderView != null) {
            this.removeRefreshHeaderView();
        }
        if (this.mRefreshHeaderView != refreshHeaderView) {
            this.mRefreshHeaderView = refreshHeaderView;
            this.ensureRefreshHeaderContainer();
            this.mRefreshHeaderContainer.addView(refreshHeaderView);
        }
    }

    public void setLoadMoreFooterView(View loadMoreFooterView) {
        if (this.mLoadMoreFooterView != null) {
            this.removeLoadMoreFooterView();
        }
        if (this.mLoadMoreFooterView != loadMoreFooterView) {
            this.mLoadMoreFooterView = loadMoreFooterView;
            this.ensureLoadMoreFooterContainer();
            this.mLoadMoreFooterContainer.addView(loadMoreFooterView);
        }
    }

    public View getRefreshHeaderView() {
        return this.mRefreshHeaderView;
    }

    public void setRefreshHeaderView(@LayoutRes int refreshHeaderLayoutRes) {
        this.ensureRefreshHeaderContainer();
        View refreshHeader = LayoutInflater.from((Context)this.getContext()).inflate(refreshHeaderLayoutRes, (ViewGroup)this.mRefreshHeaderContainer, false);
        if (refreshHeader != null) {
            this.setRefreshHeaderView(refreshHeader);
        }
    }

    public View getLoadMoreFooterView() {
        return this.mLoadMoreFooterView;
    }

    public void setLoadMoreFooterView(@LayoutRes int loadMoreFooterLayoutRes) {
        this.ensureLoadMoreFooterContainer();
        View loadMoreFooter = LayoutInflater.from((Context)this.getContext()).inflate(loadMoreFooterLayoutRes, (ViewGroup)this.mLoadMoreFooterContainer, false);
        if (loadMoreFooter != null) {
            this.setLoadMoreFooterView(loadMoreFooter);
        }
    }

    public LinearLayout getHeaderContainer() {
        this.ensureHeaderViewContainer();
        return this.mHeaderViewContainer;
    }

    public LinearLayout getFooterContainer() {
        this.ensureFooterViewContainer();
        return this.mFooterViewContainer;
    }

    public void addHeaderView(View headerView) {
        this.ensureHeaderViewContainer();
        this.mHeaderViewContainer.addView(headerView);
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter != null) {
            adapter.notifyItemChanged(1);
        }
    }

    public void addFooterView(View footerView) {
        this.ensureFooterViewContainer();
        this.mFooterViewContainer.addView(footerView);
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter != null) {
            adapter.notifyItemChanged(adapter.getItemCount() - 2);
        }
    }

    public RecyclerView.Adapter getIAdapter() {
        WrapperAdapter wrapperAdapter = (WrapperAdapter)this.getAdapter();
        return wrapperAdapter.getAdapter();
    }

    public void setIAdapter(RecyclerView.Adapter adapter) {
        this.ensureRefreshHeaderContainer();
        this.ensureHeaderViewContainer();
        this.ensureFooterViewContainer();
        this.ensureLoadMoreFooterContainer();
        this.setAdapter(new WrapperAdapter(adapter, this.mRefreshHeaderContainer, this.mHeaderViewContainer, this.mFooterViewContainer, this.mLoadMoreFooterContainer));
    }

    private void ensureRefreshHeaderContainer() {
        if (this.mRefreshHeaderContainer == null) {
            this.mRefreshHeaderContainer = new RefreshHeaderLayout(this.getContext());
            this.mRefreshHeaderContainer.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, 0));
        }
    }

    private void ensureLoadMoreFooterContainer() {
        if (this.mLoadMoreFooterContainer == null) {
            this.mLoadMoreFooterContainer = new FrameLayout(this.getContext());
            this.mLoadMoreFooterContainer.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
        }
    }

    private void ensureHeaderViewContainer() {
        if (this.mHeaderViewContainer == null) {
            this.mHeaderViewContainer = new LinearLayout(this.getContext());
            this.mHeaderViewContainer.setOrientation(1);
            this.mHeaderViewContainer.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
        }
    }

    private void ensureFooterViewContainer() {
        if (this.mFooterViewContainer == null) {
            this.mFooterViewContainer = new LinearLayout(this.getContext());
            this.mFooterViewContainer.setOrientation(1);
            this.mFooterViewContainer.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
        }
    }

    private boolean isRefreshTrigger(View refreshHeaderView) {
        return refreshHeaderView instanceof RefreshTrigger;
    }

    private void removeRefreshHeaderView() {
        if (this.mRefreshHeaderContainer != null) {
            this.mRefreshHeaderContainer.removeView(this.mRefreshHeaderView);
        }
    }

    private void removeLoadMoreFooterView() {
        if (this.mLoadMoreFooterContainer != null) {
            this.mLoadMoreFooterContainer.removeView(this.mLoadMoreFooterView);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent e) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)e);
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        switch (action) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)0);
                this.mLastTouchX = (int)(MotionEventCompat.getX((MotionEvent)e, (int)actionIndex) + 0.5f);
                this.mLastTouchY = (int)(MotionEventCompat.getY((MotionEvent)e, (int)actionIndex) + 0.5f);
                break;
            }
            case 5: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)actionIndex);
                this.mLastTouchX = (int)(MotionEventCompat.getX((MotionEvent)e, (int)actionIndex) + 0.5f);
                this.mLastTouchY = (int)(MotionEventCompat.getY((MotionEvent)e, (int)actionIndex) + 0.5f);
                break;
            }
            case 6: {
                this.onPointerUp(e);
            }
        }
        return super.onInterceptTouchEvent(e);
    }

    public boolean onTouchEvent(MotionEvent e) {
        int action = MotionEventCompat.getActionMasked((MotionEvent)e);
        switch (action) {
            case 0: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)e);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)0);
                this.mLastTouchX = this.getMotionEventX(e, index);
                this.mLastTouchY = this.getMotionEventY(e, index);
                break;
            }
            case 2: {
                boolean triggerCondition;
                int index = MotionEventCompat.findPointerIndex((MotionEvent)e, (int)this.mActivePointerId);
                if (index < 0) {
                    Log.e((String)TAG, (String)("Error processing scroll; pointer index for id " + index + " not found. Did any MotionEvents get skipped?"));
                    return false;
                }
                int x = this.getMotionEventX(e, index);
                int y = this.getMotionEventY(e, index);
                int dx = x - this.mLastTouchX;
                int dy = y - this.mLastTouchY;
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                boolean bl = triggerCondition = this.isEnabled() && this.mRefreshEnabled && this.mRefreshHeaderView != null && this.isFingerDragging() && this.canTriggerRefresh();
                if (!triggerCondition) break;
                int refreshHeaderContainerHeight = this.mRefreshHeaderContainer.getMeasuredHeight();
                int refreshHeaderViewHeight = this.mRefreshHeaderView.getMeasuredHeight();
                if (dy > 0 && this.mStatus == 0) {
                    this.setStatus(1);
                    this.mRefreshTrigger.onStart(false, refreshHeaderViewHeight, this.mRefreshFinalMoveOffset);
                } else if (dy < 0) {
                    if (this.mStatus == 1 && refreshHeaderContainerHeight <= 0) {
                        this.setStatus(0);
                    }
                    if (this.mStatus == 0) break;
                }
                if (this.mStatus != 1 && this.mStatus != 2) break;
                if (refreshHeaderContainerHeight >= refreshHeaderViewHeight) {
                    this.setStatus(2);
                } else {
                    this.setStatus(1);
                }
                this.fingerMove(dy);
                return true;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)e);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)index);
                this.mLastTouchX = this.getMotionEventX(e, index);
                this.mLastTouchY = this.getMotionEventY(e, index);
                break;
            }
            case 6: {
                this.onPointerUp(e);
                break;
            }
            case 1: {
                this.onFingerUpStartAnimating();
                break;
            }
            case 3: {
                this.onFingerUpStartAnimating();
            }
        }
        return super.onTouchEvent(e);
    }

    private boolean isFingerDragging() {
        return this.getScrollState() == 1;
    }

    public boolean canTriggerRefresh() {
        RecyclerView.Adapter adapter = this.getAdapter();
        if (adapter == null || adapter.getItemCount() <= 0) {
            return true;
        }
        View firstChild = this.getChildAt(0);
        int position = this.getChildLayoutPosition(firstChild);
        return position == 0 && firstChild.getTop() == this.mRefreshHeaderContainer.getTop();
    }

    private int getMotionEventX(MotionEvent e, int pointerIndex) {
        return (int)(MotionEventCompat.getX((MotionEvent)e, (int)pointerIndex) + 0.5f);
    }

    private int getMotionEventY(MotionEvent e, int pointerIndex) {
        return (int)(MotionEventCompat.getY((MotionEvent)e, (int)pointerIndex) + 0.5f);
    }

    private void fingerMove(int dy) {
        int ratioDy = (int)((double)((float)dy * 0.5f) + 0.5);
        int offset = this.mRefreshHeaderContainer.getMeasuredHeight();
        int finalDragOffset = this.mRefreshFinalMoveOffset;
        int nextOffset = offset + ratioDy;
        if (finalDragOffset > 0 && nextOffset > finalDragOffset) {
            ratioDy = finalDragOffset - offset;
        }
        if (nextOffset < 0) {
            ratioDy = -offset;
        }
        this.move(ratioDy);
    }

    private void move(int dy) {
        if (dy != 0) {
            int height = this.mRefreshHeaderContainer.getMeasuredHeight() + dy;
            this.setRefreshHeaderContainerHeight(height);
            this.mRefreshTrigger.onMove(false, false, height);
        }
    }

    private void setRefreshHeaderContainerHeight(int height) {
        this.mRefreshHeaderContainer.getLayoutParams().height = height;
        this.mRefreshHeaderContainer.requestLayout();
    }

    private void startScrollDefaultStatusToRefreshingStatus() {
        this.mRefreshTrigger.onStart(true, this.mRefreshHeaderView.getMeasuredHeight(), this.mRefreshFinalMoveOffset);
        int targetHeight = this.mRefreshHeaderView.getMeasuredHeight();
        int currentHeight = this.mRefreshHeaderContainer.getMeasuredHeight();
        this.startScrollAnimation(300, (Interpolator)new AccelerateInterpolator(), currentHeight, targetHeight);
    }

    private void startScrollSwipingToRefreshStatusToDefaultStatus() {
        boolean targetHeight = false;
        int currentHeight = this.mRefreshHeaderContainer.getMeasuredHeight();
        this.startScrollAnimation(300, (Interpolator)new DecelerateInterpolator(), currentHeight, 0);
    }

    private void startScrollReleaseStatusToRefreshingStatus() {
        this.mRefreshTrigger.onRelease();
        int targetHeight = this.mRefreshHeaderView.getMeasuredHeight();
        int currentHeight = this.mRefreshHeaderContainer.getMeasuredHeight();
        this.startScrollAnimation(300, (Interpolator)new DecelerateInterpolator(), currentHeight, targetHeight);
    }

    public void startScrollRefreshingStatusToDefaultStatus() {
        this.mRefreshTrigger.onComplete();
        boolean targetHeight = false;
        int currentHeight = this.mRefreshHeaderContainer.getMeasuredHeight();
        this.startScrollAnimation(200, (Interpolator)new DecelerateInterpolator(), currentHeight, 0);
    }

    public void startScrollAnimation(int time, Interpolator interpolator, int value, int toValue) {
        if (this.mScrollAnimator == null) {
            this.mScrollAnimator = new ValueAnimator();
        }
        this.mScrollAnimator.removeAllUpdateListeners();
        this.mScrollAnimator.removeAllListeners();
        this.mScrollAnimator.cancel();
        this.mScrollAnimator.setIntValues(new int[]{value, toValue});
        this.mScrollAnimator.setDuration((long)time);
        this.mScrollAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mScrollAnimator.addUpdateListener(this.mAnimatorUpdateListener);
        this.mScrollAnimator.addListener(this.mAnimationListener);
        this.mScrollAnimator.start();
    }

    public void onFingerUpStartAnimating() {
        if (this.mStatus == 2) {
            this.startScrollReleaseStatusToRefreshingStatus();
        } else if (this.mStatus == 1) {
            this.startScrollSwipingToRefreshStatusToDefaultStatus();
        }
    }

    private void onPointerUp(MotionEvent e) {
        int actionIndex = MotionEventCompat.getActionIndex((MotionEvent)e);
        if (MotionEventCompat.getPointerId((MotionEvent)e, (int)actionIndex) == this.mActivePointerId) {
            int newIndex = actionIndex == 0 ? 1 : 0;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)e, (int)newIndex);
            this.mLastTouchX = this.getMotionEventX(e, newIndex);
            this.mLastTouchY = this.getMotionEventY(e, newIndex);
        }
    }

    private void setStatus(int status) {
        this.mStatus = status;
    }

    private void printStatusLog() {
        Log.i((String)TAG, (String)this.getStatusLog(this.mStatus));
    }

    private String getStatusLog(int status) {
        String statusLog;
        switch (status) {
            case 0: {
                statusLog = "status_default";
                break;
            }
            case 1: {
                statusLog = "status_swiping_to_refresh";
                break;
            }
            case 2: {
                statusLog = "status_release_to_refresh";
                break;
            }
            case 3: {
                statusLog = "status_refreshing";
                break;
            }
            default: {
                statusLog = "status_illegal!";
            }
        }
        return statusLog;
    }
}

