/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core.utils;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.utils.Interactivity;
import com.anychart.enums.HoverMode;
import com.anychart.enums.SelectionMode;
import java.util.Locale;

public class StockInteractivity
extends Interactivity {
    protected StockInteractivity() {
    }

    public static StockInteractivity instantiate() {
        return new StockInteractivity("new anychart.core.utils.stockInteractivity()");
    }

    public StockInteractivity(String jsChart) {
        this.jsBase = "stockInteractivity" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    @Override
    public void multiSelectOnClick() {
        APIlib.getInstance().addJSLine(this.jsBase + ".multiSelectOnClick();");
    }

    @Override
    public StockInteractivity multiSelectOnClick(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".multiSelectOnClick(%s);", enabled));
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", StockInteractivity.wrapQuotes(type)));
    }

    public void scrollOnMouseWheel() {
        APIlib.getInstance().addJSLine(this.jsBase + ".scrollOnMouseWheel();");
    }

    public StockInteractivity scrollOnMouseWheel(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scrollOnMouseWheel(%s);", enabled));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener, String type, String ePath) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(String.format(Locale.US, ".listen('%1$s', function(e) {", type));
        if (listener.getFields() != null) {
            ePath = ePath != null ? ePath + "." : "";
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.%2$s%1$s + ',' +", field, ePath));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", StockInteractivity.wrapQuotes(key)));
    }

    @Override
    public void unselectOnClickOutOfPoint() {
        APIlib.getInstance().addJSLine(this.jsBase + ".unselectOnClickOutOfPoint();");
    }

    @Override
    public StockInteractivity unselectOnClickOutOfPoint(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unselectOnClickOutOfPoint(%s);", enabled));
        return this;
    }

    public void zoomOnMouseWheel() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zoomOnMouseWheel();");
    }

    public StockInteractivity zoomOnMouseWheel(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zoomOnMouseWheel(%s);", enabled));
        return this;
    }

    @Override
    public StockInteractivity allowMultiSeriesSelection(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".allowMultiSeriesSelection(%s);", value));
        return this;
    }

    @Override
    public void hoverMode() {
        APIlib.getInstance().addJSLine(this.jsBase + ".hoverMode();");
    }

    @Override
    public StockInteractivity hoverMode(HoverMode mode) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".hoverMode(%s);", mode != null ? mode.getJsBase() : null));
        return this;
    }

    @Override
    public StockInteractivity hoverMode(String mode) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".hoverMode(%s);", StockInteractivity.wrapQuotes(mode)));
        return this;
    }

    @Override
    public void selectionMode() {
        APIlib.getInstance().addJSLine(this.jsBase + ".selectionMode();");
    }

    @Override
    public StockInteractivity selectionMode(SelectionMode mode) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectionMode(%s);", mode != null ? mode.getJsBase() : null));
        return this;
    }

    @Override
    public StockInteractivity selectionMode(String mode) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selectionMode(%s);", StockInteractivity.wrapQuotes(mode)));
        return this;
    }

    @Override
    public void spotRadius() {
        APIlib.getInstance().addJSLine(this.jsBase + ".spotRadius();");
    }

    @Override
    public StockInteractivity spotRadius(Number radius) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".spotRadius(%s);", radius));
        return this;
    }
}

