/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.editor;

import com.anychart.APIlib;
import com.anychart.JsObject;
import com.anychart.chart.common.dataentry.DataEntry;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.editor.JavascriptOptions;
import com.anychart.editor.Step;
import com.anychart.enums.EditorSteps;
import java.util.List;
import java.util.Locale;

public class Editor
extends JsObject {
    protected Editor() {
    }

    public static Editor instantiate() {
        return new Editor("new anychart.editor.editor()");
    }

    public Editor(String jsChart) {
        this.jsBase = "editor" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public void addClassName(String className) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".addClassName(%s);", Editor.wrapQuotes(className)));
    }

    public void data(List<DataEntry> data) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".data(%s);", Editor.arrayToString(data)));
    }

    public void dialogRender() {
        APIlib.getInstance().addJSLine(this.jsBase + ".dialogRender();");
    }

    public void dialogRender(String className) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".dialogRender(%s);", Editor.wrapQuotes(className)));
    }

    public void dialogVisible() {
        APIlib.getInstance().addJSLine(this.jsBase + ".dialogVisible();");
    }

    public Editor dialogVisible(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".dialogVisible(%s);", enabled));
        return this;
    }

    public void dispose() {
        APIlib.getInstance().addJSLine(this.jsBase + ".dispose();");
    }

    public void getJavascript() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getJavascript();");
    }

    public void getJavascript(JavascriptOptions outputOptions) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".getJavascript(%s);", outputOptions != null ? outputOptions.getJsBase() : null));
    }

    public void getJson() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getJson();");
    }

    public void getXml() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getXml();");
    }

    public void hide(Boolean hide) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".hide(%s);", hide));
    }

    public Editor localization(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".localization(%s);", Editor.wrapQuotes(settings)));
        return this;
    }

    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Editor.wrapQuotes(type)));
    }

    public void removeClassName(String className) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeClassName(%s);", Editor.wrapQuotes(className)));
    }

    public void show(Boolean show) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".show(%s);", show));
    }

    public Step step(EditorSteps stepName) {
        return new Step(String.format(Locale.US, this.jsBase + ".step(%s)", stepName != null ? stepName.getJsBase() : null));
    }

    public Step step(String stepName) {
        return new Step(String.format(Locale.US, this.jsBase + ".step(%s)", Editor.wrapQuotes(stepName)));
    }

    public Step step(EditorSteps stepName, Boolean value) {
        return new Step(String.format(Locale.US, this.jsBase + ".step(%s, %s)", stepName != null ? stepName.getJsBase() : null, value));
    }

    public Step step(String stepName, Boolean value) {
        return new Step(String.format(Locale.US, this.jsBase + ".step(%s, %s)", Editor.wrapQuotes(stepName), value));
    }

    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    public void setOnClickListener(ListenersInterface.OnClickListener listener, String type, String ePath) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(String.format(Locale.US, ".listen('%1$s', function(e) {", type));
        if (listener.getFields() != null) {
            ePath = ePath != null ? ePath + "." : "";
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.%2$s%1$s + ',' +", field, ePath));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Editor.wrapQuotes(key)));
    }

    public void version() {
        APIlib.getInstance().addJSLine(this.jsBase + ".version();");
    }
}

