/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.graphics.vector;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.graphics.math.Rect;
import com.anychart.graphics.vector.Anchor;
import com.anychart.graphics.vector.Cursor;
import com.anychart.graphics.vector.Element;
import com.anychart.graphics.vector.Layer;
import com.anychart.graphics.vector.Stage;
import com.anychart.graphics.vector.image.Align;
import com.anychart.graphics.vector.image.Fitting;
import java.util.Locale;

public class Image
extends Element {
    protected Image() {
    }

    public static Image instantiate() {
        return new Image("new anychart.graphics.vector.image()");
    }

    public Image(String jsChart) {
        this.jsBase = "image" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public void align() {
        APIlib.getInstance().addJSLine(this.jsBase + ".align();");
    }

    public Image align(Align align) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".align(%s);", align != null ? align.getJsBase() : null));
        return this;
    }

    @Override
    public Image appendTransformationMatrix(Number m00, Number m10, Number m01, Number m11, Number m02, Number m12) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".appendTransformationMatrix(%s, %s, %s, %s, %s, %s);", m00, m10, m01, m11, m02, m12));
        return this;
    }

    @Override
    public void attr(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".attr(%s);", Image.wrapQuotes(key)));
    }

    @Override
    public Image attr(String key, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".attr(%s, %s);", Image.wrapQuotes(key), Image.wrapQuotes(value)));
        return this;
    }

    @Override
    public Rect clip() {
        return new Rect(this.jsBase + ".clip()");
    }

    @Override
    public Image clip(Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".clip(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Image clip(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".clip(%s);", Image.wrapQuotes(value)));
        return this;
    }

    @Override
    public void cursor() {
        APIlib.getInstance().addJSLine(this.jsBase + ".cursor();");
    }

    @Override
    public Image cursor(Cursor value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".cursor(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public void desc() {
        APIlib.getInstance().addJSLine(this.jsBase + ".desc();");
    }

    @Override
    public Image desc(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".desc(%s);", Image.wrapQuotes(value)));
        return this;
    }

    @Override
    public void disablePointerEvents() {
        APIlib.getInstance().addJSLine(this.jsBase + ".disablePointerEvents();");
    }

    @Override
    public Image disablePointerEvents(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".disablePointerEvents(%s);", value));
        return this;
    }

    @Override
    public void disableStrokeScaling() {
        APIlib.getInstance().addJSLine(this.jsBase + ".disableStrokeScaling();");
    }

    @Override
    public Image disableStrokeScaling(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".disableStrokeScaling(%s);", value));
        return this;
    }

    @Override
    public void dispose() {
        APIlib.getInstance().addJSLine(this.jsBase + ".dispose();");
    }

    @Override
    public void domElement() {
        APIlib.getInstance().addJSLine(this.jsBase + ".domElement();");
    }

    @Override
    public void drag() {
        APIlib.getInstance().addJSLine(this.jsBase + ".drag();");
    }

    @Override
    public Image drag(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".drag(%s);", value));
        return this;
    }

    @Override
    public Image drag(Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".drag(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public void fittingMode() {
        APIlib.getInstance().addJSLine(this.jsBase + ".fittingMode();");
    }

    public Image fittingMode(Fitting mode) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fittingMode(%s);", mode != null ? mode.getJsBase() : null));
        return this;
    }

    public Image fittingMode(String mode) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fittingMode(%s);", Image.wrapQuotes(mode)));
        return this;
    }

    @Override
    public Rect getAbsoluteBounds() {
        return new Rect(this.jsBase + ".getAbsoluteBounds()");
    }

    @Override
    public void getAbsoluteHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getAbsoluteHeight();");
    }

    @Override
    public void getAbsoluteWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getAbsoluteWidth();");
    }

    @Override
    public void getAbsoluteX() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getAbsoluteX();");
    }

    @Override
    public void getAbsoluteY() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getAbsoluteY();");
    }

    @Override
    public Rect getBounds() {
        return new Rect(this.jsBase + ".getBounds()");
    }

    @Override
    public void getHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getHeight();");
    }

    @Override
    public void getRotationAngle() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getRotationAngle();");
    }

    @Override
    public Stage getStage() {
        return new Stage(this.jsBase + ".getStage()");
    }

    @Override
    public void getTransformationMatrix() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getTransformationMatrix();");
    }

    @Override
    public void getWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getWidth();");
    }

    @Override
    public void getX() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getX();");
    }

    @Override
    public void getY() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getY();");
    }

    @Override
    public void hasParent() {
        APIlib.getInstance().addJSLine(this.jsBase + ".hasParent();");
    }

    public void height() {
        APIlib.getInstance().addJSLine(this.jsBase + ".height();");
    }

    public Image height(Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", height));
        return this;
    }

    @Override
    public void id() {
        APIlib.getInstance().addJSLine(this.jsBase + ".id();");
    }

    @Override
    public Image id(String id2) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".id(%s);", Image.wrapQuotes(id2)));
        return this;
    }

    @Override
    public Layer parent() {
        return new Layer(this.jsBase + ".parent()");
    }

    @Override
    public Image parent(Layer parent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".parent(%s);", parent != null ? parent.getJsBase() : null));
        return this;
    }

    @Override
    public Image parent(Stage parent) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".parent(%s);", parent != null ? parent.getJsBase() : null));
        return this;
    }

    @Override
    public Image remove() {
        APIlib.getInstance().addJSLine(this.jsBase + ".remove();");
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Image.wrapQuotes(type)));
    }

    @Override
    public Image rotate(Number degrees, Number cx, Number cy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".rotate(%s, %s, %s);", degrees, cx, cy));
        return this;
    }

    @Override
    public Image rotateByAnchor(Number degrees, Anchor anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".rotateByAnchor(%s, %s);", degrees, anchor != null ? anchor.getJsBase() : null));
        return this;
    }

    @Override
    public Image rotateByAnchor(Number degrees, String anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".rotateByAnchor(%s, %s);", degrees, Image.wrapQuotes(anchor)));
        return this;
    }

    @Override
    public Image scale(Number sx, Number sy, Number cx, Number cy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scale(%s, %s, %s, %s);", sx, sy, cx, cy));
        return this;
    }

    @Override
    public Image scaleByAnchor(Number sx, Number sy, Anchor anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scaleByAnchor(%s, %s, %s);", sx, sy, anchor != null ? anchor.getJsBase() : null));
        return this;
    }

    @Override
    public Image scaleByAnchor(Number sx, Number sy, String anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scaleByAnchor(%s, %s, %s);", sx, sy, Image.wrapQuotes(anchor)));
        return this;
    }

    @Override
    public Image setPosition(Number x, Number y) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setPosition(%s, %s);", x, y));
        return this;
    }

    @Override
    public Image setRotation(Number degrees, Number cx, Number cy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setRotation(%s, %s, %s);", degrees, cx, cy));
        return this;
    }

    @Override
    public Image setRotationByAnchor(Number degrees, Anchor anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setRotationByAnchor(%s, %s);", degrees, anchor != null ? anchor.getJsBase() : null));
        return this;
    }

    @Override
    public Image setRotationByAnchor(Number degrees, String anchor) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setRotationByAnchor(%s, %s);", degrees, Image.wrapQuotes(anchor)));
        return this;
    }

    @Override
    public Image setTransformationMatrix(Number m00, Number m10, Number m01, Number m11, Number m02, Number m12) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".setTransformationMatrix(%s, %s, %s, %s, %s, %s);", m00, m10, m01, m11, m02, m12));
        return this;
    }

    public void src() {
        APIlib.getInstance().addJSLine(this.jsBase + ".src();");
    }

    public Image src(String url) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".src(%s);", Image.wrapQuotes(url)));
        return this;
    }

    @Override
    public void title() {
        APIlib.getInstance().addJSLine(this.jsBase + ".title();");
    }

    @Override
    public Image title(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".title(%s);", Image.wrapQuotes(value)));
        return this;
    }

    @Override
    public Image translate(Number tx, Number ty) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".translate(%s, %s);", tx, ty));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener, String type, String ePath) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(String.format(Locale.US, ".listen('%1$s', function(e) {", type));
        if (listener.getFields() != null) {
            ePath = ePath != null ? ePath + "." : "";
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.%2$s%1$s + ',' +", field, ePath));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void visible() {
        APIlib.getInstance().addJSLine(this.jsBase + ".visible();");
    }

    @Override
    public Image visible(Boolean isVisible) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".visible(%s);", isVisible));
        return this;
    }

    public void width() {
        APIlib.getInstance().addJSLine(this.jsBase + ".width();");
    }

    public Image width(Number width) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", width));
        return this;
    }

    public void x() {
        APIlib.getInstance().addJSLine(this.jsBase + ".x();");
    }

    public Image x(Number xCoord) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".x(%s);", xCoord));
        return this;
    }

    public void y() {
        APIlib.getInstance().addJSLine(this.jsBase + ".y();");
    }

    public Image y(Number yCoord) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".y(%s);", yCoord));
        return this;
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public Image zIndex(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", value));
        return this;
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Image.wrapQuotes(key)));
    }
}

