/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.data;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.Base;
import com.anychart.data.Iterator;
import com.anychart.enums.Sort;
import java.util.Locale;

public class View
extends Base {
    protected View() {
    }

    public static View instantiate() {
        return new View("new anychart.data.view()");
    }

    public View(String jsChart) {
        this.jsBase = "view" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public View concat(View otherView) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".concat(%s);", otherView != null ? otherView.getJsBase() : null));
        return this;
    }

    public View concat(String[] otherView) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".concat(%s);", View.arrayToStringWrapQuotes(otherView)));
        return this;
    }

    public View derive() {
        APIlib.getInstance().addJSLine(this.jsBase + ".derive();");
        return this;
    }

    public void find(String fieldName, String fieldValue) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".find(%s, %s);", View.wrapQuotes(fieldName), View.wrapQuotes(fieldValue)));
    }

    public void get(Number rowIndex, String fieldName) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".get(%s, %s);", rowIndex, View.wrapQuotes(fieldName)));
    }

    public void getDataSets() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getDataSets();");
    }

    public Iterator getIterator() {
        return new Iterator(this.jsBase + ".getIterator()");
    }

    public void getRowsCount() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getRowsCount();");
    }

    public void meta(Number index, String name) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".meta(%s, %s);", index, View.wrapQuotes(name)));
    }

    public View meta(Number index, String name, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".meta(%s, %s, %s);", index, View.wrapQuotes(name), View.wrapQuotes(value)));
        return this;
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", View.wrapQuotes(type)));
    }

    public void row(Number rowIndex) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".row(%s);", rowIndex));
    }

    public void row(Number rowIndex, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".row(%s, %s);", rowIndex, View.wrapQuotes(value)));
    }

    public View set(Number rowIndex, String fieldName, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".set(%s, %s, %s);", rowIndex, View.wrapQuotes(fieldName), View.wrapQuotes(value)));
        return this;
    }

    public View sort(String fieldName, Sort order) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".sort(%s, %s);", View.wrapQuotes(fieldName), order != null ? order.getJsBase() : null));
        return this;
    }

    public View sort(String fieldName, String order) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".sort(%s, %s);", View.wrapQuotes(fieldName), View.wrapQuotes(order)));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", View.wrapQuotes(key)));
    }
}

