/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core.stock.scrollerseries;

import com.anychart.APIlib;
import com.anychart.chart.common.dataentry.DataEntry;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.StateSettings;
import com.anychart.core.series.RenderingSettings;
import com.anychart.core.stock.scrollerseries.OHLC;
import com.anychart.core.stock.series.Base;
import com.anychart.core.ui.LabelsFactory;
import com.anychart.core.utils.Bounds;
import com.anychart.data.TableMapping;
import com.anychart.data.View;
import com.anychart.enums.ScaleTypes;
import com.anychart.enums.TreeFillingMethod;
import com.anychart.graphics.math.Rect;
import com.anychart.graphics.vector.ColoredFill;
import com.anychart.graphics.vector.Fill;
import com.anychart.graphics.vector.GradientKey;
import com.anychart.graphics.vector.HatchFill;
import com.anychart.graphics.vector.PaperSize;
import com.anychart.graphics.vector.PatternFill;
import com.anychart.graphics.vector.Stroke;
import com.anychart.graphics.vector.StrokeLineCap;
import com.anychart.graphics.vector.StrokeLineJoin;
import com.anychart.graphics.vector.hatchfill.HatchFillType;
import com.anychart.scales.ScatterBase;
import com.anychart.utils.RectObj;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;

public class Candlestick
extends OHLC {
    protected Candlestick() {
    }

    public static Candlestick instantiate() {
        return new Candlestick("new anychart.core.stock.scrollerSeries.candlestick()");
    }

    public Candlestick(String jsChart) {
        this.jsBase = "candlestick" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    @Override
    public void allowPointSettings() {
        APIlib.getInstance().addJSLine(this.jsBase + ".allowPointSettings();");
    }

    @Override
    public Candlestick allowPointSettings(Boolean enabled) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".allowPointSettings(%s);", enabled));
        return this;
    }

    @Override
    public void bottom() {
        APIlib.getInstance().addJSLine(this.jsBase + ".bottom();");
    }

    @Override
    public Candlestick bottom(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", value));
        return this;
    }

    @Override
    public Candlestick bottom(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public Bounds bounds() {
        return new Bounds(this.jsBase + ".bounds()");
    }

    @Override
    public Candlestick bounds(RectObj value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick bounds(com.anychart.math.Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick bounds(Bounds value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick bounds(Number x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, height));
        return this;
    }

    @Override
    public Candlestick bounds(Number x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, Candlestick.wrapQuotes(height)));
        return this;
    }

    @Override
    public Candlestick bounds(Number x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Candlestick.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Candlestick bounds(Number x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Candlestick.wrapQuotes(width), Candlestick.wrapQuotes(height)));
        return this;
    }

    @Override
    public Candlestick bounds(Number x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Candlestick.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Candlestick bounds(Number x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Candlestick.wrapQuotes(y), width, Candlestick.wrapQuotes(height)));
        return this;
    }

    @Override
    public Candlestick bounds(Number x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Candlestick.wrapQuotes(y), Candlestick.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Candlestick bounds(Number x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Candlestick.wrapQuotes(y), Candlestick.wrapQuotes(width), Candlestick.wrapQuotes(height)));
        return this;
    }

    @Override
    public Candlestick bounds(String x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Candlestick.wrapQuotes(x), y, width, height));
        return this;
    }

    @Override
    public Candlestick bounds(String x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Candlestick.wrapQuotes(x), y, width, Candlestick.wrapQuotes(height)));
        return this;
    }

    @Override
    public Candlestick bounds(String x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Candlestick.wrapQuotes(x), y, Candlestick.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Candlestick bounds(String x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Candlestick.wrapQuotes(x), y, Candlestick.wrapQuotes(width), Candlestick.wrapQuotes(height)));
        return this;
    }

    @Override
    public Candlestick bounds(String x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Candlestick.wrapQuotes(x), Candlestick.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Candlestick bounds(String x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Candlestick.wrapQuotes(x), Candlestick.wrapQuotes(y), width, Candlestick.wrapQuotes(height)));
        return this;
    }

    @Override
    public Candlestick bounds(String x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Candlestick.wrapQuotes(x), Candlestick.wrapQuotes(y), Candlestick.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Candlestick bounds(String x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Candlestick.wrapQuotes(x), Candlestick.wrapQuotes(y), Candlestick.wrapQuotes(width), Candlestick.wrapQuotes(height)));
        return this;
    }

    @Override
    public TableMapping data(List<DataEntry> data) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".data(%s)", Candlestick.arrayToString(data)));
    }

    @Override
    public void enabled() {
        APIlib.getInstance().addJSLine(this.jsBase + ".enabled();");
    }

    @Override
    public Candlestick enabled(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".enabled(%s);", value));
        return this;
    }

    public void fallingFill() {
        APIlib.getInstance().addJSLine(this.jsBase + ".fallingFill();");
    }

    public Candlestick fallingFill(Fill value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Candlestick fallingFill(String fillFunction) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s);", Candlestick.wrapQuotes(fillFunction)));
        return this;
    }

    public Candlestick fallingFill(String color, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s);", Candlestick.wrapQuotes(color), opacity));
        return this;
    }

    public Candlestick fallingFill(GradientKey keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode, opacity));
        return this;
    }

    public Candlestick fallingFill(GradientKey keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Candlestick fallingFill(GradientKey keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, Candlestick.wrapQuotes(mode), opacity));
        return this;
    }

    public Candlestick fallingFill(String[] keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s, %s, %s);", Candlestick.arrayToStringWrapQuotes(keys), angle, mode, opacity));
        return this;
    }

    public Candlestick fallingFill(String[] keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s, %s, %s);", Candlestick.arrayToStringWrapQuotes(keys), angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Candlestick fallingFill(String[] keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s, %s, %s);", Candlestick.arrayToStringWrapQuotes(keys), angle, Candlestick.wrapQuotes(mode), opacity));
        return this;
    }

    public Candlestick fallingFill(GradientKey keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s, %s, %s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public Candlestick fallingFill(String[] keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingFill(%s, %s, %s, %s, %s, %s, %s);", Candlestick.arrayToStringWrapQuotes(keys), cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public PatternFill fallingHatchFill() {
        return new PatternFill(this.jsBase + ".fallingHatchFill()");
    }

    public Candlestick fallingHatchFill(PatternFill patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingHatchFill(%s, %s, %s, %s);", patternFillOrTypeOrState != null ? patternFillOrTypeOrState.getJsBase() : null, Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    public Candlestick fallingHatchFill(HatchFill patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingHatchFill(%s, %s, %s, %s);", patternFillOrTypeOrState != null ? patternFillOrTypeOrState.getJsBase() : null, Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    public Candlestick fallingHatchFill(String patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingHatchFill(%s, %s, %s, %s);", Candlestick.wrapQuotes(patternFillOrTypeOrState), Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    public Candlestick fallingHatchFill(HatchFillType patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingHatchFill(%s, %s, %s, %s);", patternFillOrTypeOrState != null ? patternFillOrTypeOrState.getJsBase() : null, Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    public Candlestick fallingHatchFill(Boolean patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingHatchFill(%s, %s, %s, %s);", patternFillOrTypeOrState, Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    @Override
    public void fallingStroke() {
        APIlib.getInstance().addJSLine(this.jsBase + ".fallingStroke();");
    }

    @Override
    public Candlestick fallingStroke(Stroke value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick fallingStroke(Stroke value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick fallingStroke(Stroke value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick fallingStroke(Stroke value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick fallingStroke(ColoredFill value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick fallingStroke(ColoredFill value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick fallingStroke(ColoredFill value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick fallingStroke(ColoredFill value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick fallingStroke(String value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", Candlestick.wrapQuotes(value), thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick fallingStroke(String value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", Candlestick.wrapQuotes(value), thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick fallingStroke(String value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", Candlestick.wrapQuotes(value), thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick fallingStroke(String value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fallingStroke(%s, %s, %s, %s, %s);", Candlestick.wrapQuotes(value), thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public com.anychart.math.Rect getPixelBounds() {
        return new com.anychart.math.Rect(this.jsBase + ".getPixelBounds()");
    }

    @Override
    public void height() {
        APIlib.getInstance().addJSLine(this.jsBase + ".height();");
    }

    @Override
    public Candlestick height(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", value));
        return this;
    }

    @Override
    public Candlestick height(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public LabelsFactory labels() {
        return new LabelsFactory(this.jsBase + ".labels()");
    }

    @Override
    public Candlestick labels(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".labels(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public Candlestick labels(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".labels(%s);", value));
        return this;
    }

    @Override
    public void left() {
        APIlib.getInstance().addJSLine(this.jsBase + ".left();");
    }

    @Override
    public Candlestick left(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", value));
        return this;
    }

    @Override
    public Candlestick left(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void maxHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxHeight();");
    }

    @Override
    public Candlestick maxHeight(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", value));
        return this;
    }

    @Override
    public Candlestick maxHeight(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public LabelsFactory maxLabels() {
        return new LabelsFactory(this.jsBase + ".maxLabels()");
    }

    @Override
    public Base maxLabels(String settings) {
        return new Base(String.format(Locale.US, this.jsBase + ".maxLabels(%s)", Candlestick.wrapQuotes(settings)));
    }

    @Override
    public Base maxLabels(Boolean settings) {
        return new Base(String.format(Locale.US, this.jsBase + ".maxLabels(%s)", settings));
    }

    @Override
    public void maxPointWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxPointWidth();");
    }

    @Override
    public Candlestick maxPointWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxPointWidth(%s);", value));
        return this;
    }

    @Override
    public Candlestick maxPointWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxPointWidth(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void maxWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxWidth();");
    }

    @Override
    public Candlestick maxWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", value));
        return this;
    }

    @Override
    public Candlestick maxWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void minHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minHeight();");
    }

    @Override
    public Candlestick minHeight(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", value));
        return this;
    }

    @Override
    public Candlestick minHeight(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public LabelsFactory minLabels() {
        return new LabelsFactory(this.jsBase + ".minLabels()");
    }

    @Override
    public Candlestick minLabels(String settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minLabels(%s);", Candlestick.wrapQuotes(settings)));
        return this;
    }

    @Override
    public Candlestick minLabels(Boolean settings) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minLabels(%s);", settings));
        return this;
    }

    @Override
    public void minPointLength() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minPointLength();");
    }

    @Override
    public Candlestick minPointLength(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minPointLength(%s);", value));
        return this;
    }

    @Override
    public Candlestick minPointLength(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minPointLength(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void minWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minWidth();");
    }

    @Override
    public Candlestick minWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", value));
        return this;
    }

    @Override
    public Candlestick minWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public StateSettings normal() {
        return new StateSettings(this.jsBase + ".normal()");
    }

    @Override
    public Candlestick normal(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".normal(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void pointWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".pointWidth();");
    }

    @Override
    public Candlestick pointWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".pointWidth(%s);", value));
        return this;
    }

    @Override
    public Candlestick pointWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".pointWidth(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void print(PaperSize paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", paperSizeOrOptions != null ? paperSizeOrOptions.getJsBase() : null, landscape));
    }

    @Override
    public void print(String paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", Candlestick.wrapQuotes(paperSizeOrOptions), landscape));
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Candlestick.wrapQuotes(type)));
    }

    @Override
    public RenderingSettings rendering() {
        return new RenderingSettings(this.jsBase + ".rendering()");
    }

    @Override
    public Candlestick rendering(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".rendering(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void right() {
        APIlib.getInstance().addJSLine(this.jsBase + ".right();");
    }

    @Override
    public Candlestick right(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", value));
        return this;
    }

    @Override
    public Candlestick right(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    public void risingFill() {
        APIlib.getInstance().addJSLine(this.jsBase + ".risingFill();");
    }

    public Candlestick risingFill(Fill value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Candlestick risingFill(String fillFunction) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s);", Candlestick.wrapQuotes(fillFunction)));
        return this;
    }

    public Candlestick risingFill(String color, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s);", Candlestick.wrapQuotes(color), opacity));
        return this;
    }

    public Candlestick risingFill(GradientKey keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode, opacity));
        return this;
    }

    public Candlestick risingFill(GradientKey keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Candlestick risingFill(GradientKey keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, Candlestick.wrapQuotes(mode), opacity));
        return this;
    }

    public Candlestick risingFill(String[] keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s, %s, %s);", Candlestick.arrayToStringWrapQuotes(keys), angle, mode, opacity));
        return this;
    }

    public Candlestick risingFill(String[] keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s, %s, %s);", Candlestick.arrayToStringWrapQuotes(keys), angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Candlestick risingFill(String[] keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s, %s, %s);", Candlestick.arrayToStringWrapQuotes(keys), angle, Candlestick.wrapQuotes(mode), opacity));
        return this;
    }

    public Candlestick risingFill(GradientKey keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s, %s, %s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public Candlestick risingFill(String[] keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingFill(%s, %s, %s, %s, %s, %s, %s);", Candlestick.arrayToStringWrapQuotes(keys), cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public PatternFill risingHatchFill() {
        return new PatternFill(this.jsBase + ".risingHatchFill()");
    }

    public Candlestick risingHatchFill(PatternFill patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingHatchFill(%s, %s, %s, %s);", patternFillOrTypeOrState != null ? patternFillOrTypeOrState.getJsBase() : null, Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    public Candlestick risingHatchFill(HatchFill patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingHatchFill(%s, %s, %s, %s);", patternFillOrTypeOrState != null ? patternFillOrTypeOrState.getJsBase() : null, Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    public Candlestick risingHatchFill(String patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingHatchFill(%s, %s, %s, %s);", Candlestick.wrapQuotes(patternFillOrTypeOrState), Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    public Candlestick risingHatchFill(HatchFillType patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingHatchFill(%s, %s, %s, %s);", patternFillOrTypeOrState != null ? patternFillOrTypeOrState.getJsBase() : null, Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    public Candlestick risingHatchFill(Boolean patternFillOrTypeOrState, String color, Number thickness, Number size) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingHatchFill(%s, %s, %s, %s);", patternFillOrTypeOrState, Candlestick.wrapQuotes(color), thickness, size));
        return this;
    }

    @Override
    public void risingStroke() {
        APIlib.getInstance().addJSLine(this.jsBase + ".risingStroke();");
    }

    @Override
    public Candlestick risingStroke(Stroke value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick risingStroke(Stroke value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick risingStroke(Stroke value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick risingStroke(Stroke value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick risingStroke(ColoredFill value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick risingStroke(ColoredFill value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick risingStroke(ColoredFill value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick risingStroke(ColoredFill value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", value != null ? value.getJsBase() : null, thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick risingStroke(String value, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", Candlestick.wrapQuotes(value), thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick risingStroke(String value, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", Candlestick.wrapQuotes(value), thickness, Candlestick.wrapQuotes(dashpattern), Candlestick.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick risingStroke(String value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", Candlestick.wrapQuotes(value), thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Candlestick.wrapQuotes(lineCap)));
        return this;
    }

    @Override
    public Candlestick risingStroke(String value, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".risingStroke(%s, %s, %s, %s, %s);", Candlestick.wrapQuotes(value), thickness, Candlestick.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public StateSettings selected() {
        return new StateSettings(this.jsBase + ".selected()");
    }

    @Override
    public Candlestick selected(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".selected(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void seriesType() {
        APIlib.getInstance().addJSLine(this.jsBase + ".seriesType();");
    }

    @Override
    public Candlestick seriesType(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".seriesType(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void top() {
        APIlib.getInstance().addJSLine(this.jsBase + ".top();");
    }

    @Override
    public Candlestick top(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", value));
        return this;
    }

    @Override
    public Candlestick top(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Candlestick.wrapQuotes(key)));
    }

    @Override
    public void width() {
        APIlib.getInstance().addJSLine(this.jsBase + ".width();");
    }

    @Override
    public Candlestick width(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", value));
        return this;
    }

    @Override
    public Candlestick width(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public ScatterBase yScale() {
        return new ScatterBase(this.jsBase + ".yScale()");
    }

    @Override
    public Candlestick yScale(ScatterBase value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yScale(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Candlestick yScale(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yScale(%s);", Candlestick.wrapQuotes(value)));
        return this;
    }

    @Override
    public Candlestick yScale(ScaleTypes value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".yScale(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public Candlestick zIndex(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", value));
        return this;
    }

    @Override
    public void getIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getIndex();");
    }

    @Override
    public TableMapping data(View data) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".data(%s)", data != null ? data.getJsBase() : null));
    }

    @Override
    public TableMapping data(List<DataEntry> data, TreeFillingMethod fillMethod) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".data(%s, %s)", Candlestick.arrayToString(data), fillMethod != null ? fillMethod.getJsBase() : null));
    }

    @Override
    public TableMapping data(List<DataEntry> data, String fillMethod) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".data(%s, %s)", Candlestick.arrayToString(data), Candlestick.wrapQuotes(fillMethod)));
    }

    @Override
    public Object yScale(Class scaleClass) {
        Object instance = null;
        try {
            instance = scaleClass.getDeclaredConstructor(String.class).newInstance(this.jsBase + ".yScale()");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return instance;
    }
}

