/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core.series;

import com.anychart.APIlib;
import com.anychart.chart.common.dataentry.DataEntry;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.series.Base;
import com.anychart.core.ui.LabelsFactory;
import com.anychart.core.ui.MarkersFactory;
import com.anychart.core.utils.Bounds;
import com.anychart.core.utils.Error;
import com.anychart.core.utils.LegendItemSettings;
import com.anychart.data.TableMapping;
import com.anychart.data.View;
import com.anychart.enums.TreeFillingMethod;
import com.anychart.graphics.vector.PaperSize;
import com.anychart.math.Rect;
import com.anychart.utils.RectObj;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;

public class Stock
extends Base {
    protected Stock() {
    }

    public static Stock instantiate() {
        return new Stock("new anychart.core.series.stock()");
    }

    public Stock(String jsChart) {
        this.jsBase = "stock" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    @Override
    public void bottom() {
        APIlib.getInstance().addJSLine(this.jsBase + ".bottom();");
    }

    @Override
    public Stock bottom(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", value));
        return this;
    }

    @Override
    public Stock bottom(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bottom(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Bounds bounds() {
        return new Bounds(this.jsBase + ".bounds()");
    }

    @Override
    public Stock bounds(RectObj value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock bounds(Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock bounds(Bounds value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    @Override
    public Stock bounds(Number x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, height));
        return this;
    }

    @Override
    public Stock bounds(Number x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, width, Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(Number x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Stock.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Stock bounds(Number x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, y, Stock.wrapQuotes(width), Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(Number x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Stock.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Stock bounds(Number x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Stock.wrapQuotes(y), width, Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(Number x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Stock.wrapQuotes(y), Stock.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Stock bounds(Number x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", x, Stock.wrapQuotes(y), Stock.wrapQuotes(width), Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(String x, Number y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), y, width, height));
        return this;
    }

    @Override
    public Stock bounds(String x, Number y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), y, width, Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(String x, Number y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), y, Stock.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Stock bounds(String x, Number y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), y, Stock.wrapQuotes(width), Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(String x, String y, Number width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), Stock.wrapQuotes(y), width, height));
        return this;
    }

    @Override
    public Stock bounds(String x, String y, Number width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), Stock.wrapQuotes(y), width, Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock bounds(String x, String y, String width, Number height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), Stock.wrapQuotes(y), Stock.wrapQuotes(width), height));
        return this;
    }

    @Override
    public Stock bounds(String x, String y, String width, String height) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".bounds(%s, %s, %s, %s);", Stock.wrapQuotes(x), Stock.wrapQuotes(y), Stock.wrapQuotes(width), Stock.wrapQuotes(height)));
        return this;
    }

    @Override
    public Stock clip(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".clip(%s);", value));
        return this;
    }

    @Override
    public Stock clip(Rect value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".clip(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public TableMapping data(List<DataEntry> data) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".data(%s)", Stock.arrayToString(data)));
    }

    @Override
    public void enabled() {
        APIlib.getInstance().addJSLine(this.jsBase + ".enabled();");
    }

    @Override
    public Stock enabled(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".enabled(%s);", value));
        return this;
    }

    @Override
    public Error error(String value) {
        return new Error(String.format(Locale.US, this.jsBase + ".error(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public Error error(Boolean value) {
        return new Error(String.format(Locale.US, this.jsBase + ".error(%s)", value));
    }

    @Override
    public void getIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getIndex();");
    }

    @Override
    public Rect getPixelBounds() {
        return new Rect(this.jsBase + ".getPixelBounds()");
    }

    @Override
    public void getPixelPointWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".getPixelPointWidth();");
    }

    @Override
    public void height() {
        APIlib.getInstance().addJSLine(this.jsBase + ".height();");
    }

    @Override
    public Stock height(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", value));
        return this;
    }

    @Override
    public Stock height(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public LabelsFactory hoverLabels(String value) {
        return new LabelsFactory(String.format(Locale.US, this.jsBase + ".hoverLabels(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public LabelsFactory hoverLabels(Boolean value) {
        return new LabelsFactory(String.format(Locale.US, this.jsBase + ".hoverLabels(%s)", value));
    }

    @Override
    public MarkersFactory hoverMarkers(String value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".hoverMarkers(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public MarkersFactory hoverMarkers(Boolean value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".hoverMarkers(%s)", value));
    }

    @Override
    public MarkersFactory hoverOutlierMarkers(String value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".hoverOutlierMarkers(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public MarkersFactory hoverOutlierMarkers(Boolean value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".hoverOutlierMarkers(%s)", value));
    }

    @Override
    public void id(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".id(%s);", Stock.wrapQuotes(value)));
    }

    @Override
    public LabelsFactory labels(String value) {
        return new LabelsFactory(String.format(Locale.US, this.jsBase + ".labels(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public LabelsFactory labels(Boolean value) {
        return new LabelsFactory(String.format(Locale.US, this.jsBase + ".labels(%s)", value));
    }

    @Override
    public void left() {
        APIlib.getInstance().addJSLine(this.jsBase + ".left();");
    }

    @Override
    public Stock left(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", value));
        return this;
    }

    @Override
    public Stock left(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".left(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public LegendItemSettings legendItem(String value) {
        return new LegendItemSettings(String.format(Locale.US, this.jsBase + ".legendItem(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public MarkersFactory markers(String value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".markers(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public MarkersFactory markers(Boolean value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".markers(%s)", value));
    }

    @Override
    public void maxHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxHeight();");
    }

    @Override
    public Stock maxHeight(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", value));
        return this;
    }

    @Override
    public Stock maxHeight(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxHeight(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void maxWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".maxWidth();");
    }

    @Override
    public Stock maxWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", value));
        return this;
    }

    @Override
    public Stock maxWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".maxWidth(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void meta(String object_or_key, String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".meta(%s, %s);", Stock.wrapQuotes(object_or_key), Stock.wrapQuotes(value)));
    }

    @Override
    public void minHeight() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minHeight();");
    }

    @Override
    public Stock minHeight(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", value));
        return this;
    }

    @Override
    public Stock minHeight(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minHeight(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void minWidth() {
        APIlib.getInstance().addJSLine(this.jsBase + ".minWidth();");
    }

    @Override
    public Stock minWidth(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", value));
        return this;
    }

    @Override
    public Stock minWidth(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minWidth(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock name(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".name(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public MarkersFactory outlierMarkers(String value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".outlierMarkers(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public MarkersFactory outlierMarkers(Boolean value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".outlierMarkers(%s)", value));
    }

    @Override
    public void print(PaperSize paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", paperSizeOrOptions != null ? paperSizeOrOptions.getJsBase() : null, landscape));
    }

    @Override
    public void print(String paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", Stock.wrapQuotes(paperSizeOrOptions), landscape));
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Stock.wrapQuotes(type)));
    }

    @Override
    public void right() {
        APIlib.getInstance().addJSLine(this.jsBase + ".right();");
    }

    @Override
    public Stock right(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", value));
        return this;
    }

    @Override
    public Stock right(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".right(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public LabelsFactory selectLabels(String value) {
        return new LabelsFactory(String.format(Locale.US, this.jsBase + ".selectLabels(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public LabelsFactory selectLabels(Boolean value) {
        return new LabelsFactory(String.format(Locale.US, this.jsBase + ".selectLabels(%s)", value));
    }

    @Override
    public MarkersFactory selectMarkers(String value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".selectMarkers(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public MarkersFactory selectMarkers(Boolean value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".selectMarkers(%s)", value));
    }

    @Override
    public MarkersFactory selectOutlierMarkers(String value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".selectOutlierMarkers(%s)", Stock.wrapQuotes(value)));
    }

    @Override
    public MarkersFactory selectOutlierMarkers(Boolean value) {
        return new MarkersFactory(String.format(Locale.US, this.jsBase + ".selectOutlierMarkers(%s)", value));
    }

    @Override
    public Stock seriesType(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".seriesType(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock tooltip(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".tooltip(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public Stock tooltip(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".tooltip(%s);", value));
        return this;
    }

    @Override
    public void top() {
        APIlib.getInstance().addJSLine(this.jsBase + ".top();");
    }

    @Override
    public Stock top(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", value));
        return this;
    }

    @Override
    public Stock top(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".top(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public void transformX(String value, Number subRangeRatio) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".transformX(%s, %s);", Stock.wrapQuotes(value), subRangeRatio));
    }

    @Override
    public void transformY(String value, Number subRangeRatio) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".transformY(%s, %s);", Stock.wrapQuotes(value), subRangeRatio));
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Stock.wrapQuotes(key)));
    }

    @Override
    public void width() {
        APIlib.getInstance().addJSLine(this.jsBase + ".width();");
    }

    @Override
    public Stock width(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", value));
        return this;
    }

    @Override
    public Stock width(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".width(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    @Override
    public com.anychart.scales.Base yScale(com.anychart.scales.Base value) {
        return new com.anychart.scales.Base(String.format(Locale.US, this.jsBase + ".yScale(%s)", value != null ? value.getJsBase() : null));
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public Stock zIndex(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", value));
        return this;
    }

    public TableMapping data(View data) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".data(%s)", data != null ? data.getJsBase() : null));
    }

    public TableMapping data(List<DataEntry> data, TreeFillingMethod fillMethod) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".data(%s, %s)", Stock.arrayToString(data), fillMethod != null ? fillMethod.getJsBase() : null));
    }

    public TableMapping data(List<DataEntry> data, String fillMethod) {
        return new TableMapping(String.format(Locale.US, this.jsBase + ".data(%s, %s)", Stock.arrayToString(data), Stock.wrapQuotes(fillMethod)));
    }

    @Override
    public Object yScale(Class scaleClass) {
        Object instance = null;
        try {
            instance = scaleClass.getDeclaredConstructor(String.class).newInstance(this.jsBase + ".yScale()");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return instance;
    }
}

