/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core.grids;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.VisualBase;
import com.anychart.core.axes.Linear;
import com.anychart.core.axes.StockDateTime;
import com.anychart.core.grids.Map;
import com.anychart.graphics.math.Rect;
import com.anychart.graphics.vector.ColoredFill;
import com.anychart.graphics.vector.Fill;
import com.anychart.graphics.vector.GradientKey;
import com.anychart.graphics.vector.PaperSize;
import com.anychart.graphics.vector.Stroke;
import com.anychart.graphics.vector.StrokeLineCap;
import com.anychart.graphics.vector.StrokeLineJoin;
import com.anychart.palettes.DistinctColors;
import com.anychart.palettes.RangeColors;
import com.anychart.scales.Base;
import com.anychart.scales.StockScatterDateTime;
import java.util.Locale;

public class Stock
extends VisualBase {
    protected Stock() {
    }

    public static Stock instantiate() {
        return new Stock("new anychart.core.grids.stock()");
    }

    public Stock(String jsChart) {
        this.jsBase = "stock" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public StockDateTime axis() {
        return new StockDateTime(this.jsBase + ".axis()");
    }

    public Stock axis(StockDateTime value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".axis(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Stock axis(Linear value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".axis(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public void drawFirstLine() {
        APIlib.getInstance().addJSLine(this.jsBase + ".drawFirstLine();");
    }

    public Stock drawFirstLine(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".drawFirstLine(%s);", value));
        return this;
    }

    public void drawLastLine() {
        APIlib.getInstance().addJSLine(this.jsBase + ".drawLastLine();");
    }

    public Stock drawLastLine(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".drawLastLine(%s);", value));
        return this;
    }

    @Override
    public void enabled() {
        APIlib.getInstance().addJSLine(this.jsBase + ".enabled();");
    }

    @Override
    public Stock enabled(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".enabled(%s);", value));
        return this;
    }

    public void fill() {
        APIlib.getInstance().addJSLine(this.jsBase + ".fill();");
    }

    public Stock fill(Fill value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Map fill(String fillFunction) {
        return new Map(String.format(Locale.US, this.jsBase + ".fill(%s)", Stock.wrapQuotes(fillFunction)));
    }

    public Stock fill(String color, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s);", Stock.wrapQuotes(color), opacity));
        return this;
    }

    public Stock fill(GradientKey keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode, opacity));
        return this;
    }

    public Stock fill(GradientKey keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Stock fill(GradientKey keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, angle, Stock.wrapQuotes(mode), opacity));
        return this;
    }

    public Stock fill(String[] keys, Number angle, Boolean mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, mode, opacity));
        return this;
    }

    public Stock fill(String[] keys, Number angle, com.anychart.graphics.vector.Rect mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, mode != null ? mode.getJsBase() : null, opacity));
        return this;
    }

    public Stock fill(String[] keys, Number angle, String mode, Number opacity) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), angle, Stock.wrapQuotes(mode), opacity));
        return this;
    }

    public Stock fill(GradientKey keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s, %s, %s, %s);", keys != null ? keys.getJsBase() : null, cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public Stock fill(String[] keys, Number cx, Number cy, Rect mode, Number opacity, Number fx, Number fy) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".fill(%s, %s, %s, %s, %s, %s, %s);", Stock.arrayToStringWrapQuotes(keys), cx, cy, mode != null ? mode.getJsBase() : null, opacity, fx, fy));
        return this;
    }

    public void isHorizontal() {
        APIlib.getInstance().addJSLine(this.jsBase + ".isHorizontal();");
    }

    public void isMinor() {
        APIlib.getInstance().addJSLine(this.jsBase + ".isMinor();");
    }

    public Stock isMinor(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".isMinor(%s);", value));
        return this;
    }

    public RangeColors palette() {
        return new RangeColors(this.jsBase + ".palette()");
    }

    public Map palette(RangeColors value) {
        return new Map(String.format(Locale.US, this.jsBase + ".palette(%s)", value != null ? value.getJsBase() : null));
    }

    public Map palette(DistinctColors value) {
        return new Map(String.format(Locale.US, this.jsBase + ".palette(%s)", value != null ? value.getJsBase() : null));
    }

    public Map palette(String value) {
        return new Map(String.format(Locale.US, this.jsBase + ".palette(%s)", Stock.wrapQuotes(value)));
    }

    public Map palette(String[] value) {
        return new Map(String.format(Locale.US, this.jsBase + ".palette(%s)", Stock.arrayToStringWrapQuotes(value)));
    }

    @Override
    public void print(PaperSize paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", paperSizeOrOptions != null ? paperSizeOrOptions.getJsBase() : null, landscape));
    }

    @Override
    public void print(String paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", Stock.wrapQuotes(paperSizeOrOptions), landscape));
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", Stock.wrapQuotes(type)));
    }

    public Base scale() {
        return new Base(this.jsBase + ".scale()");
    }

    public Stock scale(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scale(%s);", Stock.wrapQuotes(value)));
        return this;
    }

    public Stock scale(Base value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scale(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public Stock scale(StockScatterDateTime value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".scale(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public void stroke() {
        APIlib.getInstance().addJSLine(this.jsBase + ".stroke();");
    }

    public Stock stroke(Stroke color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock stroke(Stroke color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock stroke(Stroke color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock stroke(Stroke color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock stroke(ColoredFill color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock stroke(ColoredFill color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock stroke(ColoredFill color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock stroke(ColoredFill color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", color != null ? color.getJsBase() : null, thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock stroke(String color, Number thickness, String dashpattern, String lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock stroke(String color, Number thickness, String dashpattern, String lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), Stock.wrapQuotes(lineJoin), lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    public Stock stroke(String color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, String lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, Stock.wrapQuotes(lineCap)));
        return this;
    }

    public Stock stroke(String color, Number thickness, String dashpattern, StrokeLineJoin lineJoin, StrokeLineCap lineCap) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s, %s, %s, %s, %s);", Stock.wrapQuotes(color), thickness, Stock.wrapQuotes(dashpattern), lineJoin != null ? lineJoin.getJsBase() : null, lineCap != null ? lineCap.getJsBase() : null));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", Stock.wrapQuotes(key)));
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public Stock zIndex(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", value));
        return this;
    }

    public Stock stroke(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".stroke(%s);", Stock.wrapQuotes(value)));
        return this;
    }
}

