/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.core.axes;

import com.anychart.APIlib;
import com.anychart.chart.common.listener.ListenersInterface;
import com.anychart.core.VisualBase;
import com.anychart.core.axes.StockTicks;
import com.anychart.core.ui.Background;
import com.anychart.core.ui.LabelsFactory;
import com.anychart.enums.StockLabelsOverlapMode;
import com.anychart.graphics.vector.PaperSize;
import java.util.Locale;

public class StockDateTime
extends VisualBase {
    protected StockDateTime() {
    }

    public static StockDateTime instantiate() {
        return new StockDateTime("new anychart.core.axes.stockDateTime()");
    }

    public StockDateTime(String jsChart) {
        this.jsBase = "stockDateTime" + ++variableIndex;
        APIlib.getInstance().addJSLine(this.jsBase + " = " + jsChart + ";");
    }

    @Override
    public String getJsBase() {
        return this.jsBase;
    }

    public Background background() {
        return new Background(this.jsBase + ".background()");
    }

    public StockDateTime background(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".background(%s);", StockDateTime.wrapQuotes(value)));
        return this;
    }

    public StockDateTime background(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".background(%s);", value));
        return this;
    }

    @Override
    public void enabled() {
        APIlib.getInstance().addJSLine(this.jsBase + ".enabled();");
    }

    @Override
    public StockDateTime enabled(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".enabled(%s);", value));
        return this;
    }

    public void height() {
        APIlib.getInstance().addJSLine(this.jsBase + ".height();");
    }

    public StockDateTime height(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".height(%s);", value));
        return this;
    }

    public LabelsFactory labels() {
        return new LabelsFactory(this.jsBase + ".labels()");
    }

    public StockDateTime labels(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".labels(%s);", StockDateTime.wrapQuotes(value)));
        return this;
    }

    public StockDateTime labels(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".labels(%s);", value));
        return this;
    }

    public LabelsFactory minorLabels() {
        return new LabelsFactory(this.jsBase + ".minorLabels()");
    }

    public StockDateTime minorLabels(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minorLabels(%s);", StockDateTime.wrapQuotes(value)));
        return this;
    }

    public StockDateTime minorLabels(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minorLabels(%s);", value));
        return this;
    }

    public StockTicks minorTicks() {
        return new StockTicks(this.jsBase + ".minorTicks()");
    }

    public StockDateTime minorTicks(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minorTicks(%s);", StockDateTime.wrapQuotes(value)));
        return this;
    }

    public StockDateTime minorTicks(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".minorTicks(%s);", value));
        return this;
    }

    public void overlapMode() {
        APIlib.getInstance().addJSLine(this.jsBase + ".overlapMode();");
    }

    public StockDateTime overlapMode(StockLabelsOverlapMode value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".overlapMode(%s);", value != null ? value.getJsBase() : null));
        return this;
    }

    public StockDateTime overlapMode(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".overlapMode(%s);", StockDateTime.wrapQuotes(value)));
        return this;
    }

    @Override
    public void print(PaperSize paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", paperSizeOrOptions != null ? paperSizeOrOptions.getJsBase() : null, landscape));
    }

    @Override
    public void print(String paperSizeOrOptions, Boolean landscape) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".print(%s, %s);", StockDateTime.wrapQuotes(paperSizeOrOptions), landscape));
    }

    @Override
    public void removeAllListeners(String type) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".removeAllListeners(%s);", StockDateTime.wrapQuotes(type)));
    }

    public void showHelperLabel() {
        APIlib.getInstance().addJSLine(this.jsBase + ".showHelperLabel();");
    }

    public StockDateTime showHelperLabel(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".showHelperLabel(%s);", value));
        return this;
    }

    public StockTicks ticks() {
        return new StockTicks(this.jsBase + ".ticks()");
    }

    public StockDateTime ticks(String value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".ticks(%s);", StockDateTime.wrapQuotes(value)));
        return this;
    }

    public StockDateTime ticks(Boolean value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".ticks(%s);", value));
        return this;
    }

    @Override
    public void setOnClickListener(ListenersInterface.OnClickListener listener) {
        StringBuilder js = new StringBuilder();
        js.append(this.jsBase).append(".listen('pointClick', function(e) {");
        if (listener.getFields() != null) {
            js.append("var result = ");
            for (String field : listener.getFields()) {
                js.append(String.format(Locale.US, "'%1$s' + ':' + e.point.get('%1$s') + ',' +", field));
            }
            js.setLength(js.length() - 8);
            js.append(";");
            js.append("android.onClick(result);");
        } else {
            js.append("android.onClick(null);");
        }
        js.append("});");
        ListenersInterface.getInstance().setOnClickListener(listener);
        APIlib.getInstance().addJSLine(js.toString());
    }

    @Override
    public void unlistenByKey(String key) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".unlistenByKey(%s);", StockDateTime.wrapQuotes(key)));
    }

    @Override
    public void zIndex() {
        APIlib.getInstance().addJSLine(this.jsBase + ".zIndex();");
    }

    @Override
    public StockDateTime zIndex(Number value) {
        APIlib.getInstance().addJSLine(String.format(Locale.US, this.jsBase + ".zIndex(%s);", value));
        return this;
    }
}

