/*
 * Decompiled with CFR 0.152.
 */
package com.anychart.anychart;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.anychart.anychart.Chart;
import com.anychart.anychart.JsObject;
import com.anychart.anychart.R;
import com.anychart.anychart.application.MyApplication;

public final class AnyChartView
extends FrameLayout {
    private WebView webView;
    private Chart chart;
    protected StringBuilder js = new StringBuilder();

    public AnyChartView(Context context) {
        super(context);
        this.init();
    }

    public AnyChartView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AnyChartView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.view_anychart, (ViewGroup)this, true);
        this.webView = (WebView)view.findViewById(R.id.web_view);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setLoadsImagesAutomatically(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setLoadWithOverviewMode(true);
        this.webView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                Log.e((String)"AnyChart", (String)consoleMessage.message());
                return true;
            }
        });
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                if (AnyChartView.this.chart == null) {
                    throw new NullPointerException();
                }
                AnyChartView.this.js.append(AnyChartView.this.chart.generateJs());
                String resultJs = AnyChartView.this.js.append("chart.container(\"container\");chart.draw();").toString();
                if (Build.VERSION.SDK_INT >= 19) {
                    AnyChartView.this.webView.evaluateJavascript("anychart.onDocumentReady(function () {\n" + resultJs + "});", null);
                } else {
                    AnyChartView.this.webView.loadUrl("javascript:anychart.onDocumentReady(function () {\n" + resultJs + "});");
                }
                AnyChartView.this.chart.setOnChangeListener(new JsObject.OnChange(){

                    @Override
                    public void onChange(String jsChange) {
                        if (Build.VERSION.SDK_INT >= 19) {
                            AnyChartView.this.webView.evaluateJavascript(jsChange, null);
                        } else {
                            AnyChartView.this.webView.loadUrl("javascript:" + jsChange);
                        }
                    }
                });
            }
        });
        this.webView.addJavascriptInterface((Object)MyApplication.getInstance().getJavaScriptInterface(), "android");
        this.webView.loadUrl("file:///android_asset/base.html");
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }
}

