package com.anychart.anychart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

// class
/**
 * Class representing independent clip, that can be applied to any element.<br/>
Used to set one clip to many elements, and updates only clip.
 */
public class Clip extends JsObject {

    public Clip() {
        js.setLength(0);
        js.append("var clip").append(++variableIndex).append(" = anychart.graphics.vector.clip();");
        jsBase = "clip" + variableIndex;
    }

    protected Clip(String jsBase) {
        js.setLength(0);
        this.jsBase = jsBase;
    }

    protected Clip(StringBuilder js, String jsBase, boolean isChain) {
        this.js = js;
        this.jsBase = jsBase;
        this.isChain = isChain;
    }

    protected String getJsBase() {
        return jsBase;
    }

    
    private Shape getShape;

    /**
     * Getter for the current shape of the clip.
     */
    public Shape getShape() {
        if (getShape == null)
            getShape = new Shape(jsBase + ".shape()");

        return getShape;
    }

    private Double[] shape;
    private Shape shape1;
    private GraphicsMathRect shape2;
    private String shape3;
    private List<Clip> setShape = new ArrayList<>();

    /**
     * Setter for the shape of the clip.
     */
    public Clip setShape(Double[] shape) {
        if (jsBase == null) {
            this.shape = null;
            this.shape1 = null;
            this.shape2 = null;
            this.shape3 = null;
            
            this.shape = shape;
        } else {
            this.shape = shape;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            js.append(String.format(Locale.US, ".shape(%s)", Arrays.toString(shape)));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".shape(%s)", Arrays.toString(shape)));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetShape() {
        if (!setShape.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Clip item : setShape) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private List<Clip> setShape1 = new ArrayList<>();

    /**
     * Setter for the shape of the clip.
     */
    public Clip setShape(Shape shape1) {
        if (jsBase == null) {
            this.shape = null;
            this.shape1 = null;
            this.shape2 = null;
            this.shape3 = null;
            
            this.shape1 = shape1;
        } else {
            this.shape1 = shape1;
            if (isChain) {
                js.append(";");
                isChain = false;
            }
            js.append(shape1.generateJs());
            js.append(jsBase);

            js.append(String.format(Locale.US, ".shape(%s);",  ((shape1 != null) ? shape1.getJsBase() : "null")));
        }
        return this;
    }
    private String generateJSsetShape1() {
        if (!setShape1.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Clip item : setShape1) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private List<Clip> setShape2 = new ArrayList<>();

    /**
     * Setter for the shape of the clip.
     */
    public Clip setShape(GraphicsMathRect shape2) {
        if (jsBase == null) {
            this.shape = null;
            this.shape1 = null;
            this.shape2 = null;
            this.shape3 = null;
            
            this.shape2 = shape2;
        } else {
            this.shape2 = shape2;
            if (isChain) {
                js.append(";");
                isChain = false;
            }
            js.append(shape2.generateJs());
            js.append(jsBase);

            js.append(String.format(Locale.US, ".shape(%s);",  ((shape2 != null) ? shape2.getJsBase() : "null")));
        }
        return this;
    }
    private String generateJSsetShape2() {
        if (!setShape2.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Clip item : setShape2) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private List<Clip> setShape3 = new ArrayList<>();

    /**
     * Setter for the shape of the clip.
     */
    public Clip setShape(String shape3) {
        if (jsBase == null) {
            this.shape = null;
            this.shape1 = null;
            this.shape2 = null;
            this.shape3 = null;
            
            this.shape3 = shape3;
        } else {
            this.shape3 = shape3;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            js.append(String.format(Locale.US, ".shape(%s)", wrapQuotes(shape3)));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".shape(%s)", wrapQuotes(shape3)));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetShape3() {
        if (!setShape3.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Clip item : setShape3) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private Double left;
    private Double top;
    private Double width;
    private Double height;
    private List<Clip> setShape4 = new ArrayList<>();

    /**
     * Setter for the shape of the clip with coordinates.
     */
    public Clip setShape(Double left, Double top, Double width, Double height) {
        if (jsBase == null) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
        } else {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
            if (!isChain) {
                js.append(jsBase);
                isChain = true;
            }
            js.append(String.format(Locale.US, ".shape(%f, %f, %f, %f)", left, top, width, height));

            if (isRendered) {
                onChangeListener.onChange(String.format(Locale.US, ".shape(%f, %f, %f, %f)", left, top, width, height));
                js.setLength(0);
            }
        }
        return this;
    }
    private String generateJSsetShape4() {
        if (!setShape4.isEmpty()) {
            StringBuilder resultJs = new StringBuilder();
            for (Clip item : setShape4) {
                resultJs.append(item.generateJs());
            }
            return resultJs.toString();
        }
        return "";
    }

    private String generateJSgetShape() {
        if (getShape != null) {
            return getShape.generateJs();
        }
        return "";
    }


    protected String generateJsGetters() {
        StringBuilder jsGetters = new StringBuilder();

        jsGetters.append(super.generateJsGetters());

    
        jsGetters.append(generateJSgetShape());

        return jsGetters.toString();
    }

    @Override
    protected String generateJs() {
        if (isChain) {
            js.append(";");
            isChain = false;
        }

        js.append(generateJsGetters());

        js.append(generateJSsetShape());
        js.append(generateJSsetShape1());
        js.append(generateJSsetShape2());
        js.append(generateJSsetShape3());
        js.append(generateJSsetShape4());
        

        String result = js.toString();
        js.setLength(0);
        return result;
    }

}