/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.annotation.processor;

import android.content.Context;
import android.util.Log;
import io.github.wax911.library.annotation.GraphQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class GraphProcessor {
    private static GraphProcessor ourInstance;
    private static final Object lock;
    private static final String defaultExtension = ".graphql";
    private static final String defaultDirectory = "graphql";
    private volatile Map<String, String> graphFiles;

    public static GraphProcessor getInstance(Context context) {
        if (ourInstance == null) {
            ourInstance = new GraphProcessor(context);
        }
        return ourInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphProcessor(Context context) {
        Object object = lock;
        synchronized (object) {
            Log.d((String)"GraphProcessor", (String)(Thread.currentThread().getName() + ": has obtained a synchronized lock on the object"));
            if (this.graphFiles == null) {
                this.graphFiles = new HashMap<String, String>();
            }
            if (this.isEmpty()) {
                Log.d((String)"GraphProcessor", (String)(Thread.currentThread().getName() + ": is initializing query files"));
                this.initialize(defaultDirectory, context);
                Log.d((String)"GraphProcessor", (String)(Thread.currentThread().getName() + ": has completed initializing all files"));
                Log.d((String)"GraphProcessor", (String)(Thread.currentThread().getName() + ": Total count of graphFiles -> size: " + this.graphFiles.size()));
            } else {
                Log.d((String)"GraphProcessor", (String)(Thread.currentThread().getName() + ": skipped initialization of graphFiles -> size: " + this.graphFiles.size()));
            }
        }
    }

    public String getQuery(Annotation[] annotations) {
        GraphQuery graphQuery = null;
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof GraphQuery)) continue;
            graphQuery = (GraphQuery)annotation;
            break;
        }
        if (this.graphFiles != null && graphQuery != null) {
            String fileName = String.format("%s%s", graphQuery.value(), defaultExtension);
            Log.d((String)"GraphProcessor", (String)fileName);
            if (this.graphFiles.containsKey(fileName)) {
                return this.graphFiles.get(fileName);
            }
            Log.e((String)this.toString(), (String)String.format("The request query %s could not be found!", graphQuery.value()));
            Log.e((String)this.toString(), (String)String.format("Current size of graphFiles -> size: %d", this.graphFiles.size()));
        }
        return null;
    }

    private synchronized boolean isEmpty() {
        return this.graphFiles.size() < 1;
    }

    private synchronized void initialize(String path, Context context) {
        try {
            String[] paths = context.getAssets().list(path);
            if (paths.length > 0) {
                for (String item : paths) {
                    String absolute = path + "/" + item;
                    if (!item.endsWith(defaultExtension)) {
                        this.initialize(absolute, context);
                        continue;
                    }
                    this.graphFiles.put(item, this.getFileContents(context.getAssets().open(absolute)));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized String getFileContents(InputStream inputStream) {
        StringBuilder queryBuffer = new StringBuilder();
        try {
            String line;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                queryBuffer.append(line);
            }
            inputStreamReader.close();
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return queryBuffer.toString();
    }

    static {
        lock = new Object();
    }
}

