/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.socket.util;

import android.net.Uri;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.amity.socialcloud.sdk.socket.util.UriTypeConverter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import org.joda.time.DateTime;
import timber.log.Timber;

public final class EkoGson {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(DateTime.class, (Object)new DateTimeTypeConverter()).registerTypeAdapter(Uri.class, (Object)new UriTypeConverter()).create();

    public static Gson get() {
        return GSON;
    }

    public static <T> T merge(T source, T patch, Class<T> classOfT) {
        try {
            JsonObject sourceJson = EkoGson.toJsonObject(source);
            JsonObject patchJson = EkoGson.toJsonObject(patch);
            AmityLog.INSTANCE.getLog().d("merge: %s sourceJson: %s", new Object[]{sourceJson.getClass().getName(), sourceJson});
            Timber.d((String)"merge: %s patchJson: %s", (Object[])new Object[]{patchJson.getClass().getName(), patchJson});
            for (Map.Entry entry : patchJson.entrySet()) {
                sourceJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            Timber.d((String)"merge: %s resultJson: %s", (Object[])new Object[]{sourceJson.getClass().getName(), sourceJson});
            return (T)GSON.fromJson((JsonElement)sourceJson, classOfT);
        }
        catch (Exception e) {
            AmityLog.INSTANCE.getLog().e((Throwable)e);
            return source;
        }
    }

    private static JsonObject toJsonObject(Object object) {
        JsonElement element = GSON.toJsonTree(object);
        JsonObject jsonObject = element instanceof JsonObject ? (JsonObject)element : new JsonObject();
        return jsonObject;
    }

    private EkoGson() {
    }
}

