/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics;

import com.almasb.gameutils.math.Vec2;
import javafx.scene.paint.Color;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.shapes.ChainShape;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.JBoxSettings;
import org.jbox2d.common.Transform;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureProxy;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.particle.ParticleColor;
import org.jbox2d.particle.ParticleSystem;
import org.jbox2d.pooling.arrays.Vec2Array;

public class WorldView {
    private DebugDraw debugDraw;
    private World world;
    private final Transform xf = new Transform();
    private final Vec2 cA = new Vec2();
    private final Vec2 cB = new Vec2();
    private final Vec2Array avs = new Vec2Array();
    private static Integer LIQUID_INT = new Integer(1234598372);
    private float liquidLength = 0.12f;
    private float averageLinearVel = -1.0f;
    private final Vec2 liquidOffset = new Vec2();
    private final Vec2 circCenterMoved = new Vec2();
    private final Color liquidColor = Color.color((double)0.4, (double)0.4, (double)1.0);
    private final Vec2 center = new Vec2();
    private final Vec2 axis = new Vec2();
    private final Vec2 v1 = new Vec2();
    private final Vec2 v2 = new Vec2();
    private final Vec2Array tlvertices = new Vec2Array();

    public WorldView(World world, DebugDraw debugDraw) {
        this.world = world;
        this.debugDraw = debugDraw;
    }

    public void drawDebugData() {
        Body b;
        boolean wireframe;
        Color color = Color.color((double)0.0, (double)0.0, (double)0.0);
        int flags = this.debugDraw.getFlags();
        boolean bl = wireframe = (flags & 0x80) != 0;
        if ((flags & 2) != 0) {
            for (b = this.world.getBodyList(); b != null; b = b.getNext()) {
                this.xf.set(b.getTransform());
                for (Fixture f : b.getFixtures()) {
                    if (!b.isActive()) {
                        color = Color.color((double)0.5, (double)0.5, (double)0.3f);
                        this.drawShape(f, this.xf, color, wireframe);
                        continue;
                    }
                    if (b.getType() == BodyType.STATIC) {
                        color = Color.color((double)0.5, (double)0.9f, (double)0.3f);
                        this.drawShape(f, this.xf, color, wireframe);
                        continue;
                    }
                    if (b.getType() == BodyType.KINEMATIC) {
                        color = Color.color((double)0.5, (double)0.5, (double)0.9f);
                        this.drawShape(f, this.xf, color, wireframe);
                        continue;
                    }
                    if (!b.isAwake()) {
                        color = Color.color((double)0.5, (double)0.5, (double)0.5);
                        this.drawShape(f, this.xf, color, wireframe);
                        continue;
                    }
                    color = Color.color((double)0.9f, (double)0.7f, (double)0.7f);
                    this.drawShape(f, this.xf, color, wireframe);
                }
            }
            this.drawParticleSystem(this.world.getParticleSystem());
        }
        if ((flags & 4) != 0) {
            for (Joint j = this.world.getJointList(); j != null; j = j.getNext()) {
                this.drawJoint(j);
            }
        }
        if ((flags & 0x10) != 0) {
            color = Color.color((double)0.3f, (double)0.9f, (double)0.9f);
            for (Contact c = this.world.getContactManager().m_contactList; c != null; c = c.getNext()) {
                Fixture fixtureA = c.getFixtureA();
                Fixture fixtureB = c.getFixtureB();
                fixtureA.getAABB(c.getChildIndexA()).getCenterToOut(this.cA);
                fixtureB.getAABB(c.getChildIndexB()).getCenterToOut(this.cB);
                this.debugDraw.drawSegment(this.cA, this.cB, color);
            }
        }
        if ((flags & 8) != 0) {
            color = Color.color((double)0.9f, (double)0.3f, (double)0.9f);
            for (b = this.world.getBodyList(); b != null; b = b.getNext()) {
                if (!b.isActive()) continue;
                for (Fixture f : b.getFixtures()) {
                    for (int i = 0; i < f.getProxyCount(); ++i) {
                        FixtureProxy proxy = f.m_proxies[i];
                        AABB aabb = this.world.getContactManager().m_broadPhase.getFatAABB(proxy.proxyId);
                        if (aabb == null) continue;
                        Vec2[] vs = this.avs.get(4);
                        vs[0].set(aabb.lowerBound.x, aabb.lowerBound.y);
                        vs[1].set(aabb.upperBound.x, aabb.lowerBound.y);
                        vs[2].set(aabb.upperBound.x, aabb.upperBound.y);
                        vs[3].set(aabb.lowerBound.x, aabb.upperBound.y);
                        this.debugDraw.drawPolygon(vs, 4, color);
                    }
                }
            }
        }
        if ((flags & 0x20) != 0) {
            for (b = this.world.getBodyList(); b != null; b = b.getNext()) {
                this.xf.set(b.getTransform());
                this.xf.p.set(b.getWorldCenter());
                this.debugDraw.drawTransform(this.xf);
            }
        }
        if ((flags & 0x40) != 0) {
            this.world.getContactManager().m_broadPhase.drawTree(this.debugDraw);
        }
        this.debugDraw.flush();
    }

    private void drawJoint(Joint joint) {
        Body bodyA = joint.getBodyA();
        Body bodyB = joint.getBodyB();
        Transform xf1 = bodyA.getTransform();
        Transform xf2 = bodyB.getTransform();
        Vec2 x1 = xf1.p;
        Vec2 x2 = xf2.p;
        Vec2 p1 = this.world.getPool().popVec2();
        Vec2 p2 = this.world.getPool().popVec2();
        joint.getAnchorA(p1);
        joint.getAnchorB(p2);
        Color color = Color.color((double)0.5, (double)0.8f, (double)0.8f);
        switch (joint.getType()) {
            case DISTANCE: {
                this.debugDraw.drawSegment(p1, p2, color);
                break;
            }
            case PULLEY: {
                PulleyJoint pulley = (PulleyJoint)joint;
                Vec2 s1 = pulley.getGroundAnchorA();
                Vec2 s2 = pulley.getGroundAnchorB();
                this.debugDraw.drawSegment(s1, p1, color);
                this.debugDraw.drawSegment(s2, p2, color);
                this.debugDraw.drawSegment(s1, s2, color);
                break;
            }
            case CONSTANT_VOLUME: 
            case MOUSE: {
                break;
            }
            default: {
                this.debugDraw.drawSegment(x1, p1, color);
                this.debugDraw.drawSegment(p1, p2, color);
                this.debugDraw.drawSegment(x2, p2, color);
            }
        }
        this.world.getPool().pushVec2(2);
    }

    private void drawShape(Fixture fixture, Transform xf, Color color, boolean wireframe) {
        switch (fixture.getType()) {
            case CIRCLE: {
                CircleShape circle = (CircleShape)fixture.getShape();
                Transform.mulToOutUnsafe(xf, circle.m_p, this.center);
                float radius = circle.getRadius();
                xf.q.getXAxis(this.axis);
                if (fixture.getUserData() != null && fixture.getUserData().equals(LIQUID_INT)) {
                    Body b = fixture.getBody();
                    this.liquidOffset.set(b.m_linearVelocity);
                    float linVelLength = b.m_linearVelocity.length();
                    this.averageLinearVel = this.averageLinearVel == -1.0f ? linVelLength : 0.98f * this.averageLinearVel + 0.02f * linVelLength;
                    this.liquidOffset.mulLocal(this.liquidLength / this.averageLinearVel / 2.0f);
                    this.circCenterMoved.set(this.center).addLocal(this.liquidOffset);
                    this.center.subLocal(this.liquidOffset);
                    this.debugDraw.drawSegment(this.center, this.circCenterMoved, this.liquidColor);
                    return;
                }
                if (wireframe) {
                    this.debugDraw.drawCircle(this.center, radius, this.axis, color);
                    break;
                }
                this.debugDraw.drawSolidCircle(this.center, radius, this.axis, color);
                break;
            }
            case POLYGON: {
                PolygonShape poly = (PolygonShape)fixture.getShape();
                int vertexCount = poly.getVertexCount();
                assert (vertexCount <= JBoxSettings.maxPolygonVertices);
                Vec2[] vertices = this.tlvertices.get(JBoxSettings.maxPolygonVertices);
                for (int i = 0; i < vertexCount; ++i) {
                    Transform.mulToOutUnsafe(xf, poly.m_vertices[i], vertices[i]);
                }
                if (wireframe) {
                    this.debugDraw.drawPolygon(vertices, vertexCount, color);
                    break;
                }
                this.debugDraw.drawSolidPolygon(vertices, vertexCount, color);
                break;
            }
            case EDGE: {
                EdgeShape edge = (EdgeShape)fixture.getShape();
                Transform.mulToOutUnsafe(xf, edge.m_vertex1, this.v1);
                Transform.mulToOutUnsafe(xf, edge.m_vertex2, this.v2);
                this.debugDraw.drawSegment(this.v1, this.v2, color);
                break;
            }
            case CHAIN: {
                ChainShape chain = (ChainShape)fixture.getShape();
                int count = chain.m_count;
                Vec2[] vertices = chain.m_vertices;
                Transform.mulToOutUnsafe(xf, vertices[0], this.v1);
                for (int i = 1; i < count; ++i) {
                    Transform.mulToOutUnsafe(xf, vertices[i], this.v2);
                    this.debugDraw.drawSegment(this.v1, this.v2, color);
                    this.debugDraw.drawCircle(this.v1, 0.05f, color);
                    this.v1.set(this.v2);
                }
                break;
            }
        }
    }

    private void drawParticleSystem(ParticleSystem system) {
        boolean wireframe = (this.debugDraw.getFlags() & 0x80) != 0;
        int particleCount = system.getParticleCount();
        if (particleCount != 0) {
            float particleRadius = system.getParticleRadius();
            Vec2[] positionBuffer = system.getParticlePositionBuffer();
            ParticleColor[] colorBuffer = null;
            if (system.m_colorBuffer.data != null) {
                colorBuffer = system.getParticleColorBuffer();
            }
            if (wireframe) {
                this.debugDraw.drawParticlesWireframe(positionBuffer, particleRadius, colorBuffer, particleCount);
            } else {
                this.debugDraw.drawParticles(positionBuffer, particleRadius, colorBuffer, particleCount);
            }
        }
    }
}

