/*
 * Decompiled with CFR 0.152.
 */
package net.ypresto.androidtranscoder.format;

import android.media.MediaFormat;
import net.ypresto.androidtranscoder.format.OutputFormatUnavailableException;

public class MediaFormatPresets {
    private static final int LONGER_LENGTH_960x540 = 960;

    private MediaFormatPresets() {
    }

    @Deprecated
    public static MediaFormat getExportPreset960x540() {
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)960, (int)540);
        format.setInteger("bitrate", 5500000);
        format.setInteger("color-format", 2130708361);
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 1);
        return format;
    }

    public static MediaFormat getExportPreset960x540(int originalWidth, int originalHeight) {
        int height;
        int width;
        int longerLength = Math.max(originalWidth, originalHeight);
        int shorterLength = Math.min(originalWidth, originalHeight);
        if (longerLength <= 960) {
            return null;
        }
        int residue = 960 * shorterLength % longerLength;
        if (residue != 0) {
            double ambiguousShorter = 960.0 * (double)shorterLength / (double)longerLength;
            throw new OutputFormatUnavailableException(String.format("Could not fit to integer, original: (%d, %d), scaled: (%d, %f)", longerLength, shorterLength, 960, ambiguousShorter));
        }
        int scaledShorter = 960 * shorterLength / longerLength;
        if (originalWidth >= originalHeight) {
            width = 960;
            height = scaledShorter;
        } else {
            width = scaledShorter;
            height = 960;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)width, (int)height);
        format.setInteger("bitrate", 5500000);
        format.setInteger("color-format", 2130708361);
        format.setInteger("frame-rate", 30);
        format.setInteger("i-frame-interval", 1);
        return format;
    }
}

