/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.versionchecklib.core;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import com.allenliu.versionchecklib.R;
import com.allenliu.versionchecklib.callback.DownloadListener;
import com.allenliu.versionchecklib.core.DownloadManager;
import com.allenliu.versionchecklib.core.PermissionDialogActivity;
import com.allenliu.versionchecklib.core.VersionParams;
import com.allenliu.versionchecklib.core.http.AllenHttp;
import com.allenliu.versionchecklib.core.http.HttpRequestMethod;
import com.allenliu.versionchecklib.utils.ALog;
import java.io.File;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class AVersionService
extends Service
implements DownloadListener {
    protected VersionParams versionParams;
    public static final String VERSION_PARAMS_KEY = "VERSION_PARAMS_KEY";
    public static final String VERSION_PARAMS_EXTRA_KEY = "VERSION_PARAMS_EXTRA_KEY";
    public static final String PERMISSION_ACTION = "com.allenliu.versionchecklib.filepermisssion.action";
    Callback stringCallback = new Callback(){

        public void onFailure(Call call, IOException e) {
            AVersionService.this.pauseRequest();
        }

        public void onResponse(Call call, Response response) throws IOException {
            if (response.isSuccessful()) {
                final String result = response.body().string();
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        AVersionService.this.onResponses(AVersionService.this, result);
                    }
                });
            } else {
                AVersionService.this.pauseRequest();
            }
        }
    };
    String downloadUrl;
    String title;
    String updateMsg;
    Bundle paramBundle;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        try {
            if (intent != null) {
                this.versionParams = (VersionParams)intent.getParcelableExtra(VERSION_PARAMS_KEY);
                this.verfiyAndDeleteAPK();
                if (this.versionParams.isOnlyDownload()) {
                    this.showVersionDialog(this.versionParams.getDownloadUrl(), this.versionParams.getTitle(), this.versionParams.getUpdateMsg(), this.versionParams.getParamBundle());
                } else {
                    this.requestVersionUrlSync();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void verfiyAndDeleteAPK() {
        try {
            String downloadPath = this.versionParams.getDownloadAPKPath() + this.getApplicationContext().getString(R.string.versionchecklib_download_apkname, new Object[]{this.getApplicationContext().getPackageName()});
            if (!DownloadManager.checkAPKIsExists(this.getApplicationContext(), downloadPath)) {
                ALog.e("\u5220\u9664\u672c\u5730apk");
                new File(downloadPath).delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void requestVersionUrlSync() {
        this.requestVersionUrl();
    }

    public abstract void onResponses(AVersionService var1, String var2);

    private void pauseRequest() {
        long pauseTime = this.versionParams.getPauseRequestTime();
        if (pauseTime > 0L) {
            ALog.e("\u8bf7\u6c42\u7248\u672c\u63a5\u53e3\u5931\u8d25\uff0c\u4e0b\u6b21\u8bf7\u6c42\u5c06\u5728" + pauseTime + "ms\u540e\u5f00\u59cb");
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    AVersionService.this.requestVersionUrlSync();
                }
            }, pauseTime);
        }
    }

    private void requestVersionUrl() {
        OkHttpClient client = AllenHttp.getHttpClient();
        HttpRequestMethod requestMethod = this.versionParams.getRequestMethod();
        Request request = null;
        switch (requestMethod) {
            case GET: {
                request = AllenHttp.get(this.versionParams).build();
                break;
            }
            case POST: {
                request = AllenHttp.post(this.versionParams).build();
                break;
            }
            case POSTJSON: {
                request = AllenHttp.postJson(this.versionParams).build();
            }
        }
        client.newCall(request).enqueue(this.stringCallback);
    }

    public void showVersionDialog(String downloadUrl, String title, String updateMsg) {
        this.showVersionDialog(downloadUrl, title, updateMsg, null);
    }

    public void showVersionDialog(String downloadUrl, String title, String updateMsg, Bundle paramBundle) {
        this.downloadUrl = downloadUrl;
        this.title = title;
        this.updateMsg = updateMsg;
        this.paramBundle = paramBundle;
        if (this.versionParams.isSilentDownload()) {
            VersionBroadCastReceiver receiver = new VersionBroadCastReceiver();
            IntentFilter intentFilter = new IntentFilter(PERMISSION_ACTION);
            this.registerReceiver(receiver, intentFilter);
            Intent intent = new Intent((Context)this, PermissionDialogActivity.class);
            intent.addFlags(0x10000000);
            this.startActivity(intent);
        } else {
            this.goToVersionDialog();
        }
    }

    private void silentDownload() {
        DownloadManager.downloadAPK(this.downloadUrl, this.versionParams, this);
    }

    @Override
    public void onCheckerDownloading(int progress) {
    }

    @Override
    public void onCheckerStartDownload() {
    }

    @Override
    public void onCheckerDownloadSuccess(File file) {
        this.goToVersionDialog();
    }

    @Override
    public void onCheckerDownloadFail() {
        this.stopSelf();
    }

    private void goToVersionDialog() {
        Intent intent = new Intent(this.getApplicationContext(), this.versionParams.getCustomDownloadActivityClass());
        if (this.updateMsg != null) {
            intent.putExtra("text", this.updateMsg);
        }
        if (this.downloadUrl != null) {
            intent.putExtra("downloadUrl", this.downloadUrl);
        }
        if (this.title != null) {
            intent.putExtra("title", this.title);
        }
        if (this.paramBundle != null) {
            this.versionParams.setParamBundle(this.paramBundle);
        }
        intent.putExtra(VERSION_PARAMS_KEY, (Parcelable)this.versionParams);
        intent.addFlags(0x10000000);
        this.startActivity(intent);
        this.stopSelf();
    }

    public void setVersionParams(VersionParams versionParams) {
        this.versionParams = versionParams;
    }

    public class VersionBroadCastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(AVersionService.PERMISSION_ACTION)) {
                boolean result = intent.getBooleanExtra("result", false);
                if (result) {
                    AVersionService.this.silentDownload();
                }
                AVersionService.this.unregisterReceiver(this);
            }
        }
    }
}

