/*
 * Decompiled with CFR 0.152.
 */
package com.allenliu.sidebar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.allenliu.sidebar.ISideBarSelectCallBack;
import com.allenliu.sidebar.R;

public class SideBar
extends AppCompatTextView {
    private String[] letters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#"};
    private Paint textPaint;
    private Paint bigTextPaint;
    private ISideBarSelectCallBack callBack;
    private float eventY;
    private float w;
    private float sideTextWidth;
    private boolean isTouching = false;
    private float itemH;
    private float A = this.dp(100);
    private int gapBetweenText = this.dp(50);
    private int openCount = 13;
    private float fontScale = 1.0f;
    private float bigTextSize;

    public SideBar(Context context) {
        super(context);
        this.init(null);
    }

    public SideBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public SideBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public SideBar setFontScale(float fontScale) {
        this.fontScale = fontScale;
        return this;
    }

    public void setDataResource(String[] data) {
        this.letters = data;
        this.invalidate();
    }

    public void setOnStrSelectCallBack(ISideBarSelectCallBack callBack) {
        this.callBack = callBack;
    }

    public SideBar setBigTextSize(float bigTextSize) {
        this.bigTextSize = bigTextSize;
        this.bigTextPaint.setTextSize(bigTextSize);
        return this;
    }

    public SideBar setA(float a) {
        this.A = a;
        return this;
    }

    public SideBar setGapBetweenText(int gapBetweenText) {
        this.gapBetweenText = gapBetweenText;
        return this;
    }

    public SideBar setOpenCount(int openCount) {
        this.openCount = openCount;
        return this;
    }

    private void caculateAW(int height) {
        this.itemH = (float)height * 1.0f / (float)this.letters.length;
        float opendWidth = this.itemH * (float)this.openCount;
        this.w = (float)(Math.PI * 2 / (double)(opendWidth * 2.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.caculateAW(View.MeasureSpec.getSize((int)heightMeasureSpec));
        if (mode == 0 || mode == Integer.MIN_VALUE) {
            viewWidth = !this.isTouching ? (int)(this.sideTextWidth + (float)this.getPaddingLeft() + (float)this.getPaddingRight()) : (int)(this.A + (float)this.gapBetweenText + this.getBigTextWidth() + (float)this.getPaddingLeft() + (float)this.getPaddingRight());
        }
        this.setMeasuredDimension(viewWidth, View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SideBar);
            this.A = typedArray.getInteger(R.styleable.SideBar_A, this.dp(100));
            this.fontScale = typedArray.getFloat(R.styleable.SideBar_fontScale, 1.0f);
            this.bigTextSize = typedArray.getFloat(R.styleable.SideBar_bigTextSize, this.getTextSize() * 3.0f);
            this.gapBetweenText = typedArray.getInteger(R.styleable.SideBar_gapBetweenText, this.dp(50));
            this.openCount = typedArray.getInteger(R.styleable.SideBar_openCount, 13);
        } else {
            this.bigTextSize = this.getTextSize() * 3.0f;
        }
        this.textPaint = new Paint(1);
        this.textPaint.setColor(this.getCurrentTextColor());
        this.textPaint.setTextSize(this.getTextSize());
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.bigTextPaint = new Paint(1);
        this.bigTextPaint.setColor(this.getCurrentTextColor());
        this.bigTextPaint.setTextSize(this.bigTextSize);
        this.bigTextPaint.setTextAlign(Paint.Align.CENTER);
        float sideTextHeight = this.textPaint.getFontMetrics().descent - this.textPaint.getFontMetrics().ascent;
        this.sideTextWidth = this.textPaint.measureText("W");
    }

    private int dp(int v) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)((float)v * scale + 0.5f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int startTouchX = (int)((float)this.getMeasuredWidth() - this.A);
        switch (event.getAction()) {
            case 0: 
            case 2: {
                if (event.getX() > (float)startTouchX) {
                    this.eventY = event.getY();
                    if (!this.isTouching) {
                        this.isTouching = true;
                        this.requestLayout();
                    } else {
                        this.invalidate();
                    }
                } else if (this.isTouching) {
                    this.resetDefault();
                }
                return true;
            }
            case 1: 
            case 3: {
                this.resetDefault();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void resetDefault() {
        this.isTouching = false;
        this.eventY = 0.0f;
        this.requestLayout();
    }

    protected void onDraw(Canvas canvas) {
        int singleSideCount = this.openCount / 2;
        int index = this.isTouching && this.eventY >= 0.0f && this.eventY <= (float)this.getMeasuredHeight() ? (int)Math.floor(this.eventY / this.itemH) : -(singleSideCount + 1);
        float sideX = this.sideTextWidth / 2.0f + (float)this.getPaddingRight();
        for (int i = 0; i < this.letters.length; ++i) {
            int x;
            this.textPaint.setTextSize(this.getTextSize());
            int y = (int)(this.itemH * (float)(i + 1));
            if (Math.abs(i - index) > singleSideCount) {
                x = (int)((float)this.getMeasuredWidth() - sideX);
            } else {
                float percent = this.eventY / this.itemH;
                int t = (int)((float)i * this.itemH - this.eventY);
                double v = (double)this.A * Math.sin((double)(this.w * (float)t) + 1.5707963267948966);
                v = Math.max(v, (double)sideX);
                x = (int)((double)this.getMeasuredWidth() - v);
                if (v == (double)sideX) {
                    this.textPaint.setTextSize(this.getTextSize());
                } else {
                    float delta = Math.abs((float)i - percent) / (float)singleSideCount;
                    float textSize = this.getTextSize() + (1.0f - delta) * this.getTextSize() * this.fontScale;
                    this.textPaint.setTextSize(textSize);
                }
            }
            canvas.drawText(this.letters[i], (float)x, (float)y, this.textPaint);
        }
        if (index != -(singleSideCount + 1)) {
            canvas.drawText(this.letters[index], (float)this.getPaddingLeft() + this.getBigTextWidth() / 2.0f, (float)((int)(this.itemH * (float)(index + 1))), this.bigTextPaint);
            if (this.callBack != null) {
                this.callBack.onSelectStr(index, this.letters[index]);
            }
        }
    }

    private float getBigTextWidth() {
        return this.bigTextPaint.measureText("W");
    }
}

