/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeReaderVariable;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.ProtectionSchemeInformationBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SchemeInformationBox;
import com.coremedia.iso.boxes.SchemeTypeBox;
import com.coremedia.iso.boxes.SubSampleInformationBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.MemoryDataSourceImpl;
import com.googlecode.mp4parser.authoring.Edit;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.authoring.tracks.CencEncryptedTrack;
import com.googlecode.mp4parser.boxes.cenc.CencEncryptingSampleList;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.CencSampleEncryptionInformationGroupEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.RangeStartMap;
import com.mp4parser.iso14496.part15.AvcConfigurationBox;
import com.mp4parser.iso14496.part15.HevcConfigurationBox;
import com.mp4parser.iso23001.part7.CencSampleAuxiliaryDataFormat;
import com.mp4parser.iso23001.part7.TrackEncryptionBox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.crypto.SecretKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CencEncryptingTrackImpl
implements CencEncryptedTrack {
    private final String encryptionAlgo;
    Track source;
    Map<UUID, SecretKey> keys = new HashMap<UUID, SecretKey>();
    UUID defaultKeyId;
    List<Sample> samples;
    List<CencSampleAuxiliaryDataFormat> cencSampleAuxiliaryData;
    boolean dummyIvs = false;
    boolean subSampleEncryption = false;
    SampleDescriptionBox stsd = null;
    RangeStartMap<Integer, SecretKey> indexToKey;
    Map<GroupEntry, long[]> sampleGroups;

    public CencEncryptingTrackImpl(Track source, UUID defaultKeyId, SecretKey key, boolean dummyIvs) {
        this(source, defaultKeyId, Collections.singletonMap(defaultKeyId, key), null, "cenc", dummyIvs);
    }

    public CencEncryptingTrackImpl(Track source, UUID defaultKeyId, Map<UUID, SecretKey> keys, Map<CencSampleEncryptionInformationGroupEntry, long[]> keyRotation, String encryptionAlgo, boolean dummyIvs) {
        this(source, defaultKeyId, keys, keyRotation, encryptionAlgo, dummyIvs, false);
    }

    public CencEncryptingTrackImpl(Track source, UUID defaultKeyId, Map<UUID, SecretKey> keys, Map<CencSampleEncryptionInformationGroupEntry, long[]> keyRotation, String encryptionAlgo, boolean dummyIvs, boolean encryptButAllClear) {
        this.source = source;
        this.keys = keys;
        this.defaultKeyId = defaultKeyId;
        this.dummyIvs = dummyIvs;
        this.encryptionAlgo = encryptionAlgo;
        this.sampleGroups = new HashMap<GroupEntry, long[]>();
        for (Map.Entry<GroupEntry, long[]> entry : source.getSampleGroups().entrySet()) {
            if (entry.getKey() instanceof CencSampleEncryptionInformationGroupEntry) continue;
            this.sampleGroups.put(entry.getKey(), entry.getValue());
        }
        if (keyRotation != null) {
            for (Map.Entry<GroupEntry, long[]> entry : keyRotation.entrySet()) {
                this.sampleGroups.put(entry.getKey(), entry.getValue());
            }
        }
        this.sampleGroups = new HashMap<GroupEntry, long[]>(this.sampleGroups){

            @Override
            public long[] put(GroupEntry key, long[] value) {
                if (key instanceof CencSampleEncryptionInformationGroupEntry) {
                    throw new RuntimeException("Please supply CencSampleEncryptionInformationGroupEntries in the constructor");
                }
                return super.put(key, value);
            }
        };
        this.samples = source.getSamples();
        this.cencSampleAuxiliaryData = new ArrayList<CencSampleAuxiliaryDataFormat>();
        BigInteger bigInteger = new BigInteger("1");
        byte[] init = new byte[8];
        if (!dummyIvs) {
            SecureRandom random = new SecureRandom();
            ((Random)random).nextBytes(init);
        }
        BigInteger ivInt = new BigInteger(1, init);
        ArrayList<CencSampleEncryptionInformationGroupEntry> groupEntries = new ArrayList<CencSampleEncryptionInformationGroupEntry>();
        if (keyRotation != null) {
            groupEntries.addAll(keyRotation.keySet());
        }
        this.indexToKey = new RangeStartMap();
        int lastSampleGroupDescriptionIndex = -1;
        int i = 0;
        while (i < source.getSamples().size()) {
            int index = 0;
            int j = 0;
            while (j < groupEntries.size()) {
                GroupEntry groupEntry = (GroupEntry)groupEntries.get(j);
                long[] sampleNums = this.getSampleGroups().get(groupEntry);
                if (Arrays.binarySearch(sampleNums, (long)i) >= 0) {
                    index = j + 1;
                }
                ++j;
            }
            if (lastSampleGroupDescriptionIndex != index) {
                if (index == 0) {
                    this.indexToKey.put(i, keys.get(defaultKeyId));
                } else if (((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid() != null) {
                    SecretKey sk = keys.get(((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid());
                    if (sk == null) {
                        throw new RuntimeException("Key " + ((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid() + " was not supplied for decryption");
                    }
                    this.indexToKey.put(i, sk);
                } else {
                    this.indexToKey.put(i, null);
                }
                lastSampleGroupDescriptionIndex = index;
            }
            ++i;
        }
        List<Box> boxes = source.getSampleDescriptionBox().getSampleEntry().getBoxes();
        int nalLengthSize = -1;
        for (Box box : boxes) {
            if (box instanceof AvcConfigurationBox) {
                AvcConfigurationBox avcC = (AvcConfigurationBox)box;
                this.subSampleEncryption = true;
                nalLengthSize = avcC.getLengthSizeMinusOne() + 1;
            }
            if (!(box instanceof HevcConfigurationBox)) continue;
            HevcConfigurationBox hvcC = (HevcConfigurationBox)box;
            this.subSampleEncryption = true;
            nalLengthSize = hvcC.getLengthSizeMinusOne() + 1;
        }
        int i2 = 0;
        while (i2 < this.samples.size()) {
            Sample origSample = this.samples.get(i2);
            CencSampleAuxiliaryDataFormat e = new CencSampleAuxiliaryDataFormat();
            this.cencSampleAuxiliaryData.add(e);
            if (this.indexToKey.get(i2) != null) {
                byte[] iv = ivInt.toByteArray();
                byte[] eightByteIv = new byte[8];
                System.arraycopy(iv, iv.length - 8 > 0 ? iv.length - 8 : 0, eightByteIv, 8 - iv.length < 0 ? 0 : 8 - iv.length, iv.length > 8 ? 8 : iv.length);
                e.iv = eightByteIv;
                ByteBuffer sample = (ByteBuffer)origSample.asByteBuffer().rewind();
                if (this.subSampleEncryption) {
                    if (encryptButAllClear) {
                        e.pairs = new CencSampleAuxiliaryDataFormat.Pair[]{e.createPair(sample.remaining(), 0L)};
                    } else {
                        ArrayList<CencSampleAuxiliaryDataFormat.Pair> pairs = new ArrayList<CencSampleAuxiliaryDataFormat.Pair>(5);
                        while (sample.remaining() > 0) {
                            int nalLength = CastUtils.l2i(IsoTypeReaderVariable.read(sample, nalLengthSize));
                            int nalGrossSize = nalLength + nalLengthSize;
                            int clearBytes = nalGrossSize >= 112 ? 96 + nalGrossSize % 16 : nalGrossSize;
                            pairs.add(e.createPair(clearBytes, nalGrossSize - clearBytes));
                            sample.position(sample.position() + nalLength);
                        }
                        e.pairs = pairs.toArray(new CencSampleAuxiliaryDataFormat.Pair[pairs.size()]);
                    }
                }
                ivInt = ivInt.add(bigInteger);
            }
            ++i2;
        }
        System.err.println("");
    }

    @Override
    public UUID getDefaultKeyId() {
        return this.defaultKeyId;
    }

    @Override
    public boolean hasSubSampleEncryption() {
        return this.subSampleEncryption;
    }

    @Override
    public List<CencSampleAuxiliaryDataFormat> getSampleEncryptionEntries() {
        return this.cencSampleAuxiliaryData;
    }

    @Override
    public synchronized SampleDescriptionBox getSampleDescriptionBox() {
        if (this.stsd == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.source.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
                this.stsd = (SampleDescriptionBox)new IsoFile(new MemoryDataSourceImpl(baos.toByteArray())).getBoxes().get(0);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Dumping stsd to memory failed");
            }
            OriginalFormatBox originalFormatBox = new OriginalFormatBox();
            originalFormatBox.setDataFormat(this.stsd.getSampleEntry().getType());
            if (this.stsd.getSampleEntry() instanceof AudioSampleEntry) {
                ((AudioSampleEntry)this.stsd.getSampleEntry()).setType("enca");
            } else if (this.stsd.getSampleEntry() instanceof VisualSampleEntry) {
                ((VisualSampleEntry)this.stsd.getSampleEntry()).setType("encv");
            } else {
                throw new RuntimeException("I don't know how to cenc " + this.stsd.getSampleEntry().getType());
            }
            ProtectionSchemeInformationBox sinf = new ProtectionSchemeInformationBox();
            sinf.addBox(originalFormatBox);
            SchemeTypeBox schm = new SchemeTypeBox();
            schm.setSchemeType(this.encryptionAlgo);
            schm.setSchemeVersion(65536);
            sinf.addBox(schm);
            SchemeInformationBox schi = new SchemeInformationBox();
            TrackEncryptionBox trackEncryptionBox = new TrackEncryptionBox();
            trackEncryptionBox.setDefaultIvSize(this.defaultKeyId == null ? 0 : 8);
            trackEncryptionBox.setDefaultAlgorithmId(this.defaultKeyId == null ? 0 : 1);
            trackEncryptionBox.setDefault_KID(this.defaultKeyId == null ? new UUID(0L, 0L) : this.defaultKeyId);
            schi.addBox(trackEncryptionBox);
            sinf.addBox(schi);
            this.stsd.getSampleEntry().addBox(sinf);
        }
        return this.stsd;
    }

    @Override
    public long[] getSampleDurations() {
        return this.source.getSampleDurations();
    }

    @Override
    public long getDuration() {
        return this.source.getDuration();
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.source.getCompositionTimeEntries();
    }

    @Override
    public long[] getSyncSamples() {
        return this.source.getSyncSamples();
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.source.getSampleDependencies();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.source.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.source.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return new CencEncryptingSampleList(this.indexToKey, this.source.getSamples(), this.cencSampleAuxiliaryData, this.encryptionAlgo);
    }

    @Override
    public SubSampleInformationBox getSubsampleInformationBox() {
        return this.source.getSubsampleInformationBox();
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    @Override
    public String getName() {
        return "enc(" + this.source.getName() + ")";
    }

    @Override
    public List<Edit> getEdits() {
        return this.source.getEdits();
    }

    @Override
    public Map<GroupEntry, long[]> getSampleGroups() {
        return this.sampleGroups;
    }
}

