/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary.video;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.abedelazizshe.lightcompressorlibrary.video.Sample;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.DecoderConfigDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.ESDescriptor;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.SLConfigDescriptor;
import com.mp4parser.iso14496.part15.AvcConfigurationBox;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\nJ\u0006\u0010(\u001a\u00020\fJ\u0006\u0010)\u001a\u00020\u000fJ\u0006\u0010*\u001a\u00020\u0003J\u0006\u0010+\u001a\u00020\u0014J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u0016J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016J\b\u0010.\u001a\u0004\u0018\u00010/J\u0006\u00100\u001a\u00020\u0003J\u0006\u00101\u001a\u00020\fJ\u0006\u00102\u001a\u00020 J\u0006\u00103\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0007J\u0014\u00104\u001a\u000205*\u0002052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u00104\u001a\u000206*\u0002062\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0002J\f\u00104\u001a\u000209*\u000209H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/video/Track;", "", "id", "", "format", "Landroid/media/MediaFormat;", "audio", "", "(ILandroid/media/MediaFormat;Z)V", "creationTime", "Ljava/util/Date;", "duration", "", "first", "handler", "", "height", "isAudio", "lastPresentationTimeUs", "sampleDescriptionBox", "Lcom/coremedia/iso/boxes/SampleDescriptionBox;", "sampleDurations", "Ljava/util/ArrayList;", "samples", "Lcom/abedelazizshe/lightcompressorlibrary/video/Sample;", "samplingFrequencyIndexMap", "", "syncSamples", "Ljava/util/LinkedList;", "timeScale", "trackId", "volume", "", "width", "addSample", "", "offset", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "getCreationTime", "getDuration", "getHandler", "getHeight", "getSampleDescriptionBox", "getSampleDurations", "getSamples", "getSyncSamples", "", "getTimeScale", "getTrackId", "getVolume", "getWidth", "setup", "Lcom/coremedia/iso/boxes/sampleentry/AudioSampleEntry;", "Lcom/coremedia/iso/boxes/sampleentry/VisualSampleEntry;", "w", "h", "Lcom/googlecode/mp4parser/boxes/mp4/objectdescriptors/DecoderConfigDescriptor;", "lightcompressor_release"})
public final class Track {
    private long trackId;
    @NotNull
    private final ArrayList<Sample> samples;
    private long duration;
    @NotNull
    private String handler;
    @NotNull
    private SampleDescriptionBox sampleDescriptionBox;
    @Nullable
    private LinkedList<Integer> syncSamples;
    private int timeScale;
    @NotNull
    private final Date creationTime;
    private int height;
    private int width;
    private float volume;
    @NotNull
    private final ArrayList<Long> sampleDurations;
    private final boolean isAudio;
    @NotNull
    private Map<Integer, Integer> samplingFrequencyIndexMap;
    private long lastPresentationTimeUs;
    private boolean first;

    public Track(int id, @NotNull MediaFormat format, boolean audio) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.samples = new ArrayList();
        this.creationTime = new Date();
        this.sampleDurations = new ArrayList();
        this.isAudio = audio;
        this.samplingFrequencyIndexMap = new HashMap();
        this.first = true;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)96000, (Object)0), TuplesKt.to((Object)88200, (Object)1), TuplesKt.to((Object)64000, (Object)2), TuplesKt.to((Object)48000, (Object)3), TuplesKt.to((Object)44100, (Object)4), TuplesKt.to((Object)32000, (Object)5), TuplesKt.to((Object)24000, (Object)6), TuplesKt.to((Object)22050, (Object)7), TuplesKt.to((Object)16000, (Object)8), TuplesKt.to((Object)12000, (Object)9), TuplesKt.to((Object)11025, (Object)10), TuplesKt.to((Object)8000, (Object)11)};
        this.samplingFrequencyIndexMap = MapsKt.mapOf((Pair[])pairArray);
        this.trackId = id;
        if (!this.isAudio) {
            this.sampleDurations.add(3015L);
            this.duration = 3015L;
            this.width = format.getInteger("width");
            this.height = format.getInteger("height");
            this.timeScale = 90000;
            this.syncSamples = new LinkedList();
            this.handler = "vide";
            this.sampleDescriptionBox = new SampleDescriptionBox();
            String mime = format.getString("mime");
            if (Intrinsics.areEqual((Object)mime, (Object)"video/avc")) {
                VisualSampleEntry visualSampleEntry = this.setup(new VisualSampleEntry("avc1"), this.width, this.height);
                AvcConfigurationBox avcConfigurationBox = new AvcConfigurationBox();
                if (format.getByteBuffer("csd-0") != null) {
                    ByteBuffer ppsBuff;
                    ByteBuffer spsBuff;
                    ArrayList<byte[]> spsArray = new ArrayList<byte[]>();
                    ByteBuffer byteBuffer = spsBuff = format.getByteBuffer("csd-0");
                    Intrinsics.checkNotNull((Object)byteBuffer);
                    byteBuffer.position(4);
                    byte[] spsBytes = new byte[spsBuff.remaining()];
                    spsBuff.get(spsBytes);
                    spsArray.add(spsBytes);
                    ArrayList<byte[]> ppsArray = new ArrayList<byte[]>();
                    ByteBuffer byteBuffer2 = ppsBuff = format.getByteBuffer("csd-1");
                    if (byteBuffer2 != null) {
                        ByteBuffer it = byteBuffer2;
                        boolean bl = false;
                        it.position(4);
                        byte[] ppsBytes = new byte[it.remaining()];
                        it.get(ppsBytes);
                        ppsArray.add(ppsBytes);
                        avcConfigurationBox.setSequenceParameterSets((List)spsArray);
                        avcConfigurationBox.setPictureParameterSets((List)ppsArray);
                    }
                }
                if (format.containsKey("level")) {
                    switch (format.getInteger("level")) {
                        case 1: {
                            avcConfigurationBox.setAvcLevelIndication(1);
                            break;
                        }
                        case 32: {
                            avcConfigurationBox.setAvcLevelIndication(2);
                            break;
                        }
                        case 4: {
                            avcConfigurationBox.setAvcLevelIndication(11);
                            break;
                        }
                        case 8: {
                            avcConfigurationBox.setAvcLevelIndication(12);
                            break;
                        }
                        case 16: {
                            avcConfigurationBox.setAvcLevelIndication(13);
                            break;
                        }
                        case 64: {
                            avcConfigurationBox.setAvcLevelIndication(21);
                            break;
                        }
                        case 128: {
                            avcConfigurationBox.setAvcLevelIndication(22);
                            break;
                        }
                        case 256: {
                            avcConfigurationBox.setAvcLevelIndication(3);
                            break;
                        }
                        case 512: {
                            avcConfigurationBox.setAvcLevelIndication(31);
                            break;
                        }
                        case 1024: {
                            avcConfigurationBox.setAvcLevelIndication(32);
                            break;
                        }
                        case 2048: {
                            avcConfigurationBox.setAvcLevelIndication(4);
                            break;
                        }
                        case 4096: {
                            avcConfigurationBox.setAvcLevelIndication(41);
                            break;
                        }
                        case 8192: {
                            avcConfigurationBox.setAvcLevelIndication(42);
                            break;
                        }
                        case 16384: {
                            avcConfigurationBox.setAvcLevelIndication(5);
                            break;
                        }
                        case 32768: {
                            avcConfigurationBox.setAvcLevelIndication(51);
                            break;
                        }
                        case 65536: {
                            avcConfigurationBox.setAvcLevelIndication(52);
                            break;
                        }
                        case 2: {
                            avcConfigurationBox.setAvcLevelIndication(27);
                            break;
                        }
                        default: {
                            avcConfigurationBox.setAvcLevelIndication(13);
                            break;
                        }
                    }
                } else {
                    avcConfigurationBox.setAvcLevelIndication(13);
                }
                if (format.containsKey("profile")) {
                    switch (format.getInteger("profile")) {
                        case 1: {
                            avcConfigurationBox.setAvcProfileIndication(66);
                            break;
                        }
                        case 2: {
                            avcConfigurationBox.setAvcProfileIndication(77);
                            break;
                        }
                        case 4: {
                            avcConfigurationBox.setAvcProfileIndication(88);
                            break;
                        }
                        case 8: {
                            avcConfigurationBox.setAvcProfileIndication(100);
                            break;
                        }
                        case 16: {
                            avcConfigurationBox.setAvcProfileIndication(110);
                            break;
                        }
                        case 32: {
                            avcConfigurationBox.setAvcProfileIndication(122);
                            break;
                        }
                        case 64: {
                            avcConfigurationBox.setAvcProfileIndication(244);
                            break;
                        }
                        case 524288: {
                            avcConfigurationBox.setAvcProfileIndication(488);
                            break;
                        }
                        case 65536: {
                            avcConfigurationBox.setAvcProfileIndication(244);
                            break;
                        }
                        default: {
                            avcConfigurationBox.setAvcProfileIndication(100);
                            break;
                        }
                    }
                } else {
                    avcConfigurationBox.setAvcProfileIndication(100);
                }
                avcConfigurationBox.setBitDepthLumaMinus8(-1);
                avcConfigurationBox.setBitDepthChromaMinus8(-1);
                avcConfigurationBox.setChromaFormat(-1);
                avcConfigurationBox.setConfigurationVersion(1);
                avcConfigurationBox.setLengthSizeMinusOne(3);
                avcConfigurationBox.setProfileCompatibility(0);
                visualSampleEntry.addBox((Box)avcConfigurationBox);
                this.sampleDescriptionBox.addBox((Box)visualSampleEntry);
            } else if (Intrinsics.areEqual((Object)mime, (Object)"video/mp4v")) {
                VisualSampleEntry visualSampleEntry = this.setup(new VisualSampleEntry("mp4v"), this.width, this.height);
                this.sampleDescriptionBox.addBox((Box)visualSampleEntry);
            }
        } else {
            this.sampleDurations.add(1024L);
            this.duration = 1024L;
            this.volume = 1.0f;
            this.timeScale = format.getInteger("sample-rate");
            this.handler = "soun";
            this.sampleDescriptionBox = new SampleDescriptionBox();
            AudioSampleEntry audioSampleEntry = this.setup(new AudioSampleEntry("mp4a"), format);
            ESDescriptorBox esds = new ESDescriptorBox();
            ESDescriptor descriptor = new ESDescriptor();
            descriptor.setEsId(0);
            SLConfigDescriptor slConfigDescriptor = new SLConfigDescriptor();
            slConfigDescriptor.setPredefined(2);
            descriptor.setSlConfigDescriptor(slConfigDescriptor);
            DecoderConfigDescriptor decoderConfigDescriptor = this.setup(new DecoderConfigDescriptor());
            AudioSpecificConfig audioSpecificConfig = new AudioSpecificConfig();
            audioSpecificConfig.setAudioObjectType(2);
            Integer n = this.samplingFrequencyIndexMap.get((int)audioSampleEntry.getSampleRate());
            Intrinsics.checkNotNull((Object)n);
            audioSpecificConfig.setSamplingFrequencyIndex(((Number)n).intValue());
            audioSpecificConfig.setChannelConfiguration(audioSampleEntry.getChannelCount());
            decoderConfigDescriptor.setAudioSpecificInfo(audioSpecificConfig);
            descriptor.setDecoderConfigDescriptor(decoderConfigDescriptor);
            ByteBuffer data = descriptor.serialize();
            esds.setEsDescriptor(descriptor);
            esds.setData(data);
            audioSampleEntry.addBox((Box)esds);
            this.sampleDescriptionBox.addBox((Box)audioSampleEntry);
        }
    }

    public final long getTrackId() {
        return this.trackId;
    }

    public final void addSample(long offset, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        boolean isSyncFrame = !this.isAudio && (bufferInfo.flags & 1) != 0;
        this.samples.add(new Sample(offset, bufferInfo.size));
        if (this.syncSamples != null && isSyncFrame) {
            LinkedList<Integer> linkedList = this.syncSamples;
            if (linkedList != null) {
                linkedList.add(this.samples.size());
            }
        }
        long delta = bufferInfo.presentationTimeUs - this.lastPresentationTimeUs;
        this.lastPresentationTimeUs = bufferInfo.presentationTimeUs;
        delta = (delta * (long)this.timeScale + 500000L) / 1000000L;
        if (!this.first) {
            this.sampleDurations.add(this.sampleDurations.size() - 1, delta);
            this.duration += delta;
        }
        this.first = false;
    }

    @NotNull
    public final ArrayList<Sample> getSamples() {
        return this.samples;
    }

    public final long getDuration() {
        return this.duration;
    }

    @NotNull
    public final String getHandler() {
        return this.handler;
    }

    @NotNull
    public final SampleDescriptionBox getSampleDescriptionBox() {
        return this.sampleDescriptionBox;
    }

    @Nullable
    public final long[] getSyncSamples() {
        block4: {
            block3: {
                if (this.syncSamples == null) break block3;
                LinkedList<Integer> linkedList = this.syncSamples;
                Intrinsics.checkNotNull(linkedList);
                if (!linkedList.isEmpty()) break block4;
            }
            return null;
        }
        LinkedList<Integer> linkedList = this.syncSamples;
        Intrinsics.checkNotNull(linkedList);
        long[] returns = new long[linkedList.size()];
        LinkedList<Integer> linkedList2 = this.syncSamples;
        Intrinsics.checkNotNull(linkedList2);
        int n = linkedList2.size();
        for (int i = 0; i < n; ++i) {
            LinkedList<Integer> linkedList3 = this.syncSamples;
            Intrinsics.checkNotNull(linkedList3);
            returns[i] = ((Number)linkedList3.get(i)).intValue();
        }
        return returns;
    }

    public final int getTimeScale() {
        return this.timeScale;
    }

    @NotNull
    public final Date getCreationTime() {
        return this.creationTime;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final float getVolume() {
        return this.volume;
    }

    @NotNull
    public final ArrayList<Long> getSampleDurations() {
        return this.sampleDurations;
    }

    public final boolean isAudio() {
        return this.isAudio;
    }

    private final DecoderConfigDescriptor setup(DecoderConfigDescriptor $this$setup) {
        DecoderConfigDescriptor decoderConfigDescriptor;
        DecoderConfigDescriptor $this$setup_u24lambda_u2d1 = decoderConfigDescriptor = $this$setup;
        boolean bl = false;
        $this$setup_u24lambda_u2d1.setObjectTypeIndication(64);
        $this$setup_u24lambda_u2d1.setStreamType(5);
        $this$setup_u24lambda_u2d1.setBufferSizeDB(1536);
        $this$setup_u24lambda_u2d1.setMaxBitRate(96000L);
        $this$setup_u24lambda_u2d1.setAvgBitRate(96000L);
        return decoderConfigDescriptor;
    }

    private final VisualSampleEntry setup(VisualSampleEntry $this$setup, int w, int h) {
        VisualSampleEntry visualSampleEntry;
        VisualSampleEntry $this$setup_u24lambda_u2d2 = visualSampleEntry = $this$setup;
        boolean bl = false;
        $this$setup_u24lambda_u2d2.setDataReferenceIndex(1);
        $this$setup_u24lambda_u2d2.setDepth(24);
        $this$setup_u24lambda_u2d2.setFrameCount(1);
        $this$setup_u24lambda_u2d2.setHorizresolution(72.0);
        $this$setup_u24lambda_u2d2.setVertresolution(72.0);
        $this$setup_u24lambda_u2d2.setWidth(w);
        $this$setup_u24lambda_u2d2.setHeight(h);
        $this$setup_u24lambda_u2d2.setCompressorname("AVC Coding");
        return visualSampleEntry;
    }

    private final AudioSampleEntry setup(AudioSampleEntry $this$setup, MediaFormat format) {
        AudioSampleEntry audioSampleEntry;
        AudioSampleEntry $this$setup_u24lambda_u2d3 = audioSampleEntry = $this$setup;
        boolean bl = false;
        $this$setup_u24lambda_u2d3.setChannelCount(format.getInteger("channel-count") == 1 ? 2 : format.getInteger("channel-count"));
        $this$setup_u24lambda_u2d3.setSampleRate((long)format.getInteger("sample-rate"));
        $this$setup_u24lambda_u2d3.setDataReferenceIndex(1);
        $this$setup_u24lambda_u2d3.setSampleSize(16);
        return audioSampleEntry;
    }
}

