/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary.utils;

import android.util.Log;
import com.abedelazizshe.lightcompressorlibrary.data.AtomsKt;
import com.abedelazizshe.lightcompressorlibrary.utils.NumbersUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/utils/StreamableVideo;", "", "()V", "ATOM_PREAMBLE_SIZE", "", "tag", "", "convert", "", "infile", "Ljava/nio/channels/FileChannel;", "outfile", "readAndFill", "buffer", "Ljava/nio/ByteBuffer;", "position", "", "safeClose", "", "closeable", "Ljava/io/Closeable;", "start", "in", "Ljava/io/File;", "out", "lightcompressor_release"})
public final class StreamableVideo {
    @NotNull
    public static final StreamableVideo INSTANCE = new StreamableVideo();
    @NotNull
    private static final String tag = "StreamableVideo";
    private static final int ATOM_PREAMBLE_SIZE = 8;

    private StreamableVideo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean start(@Nullable File in, @NotNull File out) throws IOException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        boolean ret = false;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(in);
            FileChannel infile = inStream.getChannel();
            outStream = new FileOutputStream(out);
            FileChannel outfile = outStream.getChannel();
            Intrinsics.checkNotNullExpressionValue((Object)infile, (String)"infile");
            Intrinsics.checkNotNullExpressionValue((Object)outfile, (String)"outfile");
            boolean bl2 = this.convert(infile, outfile);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean it = bl2;
            boolean bl5 = false;
            ret = it;
            bl = bl2;
        }
        finally {
            this.safeClose(inStream);
            this.safeClose(outStream);
            if (!ret) {
                out.delete();
            }
        }
        return bl;
    }

    private final boolean convert(FileChannel infile, FileChannel outfile) throws IOException {
        ByteBuffer atomBytes = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        int atomType = 0;
        long atomSize = 0L;
        long lastOffset = 0L;
        ByteBuffer moovAtom = null;
        ByteBuffer ftypAtom = null;
        long startOffset = 0L;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)atomBytes, (String)"atomBytes");
            if (!this.readAndFill(infile, atomBytes)) break;
            atomSize = NumbersUtilsKt.uInt32ToLong(atomBytes.getInt());
            atomType = atomBytes.getInt();
            if (atomType == AtomsKt.getFTYP_ATOM()) {
                int ftypAtomSize = NumbersUtilsKt.uInt32ToInt(atomSize);
                ftypAtom = ByteBuffer.allocate(ftypAtomSize).order(ByteOrder.BIG_ENDIAN);
                atomBytes.rewind();
                ftypAtom.put(atomBytes);
                if (infile.read(ftypAtom) < ftypAtomSize - 8) break;
                ftypAtom.flip();
                startOffset = infile.position();
            } else if (atomSize == 1L) {
                atomBytes.clear();
                if (!this.readAndFill(infile, atomBytes)) break;
                atomSize = NumbersUtilsKt.uInt64ToLong(atomBytes.getLong());
                infile.position(infile.position() + atomSize - (long)16);
            } else {
                infile.position(infile.position() + atomSize - (long)8);
            }
            if (atomType == AtomsKt.getFREE_ATOM() || atomType == AtomsKt.getJUNK_ATOM() || atomType == AtomsKt.getMDAT_ATOM() || atomType == AtomsKt.getMOOV_ATOM() || atomType == AtomsKt.getPNOT_ATOM() || atomType == AtomsKt.getSKIP_ATOM() || atomType == AtomsKt.getWIDE_ATOM() || atomType == AtomsKt.getPICT_ATOM() || atomType == AtomsKt.getUUID_ATOM() || atomType == AtomsKt.getFTYP_ATOM()) continue;
            Log.wtf((String)tag, (String)"encountered non-QT top-level atom (is this a QuickTime file?)");
            break;
        } while (atomSize >= 8L);
        if (atomType != AtomsKt.getMOOV_ATOM()) {
            Log.wtf((String)tag, (String)"last atom in file was not a moov atom");
            return false;
        }
        int moovAtomSize = NumbersUtilsKt.uInt32ToInt(atomSize);
        lastOffset = infile.size() - (long)moovAtomSize;
        ByteBuffer byteBuffer = ByteBuffer.allocate(moovAtomSize).order(ByteOrder.BIG_ENDIAN);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(moovAtomSize).order(ByteOrder.BIG_ENDIAN)");
        moovAtom = byteBuffer;
        if (!this.readAndFill(infile, moovAtom, lastOffset)) {
            throw new Exception("failed to read moov atom");
        }
        if (moovAtom.getInt(12) == AtomsKt.getCMOV_ATOM()) {
            throw new Exception("this utility does not support compressed moov atoms yet");
        }
        while (moovAtom.remaining() >= 8) {
            int i;
            int n;
            int atomHead = moovAtom.position();
            atomType = moovAtom.getInt(atomHead + 4);
            if (atomType != AtomsKt.getSTCO_ATOM() && atomType != AtomsKt.getCO64_ATOM()) {
                moovAtom.position(moovAtom.position() + 1);
                continue;
            }
            atomSize = NumbersUtilsKt.uInt32ToLong(moovAtom.getInt(atomHead));
            if (atomSize > (long)moovAtom.remaining()) {
                throw new Exception("bad atom size");
            }
            moovAtom.position(atomHead + 12);
            if (moovAtom.remaining() < 4) {
                throw new Exception("malformed atom");
            }
            int offsetCount = NumbersUtilsKt.uInt32ToInt(moovAtom.getInt());
            if (atomType == AtomsKt.getSTCO_ATOM()) {
                Log.i((String)tag, (String)"patching stco atom...");
                if (moovAtom.remaining() < offsetCount * 4) {
                    throw new Exception("bad atom size/element count");
                }
                n = 0;
                if (n >= offsetCount) continue;
                do {
                    i = n++;
                    int currentOffset = moovAtom.getInt(moovAtom.position());
                    int newOffset = currentOffset + moovAtomSize;
                    if (currentOffset < 0 && newOffset >= 0) {
                        throw new Exception("This is bug in original qt-faststart.c: stco atom should be extended to co64 atom as new offset value overflows uint32, but is not implemented.");
                    }
                    moovAtom.putInt(newOffset);
                } while (n < offsetCount);
                continue;
            }
            if (atomType != AtomsKt.getCO64_ATOM()) continue;
            Log.wtf((String)tag, (String)"patching co64 atom...");
            if (moovAtom.remaining() < offsetCount * 8) {
                throw new Exception("bad atom size/element count");
            }
            n = 0;
            if (n >= offsetCount) continue;
            do {
                i = n++;
                long currentOffset = moovAtom.getLong(moovAtom.position());
                moovAtom.putLong(currentOffset + (long)moovAtomSize);
            } while (n < offsetCount);
        }
        infile.position(startOffset);
        if (ftypAtom != null) {
            Log.i((String)tag, (String)"writing ftyp atom...");
            ftypAtom.rewind();
            outfile.write(ftypAtom);
        }
        Log.i((String)tag, (String)"writing moov atom...");
        moovAtom.rewind();
        outfile.write(moovAtom);
        Log.i((String)tag, (String)"copying rest of file...");
        infile.transferTo(startOffset, lastOffset - startOffset, outfile);
        return true;
    }

    private final void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                Log.wtf((String)tag, (String)"Failed to close file: ");
            }
        }
    }

    private final boolean readAndFill(FileChannel infile, ByteBuffer buffer) throws IOException {
        buffer.clear();
        int size = infile.read(buffer);
        buffer.flip();
        return size == buffer.capacity();
    }

    private final boolean readAndFill(FileChannel infile, ByteBuffer buffer, long position) throws IOException {
        buffer.clear();
        int size = infile.read(buffer, position);
        buffer.flip();
        return size == buffer.capacity();
    }
}

