/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.OutputSurface;
import com.abedelazizshe.lightcompressorlibrary.Result;
import com.abedelazizshe.lightcompressorlibrary.VideoQuality;
import com.abedelazizshe.lightcompressorlibrary.config.Configuration;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.ypresto.qtfaststart.QtFastStart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 JH\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J,\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004022\u0006\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0010H\u0002J\u0018\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u00020\rH\u0002J\u0018\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020<H\u0002J\u0017\u0010=\u001a\u0004\u0018\u00010\u00042\u0006\u0010>\u001a\u00020?H\u0003\u00a2\u0006\u0002\u0010@J\u0017\u0010A\u001a\u0004\u0018\u00010\u00042\u0006\u0010>\u001a\u00020?H\u0003\u00a2\u0006\u0002\u0010@J\u0017\u0010B\u001a\u0004\u0018\u00010\u00042\u0006\u0010>\u001a\u00020?H\u0003\u00a2\u0006\u0002\u0010@J\u0010\u0010C\u001a\u00020\u00042\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010D\u001a\u00020\u00042\u0006\u0010>\u001a\u00020?H\u0002J\u001f\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010IJ\u001f\u0010J\u001a\u00020\r2\u0006\u0010F\u001a\u00020G2\b\u0010K\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010IJ\u0014\u0010L\u001a\u00020\"2\n\u0010M\u001a\u00060Nj\u0002`OH\u0002J \u0010P\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010Q\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0002J\u0018\u0010R\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010S\u001a\u00020\u0010H\u0002J \u0010T\u001a\u00020\"2\u0006\u0010U\u001a\u00020?2\u0006\u0010V\u001a\u00020?2\u0006\u0010W\u001a\u00020\u0004H\u0002J\u0018\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\\H\u0002J0\u0010]\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006^"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/Compressor;", "", "()V", "FRAME_RATE", "", "INVALID_BITRATE", "", "I_FRAME_INTERVAL", "MEDIACODEC_TIMEOUT_DEFAULT", "", "MIME_TYPE", "MIN_BITRATE", "MIN_HEIGHT", "", "MIN_WIDTH", "isRunning", "", "()Z", "setRunning", "(Z)V", "compressVideo", "Lcom/abedelazizshe/lightcompressorlibrary/Result;", "context", "Landroid/content/Context;", "srcUri", "Landroid/net/Uri;", "srcPath", "destination", "streamableFile", "configuration", "Lcom/abedelazizshe/lightcompressorlibrary/config/Configuration;", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "dispose", "", "extractor", "Landroid/media/MediaExtractor;", "videoIndex", "decoder", "Landroid/media/MediaCodec;", "encoder", "inputSurface", "Lcom/abedelazizshe/lightcompressorlibrary/InputSurface;", "outputSurface", "Lcom/abedelazizshe/lightcompressorlibrary/OutputSurface;", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "keepOriginalResolution", "generateWidthHeightValue", "value", "factor", "getBitrate", "bitrate", "quality", "Lcom/abedelazizshe/lightcompressorlibrary/VideoQuality;", "getColorRange", "format", "Landroid/media/MediaFormat;", "(Landroid/media/MediaFormat;)Ljava/lang/Integer;", "getColorStandard", "getColorTransfer", "getFrameRate", "getIFrameIntervalRate", "prepareVideoHeight", "mediaMetadataRetriever", "Landroid/media/MediaMetadataRetriever;", "videoHeight", "(Landroid/media/MediaMetadataRetriever;Ljava/lang/Double;)D", "prepareVideoWidth", "videoWidth", "printException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processAudio", "roundEven", "selectTrack", "isVideo", "setOutputFileParameters", "inputFormat", "outputFormat", "newBitrate", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/Mp4Movie;", "rotation", "cacheFile", "Ljava/io/File;", "validateInputs", "lightcompressor_release"})
public final class Compressor {
    @NotNull
    public static final Compressor INSTANCE = new Compressor();
    private static final int MIN_BITRATE = 2000000;
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 360.0;
    private static final int FRAME_RATE = 30;
    private static final int I_FRAME_INTERVAL = 2;
    @NotNull
    private static final String MIME_TYPE = "video/avc";
    private static final long MEDIACODEC_TIMEOUT_DEFAULT = 100L;
    @NotNull
    private static final String INVALID_BITRATE = "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false";
    private static boolean isRunning = true;

    private Compressor() {
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    @NotNull
    public final Result compressVideo(@Nullable Context context, @Nullable Uri srcUri, @Nullable String srcPath, @NotNull String destination, @Nullable String streamableFile, @NotNull Configuration configuration, @NotNull CompressionProgressListener listener) {
        int n;
        boolean bl;
        String durationData;
        String bitrateData;
        String rotationData;
        double width;
        double height;
        MediaExtractor extractor;
        block70: {
            block69: {
                Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
                String string = this.validateInputs(context, srcUri, srcPath, configuration);
                if (string != null) {
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it = string2;
                    boolean bl4 = false;
                    return new Result(false, it);
                }
                extractor = new MediaExtractor();
                if (context != null && srcUri != null && srcPath == null) {
                    try {
                        mediaMetadataRetriever.setDataSource(context, srcUri);
                    }
                    catch (IllegalArgumentException exception) {
                        this.printException(exception);
                        return new Result(false, String.valueOf(exception.getMessage()));
                    }
                    extractor.setDataSource(context, srcUri, null);
                } else {
                    try {
                        mediaMetadataRetriever.setDataSource(srcPath);
                    }
                    catch (IllegalArgumentException exception) {
                        this.printException(exception);
                        return new Result(false, String.valueOf(exception.getMessage()));
                    }
                    Intrinsics.checkNotNull((Object)srcPath);
                    File file = new File(srcPath);
                    if (!file.canRead()) {
                        return new Result(false, "The source file cannot be accessed!");
                    }
                    extractor.setDataSource(file.toString());
                }
                height = this.prepareVideoHeight(mediaMetadataRetriever, configuration.getVideoHeight());
                width = this.prepareVideoWidth(mediaMetadataRetriever, configuration.getVideoWidth());
                rotationData = mediaMetadataRetriever.extractMetadata(24);
                bitrateData = mediaMetadataRetriever.extractMetadata(20);
                durationData = mediaMetadataRetriever.extractMetadata(9);
                CharSequence charSequence = rotationData;
                boolean bl5 = false;
                bl = false;
                if (charSequence == null || charSequence.length() == 0) break block69;
                charSequence = bitrateData;
                bl5 = false;
                bl = false;
                if (charSequence == null || charSequence.length() == 0) break block69;
                charSequence = durationData;
                bl5 = false;
                bl = false;
                if (!(charSequence == null || charSequence.length() == 0)) break block70;
            }
            return new Result(false, "Failed to extract video meta-data, please try again");
        }
        String string = rotationData;
        bl = false;
        int rotation = Integer.parseInt(string);
        String string3 = bitrateData;
        boolean bl6 = false;
        int bitrate = Integer.parseInt(string3);
        String string4 = durationData;
        boolean bl7 = false;
        long duration = Long.parseLong(string4) * (long)1000;
        if (configuration.isMinBitRateEnabled() && bitrate <= 2000000) {
            return new Result(false, INVALID_BITRATE);
        }
        if (configuration.getVideoBitrate() == null) {
            n = this.getBitrate(bitrate, configuration.getQuality());
        } else {
            Integer n2 = configuration.getVideoBitrate();
            Intrinsics.checkNotNull((Object)n2);
            n = n2;
        }
        int newBitrate = n;
        Pair pair = configuration.getVideoHeight() != null ? new Pair((Object)((int)width), (Object)((int)height)) : this.generateWidthAndHeight(width, height, configuration.getKeepOriginalResolution());
        int newWidth = ((Number)pair.component1()).intValue();
        int newHeight = ((Number)pair.component2()).intValue();
        int n3 = rotation;
        switch (n3) {
            case 90: 
            case 270: {
                int tempHeight = newHeight;
                newHeight = newWidth;
                newWidth = tempHeight;
                int n4 = 0;
                break;
            }
            case 180: {
                int n4 = 0;
                break;
            }
            default: {
                int n4 = rotation = rotation;
            }
        }
        if (newWidth != 0 && newHeight != 0) {
            Unit unit;
            File cacheFile = new File(destination);
            try {
                MediaCodec mediaCodec;
                MediaCodec mediaCodec2;
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                Mp4Movie movie = this.setUpMP4Movie(rotation, cacheFile);
                MP4Builder mediaMuxer = new MP4Builder().createMovie(movie);
                int videoIndex = this.selectTrack(extractor, true);
                extractor.selectTrack(videoIndex);
                extractor.seekTo(0L, 0);
                MediaFormat mediaFormat = extractor.getTrackFormat(videoIndex);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(videoIndex)");
                MediaFormat inputFormat = mediaFormat;
                MediaFormat mediaFormat2 = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)newWidth, (int)newHeight);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat2, (String)"createVideoFormat(MIME_TYPE, newWidth, newHeight)");
                MediaFormat outputFormat = mediaFormat2;
                this.setOutputFileParameters(inputFormat, outputFormat, newBitrate);
                MediaCodec decoder = null;
                boolean hasQTI = false;
                MediaCodecInfo[] list = new MediaCodecList(0).getCodecInfos();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
                for (MediaCodecInfo codec : list) {
                    Log.i((String)"CODECS: ", (String)codec.getName());
                    String string5 = codec.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"codec.name");
                    if (!StringsKt.contains$default((CharSequence)string5, (CharSequence)"qti.avc", (boolean)false, (int)2, null)) continue;
                    hasQTI = true;
                    break;
                }
                if (hasQTI) {
                    mediaCodec2 = MediaCodec.createByCodecName((String)"c2.android.avc.encoder");
                    Intrinsics.checkNotNullExpressionValue((Object)mediaCodec2, (String)"{\n                    MediaCodec.createByCodecName(\"c2.android.avc.encoder\")\n                }");
                    mediaCodec = mediaCodec2;
                } else {
                    mediaCodec2 = MediaCodec.createEncoderByType((String)MIME_TYPE);
                    Intrinsics.checkNotNullExpressionValue((Object)mediaCodec2, (String)"{\n                    MediaCodec.createEncoderByType(MIME_TYPE)\n                }");
                    mediaCodec = mediaCodec2;
                }
                MediaCodec encoder = mediaCodec;
                InputSurface inputSurface = null;
                OutputSurface outputSurface = null;
                try {
                    boolean inputDone = false;
                    boolean outputDone = false;
                    int videoTrackIndex = -5;
                    encoder.configure(outputFormat, null, null, 1);
                    inputSurface = new InputSurface(encoder.createInputSurface());
                    inputSurface.makeCurrent();
                    encoder.start();
                    outputSurface = new OutputSurface();
                    String string6 = inputFormat.getString("mime");
                    Intrinsics.checkNotNull((Object)string6);
                    MediaCodec mediaCodec3 = MediaCodec.createDecoderByType((String)string6);
                    Intrinsics.checkNotNullExpressionValue((Object)mediaCodec3, (String)"createDecoderByType(inputFormat.getString(MediaFormat.KEY_MIME)!!)");
                    decoder = mediaCodec3;
                    decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                    decoder.start();
                    while (!outputDone) {
                        if (!inputDone) {
                            int inputBufferIndex;
                            int index = extractor.getSampleTrackIndex();
                            if (index == videoIndex) {
                                int inputBufferIndex2 = decoder.dequeueInputBuffer(100L);
                                if (inputBufferIndex2 >= 0) {
                                    ByteBuffer inputBuffer = decoder.getInputBuffer(inputBufferIndex2);
                                    Intrinsics.checkNotNull((Object)inputBuffer);
                                    int chunkSize = extractor.readSampleData(inputBuffer, 0);
                                    if (chunkSize < 0) {
                                        decoder.queueInputBuffer(inputBufferIndex2, 0, 0, 0L, 4);
                                        inputDone = true;
                                    } else {
                                        decoder.queueInputBuffer(inputBufferIndex2, 0, chunkSize, extractor.getSampleTime(), 0);
                                        extractor.advance();
                                    }
                                }
                            } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(100L)) >= 0) {
                                decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                inputDone = true;
                            }
                        }
                        boolean decoderOutputAvailable = true;
                        boolean encoderOutputAvailable = true;
                        while (decoderOutputAvailable || encoderOutputAvailable) {
                            if (!isRunning) {
                                listener.onProgressCancelled();
                                return new Result(false, "The compression has been stopped!");
                            }
                            int encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 100L);
                            if (encoderStatus == -1) {
                                encoderOutputAvailable = false;
                            } else if (encoderStatus == -2) {
                                MediaFormat mediaFormat3 = encoder.getOutputFormat();
                                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat3, (String)"encoder.outputFormat");
                                MediaFormat newFormat = mediaFormat3;
                                if (videoTrackIndex == -5) {
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            } else if (encoderStatus != -3) {
                                ByteBuffer byteBuffer;
                                if (encoderStatus < 0) {
                                    throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from encoder.dequeueOutputBuffer: ", (Object)encoderStatus));
                                }
                                ByteBuffer byteBuffer2 = encoder.getOutputBuffer(encoderStatus);
                                if (byteBuffer2 == null) {
                                    throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                                }
                                ByteBuffer encodedData = byteBuffer = byteBuffer2;
                                if (bufferInfo.size > 1) {
                                    if ((bufferInfo.flags & 2) == 0) {
                                        mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                    } else if (videoTrackIndex == -5) {
                                        byte[] csd = new byte[bufferInfo.size];
                                        byteBuffer2 = encodedData;
                                        boolean bl8 = false;
                                        int n5 = 0;
                                        ByteBuffer $this$compressVideo_u24lambda_u2d1 = byteBuffer2;
                                        boolean bl9 = false;
                                        $this$compressVideo_u24lambda_u2d1.limit(bufferInfo.offset + bufferInfo.size);
                                        $this$compressVideo_u24lambda_u2d1.position(bufferInfo.offset);
                                        $this$compressVideo_u24lambda_u2d1.get(csd);
                                        ByteBuffer sps = null;
                                        ByteBuffer pps = null;
                                        n5 = bufferInfo.size - 1;
                                        if (0 <= n5) {
                                            int a;
                                            while ((a = n5--) > 3) {
                                                if (csd[a] == 1 && csd[a - 1] == 0 && csd[a - 2] == 0 && csd[a - 3] == 0) {
                                                    sps = ByteBuffer.allocate(a - 3);
                                                    pps = ByteBuffer.allocate(bufferInfo.size - (a - 3));
                                                    Intrinsics.checkNotNull((Object)sps);
                                                    sps.put(csd, 0, a - 3).position(0);
                                                    Intrinsics.checkNotNull((Object)pps);
                                                    pps.put(csd, a - 3, bufferInfo.size - (a - 3)).position(0);
                                                    break;
                                                }
                                                if (0 <= n5) continue;
                                            }
                                        }
                                        MediaFormat mediaFormat4 = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)newWidth, (int)newHeight);
                                        Intrinsics.checkNotNullExpressionValue((Object)mediaFormat4, (String)"createVideoFormat(\n                                                MIME_TYPE,\n                                                newWidth,\n                                                newHeight\n                                            )");
                                        MediaFormat newFormat = mediaFormat4;
                                        if (sps != null && pps != null) {
                                            newFormat.setByteBuffer("csd-0", sps);
                                            newFormat.setByteBuffer("csd-1", pps);
                                        }
                                        videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                    }
                                }
                                outputDone = (bufferInfo.flags & 4) != 0;
                                encoder.releaseOutputBuffer(encoderStatus, false);
                            }
                            if (encoderStatus != -1) continue;
                            int decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 100L);
                            if (decoderStatus == -1) {
                                decoderOutputAvailable = false;
                                continue;
                            }
                            if (decoderStatus == -3 || decoderStatus == -2) continue;
                            if (decoderStatus < 0) {
                                throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from decoder.dequeueOutputBuffer: ", (Object)decoderStatus));
                            }
                            boolean doRender = bufferInfo.size != 0;
                            decoder.releaseOutputBuffer(decoderStatus, doRender);
                            if (doRender) {
                                boolean errorWait = false;
                                try {
                                    outputSurface.awaitNewImage();
                                }
                                catch (Exception e) {
                                    errorWait = true;
                                    String string7 = e.getMessage();
                                    Log.e((String)"Compressor", (String)(string7 == null ? "Compression failed at swapping buffer" : string7));
                                }
                                if (!errorWait) {
                                    outputSurface.drawImage();
                                    inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                                    listener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                                    inputSurface.swapBuffers();
                                }
                            }
                            if ((bufferInfo.flags & 4) == 0) continue;
                            decoderOutputAvailable = false;
                            encoder.signalEndOfInputStream();
                        }
                    }
                }
                catch (Exception exception) {
                    this.printException(exception);
                    return new Result(false, exception.getMessage());
                }
                Intrinsics.checkNotNullExpressionValue((Object)mediaMuxer, (String)"mediaMuxer");
                this.dispose(extractor, videoIndex, decoder, encoder, inputSurface, outputSurface, mediaMuxer, bufferInfo);
                extractor.release();
                try {
                    mediaMuxer.finishMovie();
                }
                catch (Exception e) {
                    this.printException(e);
                }
            }
            catch (Exception exception) {
                this.printException(exception);
            }
            String string8 = streamableFile;
            if (string8 == null) {
                unit = null;
            } else {
                String string9 = string8;
                boolean bl10 = false;
                boolean bl11 = false;
                String it = string9;
                boolean bl12 = false;
                try {
                    boolean result = QtFastStart.fastStart((File)cacheFile, (File)new File(it));
                    if (result && cacheFile.exists()) {
                        cacheFile.delete();
                    }
                }
                catch (Exception e) {
                    INSTANCE.printException(e);
                }
                unit = Unit.INSTANCE;
            }
            return new Result(true, null);
        }
        return new Result(false, "Something went wrong, please try again");
    }

    private final void dispose(MediaExtractor extractor, int videoIndex, MediaCodec decoder, MediaCodec encoder, InputSurface inputSurface, OutputSurface outputSurface, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        extractor.unselectTrack(videoIndex);
        decoder.stop();
        decoder.release();
        encoder.stop();
        encoder.release();
        inputSurface.release();
        outputSurface.release();
        this.processAudio(extractor, mediaMuxer, bufferInfo);
    }

    private final void printException(Exception exception) {
        String message = null;
        message = "An error has occurred!";
        String string = exception.getMessage();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            message = it;
        }
        Log.e((String)"Compressor", (String)message);
    }

    private final int getBitrate(int bitrate, VideoQuality quality) {
        int n;
        VideoQuality videoQuality = quality;
        int n2 = WhenMappings.$EnumSwitchMapping$0[videoQuality.ordinal()];
        switch (n2) {
            case 1: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.08));
                break;
            }
            case 2: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.1));
                break;
            }
            case 3: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.2));
                break;
            }
            case 4: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.3));
                break;
            }
            case 5: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.5));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final Pair<Integer, Integer> generateWidthAndHeight(double width, double height, boolean keepOriginalResolution) {
        if (keepOriginalResolution) {
            return new Pair((Object)MathKt.roundToInt((double)width), (Object)MathKt.roundToInt((double)height));
        }
        int newWidth = 0;
        int newHeight = 0;
        if (width >= 1920.0 || height >= 1920.0) {
            newWidth = this.generateWidthHeightValue(width, 0.5);
            newHeight = this.generateWidthHeightValue(height, 0.5);
        } else if (width >= 1280.0 || height >= 1280.0) {
            newWidth = this.generateWidthHeightValue(width, 0.75);
            newHeight = this.generateWidthHeightValue(height, 0.75);
        } else if (width >= 960.0 || height >= 960.0) {
            if (width > height) {
                newWidth = this.generateWidthHeightValue(640.0, 0.95);
                newHeight = this.generateWidthHeightValue(360.0, 0.95);
            } else {
                newWidth = this.generateWidthHeightValue(360.0, 0.95);
                newHeight = this.generateWidthHeightValue(640.0, 0.95);
            }
        } else {
            newWidth = this.generateWidthHeightValue(width, 0.9);
            newHeight = this.generateWidthHeightValue(height, 0.9);
        }
        return new Pair((Object)newWidth, (Object)newHeight);
    }

    private final int roundEven(int value) {
        return value + 1 & 0xFFFFFFFE;
    }

    private final int generateWidthHeightValue(double value, double factor) {
        return this.roundEven(MathKt.roundToInt((double)(value * factor / (double)16)) * 16);
    }

    private final Mp4Movie setUpMP4Movie(int rotation, File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$setUpMP4Movie_u24lambda_u2d4 = mp4Movie;
        boolean bl3 = false;
        $this$setUpMP4Movie_u24lambda_u2d4.setCacheFile(cacheFile);
        $this$setUpMP4Movie_u24lambda_u2d4.setRotation(rotation);
        return movie;
    }

    private final void setOutputFileParameters(MediaFormat inputFormat, MediaFormat outputFormat, int newBitrate) {
        int frameRate = this.getFrameRate(inputFormat);
        int iFrameInterval = this.getIFrameIntervalRate(inputFormat);
        MediaFormat mediaFormat = outputFormat;
        boolean bl = false;
        boolean bl2 = false;
        MediaFormat $this$setOutputFileParameters_u24lambda_u2d8 = mediaFormat;
        boolean bl3 = false;
        $this$setOutputFileParameters_u24lambda_u2d8.setInteger("color-format", 2130708361);
        $this$setOutputFileParameters_u24lambda_u2d8.setInteger("frame-rate", frameRate);
        $this$setOutputFileParameters_u24lambda_u2d8.setInteger("i-frame-interval", iFrameInterval);
        $this$setOutputFileParameters_u24lambda_u2d8.setInteger("bitrate", newBitrate);
        if (Build.VERSION.SDK_INT > 23) {
            int it;
            boolean bl4;
            boolean bl5;
            Integer n;
            Integer n2 = INSTANCE.getColorStandard(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl6 = false;
                $this$setOutputFileParameters_u24lambda_u2d8.setInteger("color-standard", it);
            }
            n2 = INSTANCE.getColorTransfer(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl7 = false;
                $this$setOutputFileParameters_u24lambda_u2d8.setInteger("color-transfer", it);
            }
            n2 = INSTANCE.getColorRange(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl8 = false;
                $this$setOutputFileParameters_u24lambda_u2d8.setInteger("color-range", it);
            }
        }
    }

    private final int selectTrack(MediaExtractor extractor, boolean isVideo) {
        int n = 0;
        int numTracks = extractor.getTrackCount();
        if (n < numTracks) {
            do {
                Boolean bl;
                String string;
                int i = n++;
                MediaFormat mediaFormat = extractor.getTrackFormat(i);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(i)");
                MediaFormat format = mediaFormat;
                String mime = format.getString("mime");
                if (isVideo) {
                    string = mime;
                    bl = string == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null));
                    Intrinsics.checkNotNull(bl);
                    if (!bl.booleanValue()) continue;
                    return i;
                }
                string = mime;
                bl = string == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null));
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) continue;
                return i;
            } while (n < numTracks);
        }
        return -5;
    }

    private final void processAudio(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        int audioIndex = this.selectTrack(extractor, false);
        if (audioIndex >= 0) {
            extractor.selectTrack(audioIndex);
            MediaFormat mediaFormat = extractor.getTrackFormat(audioIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(audioIndex)");
            MediaFormat audioFormat = mediaFormat;
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size < 0) continue;
                    MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec.BufferInfo $this$processAudio_u24lambda_u2d9 = bufferInfo2;
                    boolean bl3 = false;
                    $this$processAudio_u24lambda_u2d9.presentationTimeUs = extractor.getSampleTime();
                    $this$processAudio_u24lambda_u2d9.offset = 0;
                    $this$processAudio_u24lambda_u2d9.flags = 1;
                    mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                    extractor.advance();
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private final int getFrameRate(MediaFormat format) {
        return format.containsKey("frame-rate") ? format.getInteger("frame-rate") : 30;
    }

    private final int getIFrameIntervalRate(MediaFormat format) {
        return format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 2;
    }

    @RequiresApi(value=24)
    private final Integer getColorStandard(MediaFormat format) {
        return format.containsKey("color-standard") ? Integer.valueOf(format.getInteger("color-standard")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorTransfer(MediaFormat format) {
        return format.containsKey("color-transfer") ? Integer.valueOf(format.getInteger("color-transfer")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorRange(MediaFormat format) {
        return format.containsKey("color-range") ? Integer.valueOf(format.getInteger("color-range")) : null;
    }

    private final double prepareVideoHeight(MediaMetadataRetriever mediaMetadataRetriever, Double videoHeight) {
        double d;
        if (videoHeight == null) {
            String heightData = mediaMetadataRetriever.extractMetadata(19);
            CharSequence charSequence = heightData;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                d = 640.0;
            } else {
                charSequence = heightData;
                bl = false;
                d = Double.parseDouble((String)charSequence);
            }
        } else {
            d = videoHeight;
        }
        return d;
    }

    private final double prepareVideoWidth(MediaMetadataRetriever mediaMetadataRetriever, Double videoWidth) {
        double d;
        if (videoWidth == null) {
            String widthData = mediaMetadataRetriever.extractMetadata(18);
            CharSequence charSequence = widthData;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                d = 360.0;
            } else {
                charSequence = widthData;
                bl = false;
                d = Double.parseDouble((String)charSequence);
            }
        } else {
            d = videoWidth;
        }
        return d;
    }

    private final String validateInputs(Context context, Uri srcUri, String srcPath, Configuration configuration) {
        if (srcPath != null && srcUri != null) {
            Log.w((String)"Compressor", (String)"ARE YOU SURE YOU WANT TO PASS BOTH srcPath AND srcUri?");
        }
        if (context == null && srcPath == null && srcUri == null) {
            return "You need to provide either a srcUri or a srcPath";
        }
        if (context == null && srcPath == null && srcUri != null) {
            return "You need to provide the application context";
        }
        if (configuration.getVideoHeight() != null && configuration.getVideoWidth() == null || configuration.getVideoHeight() == null && configuration.getVideoWidth() != null) {
            return "You must specify both height and width values";
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoQuality.values().length];
            nArray[VideoQuality.VERY_LOW.ordinal()] = 1;
            nArray[VideoQuality.LOW.ordinal()] = 2;
            nArray[VideoQuality.MEDIUM.ordinal()] = 3;
            nArray[VideoQuality.HIGH.ordinal()] = 4;
            nArray[VideoQuality.VERY_HIGH.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

