/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.OutputSurface;
import com.abedelazizshe.lightcompressorlibrary.Result;
import com.abedelazizshe.lightcompressorlibrary.VideoQuality;
import com.abedelazizshe.lightcompressorlibrary.config.Configuration;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ,\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002J\u0017\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0003\u00a2\u0006\u0002\u0010/J\u0017\u00100\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0003\u00a2\u0006\u0002\u0010/J\u0017\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0003\u00a2\u0006\u0002\u0010/J\u0010\u00102\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00103\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0017\u00104\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0003\u00a2\u0006\u0002\u0010/J\u0017\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/J\u001f\u00106\u001a\u00020\r2\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010:J\u001f\u0010;\u001a\u00020\r2\u0006\u00107\u001a\u0002082\b\u0010<\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010:J\u0014\u0010=\u001a\u00020>2\n\u0010?\u001a\u00060@j\u0002`AH\u0002J \u0010B\u001a\u00020>2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0018\u0010J\u001a\u00020\u00042\u0006\u0010C\u001a\u00020D2\u0006\u0010K\u001a\u00020\u0010H\u0002J \u0010L\u001a\u00020>2\u0006\u0010M\u001a\u00020.2\u0006\u0010N\u001a\u00020.2\u0006\u0010O\u001a\u00020\u0004H\u0002J\u0018\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u00042\u0006\u0010S\u001a\u00020TH\u0002J0\u0010U\u001a\u0004\u0018\u00010\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006V"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/Compressor;", "", "()V", "FRAME_RATE", "", "INVALID_BITRATE", "", "I_FRAME_INTERVAL", "MEDIACODEC_TIMEOUT_DEFAULT", "", "MIME_TYPE", "MIN_BITRATE", "MIN_HEIGHT", "", "MIN_WIDTH", "isRunning", "", "()Z", "setRunning", "(Z)V", "compressVideo", "Lcom/abedelazizshe/lightcompressorlibrary/Result;", "context", "Landroid/content/Context;", "srcUri", "Landroid/net/Uri;", "srcPath", "destination", "configuration", "Lcom/abedelazizshe/lightcompressorlibrary/config/Configuration;", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "keepOriginalResolution", "generateWidthHeightValue", "value", "factor", "getBitrate", "bitrate", "quality", "Lcom/abedelazizshe/lightcompressorlibrary/VideoQuality;", "getColorRange", "format", "Landroid/media/MediaFormat;", "(Landroid/media/MediaFormat;)Ljava/lang/Integer;", "getColorStandard", "getColorTransfer", "getFrameRate", "getIFrameIntervalRate", "getLevel", "getProfile", "prepareVideoHeight", "mediaMetadataRetriever", "Landroid/media/MediaMetadataRetriever;", "videoHeight", "(Landroid/media/MediaMetadataRetriever;Ljava/lang/Double;)D", "prepareVideoWidth", "videoWidth", "printException", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processAudio", "extractor", "Landroid/media/MediaExtractor;", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "roundEven", "selectTrack", "isVideo", "setOutputFileParameters", "inputFormat", "outputFormat", "newBitrate", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/Mp4Movie;", "rotation", "cacheFile", "Ljava/io/File;", "validateInputs", "lightcompressor_release"})
public final class Compressor {
    @NotNull
    public static final Compressor INSTANCE = new Compressor();
    private static final int MIN_BITRATE = 2000000;
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 360.0;
    private static final int FRAME_RATE = 30;
    private static final int I_FRAME_INTERVAL = 2;
    @NotNull
    private static final String MIME_TYPE = "video/avc";
    private static final long MEDIACODEC_TIMEOUT_DEFAULT = 100L;
    @NotNull
    private static final String INVALID_BITRATE = "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false";
    private static boolean isRunning = true;

    private Compressor() {
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Result compressVideo(@Nullable Context context, @Nullable Uri srcUri, @Nullable String srcPath, @NotNull String destination, @NotNull Configuration configuration, @NotNull CompressionProgressListener listener) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        mediaMetadataRetriever = new MediaMetadataRetriever();
        var8_8 = this.validateInputs(context, srcUri, srcPath, configuration);
        if (var8_8 != null) {
            var9_9 = var8_8;
            var10_14 = false;
            var11_15 = false;
            it = var9_9;
            return new Result(false, it);
        }
        extractor = new MediaExtractor();
        if (context != null && srcUri != null && srcPath == null) {
            try {
                mediaMetadataRetriever.setDataSource(context, srcUri);
            }
            catch (IllegalArgumentException exception) {
                this.printException(exception);
                return new Result(false, String.valueOf(exception.getMessage()));
            }
            extractor.setDataSource(context, srcUri, null);
        } else {
            try {
                mediaMetadataRetriever.setDataSource(srcPath);
            }
            catch (IllegalArgumentException exception) {
                this.printException(exception);
                return new Result(false, String.valueOf(exception.getMessage()));
            }
            Intrinsics.checkNotNull((Object)srcPath);
            file = new File(srcPath);
            if (!file.canRead()) {
                return new Result(false, "The source file cannot be accessed!");
            }
            extractor.setDataSource(file.toString());
        }
        height = this.prepareVideoHeight(mediaMetadataRetriever, configuration.getVideoHeight());
        width = this.prepareVideoWidth(mediaMetadataRetriever, configuration.getVideoWidth());
        rotationData = mediaMetadataRetriever.extractMetadata(24);
        bitrateData = mediaMetadataRetriever.extractMetadata(20);
        durationData = mediaMetadataRetriever.extractMetadata(9);
        var16_22 = rotationData;
        var17_24 = false;
        var18_27 = false;
        if ((var16_22 == null || var16_22.length() == 0) != false) return new Result(false, "Failed to extract video meta-data, please try again");
        var16_22 = bitrateData;
        var17_24 = false;
        var18_27 = false;
        if ((var16_22 == null || var16_22.length() == 0) != false) return new Result(false, "Failed to extract video meta-data, please try again");
        var16_22 = durationData;
        var17_24 = false;
        var18_27 = false;
        if (var16_22 == null || var16_22.length() == 0) {
            return new Result(false, "Failed to extract video meta-data, please try again");
        }
        var17_25 = rotationData;
        var18_27 = false;
        rotation = Integer.parseInt(var17_25);
        var18_28 = bitrateData;
        var19_30 = false;
        bitrate = Integer.parseInt(var18_28);
        var20_31 = durationData;
        var21_33 = false;
        duration = Long.parseLong(var20_31) * (long)1000;
        if (configuration.isMinBitRateEnabled() && bitrate <= 2000000) {
            return new Result(false, "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false");
        }
        if (configuration.getVideoBitrate() == null) {
            v0 = this.getBitrate(bitrate, configuration.getQuality());
        } else {
            var21_34 = configuration.getVideoBitrate();
            Intrinsics.checkNotNull((Object)var21_34);
            v0 = var21_34;
        }
        newBitrate = v0;
        var21_35 = configuration.getVideoHeight() != null ? new Pair((Object)((int)width), (Object)((int)height)) : this.generateWidthAndHeight(width, height, configuration.getKeepOriginalResolution());
        newWidth = ((Number)var21_35.component1()).intValue();
        newHeight = ((Number)var21_35.component2()).intValue();
        var24_38 = rotation;
        switch (var24_38) {
            case 90: 
            case 270: {
                tempHeight = newHeight;
                newHeight = newWidth;
                newWidth = tempHeight;
                v1 = 0;
                break;
            }
            case 180: {
                v1 = 0;
                break;
            }
            default: {
                v1 = rotation;
            }
        }
        rotation = v1;
        noExceptions = true;
        if (newWidth == 0) return new Result(false, "Something went wrong, please try again");
        if (newHeight == 0) return new Result(false, "Something went wrong, please try again");
        cacheFile = new File(destination);
        try {
            bufferInfo = new MediaCodec.BufferInfo();
            movie = this.setUpMP4Movie(rotation, cacheFile);
            mediaMuxer = new MP4Builder().createMovie(movie);
            videoIndex = this.selectTrack(extractor, true);
            extractor.selectTrack(videoIndex);
            extractor.seekTo(0L, 0);
            var31_46 = extractor.getTrackFormat(videoIndex);
            Intrinsics.checkNotNullExpressionValue((Object)var31_46, (String)"extractor.getTrackFormat(videoIndex)");
            inputFormat = var31_46;
            var32_48 = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
            Intrinsics.checkNotNullExpressionValue((Object)var32_48, (String)"createVideoFormat(MIME_TYPE, newWidth, newHeight)");
            outputFormat = var32_48;
            this.setOutputFileParameters(inputFormat, outputFormat, newBitrate);
            decoder = null;
            hasQTI = false;
            list = new MediaCodecList(0).getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
            for (MediaCodecInfo codec : list) {
                Log.i((String)"CODECS: ", (String)codec.getName());
                var39_62 = codec.getName();
                Intrinsics.checkNotNullExpressionValue((Object)var39_62, (String)"codec.name");
                if (!StringsKt.contains$default((CharSequence)((CharSequence)var39_62), (CharSequence)"qti.avc", (boolean)false, (int)2, null)) continue;
                hasQTI = true;
                break;
            }
            if (hasQTI) {
                var36_53 = MediaCodec.createByCodecName((String)"c2.android.avc.encoder");
                Intrinsics.checkNotNullExpressionValue((Object)var36_53, (String)"{\n                    MediaCodec.createByCodecName(\"c2.android.avc.encoder\")\n                }");
                v2 = var36_53;
            } else {
                var36_53 = MediaCodec.createEncoderByType((String)"video/avc");
                Intrinsics.checkNotNullExpressionValue((Object)var36_53, (String)"{\n                    MediaCodec.createEncoderByType(MIME_TYPE)\n                }");
                v2 = var36_53;
            }
            encoder = v2;
            inputSurface = null;
            outputSurface = null;
            try {
                inputDone = false;
                outputDone = false;
                videoTrackIndex = -5;
                encoder.configure(outputFormat, null, null, 1);
                inputSurface = new InputSurface(encoder.createInputSurface());
                inputSurface.makeCurrent();
                encoder.start();
                outputSurface = new OutputSurface();
                var41_65 = inputFormat.getString("mime");
                Intrinsics.checkNotNull((Object)var41_65);
                decoder = MediaCodec.createDecoderByType((String)var41_65);
                decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                decoder.start();
                while (!outputDone) {
                    if (!inputDone) {
                        index = extractor.getSampleTrackIndex();
                        if (index == videoIndex) {
                            inputBufferIndex = decoder.dequeueInputBuffer(100L);
                            if (inputBufferIndex >= 0) {
                                inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                Intrinsics.checkNotNull((Object)inputBuffer);
                                chunkSize = extractor.readSampleData((ByteBuffer)inputBuffer, 0);
                                if (chunkSize < 0) {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                    inputDone = true;
                                } else {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                    extractor.advance();
                                }
                            }
                        } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(100L)) >= 0) {
                            decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                            inputDone = true;
                        }
                    }
                    decoderOutputAvailable = true;
                    encoderOutputAvailable = true;
lbl169:
                    // 6 sources

                    while (decoderOutputAvailable || encoderOutputAvailable) {
                        if (Compressor.isRunning) ** GOTO lbl-1000
                        listener.onProgressCancelled();
                        inputBuffer = new Result(false, "The compression has been stopped!");
                        ** GOTO lbl213
                    }
                }
                ** GOTO lbl336
            }
            catch (Exception exception) {
                try {
                    this.printException(exception);
                    noExceptions = false;
                }
                catch (Throwable exception) {
                    extractor.unselectTrack(videoIndex);
                    var39_62 = decoder;
                    if (var39_62 == null) {
                        v3 = null;
                    } else {
                        var39_62.stop();
                        v3 = Unit.INSTANCE;
                    }
                    var39_62 = decoder;
                    if (var39_62 == null) {
                        v4 = null;
                    } else {
                        var39_62.release();
                        v4 = Unit.INSTANCE;
                    }
                    encoder.stop();
                    encoder.release();
                    var39_62 = inputSurface;
                    if (var39_62 == null) {
                        v5 = null;
                    } else {
                        var39_62.release();
                        v5 = Unit.INSTANCE;
                    }
                    var39_62 = outputSurface;
                    if (var39_62 == null) {
                        v6 = null;
                    } else {
                        var39_62.release();
                        v6 = Unit.INSTANCE;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)mediaMuxer, (String)"mediaMuxer");
                    this.processAudio(extractor, mediaMuxer, bufferInfo);
                    throw exception;
                }
lbl213:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                chunkSize = decoder;
                if (chunkSize == null) {
                    v7 = null;
                } else {
                    chunkSize.stop();
                    v7 = Unit.INSTANCE;
                }
                chunkSize = decoder;
                if (chunkSize == null) {
                    v8 = null;
                } else {
                    chunkSize.release();
                    v8 = Unit.INSTANCE;
                }
                encoder.stop();
                encoder.release();
                chunkSize = inputSurface;
                chunkSize.release();
                chunkSize = outputSurface;
                chunkSize.release();
                Intrinsics.checkNotNullExpressionValue((Object)mediaMuxer, (String)"mediaMuxer");
                this.processAudio(extractor, mediaMuxer, bufferInfo);
                return inputBuffer;
lbl-1000:
                // 1 sources

                {
                    block82: {
                        encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 100L);
                        if (encoderStatus == -1) {
                            encoderOutputAvailable = false;
                        } else if (encoderStatus == -2) {
                            var45_76 = encoder.getOutputFormat();
                            Intrinsics.checkNotNullExpressionValue((Object)var45_76, (String)"encoder.outputFormat");
                            newFormat = var45_76;
                            if (videoTrackIndex == -5) {
                                videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                            }
                        } else if (encoderStatus != -3) {
                            if (encoderStatus < 0) {
                                throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from encoder.dequeueOutputBuffer: ", (Object)encoderStatus));
                            }
                            var46_79 = encoder.getOutputBuffer(encoderStatus);
                            if (var46_79 == null) {
                                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                            }
                            encodedData = var45_77 = var46_79;
                            if (bufferInfo.size > 1) {
                                if ((bufferInfo.flags & 2) == 0) {
                                    mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                } else if (videoTrackIndex == -5) {
                                    csd = new byte[bufferInfo.size];
                                    var46_79 = encodedData;
                                    var47_82 = false;
                                    var48_85 = 0;
                                    $this$compressVideo_u24lambda_u2d1 = var46_79;
                                    $i$a$-apply-Compressor$compressVideo$2 = false;
                                    $this$compressVideo_u24lambda_u2d1.limit(bufferInfo.offset + bufferInfo.size);
                                    $this$compressVideo_u24lambda_u2d1.position(bufferInfo.offset);
                                    $this$compressVideo_u24lambda_u2d1.get(csd);
                                    sps = null;
                                    pps = null;
                                    var48_85 = bufferInfo.size - 1;
                                    if (0 <= var48_85) {
                                        while ((a = var48_85--) > 3) {
                                            if (csd[a] == 1 && csd[a - 1] == 0 && csd[a - 2] == 0 && csd[a - 3] == 0) {
                                                sps = ByteBuffer.allocate(a - 3);
                                                pps = ByteBuffer.allocate(bufferInfo.size - (a - 3));
                                                Intrinsics.checkNotNull((Object)sps);
                                                sps.put(csd, 0, a - 3).position(0);
                                                Intrinsics.checkNotNull((Object)pps);
                                                pps.put(csd, a - 3, bufferInfo.size - (a - 3)).position(0);
                                                break;
                                            }
                                            if (0 <= var48_85) continue;
                                        }
                                    }
                                    var49_86 = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
                                    Intrinsics.checkNotNullExpressionValue((Object)var49_86, (String)"createVideoFormat(\n                                                MIME_TYPE,\n                                                newWidth,\n                                                newHeight\n                                            )");
                                    newFormat = var49_86;
                                    if (sps != null && pps != null) {
                                        newFormat.setByteBuffer("csd-0", sps);
                                        newFormat.setByteBuffer("csd-1", pps);
                                    }
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            }
                            outputDone = (bufferInfo.flags & 4) != 0;
                            encoder.releaseOutputBuffer(encoderStatus, false);
                        }
                        if (encoderStatus != -1) ** GOTO lbl169
                        decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 100L);
                        if (decoderStatus != -1) break block82;
                        decoderOutputAvailable = false;
                        ** GOTO lbl169
                    }
                    if (decoderStatus == -3 || decoderStatus == -2) ** GOTO lbl169
                    if (decoderStatus < 0) {
                        throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from decoder.dequeueOutputBuffer: ", (Object)decoderStatus));
                    }
                    doRender = bufferInfo.size != 0;
                    decoder.releaseOutputBuffer(decoderStatus, doRender);
                    if (doRender) {
                        errorWait = false;
                        try {
                            outputSurface.awaitNewImage();
                        }
                        catch (Exception e) {
                            errorWait = true;
                            var48_84 = e.getMessage();
                            Log.e((String)"Compressor", (String)(var48_84 == null ? "Compression failed at swapping buffer" : var48_84));
                        }
                        if (!errorWait) {
                            outputSurface.drawImage();
                            inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                            listener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                            inputSurface.swapBuffers();
                        }
                    }
                    if ((bufferInfo.flags & 4) == 0) ** GOTO lbl169
                    decoderOutputAvailable = false;
                    encoder.signalEndOfInputStream();
                    ** GOTO lbl169
                }
lbl336:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                inputDone = decoder;
                if (inputDone == null) {
                    v9 = null;
                } else {
                    inputDone.stop();
                    v9 = Unit.INSTANCE;
                }
                inputDone = decoder;
                if (inputDone == null) {
                    v10 = null;
                } else {
                    inputDone.release();
                    v10 = Unit.INSTANCE;
                }
                encoder.stop();
                encoder.release();
                inputDone = inputSurface;
                inputDone.release();
                inputDone = outputSurface;
                inputDone.release();
                Intrinsics.checkNotNullExpressionValue((Object)mediaMuxer, (String)"mediaMuxer");
                this.processAudio(extractor, mediaMuxer, bufferInfo);
                extractor.unselectTrack(videoIndex);
                exception = decoder;
                if (exception == null) {
                    v11 = null;
                } else {
                    exception.stop();
                    v11 = Unit.INSTANCE;
                }
                exception = decoder;
                if (exception == null) {
                    v12 = null;
                } else {
                    exception.release();
                    v12 = Unit.INSTANCE;
                }
                encoder.stop();
                encoder.release();
                exception = inputSurface;
                if (exception == null) {
                    v13 = null;
                } else {
                    exception.release();
                    v13 = Unit.INSTANCE;
                }
                exception = outputSurface;
                if (exception == null) {
                    v14 = null;
                }
                exception.release();
                v14 = Unit.INSTANCE;
            }
            extractor.release();
            try {
                mediaMuxer.finishMovie();
                return new Result(true, null);
            }
            catch (Exception e) {
                this.printException(e);
            }
            return new Result(true, null);
        }
        catch (Exception exception) {
            this.printException(exception);
        }
        return new Result(true, null);
    }

    private final void printException(Exception exception) {
        String message = null;
        message = "An error has occurred!";
        String string = exception.getMessage();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            message = it;
        }
        Log.e((String)"Compressor", (String)message);
    }

    private final int getBitrate(int bitrate, VideoQuality quality) {
        int n;
        VideoQuality videoQuality = quality;
        int n2 = WhenMappings.$EnumSwitchMapping$0[videoQuality.ordinal()];
        switch (n2) {
            case 1: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.08));
                break;
            }
            case 2: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.1));
                break;
            }
            case 3: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.2));
                break;
            }
            case 4: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.3));
                break;
            }
            case 5: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.5));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final Pair<Integer, Integer> generateWidthAndHeight(double width, double height, boolean keepOriginalResolution) {
        if (keepOriginalResolution) {
            return new Pair((Object)MathKt.roundToInt((double)width), (Object)MathKt.roundToInt((double)height));
        }
        int newWidth = 0;
        int newHeight = 0;
        if (width >= 1920.0 || height >= 1920.0) {
            newWidth = this.generateWidthHeightValue(width, 0.5);
            newHeight = this.generateWidthHeightValue(height, 0.5);
        } else if (width >= 1280.0 || height >= 1280.0) {
            newWidth = this.generateWidthHeightValue(width, 0.75);
            newHeight = this.generateWidthHeightValue(height, 0.75);
        } else if (width >= 960.0 || height >= 960.0) {
            if (width > height) {
                newWidth = this.generateWidthHeightValue(640.0, 0.95);
                newHeight = this.generateWidthHeightValue(360.0, 0.95);
            } else {
                newWidth = this.generateWidthHeightValue(360.0, 0.95);
                newHeight = this.generateWidthHeightValue(640.0, 0.95);
            }
        } else {
            newWidth = this.generateWidthHeightValue(width, 0.9);
            newHeight = this.generateWidthHeightValue(height, 0.9);
        }
        return new Pair((Object)newWidth, (Object)newHeight);
    }

    private final int roundEven(int value) {
        return value + 1 & 0xFFFFFFFE;
    }

    private final int generateWidthHeightValue(double value, double factor) {
        return this.roundEven(MathKt.roundToInt((double)(value * factor / (double)16)) * 16);
    }

    private final Mp4Movie setUpMP4Movie(int rotation, File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$setUpMP4Movie_u24lambda_u2d3 = mp4Movie;
        boolean bl3 = false;
        $this$setUpMP4Movie_u24lambda_u2d3.setCacheFile(cacheFile);
        $this$setUpMP4Movie_u24lambda_u2d3.setRotation(rotation);
        return movie;
    }

    private final void setOutputFileParameters(MediaFormat inputFormat, MediaFormat outputFormat, int newBitrate) {
        int frameRate = this.getFrameRate(inputFormat);
        int iFrameInterval = this.getIFrameIntervalRate(inputFormat);
        MediaFormat mediaFormat = outputFormat;
        boolean bl = false;
        boolean bl2 = false;
        MediaFormat $this$setOutputFileParameters_u24lambda_u2d9 = mediaFormat;
        boolean bl3 = false;
        $this$setOutputFileParameters_u24lambda_u2d9.setInteger("color-format", 2130708361);
        $this$setOutputFileParameters_u24lambda_u2d9.setInteger("frame-rate", frameRate);
        $this$setOutputFileParameters_u24lambda_u2d9.setInteger("i-frame-interval", iFrameInterval);
        $this$setOutputFileParameters_u24lambda_u2d9.setInteger("bitrate", newBitrate);
        if (Build.VERSION.SDK_INT > 23) {
            int it;
            boolean bl4;
            boolean bl5;
            Integer n;
            Integer n2 = INSTANCE.getProfile(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl6 = false;
                $this$setOutputFileParameters_u24lambda_u2d9.setInteger("profile", it);
            }
            n2 = INSTANCE.getLevel(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl7 = false;
                $this$setOutputFileParameters_u24lambda_u2d9.setInteger("level", it);
            }
            n2 = INSTANCE.getColorStandard(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl8 = false;
                $this$setOutputFileParameters_u24lambda_u2d9.setInteger("color-standard", it);
            }
            n2 = INSTANCE.getColorTransfer(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl9 = false;
                $this$setOutputFileParameters_u24lambda_u2d9.setInteger("color-transfer", it);
            }
            n2 = INSTANCE.getColorRange(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl10 = false;
                $this$setOutputFileParameters_u24lambda_u2d9.setInteger("color-range", it);
            }
        }
    }

    private final int selectTrack(MediaExtractor extractor, boolean isVideo) {
        int n = 0;
        int numTracks = extractor.getTrackCount();
        if (n < numTracks) {
            do {
                Boolean bl;
                String string;
                int i = n++;
                MediaFormat mediaFormat = extractor.getTrackFormat(i);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(i)");
                MediaFormat format = mediaFormat;
                String mime = format.getString("mime");
                if (isVideo) {
                    string = mime;
                    bl = string == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null));
                    Intrinsics.checkNotNull(bl);
                    if (!bl.booleanValue()) continue;
                    return i;
                }
                string = mime;
                bl = string == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null));
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) continue;
                return i;
            } while (n < numTracks);
        }
        return -5;
    }

    private final void processAudio(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        int audioIndex = this.selectTrack(extractor, false);
        if (audioIndex >= 0) {
            extractor.selectTrack(audioIndex);
            MediaFormat mediaFormat = extractor.getTrackFormat(audioIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(audioIndex)");
            MediaFormat audioFormat = mediaFormat;
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size < 0) continue;
                    MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec.BufferInfo $this$processAudio_u24lambda_u2d10 = bufferInfo2;
                    boolean bl3 = false;
                    $this$processAudio_u24lambda_u2d10.presentationTimeUs = extractor.getSampleTime();
                    $this$processAudio_u24lambda_u2d10.offset = 0;
                    $this$processAudio_u24lambda_u2d10.flags = extractor.getSampleFlags();
                    mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                    extractor.advance();
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private final int getFrameRate(MediaFormat format) {
        return format.containsKey("frame-rate") ? format.getInteger("frame-rate") : 30;
    }

    private final int getIFrameIntervalRate(MediaFormat format) {
        return format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 2;
    }

    @RequiresApi(value=23)
    private final Integer getLevel(MediaFormat format) {
        return format.containsKey("level") ? Integer.valueOf(format.getInteger("level")) : null;
    }

    private final Integer getProfile(MediaFormat format) {
        return format.containsKey("profile") ? Integer.valueOf(format.getInteger("profile")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorStandard(MediaFormat format) {
        return format.containsKey("color-standard") ? Integer.valueOf(format.getInteger("color-standard")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorTransfer(MediaFormat format) {
        return format.containsKey("color-transfer") ? Integer.valueOf(format.getInteger("color-transfer")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorRange(MediaFormat format) {
        return format.containsKey("color-range") ? Integer.valueOf(format.getInteger("color-range")) : null;
    }

    private final double prepareVideoHeight(MediaMetadataRetriever mediaMetadataRetriever, Double videoHeight) {
        double d;
        if (videoHeight == null) {
            String heightData = mediaMetadataRetriever.extractMetadata(19);
            CharSequence charSequence = heightData;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                d = 640.0;
            } else {
                charSequence = heightData;
                bl = false;
                d = Double.parseDouble((String)charSequence);
            }
        } else {
            d = videoHeight;
        }
        return d;
    }

    private final double prepareVideoWidth(MediaMetadataRetriever mediaMetadataRetriever, Double videoWidth) {
        double d;
        if (videoWidth == null) {
            String widthData = mediaMetadataRetriever.extractMetadata(18);
            CharSequence charSequence = widthData;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                d = 360.0;
            } else {
                charSequence = widthData;
                bl = false;
                d = Double.parseDouble((String)charSequence);
            }
        } else {
            d = videoWidth;
        }
        return d;
    }

    private final String validateInputs(Context context, Uri srcUri, String srcPath, Configuration configuration) {
        if (srcPath != null && srcUri != null) {
            Log.w((String)"Compressor", (String)"ARE YOU SURE YOU WANT TO PASS BOTH srcPath AND srcUri?");
        }
        if (context == null && srcPath == null && srcUri == null) {
            return "You need to provide either a srcUri or a srcPath";
        }
        if (context == null && srcPath == null && srcUri != null) {
            return "You need to provide the application context";
        }
        if (configuration.getVideoHeight() != null && configuration.getVideoWidth() == null || configuration.getVideoHeight() == null && configuration.getVideoWidth() != null) {
            return "You must specify both height and width values";
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoQuality.values().length];
            nArray[VideoQuality.VERY_LOW.ordinal()] = 1;
            nArray[VideoQuality.LOW.ordinal()] = 2;
            nArray[VideoQuality.MEDIUM.ordinal()] = 3;
            nArray[VideoQuality.HIGH.ordinal()] = 4;
            nArray[VideoQuality.VERY_HIGH.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

