/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.OutputSurface;
import com.abedelazizshe.lightcompressorlibrary.Result;
import com.abedelazizshe.lightcompressorlibrary.VideoHelper;
import com.abedelazizshe.lightcompressorlibrary.VideoQuality;
import com.abedelazizshe.lightcompressorlibrary.config.Configuration;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ,\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002J\u0017\u0010,\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0003\u00a2\u0006\u0002\u0010/J\u0017\u00100\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0003\u00a2\u0006\u0002\u0010/J\u0017\u00101\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0003\u00a2\u0006\u0002\u0010/J\u0010\u00102\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00103\u001a\u00020\u00042\u0006\u0010-\u001a\u00020.H\u0002J\u0017\u00104\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0003\u00a2\u0006\u0002\u0010/J\u0017\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010-\u001a\u00020.H\u0002\u00a2\u0006\u0002\u0010/J\u0014\u00106\u001a\u0002072\n\u00108\u001a\u000609j\u0002`:H\u0002J \u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0018\u0010C\u001a\u00020\u00042\u0006\u0010<\u001a\u00020=2\u0006\u0010D\u001a\u00020\u0010H\u0002J \u0010E\u001a\u0002072\u0006\u0010F\u001a\u00020.2\u0006\u0010G\u001a\u00020.2\u0006\u0010H\u001a\u00020\u0004H\u0002J\u0018\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020MH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006N"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/Compressor;", "", "()V", "FRAME_RATE", "", "INVALID_BITRATE", "", "I_FRAME_INTERVAL", "MEDIACODEC_TIMEOUT_DEFAULT", "", "MIME_TYPE", "MIN_BITRATE", "MIN_HEIGHT", "", "MIN_WIDTH", "isRunning", "", "()Z", "setRunning", "(Z)V", "compressVideo", "Lcom/abedelazizshe/lightcompressorlibrary/Result;", "context", "Landroid/content/Context;", "srcUri", "Landroid/net/Uri;", "srcPath", "destination", "configuration", "Lcom/abedelazizshe/lightcompressorlibrary/config/Configuration;", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "keepOriginalResolution", "generateWidthHeightValue", "value", "factor", "getBitrate", "bitrate", "quality", "Lcom/abedelazizshe/lightcompressorlibrary/VideoQuality;", "getColorRange", "format", "Landroid/media/MediaFormat;", "(Landroid/media/MediaFormat;)Ljava/lang/Integer;", "getColorStandard", "getColorTransfer", "getFrameRate", "getIFrameIntervalRate", "getLevel", "getProfile", "printException", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processAudio", "extractor", "Landroid/media/MediaExtractor;", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "roundEven", "selectTrack", "isVideo", "setOutputFileParameters", "inputFormat", "outputFormat", "newBitrate", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/Mp4Movie;", "rotation", "cacheFile", "Ljava/io/File;", "lightcompressor_release"})
public final class Compressor {
    @NotNull
    public static final Compressor INSTANCE = new Compressor();
    private static final int MIN_BITRATE = 2000000;
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 360.0;
    private static final int FRAME_RATE = 30;
    private static final int I_FRAME_INTERVAL = 2;
    @NotNull
    private static final String MIME_TYPE = "video/avc";
    private static final long MEDIACODEC_TIMEOUT_DEFAULT = 100L;
    @NotNull
    private static final String INVALID_BITRATE = "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false";
    private static boolean isRunning = true;

    private Compressor() {
    }

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Result compressVideo(@Nullable Context context, @Nullable Uri srcUri, @Nullable String srcPath, @NotNull String destination, @NotNull Configuration configuration, @NotNull CompressionProgressListener listener) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (context == null && srcPath == null && srcUri == null) {
            return new Result(false, "You need to provide either a srcUri or a srcPath");
        }
        if (context == null && srcPath == null && srcUri != null) {
            return new Result(false, "You need to provide the application context");
        }
        if (configuration.getVideoHeight() != null) {
            if (configuration.getVideoWidth() == null) return new Result(false, "You must specify both height and width values");
        }
        if (configuration.getVideoHeight() == null && configuration.getVideoWidth() != null) {
            return new Result(false, "You must specify both height and width values");
        }
        source = new Ref.ObjectRef();
        source.element = srcPath;
        if (context != null && srcUri != null && source.element == null) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<String>)source, context, srcUri, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Ref.ObjectRef<String> $source;
                final /* synthetic */ Context $context;
                final /* synthetic */ Uri $srcUri;
                {
                    this.$source = $source;
                    this.$context = $context;
                    this.$srcUri = $srcUri;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$runBlocking = (CoroutineScope)this.L$0;
                            job = BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this.$context, this.$srcUri, null){
                                int label;
                                final /* synthetic */ Context $context;
                                final /* synthetic */ Uri $srcUri;
                                {
                                    this.$context = $context;
                                    this.$srcUri = $srcUri;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            return VideoHelper.INSTANCE.getMediaPath(this.$context, this.$srcUri);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            this.L$0 = var4_5 = this.$source;
                            this.label = 1;
                            v0 = job.await((Continuation)this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            var4_5 = (Ref.ObjectRef<String>)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            var5_6 = v0;
                            var4_5.element = var5_6;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        mediaMetadataRetriever = new MediaMetadataRetriever();
        try {
            mediaMetadataRetriever.setDataSource((String)source.element);
        }
        catch (IllegalArgumentException exception) {
            return new Result(false, "Source path: " + source.element + " can be invalid! or you don't have READ_EXTERNAL_STORAGE permission");
        }
        if (configuration.getVideoHeight() == null) {
            heightData = mediaMetadataRetriever.extractMetadata(19);
            var12_13 = (CharSequence)heightData;
            var13_14 = false;
            var14_16 = false;
            if (var12_13 == null || var12_13.length() == 0) {
                v0 = 640.0;
            } else {
                var12_13 = heightData;
                var13_14 = false;
                v0 = Double.parseDouble((String)var12_13);
            }
        } else {
            heightData = configuration.getVideoHeight();
            Intrinsics.checkNotNull((Object)heightData);
            v0 = height = heightData.doubleValue();
        }
        if (configuration.getVideoWidth() == null) {
            widthData = mediaMetadataRetriever.extractMetadata(18);
            var14_17 = (CharSequence)widthData;
            var15_19 = false;
            var16_21 = false;
            if (var14_17 == null || var14_17.length() == 0) {
                v1 = 360.0;
            } else {
                var14_17 = widthData;
                var15_19 = false;
                v1 = Double.parseDouble((String)var14_17);
            }
        } else {
            widthData = configuration.getVideoWidth();
            Intrinsics.checkNotNull((Object)widthData);
            v1 = widthData.doubleValue();
        }
        width = v1;
        rotationData = mediaMetadataRetriever.extractMetadata(24);
        bitrateData = mediaMetadataRetriever.extractMetadata(20);
        durationData = mediaMetadataRetriever.extractMetadata(9);
        var16_22 = rotationData;
        var17_24 = false;
        var18_27 = false;
        if ((var16_22 == null || var16_22.length() == 0) != false) return new Result(false, "Failed to extract video meta-data, please try again");
        var16_22 = bitrateData;
        var17_24 = false;
        var18_27 = false;
        if ((var16_22 == null || var16_22.length() == 0) != false) return new Result(false, "Failed to extract video meta-data, please try again");
        var16_22 = durationData;
        var17_24 = false;
        var18_27 = false;
        if (var16_22 == null || var16_22.length() == 0) {
            return new Result(false, "Failed to extract video meta-data, please try again");
        }
        var17_25 = rotationData;
        var18_27 = false;
        rotation = Integer.parseInt(var17_25);
        var18_28 = bitrateData;
        var19_30 = false;
        bitrate = Integer.parseInt(var18_28);
        var20_31 = durationData;
        var21_33 = false;
        duration = Long.parseLong(var20_31) * (long)1000;
        if (configuration.isMinBitRateEnabled() && bitrate <= 2000000) {
            return new Result(false, "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false");
        }
        if (configuration.getVideoBitrate() == null) {
            v2 = this.getBitrate(bitrate, configuration.getQuality());
        } else {
            var21_34 = configuration.getVideoBitrate();
            Intrinsics.checkNotNull((Object)var21_34);
            v2 = var21_34;
        }
        newBitrate = v2;
        var21_35 = configuration.getVideoHeight() != null ? new Pair((Object)((int)width), (Object)((int)height)) : this.generateWidthAndHeight(width, height, configuration.getKeepOriginalResolution());
        newWidth = ((Number)var21_35.component1()).intValue();
        newHeight = ((Number)var21_35.component2()).intValue();
        var24_38 = rotation;
        switch (var24_38) {
            case 90: 
            case 270: {
                tempHeight = newHeight;
                newHeight = newWidth;
                newWidth = tempHeight;
                v3 = 0;
                break;
            }
            case 180: {
                v3 = 0;
                break;
            }
            default: {
                v3 = rotation;
            }
        }
        rotation = v3;
        Intrinsics.checkNotNull((Object)source.element);
        file = new File((String)source.element);
        if (!file.canRead()) {
            return new Result(false, "The source file cannot be accessed!");
        }
        noExceptions = true;
        if (newWidth == 0) return new Result(false, "Something went wrong, please try again");
        if (newHeight == 0) return new Result(false, "Something went wrong, please try again");
        cacheFile = new File(destination);
        try {
            bufferInfo = new MediaCodec.BufferInfo();
            movie = this.setUpMP4Movie(rotation, cacheFile);
            mediaMuxer = new MP4Builder().createMovie(movie);
            extractor = new MediaExtractor();
            extractor.setDataSource(file.toString());
            videoIndex = this.selectTrack(extractor, true);
            extractor.selectTrack(videoIndex);
            extractor.seekTo(0L, 0);
            var33_48 = extractor.getTrackFormat(videoIndex);
            Intrinsics.checkNotNullExpressionValue((Object)var33_48, (String)"extractor.getTrackFormat(videoIndex)");
            inputFormat = var33_48;
            var34_50 = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
            Intrinsics.checkNotNullExpressionValue((Object)var34_50, (String)"createVideoFormat(MIME_TYPE, newWidth, newHeight)");
            outputFormat = var34_50;
            this.setOutputFileParameters(inputFormat, outputFormat, newBitrate);
            decoder = null;
            hasQTI = false;
            list = new MediaCodecList(0).getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list");
            for (MediaCodecInfo codec : list) {
                Log.i((String)"CODECS: ", (String)codec.getName());
                var41_64 = codec.getName();
                Intrinsics.checkNotNullExpressionValue((Object)var41_64, (String)"codec.name");
                if (!StringsKt.contains$default((CharSequence)((CharSequence)var41_64), (CharSequence)"qti.avc", (boolean)false, (int)2, null)) continue;
                hasQTI = true;
                break;
            }
            if (hasQTI) {
                var38_55 = MediaCodec.createByCodecName((String)"c2.android.avc.encoder");
                Intrinsics.checkNotNullExpressionValue((Object)var38_55, (String)"{\n                    MediaCodec.createByCodecName(\"c2.android.avc.encoder\")\n                }");
                v4 = var38_55;
            } else {
                var38_55 = MediaCodec.createEncoderByType((String)"video/avc");
                Intrinsics.checkNotNullExpressionValue((Object)var38_55, (String)"{\n                    MediaCodec.createEncoderByType(MIME_TYPE)\n                }");
                v4 = var38_55;
            }
            encoder = v4;
            inputSurface = null;
            outputSurface = null;
            try {
                inputDone = false;
                outputDone = false;
                videoTrackIndex = -5;
                encoder.configure(outputFormat, null, null, 1);
                inputSurface = new InputSurface(encoder.createInputSurface());
                inputSurface.makeCurrent();
                encoder.start();
                outputSurface = new OutputSurface();
                var43_67 = inputFormat.getString("mime");
                Intrinsics.checkNotNull((Object)var43_67);
                decoder = MediaCodec.createDecoderByType((String)var43_67);
                decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                decoder.start();
                while (!outputDone) {
                    if (!inputDone) {
                        index = extractor.getSampleTrackIndex();
                        if (index == videoIndex) {
                            inputBufferIndex = decoder.dequeueInputBuffer(100L);
                            if (inputBufferIndex >= 0) {
                                inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                Intrinsics.checkNotNull((Object)inputBuffer);
                                chunkSize = extractor.readSampleData((ByteBuffer)inputBuffer, 0);
                                if (chunkSize < 0) {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                    inputDone = true;
                                } else {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                    extractor.advance();
                                }
                            }
                        } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(100L)) >= 0) {
                            decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                            inputDone = true;
                        }
                    }
                    decoderOutputAvailable = true;
                    encoderOutputAvailable = true;
lbl195:
                    // 6 sources

                    while (decoderOutputAvailable || encoderOutputAvailable) {
                        if (Compressor.isRunning) ** GOTO lbl-1000
                        listener.onProgressCancelled();
                        inputBuffer = new Result(false, "The compression has been stopped!");
                        ** GOTO lbl239
                    }
                }
                ** GOTO lbl362
            }
            catch (Exception exception) {
                try {
                    this.printException(exception);
                    noExceptions = false;
                }
                catch (Throwable exception) {
                    extractor.unselectTrack(videoIndex);
                    var41_64 = decoder;
                    if (var41_64 == null) {
                        v5 = null;
                    } else {
                        var41_64.stop();
                        v5 = Unit.INSTANCE;
                    }
                    var41_64 = decoder;
                    if (var41_64 == null) {
                        v6 = null;
                    } else {
                        var41_64.release();
                        v6 = Unit.INSTANCE;
                    }
                    encoder.stop();
                    encoder.release();
                    var41_64 = inputSurface;
                    if (var41_64 == null) {
                        v7 = null;
                    } else {
                        var41_64.release();
                        v7 = Unit.INSTANCE;
                    }
                    var41_64 = outputSurface;
                    if (var41_64 == null) {
                        v8 = null;
                    } else {
                        var41_64.release();
                        v8 = Unit.INSTANCE;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)mediaMuxer, (String)"mediaMuxer");
                    this.processAudio(extractor, mediaMuxer, bufferInfo);
                    throw exception;
                }
lbl239:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                chunkSize = decoder;
                if (chunkSize == null) {
                    v9 = null;
                } else {
                    chunkSize.stop();
                    v9 = Unit.INSTANCE;
                }
                chunkSize = decoder;
                if (chunkSize == null) {
                    v10 = null;
                } else {
                    chunkSize.release();
                    v10 = Unit.INSTANCE;
                }
                encoder.stop();
                encoder.release();
                chunkSize = inputSurface;
                chunkSize.release();
                chunkSize = outputSurface;
                chunkSize.release();
                Intrinsics.checkNotNullExpressionValue((Object)mediaMuxer, (String)"mediaMuxer");
                this.processAudio(extractor, mediaMuxer, bufferInfo);
                return inputBuffer;
lbl-1000:
                // 1 sources

                {
                    block92: {
                        encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 100L);
                        if (encoderStatus == -1) {
                            encoderOutputAvailable = false;
                        } else if (encoderStatus == -2) {
                            var47_78 = encoder.getOutputFormat();
                            Intrinsics.checkNotNullExpressionValue((Object)var47_78, (String)"encoder.outputFormat");
                            newFormat = var47_78;
                            if (videoTrackIndex == -5) {
                                videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                            }
                        } else if (encoderStatus != -3) {
                            if (encoderStatus < 0) {
                                throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from encoder.dequeueOutputBuffer: ", (Object)encoderStatus));
                            }
                            var48_81 = encoder.getOutputBuffer(encoderStatus);
                            if (var48_81 == null) {
                                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                            }
                            encodedData = var47_79 = var48_81;
                            if (bufferInfo.size > 1) {
                                if ((bufferInfo.flags & 2) == 0) {
                                    mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                } else if (videoTrackIndex == -5) {
                                    csd = new byte[bufferInfo.size];
                                    var48_81 = encodedData;
                                    var49_84 = false;
                                    var50_87 = 0;
                                    $this$compressVideo_u24lambda_u2d0 = var48_81;
                                    $i$a$-apply-Compressor$compressVideo$2 = false;
                                    $this$compressVideo_u24lambda_u2d0.limit(bufferInfo.offset + bufferInfo.size);
                                    $this$compressVideo_u24lambda_u2d0.position(bufferInfo.offset);
                                    $this$compressVideo_u24lambda_u2d0.get(csd);
                                    sps = null;
                                    pps = null;
                                    var50_87 = bufferInfo.size - 1;
                                    if (0 <= var50_87) {
                                        while ((a = var50_87--) > 3) {
                                            if (csd[a] == 1 && csd[a - 1] == 0 && csd[a - 2] == 0 && csd[a - 3] == 0) {
                                                sps = ByteBuffer.allocate(a - 3);
                                                pps = ByteBuffer.allocate(bufferInfo.size - (a - 3));
                                                Intrinsics.checkNotNull((Object)sps);
                                                sps.put(csd, 0, a - 3).position(0);
                                                Intrinsics.checkNotNull((Object)pps);
                                                pps.put(csd, a - 3, bufferInfo.size - (a - 3)).position(0);
                                                break;
                                            }
                                            if (0 <= var50_87) continue;
                                        }
                                    }
                                    var51_88 = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
                                    Intrinsics.checkNotNullExpressionValue((Object)var51_88, (String)"createVideoFormat(\n                                                MIME_TYPE,\n                                                newWidth,\n                                                newHeight\n                                            )");
                                    newFormat = var51_88;
                                    if (sps != null && pps != null) {
                                        newFormat.setByteBuffer("csd-0", sps);
                                        newFormat.setByteBuffer("csd-1", pps);
                                    }
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            }
                            outputDone = (bufferInfo.flags & 4) != 0;
                            encoder.releaseOutputBuffer(encoderStatus, false);
                        }
                        if (encoderStatus != -1) ** GOTO lbl195
                        decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 100L);
                        if (decoderStatus != -1) break block92;
                        decoderOutputAvailable = false;
                        ** GOTO lbl195
                    }
                    if (decoderStatus == -3 || decoderStatus == -2) ** GOTO lbl195
                    if (decoderStatus < 0) {
                        throw new RuntimeException(Intrinsics.stringPlus((String)"unexpected result from decoder.dequeueOutputBuffer: ", (Object)decoderStatus));
                    }
                    doRender = bufferInfo.size != 0;
                    decoder.releaseOutputBuffer(decoderStatus, doRender);
                    if (doRender) {
                        errorWait = false;
                        try {
                            outputSurface.awaitNewImage();
                        }
                        catch (Exception e) {
                            errorWait = true;
                            var50_86 = e.getMessage();
                            Log.e((String)"Compressor", (String)(var50_86 == null ? "Compression failed at swapping buffer" : var50_86));
                        }
                        if (!errorWait) {
                            outputSurface.drawImage();
                            inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                            listener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                            inputSurface.swapBuffers();
                        }
                    }
                    if ((bufferInfo.flags & 4) == 0) ** GOTO lbl195
                    decoderOutputAvailable = false;
                    encoder.signalEndOfInputStream();
                    ** GOTO lbl195
                }
lbl362:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                inputDone = decoder;
                if (inputDone == null) {
                    v11 = null;
                } else {
                    inputDone.stop();
                    v11 = Unit.INSTANCE;
                }
                inputDone = decoder;
                if (inputDone == null) {
                    v12 = null;
                } else {
                    inputDone.release();
                    v12 = Unit.INSTANCE;
                }
                encoder.stop();
                encoder.release();
                inputDone = inputSurface;
                inputDone.release();
                inputDone = outputSurface;
                inputDone.release();
                Intrinsics.checkNotNullExpressionValue((Object)mediaMuxer, (String)"mediaMuxer");
                this.processAudio(extractor, mediaMuxer, bufferInfo);
                extractor.unselectTrack(videoIndex);
                exception = decoder;
                if (exception == null) {
                    v13 = null;
                } else {
                    exception.stop();
                    v13 = Unit.INSTANCE;
                }
                exception = decoder;
                if (exception == null) {
                    v14 = null;
                } else {
                    exception.release();
                    v14 = Unit.INSTANCE;
                }
                encoder.stop();
                encoder.release();
                exception = inputSurface;
                if (exception == null) {
                    v15 = null;
                } else {
                    exception.release();
                    v15 = Unit.INSTANCE;
                }
                exception = outputSurface;
                if (exception == null) {
                    v16 = null;
                }
                exception.release();
                v16 = Unit.INSTANCE;
            }
            extractor.release();
            try {
                mediaMuxer.finishMovie();
                return new Result(true, null);
            }
            catch (Exception e) {
                this.printException(e);
            }
            return new Result(true, null);
        }
        catch (Exception exception) {
            this.printException(exception);
        }
        return new Result(true, null);
    }

    private final void printException(Exception exception) {
        String message = null;
        message = "An error has occurred!";
        String string = exception.getMessage();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            message = it;
        }
        Log.e((String)"Compressor", (String)message);
    }

    private final int getBitrate(int bitrate, VideoQuality quality) {
        int n;
        VideoQuality videoQuality = quality;
        int n2 = WhenMappings.$EnumSwitchMapping$0[videoQuality.ordinal()];
        switch (n2) {
            case 1: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.08));
                break;
            }
            case 2: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.1));
                break;
            }
            case 3: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.2));
                break;
            }
            case 4: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.3));
                break;
            }
            case 5: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.5));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final Pair<Integer, Integer> generateWidthAndHeight(double width, double height, boolean keepOriginalResolution) {
        if (keepOriginalResolution) {
            return new Pair((Object)MathKt.roundToInt((double)width), (Object)MathKt.roundToInt((double)height));
        }
        int newWidth = 0;
        int newHeight = 0;
        if (width >= 1920.0 || height >= 1920.0) {
            newWidth = this.generateWidthHeightValue(width, 0.5);
            newHeight = this.generateWidthHeightValue(height, 0.5);
        } else if (width >= 1280.0 || height >= 1280.0) {
            newWidth = this.generateWidthHeightValue(width, 0.75);
            newHeight = this.generateWidthHeightValue(height, 0.75);
        } else if (width >= 960.0 || height >= 960.0) {
            if (width > height) {
                newWidth = this.generateWidthHeightValue(640.0, 0.95);
                newHeight = this.generateWidthHeightValue(360.0, 0.95);
            } else {
                newWidth = this.generateWidthHeightValue(360.0, 0.95);
                newHeight = this.generateWidthHeightValue(640.0, 0.95);
            }
        } else {
            newWidth = this.generateWidthHeightValue(width, 0.9);
            newHeight = this.generateWidthHeightValue(height, 0.9);
        }
        return new Pair((Object)newWidth, (Object)newHeight);
    }

    private final int roundEven(int value) {
        return value + 1 & 0xFFFFFFFE;
    }

    private final int generateWidthHeightValue(double value, double factor) {
        return this.roundEven(MathKt.roundToInt((double)(value * factor / (double)16)) * 16);
    }

    private final Mp4Movie setUpMP4Movie(int rotation, File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$setUpMP4Movie_u24lambda_u2d2 = mp4Movie;
        boolean bl3 = false;
        $this$setUpMP4Movie_u24lambda_u2d2.setCacheFile(cacheFile);
        $this$setUpMP4Movie_u24lambda_u2d2.setRotation(rotation);
        return movie;
    }

    private final void setOutputFileParameters(MediaFormat inputFormat, MediaFormat outputFormat, int newBitrate) {
        int frameRate = this.getFrameRate(inputFormat);
        int iFrameInterval = this.getIFrameIntervalRate(inputFormat);
        MediaFormat mediaFormat = outputFormat;
        boolean bl = false;
        boolean bl2 = false;
        MediaFormat $this$setOutputFileParameters_u24lambda_u2d8 = mediaFormat;
        boolean bl3 = false;
        $this$setOutputFileParameters_u24lambda_u2d8.setInteger("color-format", 2130708361);
        $this$setOutputFileParameters_u24lambda_u2d8.setInteger("frame-rate", frameRate);
        $this$setOutputFileParameters_u24lambda_u2d8.setInteger("i-frame-interval", iFrameInterval);
        $this$setOutputFileParameters_u24lambda_u2d8.setInteger("bitrate", newBitrate);
        if (Build.VERSION.SDK_INT > 23) {
            int it;
            boolean bl4;
            boolean bl5;
            Integer n;
            Integer n2 = INSTANCE.getProfile(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl6 = false;
                $this$setOutputFileParameters_u24lambda_u2d8.setInteger("profile", it);
            }
            n2 = INSTANCE.getLevel(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl7 = false;
                $this$setOutputFileParameters_u24lambda_u2d8.setInteger("level", it);
            }
            n2 = INSTANCE.getColorStandard(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl8 = false;
                $this$setOutputFileParameters_u24lambda_u2d8.setInteger("color-standard", it);
            }
            n2 = INSTANCE.getColorTransfer(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl9 = false;
                $this$setOutputFileParameters_u24lambda_u2d8.setInteger("color-transfer", it);
            }
            n2 = INSTANCE.getColorRange(inputFormat);
            if (n2 != null) {
                n = n2;
                bl5 = false;
                bl4 = false;
                it = ((Number)n).intValue();
                boolean bl10 = false;
                $this$setOutputFileParameters_u24lambda_u2d8.setInteger("color-range", it);
            }
        }
    }

    private final int selectTrack(MediaExtractor extractor, boolean isVideo) {
        int n = 0;
        int numTracks = extractor.getTrackCount();
        if (n < numTracks) {
            do {
                Boolean bl;
                String string;
                int i = n++;
                MediaFormat mediaFormat = extractor.getTrackFormat(i);
                Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(i)");
                MediaFormat format = mediaFormat;
                String mime = format.getString("mime");
                if (isVideo) {
                    string = mime;
                    bl = string == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null));
                    Intrinsics.checkNotNull(bl);
                    if (!bl.booleanValue()) continue;
                    return i;
                }
                string = mime;
                bl = string == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null));
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) continue;
                return i;
            } while (n < numTracks);
        }
        return -5;
    }

    private final void processAudio(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        int audioIndex = this.selectTrack(extractor, false);
        if (audioIndex >= 0) {
            extractor.selectTrack(audioIndex);
            MediaFormat mediaFormat = extractor.getTrackFormat(audioIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(audioIndex)");
            MediaFormat audioFormat = mediaFormat;
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size < 0) continue;
                    MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec.BufferInfo $this$processAudio_u24lambda_u2d9 = bufferInfo2;
                    boolean bl3 = false;
                    $this$processAudio_u24lambda_u2d9.presentationTimeUs = extractor.getSampleTime();
                    $this$processAudio_u24lambda_u2d9.offset = 0;
                    $this$processAudio_u24lambda_u2d9.flags = extractor.getSampleFlags();
                    mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                    extractor.advance();
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private final int getFrameRate(MediaFormat format) {
        return format.containsKey("frame-rate") ? format.getInteger("frame-rate") : 30;
    }

    private final int getIFrameIntervalRate(MediaFormat format) {
        return format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 2;
    }

    @RequiresApi(value=23)
    private final Integer getLevel(MediaFormat format) {
        return format.containsKey("level") ? Integer.valueOf(format.getInteger("level")) : null;
    }

    private final Integer getProfile(MediaFormat format) {
        return format.containsKey("profile") ? Integer.valueOf(format.getInteger("profile")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorStandard(MediaFormat format) {
        return format.containsKey("color-standard") ? Integer.valueOf(format.getInteger("color-standard")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorTransfer(MediaFormat format) {
        return format.containsKey("color-transfer") ? Integer.valueOf(format.getInteger("color-transfer")) : null;
    }

    @RequiresApi(value=24)
    private final Integer getColorRange(MediaFormat format) {
        return format.containsKey("color-range") ? Integer.valueOf(format.getInteger("color-range")) : null;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoQuality.values().length];
            nArray[VideoQuality.VERY_LOW.ordinal()] = 1;
            nArray[VideoQuality.LOW.ordinal()] = 2;
            nArray[VideoQuality.MEDIUM.ordinal()] = 3;
            nArray[VideoQuality.HIGH.ordinal()] = 4;
            nArray[VideoQuality.VERY_HIGH.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

