/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.util.Log;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.Compressor$WhenMappings;
import com.abedelazizshe.lightcompressorlibrary.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.OutputSurface;
import com.abedelazizshe.lightcompressorlibrary.Result;
import com.abedelazizshe.lightcompressorlibrary.VideoQuality;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dJ,\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001f2\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002J\u0014\u0010(\u001a\u00020)2\n\u0010*\u001a\u00060+j\u0002`,H\u0002J \u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0018\u00104\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/2\u0006\u00105\u001a\u00020\u0010H\u0002J0\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0004H\u0002J(\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u00042\u0006\u0010A\u001a\u00020BH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006C"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/Compressor;", "", "()V", "FRAME_RATE", "", "INVALID_BITRATE", "", "I_FRAME_INTERVAL", "MEDIACODEC_TIMEOUT_DEFAULT", "", "MIME_TYPE", "MIN_BITRATE", "MIN_HEIGHT", "", "MIN_WIDTH", "isRunning", "", "()Z", "setRunning", "(Z)V", "compressVideo", "Lcom/abedelazizshe/lightcompressorlibrary/Result;", "source", "destination", "quality", "Lcom/abedelazizshe/lightcompressorlibrary/VideoQuality;", "isMinBitRateEnabled", "keepOriginalResolution", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "getBitrate", "bitrate", "getFrameRate", "format", "Landroid/media/MediaFormat;", "getIFrameIntervalRate", "printException", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processAudio", "extractor", "Landroid/media/MediaExtractor;", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "selectTrack", "isVideo", "setOutputFileParameters", "outputFormat", "colorFormat", "newBitrate", "frameRate", "iFrameInterval", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/Mp4Movie;", "rotation", "newWidth", "newHeight", "cacheFile", "Ljava/io/File;", "lightcompressor_release"})
public final class Compressor {
    private static final int MIN_BITRATE = 2000000;
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 360.0;
    private static final int FRAME_RATE = 30;
    private static final int I_FRAME_INTERVAL = 15;
    private static final String MIME_TYPE = "video/avc";
    private static final long MEDIACODEC_TIMEOUT_DEFAULT = 2500L;
    private static final String INVALID_BITRATE = "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false";
    private static boolean isRunning;
    public static final Compressor INSTANCE;

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Result compressVideo(@NotNull String source, @NotNull String destination, @NotNull VideoQuality quality, boolean isMinBitRateEnabled, boolean keepOriginalResolution, @NotNull CompressionProgressListener listener) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)quality, (String)"quality");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        mediaMetadataRetriever = new MediaMetadataRetriever();
        try {
            mediaMetadataRetriever.setDataSource(source);
        }
        catch (IllegalArgumentException exception) {
            return new Result(false, "Source path: " + source + " can be invalid! or you don't have READ_EXTERNAL_STORAGE permission");
        }
        heightData = mediaMetadataRetriever.extractMetadata(19);
        widthData = mediaMetadataRetriever.extractMetadata(18);
        rotationData = mediaMetadataRetriever.extractMetadata(24);
        bitrateData = mediaMetadataRetriever.extractMetadata(20);
        durationData = mediaMetadataRetriever.extractMetadata(9);
        height = 0.0;
        width = 0.0;
        var17_16 = heightData;
        var18_18 = false;
        var19_21 = false;
        if (var17_16 == null || var17_16.length() == 0) ** GOTO lbl-1000
        var17_16 = widthData;
        var18_18 = false;
        var19_21 = false;
        if (var17_16 == null || var17_16.length() == 0) lbl-1000:
        // 2 sources

        {
            height = 640.0;
            width = 360.0;
        } else {
            var17_16 = heightData;
            var18_18 = false;
            height = Double.parseDouble((String)var17_16);
            var17_16 = widthData;
            var18_18 = false;
            width = Double.parseDouble((String)var17_16);
        }
        var17_16 = rotationData;
        var18_18 = false;
        var19_21 = false;
        if ((var17_16 == null || var17_16.length() == 0) != false) return new Result(false, "Failed to extract video meta-data, please try again");
        var17_16 = bitrateData;
        var18_18 = false;
        var19_21 = false;
        if ((var17_16 == null || var17_16.length() == 0) != false) return new Result(false, "Failed to extract video meta-data, please try again");
        var17_16 = durationData;
        var18_18 = false;
        var19_21 = false;
        if (var17_16 == null || var17_16.length() == 0) {
            return new Result(false, "Failed to extract video meta-data, please try again");
        }
        var18_19 = rotationData;
        var19_21 = false;
        rotation = Integer.parseInt(var18_19);
        var19_22 = bitrateData;
        var20_24 = false;
        bitrate = Integer.parseInt(var19_22);
        var21_25 = durationData;
        var22_27 = 0;
        duration = Long.parseLong(var21_25) * (long)1000;
        if (isMinBitRateEnabled && bitrate <= 2000000) {
            return new Result(false, "The provided bitrate is smaller than what is needed for compression try to set isMinBitRateEnabled to false");
        }
        newBitrate = this.getBitrate(bitrate, quality);
        var24_28 = this.generateWidthAndHeight(width, height, keepOriginalResolution);
        var22_27 = ((Number)var24_28.component1()).intValue();
        newHeight = ((Number)var24_28.component2()).intValue();
        switch (rotation) {
            case 90: 
            case 270: {
                tempHeight = newHeight;
                newHeight = newWidth;
                newWidth = tempHeight;
                v0 = 0;
                break;
            }
            case 180: {
                v0 = 0;
                break;
            }
            default: {
                v0 = rotation;
            }
        }
        rotation = v0;
        file = new File(source);
        if (!file.canRead()) {
            return new Result(false, "The source file cannot be accessed!");
        }
        noExceptions = true;
        if (newWidth == 0) return new Result(false, "Something went wrong, please try again");
        if (newHeight == 0) return new Result(false, "Something went wrong, please try again");
        cacheFile = new File(destination);
        try {
            bufferInfo = new MediaCodec.BufferInfo();
            movie = this.setUpMP4Movie(rotation, newWidth, newHeight, cacheFile);
            mediaMuxer = new MP4Builder().createMovie(movie);
            extractor = new MediaExtractor();
            extractor.setDataSource(file.toString());
            videoIndex = this.selectTrack(extractor, true);
            extractor.selectTrack(videoIndex);
            extractor.seekTo(0L, 0);
            v1 = extractor.getTrackFormat(videoIndex);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"extractor.getTrackFormat(videoIndex)");
            inputFormat = v1;
            frameRate = this.getFrameRate(inputFormat);
            iFrameInterval = this.getIFrameIntervalRate(inputFormat);
            v2 = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"MediaFormat.createVideoF\u2026YPE, newWidth, newHeight)");
            outputFormat = v2;
            decoder = null;
            v3 = MediaCodec.createEncoderByType((String)"video/avc");
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"MediaCodec.createEncoderByType(MIME_TYPE)");
            encoder = v3;
            inputSurface = null;
            outputSurface = null;
            try {
                inputDone = false;
                outputDone = false;
                videoTrackIndex = -5;
                colorFormat = 2130708361;
                this.setOutputFileParameters(outputFormat, colorFormat, newBitrate, frameRate, iFrameInterval);
                encoder.configure(outputFormat, null, null, 1);
                inputSurface = new InputSurface(encoder.createInputSurface());
                inputSurface.makeCurrent();
                encoder.start();
                outputSurface = new OutputSurface();
                v4 = inputFormat.getString("mime");
                Intrinsics.checkNotNull((Object)v4);
                decoder = MediaCodec.createDecoderByType((String)v4);
                decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                decoder.start();
                while (!outputDone) {
                    if (!inputDone) {
                        index = extractor.getSampleTrackIndex();
                        if (index == videoIndex) {
                            inputBufferIndex = decoder.dequeueInputBuffer(0L);
                            if (inputBufferIndex >= 0) {
                                v5 = inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                Intrinsics.checkNotNull((Object)v5);
                                chunkSize = extractor.readSampleData((ByteBuffer)v5, 0);
                                if (chunkSize < 0) {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                    inputDone = true;
                                } else {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                    extractor.advance();
                                }
                            }
                        } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(0L)) >= 0) {
                            decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                            inputDone = true;
                        }
                    }
                    decoderOutputAvailable = true;
                    encoderOutputAvailable = true;
lbl149:
                    // 6 sources

                    while (decoderOutputAvailable || encoderOutputAvailable) {
                        if (Compressor.isRunning) ** GOTO lbl-1000
                        listener.onProgressCancelled();
                        inputBuffer = new Result(false, "The compression has been stopped!");
                        ** GOTO lbl194
                    }
                }
                ** GOTO lbl311
            }
            catch (Exception exception) {
                try {
                    this.printException(exception);
                    noExceptions = false;
                }
                catch (Throwable exception) {
                    extractor.unselectTrack(videoIndex);
                    v6 = decoder;
                    if (v6 != null) {
                        v6.stop();
                        v7 = Unit.INSTANCE;
                    } else {
                        v7 = null;
                    }
                    v8 = decoder;
                    if (v8 != null) {
                        v8.release();
                        v9 = Unit.INSTANCE;
                    } else {
                        v9 = null;
                    }
                    encoder.stop();
                    encoder.release();
                    v10 = inputSurface;
                    if (v10 != null) {
                        v10.release();
                        v11 = Unit.INSTANCE;
                    } else {
                        v11 = null;
                    }
                    v12 = outputSurface;
                    if (v12 != null) {
                        v12.release();
                        v13 = Unit.INSTANCE;
                    } else {
                        v13 = null;
                    }
                    v14 = mediaMuxer;
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"mediaMuxer");
                    this.processAudio(extractor, v14, bufferInfo);
                    throw exception;
                }
lbl194:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                v15 = decoder;
                if (v15 != null) {
                    v15.stop();
                    v16 = Unit.INSTANCE;
                } else {
                    v16 = null;
                }
                v17 = decoder;
                if (v17 != null) {
                    v17.release();
                    v18 = Unit.INSTANCE;
                } else {
                    v18 = null;
                }
                encoder.stop();
                encoder.release();
                inputSurface.release();
                outputSurface.release();
                v19 = mediaMuxer;
                Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"mediaMuxer");
                this.processAudio(extractor, v19, bufferInfo);
                return inputBuffer;
lbl-1000:
                // 1 sources

                {
                    block72: {
                        encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 2500L);
                        if (encoderStatus == -1) {
                            encoderOutputAvailable = false;
                        } else if (encoderStatus == -2) {
                            Intrinsics.checkNotNullExpressionValue((Object)encoder.getOutputFormat(), (String)"encoder.outputFormat");
                            if (videoTrackIndex == -5) {
                                videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                            }
                        } else if (encoderStatus != -3) {
                            if (encoderStatus < 0) {
                                throw (Throwable)new RuntimeException("unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                            }
                            if (encoder.getOutputBuffer(encoderStatus) == null) throw (Throwable)new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                            Intrinsics.checkNotNullExpressionValue((Object)encodedData, (String)"encoder.getOutputBuffer(\u2026$encoderStatus was null\")");
                            if (bufferInfo.size > 1) {
                                if ((bufferInfo.flags & 2) == 0) {
                                    mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                } else if (videoTrackIndex == -5) {
                                    csd = new byte[bufferInfo.size];
                                    var49_65 = encodedData;
                                    var50_68 = false;
                                    var51_70 = 0;
                                    $this$apply = var49_65;
                                    $i$a$-apply-Compressor$compressVideo$1 = false;
                                    $this$apply.limit(bufferInfo.offset + bufferInfo.size);
                                    $this$apply.position(bufferInfo.offset);
                                    $this$apply.get(csd);
                                    sps = null;
                                    pps = null;
                                    var51_70 = bufferInfo.size - 1;
                                    var52_71 = false;
                                    while (var51_70 >= 0 && a > 3) {
                                        if (csd[a] == 1 && csd[a - true] == 0 && csd[a - 2] == 0 && csd[a - 3] == 0) {
                                            sps = ByteBuffer.allocate((int)(a - 3));
                                            pps = ByteBuffer.allocate(bufferInfo.size - (a - 3));
                                            v20 = sps;
                                            Intrinsics.checkNotNull((Object)v20);
                                            v20.put(csd, 0, (int)(a - 3)).position(0);
                                            v21 = pps;
                                            Intrinsics.checkNotNull((Object)v21);
                                            v21.put(csd, (int)(a - 3), bufferInfo.size - (a - 3)).position(0);
                                            break;
                                        }
                                        --a;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight), (String)"MediaFormat.createVideoF\u2026                        )");
                                    if (sps != null && pps != null) {
                                        newFormat.setByteBuffer("csd-0", sps);
                                        newFormat.setByteBuffer("csd-1", pps);
                                    }
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            }
                            outputDone = (bufferInfo.flags & 4) != 0;
                            encoder.releaseOutputBuffer(encoderStatus, false);
                        }
                        if (encoderStatus != -1) ** GOTO lbl149
                        decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 2500L);
                        if (decoderStatus != -1) break block72;
                        decoderOutputAvailable = false;
                        ** GOTO lbl149
                    }
                    if (decoderStatus == -3 || decoderStatus == -2) ** GOTO lbl149
                    if (decoderStatus < 0) {
                        throw (Throwable)new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
                    }
                    doRender = bufferInfo.size != 0;
                    decoder.releaseOutputBuffer(decoderStatus, doRender);
                    if (doRender) {
                        try {
                            outputSurface.awaitNewImage();
                            outputSurface.drawImage();
                            inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                            listener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                            inputSurface.swapBuffers();
                        }
                        catch (Exception e) {
                            v22 = e.getMessage();
                            if (v22 == null) {
                                v22 = "Compression failed at swapping buffer";
                            }
                            Log.e((String)"Compressor", (String)v22);
                        }
                    }
                    if ((bufferInfo.flags & 4) == 0) ** GOTO lbl149
                    decoderOutputAvailable = false;
                    encoder.signalEndOfInputStream();
                    ** GOTO lbl149
                }
lbl311:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                v23 = decoder;
                if (v23 != null) {
                    v23.stop();
                    v24 = Unit.INSTANCE;
                } else {
                    v24 = null;
                }
                v25 = decoder;
                if (v25 != null) {
                    v25.release();
                    v26 = Unit.INSTANCE;
                } else {
                    v26 = null;
                }
                encoder.stop();
                encoder.release();
                inputSurface.release();
                outputSurface.release();
                v27 = mediaMuxer;
                Intrinsics.checkNotNullExpressionValue((Object)v27, (String)"mediaMuxer");
                this.processAudio(extractor, v27, bufferInfo);
                extractor.unselectTrack(videoIndex);
                v28 = decoder;
                if (v28 != null) {
                    v28.stop();
                    v29 = Unit.INSTANCE;
                } else {
                    v29 = null;
                }
                v30 = decoder;
                if (v30 != null) {
                    v30.release();
                    v31 = Unit.INSTANCE;
                } else {
                    v31 = null;
                }
                encoder.stop();
                encoder.release();
                v32 = inputSurface;
                if (v32 != null) {
                    v32.release();
                    v33 = Unit.INSTANCE;
                } else {
                    v33 = null;
                }
                v34 = outputSurface;
                if (v34 != null) {
                    v34.release();
                    v35 = Unit.INSTANCE;
                }
                v35 = null;
            }
            extractor.release();
            try {
                mediaMuxer.finishMovie();
                return new Result(true, null);
            }
            catch (Exception e) {
                this.printException(e);
                return new Result(true, null);
            }
        }
        catch (Exception exception) {
            this.printException(exception);
        }
        return new Result(true, null);
    }

    private final void printException(Exception exception) {
        String message = "An error has occurred!";
        String string = exception.getMessage();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            message = it;
        }
        Log.e((String)"Compressor", (String)message);
    }

    private final int getBitrate(int bitrate, VideoQuality quality) {
        int n;
        switch (Compressor$WhenMappings.$EnumSwitchMapping$0[quality.ordinal()]) {
            case 1: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.1));
                break;
            }
            case 2: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.2));
                break;
            }
            case 3: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.3));
                break;
            }
            case 4: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.5));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final Pair<Integer, Integer> generateWidthAndHeight(double width, double height, boolean keepOriginalResolution) {
        if (keepOriginalResolution) {
            return new Pair((Object)MathKt.roundToInt((double)width), (Object)MathKt.roundToInt((double)height));
        }
        double newWidth = 0.0;
        double newHeight = 0.0;
        if (width >= (double)1920 || height >= (double)1920) {
            newWidth = width * 0.5;
            newHeight = height * 0.5;
        } else if (width >= (double)1280 || height >= (double)1280) {
            newWidth = width * 0.75;
            newHeight = height * 0.75;
        } else if (width >= (double)960 || height >= (double)960) {
            newWidth = 608.0;
            newHeight = 342.0;
        } else {
            newWidth = width * 0.9;
            newHeight = height * 0.9;
        }
        return new Pair((Object)(2 * MathKt.roundToInt((double)(newWidth / (double)2))), (Object)(2 * MathKt.roundToInt((double)(newHeight / (double)2))));
    }

    private final Mp4Movie setUpMP4Movie(int rotation, int newWidth, int newHeight, File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$apply = mp4Movie;
        boolean bl3 = false;
        $this$apply.setCacheFile(cacheFile);
        $this$apply.setRotation(rotation);
        $this$apply.setSize(newWidth, newHeight);
        return movie;
    }

    private final void setOutputFileParameters(MediaFormat outputFormat, int colorFormat, int newBitrate, int frameRate, int iFrameInterval) {
        MediaFormat mediaFormat = outputFormat;
        boolean bl = false;
        boolean bl2 = false;
        MediaFormat $this$apply = mediaFormat;
        boolean bl3 = false;
        $this$apply.setInteger("color-format", colorFormat);
        $this$apply.setInteger("bitrate", newBitrate);
        $this$apply.setInteger("frame-rate", frameRate);
        $this$apply.setInteger("i-frame-interval", iFrameInterval);
    }

    /*
     * WARNING - void declaration
     */
    private final int selectTrack(MediaExtractor extractor, boolean isVideo) {
        int numTracks = extractor.getTrackCount();
        int n = 0;
        int n2 = numTracks;
        while (n < n2) {
            MediaFormat format;
            void i;
            Intrinsics.checkNotNullExpressionValue((Object)extractor.getTrackFormat((int)i), (String)"extractor.getTrackFormat(i)");
            String mime = format.getString("mime");
            if (isVideo) {
                String string = mime;
                Boolean bl = string != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null)) : null;
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) {
                    return (int)i;
                }
            } else {
                String string = mime;
                Boolean bl = string != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null)) : null;
                Intrinsics.checkNotNull(bl);
                if (bl.booleanValue()) {
                    return (int)i;
                }
            }
            ++i;
        }
        return -5;
    }

    private final void processAudio(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        int audioIndex = this.selectTrack(extractor, false);
        if (audioIndex >= 0) {
            extractor.selectTrack(audioIndex);
            MediaFormat mediaFormat = extractor.getTrackFormat(audioIndex);
            Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"extractor.getTrackFormat(audioIndex)");
            MediaFormat audioFormat = mediaFormat;
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size < 0) continue;
                    MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec.BufferInfo $this$apply = bufferInfo2;
                    boolean bl3 = false;
                    $this$apply.presentationTimeUs = extractor.getSampleTime();
                    $this$apply.offset = 0;
                    $this$apply.flags = extractor.getSampleFlags();
                    mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                    extractor.advance();
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private final int getFrameRate(MediaFormat format) {
        return format.containsKey("frame-rate") ? format.getInteger("frame-rate") : 30;
    }

    private final int getIFrameIntervalRate(MediaFormat format) {
        return format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 15;
    }

    private Compressor() {
    }

    static {
        Compressor compressor;
        INSTANCE = compressor = new Compressor();
        isRunning = true;
    }
}

