/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import java.util.Arrays;

public class TwoSecondIntersectionFinder
implements FragmentIntersectionFinder {
    private int fragmentLength = 2;
    private Movie movie;

    public TwoSecondIntersectionFinder(Movie movie, int fragmentLength) {
        this.movie = movie;
        this.fragmentLength = fragmentLength;
    }

    public long[] sampleNumbers(Track track) {
        double trackLength = 0.0;
        for (Track thisTrack : this.movie.getTracks()) {
            double thisTracksLength = thisTrack.getDuration() / thisTrack.getTrackMetaData().getTimescale();
            if (!(trackLength < thisTracksLength)) continue;
            trackLength = thisTracksLength;
        }
        int fragmentCount = (int)Math.ceil(trackLength / (double)this.fragmentLength) - 1;
        if ((fragmentCount = Math.min(fragmentCount, track.getSamples().size())) < 1) {
            fragmentCount = 1;
        }
        long[] fragments = new long[fragmentCount];
        Arrays.fill(fragments, -1L);
        fragments[0] = 1L;
        long time = 0L;
        int samples = 0;
        long[] lArray = track.getSampleDurations();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long delta = lArray[n2];
            int currentFragment = (int)(time / track.getTrackMetaData().getTimescale() / (long)this.fragmentLength) + 1;
            if (currentFragment >= fragments.length) break;
            fragments[currentFragment] = samples++ + 1;
            time += delta;
            ++n2;
        }
        long last = samples + 1;
        int i = fragments.length - 1;
        while (i >= 0) {
            if (fragments[i] == -1L) {
                fragments[i] = last;
            }
            last = fragments[i];
            --i;
        }
        long[] cleanedFragments = new long[]{};
        long[] lArray2 = fragments;
        int n3 = fragments.length;
        int n4 = 0;
        while (n4 < n3) {
            long fragment = lArray2[n4];
            if (cleanedFragments.length == 0 || cleanedFragments[cleanedFragments.length - 1] != fragment) {
                cleanedFragments = Arrays.copyOf(cleanedFragments, cleanedFragments.length + 1);
                cleanedFragments[cleanedFragments.length - 1] = fragment;
            }
            ++n4;
        }
        return cleanedFragments;
    }
}

