/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.Sample;
import com.abedelazizshe.lightcompressorlibrary.Track;
import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.util.Matrix;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

class MP4Builder {
    private InterleaveChunkMdat mdat = null;
    private Mp4Movie currentMp4Movie = null;
    private FileOutputStream fos = null;
    private FileChannel fc = null;
    private long dataOffset = 0L;
    private long wroteSinceLastMdat = 0L;
    private boolean writeNewMdat = true;
    private HashMap<Track, long[]> track2SampleSizes = new HashMap();
    private ByteBuffer sizeBuffer = null;

    MP4Builder() {
    }

    MP4Builder createMovie(Mp4Movie mp4Movie) throws Exception {
        this.currentMp4Movie = mp4Movie;
        this.fos = new FileOutputStream(mp4Movie.getCacheFile());
        this.fc = this.fos.getChannel();
        FileTypeBox fileTypeBox = this.createFileTypeBox();
        fileTypeBox.getBox((WritableByteChannel)this.fc);
        this.dataOffset += fileTypeBox.getSize();
        this.wroteSinceLastMdat += this.dataOffset;
        this.mdat = new InterleaveChunkMdat();
        this.sizeBuffer = ByteBuffer.allocateDirect(4);
        return this;
    }

    private void flushCurrentMdat() throws Exception {
        long oldPosition = this.fc.position();
        this.fc.position(this.mdat.getOffset());
        this.mdat.getBox(this.fc);
        this.fc.position(oldPosition);
        this.mdat.setDataOffset(0L);
        this.mdat.setContentSize(0L);
        this.fos.flush();
    }

    boolean writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo, boolean isAudio) throws Exception {
        if (this.writeNewMdat) {
            this.mdat.setContentSize(0L);
            this.mdat.getBox(this.fc);
            this.mdat.setDataOffset(this.dataOffset);
            this.dataOffset += 16L;
            this.wroteSinceLastMdat += 16L;
            this.writeNewMdat = false;
        }
        this.mdat.setContentSize(this.mdat.getContentSize() + (long)bufferInfo.size);
        this.wroteSinceLastMdat += (long)bufferInfo.size;
        boolean flush = false;
        if (this.wroteSinceLastMdat >= 32768L) {
            this.flushCurrentMdat();
            this.writeNewMdat = true;
            flush = true;
            this.wroteSinceLastMdat = 0L;
        }
        this.currentMp4Movie.addSample(trackIndex, this.dataOffset, bufferInfo);
        byteBuf.position(bufferInfo.offset + (isAudio ? 0 : 4));
        byteBuf.limit(bufferInfo.offset + bufferInfo.size);
        if (!isAudio) {
            this.sizeBuffer.position(0);
            this.sizeBuffer.putInt(bufferInfo.size - 4);
            this.sizeBuffer.position(0);
            this.fc.write(this.sizeBuffer);
        }
        this.fc.write(byteBuf);
        this.dataOffset += (long)bufferInfo.size;
        if (flush) {
            this.fos.flush();
        }
        return flush;
    }

    int addTrack(MediaFormat mediaFormat, boolean isAudio) throws Exception {
        return this.currentMp4Movie.addTrack(mediaFormat, isAudio);
    }

    void finishMovie() throws Exception {
        if (this.mdat.getContentSize() != 0L) {
            this.flushCurrentMdat();
        }
        for (Track track : this.currentMp4Movie.getTracks()) {
            ArrayList<Sample> samples = track.getSamples();
            long[] sizes = new long[samples.size()];
            for (int i = 0; i < sizes.length; ++i) {
                sizes[i] = ((Sample)samples.get(i)).getSize();
            }
            this.track2SampleSizes.put(track, sizes);
        }
        MovieBox moov = this.createMovieBox(this.currentMp4Movie);
        moov.getBox((WritableByteChannel)this.fc);
        this.fos.flush();
        this.fc.close();
        this.fos.close();
    }

    private FileTypeBox createFileTypeBox() {
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("mp42");
        minorBrands.add("iso6");
        minorBrands.add("avc1");
        minorBrands.add("isom");
        return new FileTypeBox("iso6", 1L, minorBrands);
    }

    private static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return MP4Builder.gcd(b, a % b);
    }

    private long getTimescale(Mp4Movie mp4Movie) {
        long timescale = 0L;
        if (!mp4Movie.getTracks().isEmpty()) {
            timescale = mp4Movie.getTracks().iterator().next().getTimeScale();
        }
        for (Track track : mp4Movie.getTracks()) {
            timescale = MP4Builder.gcd(track.getTimeScale(), timescale);
        }
        return timescale;
    }

    private MovieBox createMovieBox(Mp4Movie movie) {
        MovieBox movieBox = new MovieBox();
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setCreationTime(new Date());
        mvhd.setModificationTime(new Date());
        mvhd.setMatrix(Matrix.ROTATE_0);
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration = track.getDuration() * movieTimeScale / (long)track.getTimeScale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        mvhd.setNextTrackId((long)(movie.getTracks().size() + 1));
        movieBox.addBox((Box)mvhd);
        for (Track track : movie.getTracks()) {
            movieBox.addBox((Box)this.createTrackBox(track, movie));
        }
        return movieBox;
    }

    private TrackBox createTrackBox(Track track, Mp4Movie movie) {
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox tkhd = new TrackHeaderBox();
        tkhd.setEnabled(true);
        tkhd.setInMovie(true);
        tkhd.setInPreview(true);
        if (track.isAudio()) {
            tkhd.setMatrix(Matrix.ROTATE_0);
        } else {
            tkhd.setMatrix(movie.getMatrix());
        }
        tkhd.setAlternateGroup(0);
        tkhd.setCreationTime(track.getCreationTime());
        tkhd.setDuration(track.getDuration() * this.getTimescale(movie) / (long)track.getTimeScale());
        tkhd.setHeight((double)track.getHeight());
        tkhd.setWidth((double)track.getWidth());
        tkhd.setLayer(0);
        tkhd.setModificationTime(new Date());
        tkhd.setTrackId(track.getTrackId() + 1L);
        tkhd.setVolume(track.getVolume());
        trackBox.addBox((Box)tkhd);
        MediaBox mdia = new MediaBox();
        trackBox.addBox((Box)mdia);
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(track.getCreationTime());
        mdhd.setDuration(track.getDuration());
        mdhd.setTimescale((long)track.getTimeScale());
        mdhd.setLanguage("eng");
        mdia.addBox((Box)mdhd);
        HandlerBox hdlr = new HandlerBox();
        hdlr.setName(track.isAudio() ? "SoundHandle" : "VideoHandle");
        hdlr.setHandlerType(track.getHandler());
        mdia.addBox((Box)hdlr);
        MediaInformationBox minf = new MediaInformationBox();
        minf.addBox((Box)track.getMediaHeaderBox());
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox((Box)dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox((Box)url);
        minf.addBox((Box)dinf);
        Box stbl = this.createStbl(track);
        minf.addBox(stbl);
        mdia.addBox((Box)minf);
        return trackBox;
    }

    private Box createStbl(Track track) {
        SampleTableBox stbl = new SampleTableBox();
        this.createStsd(track, stbl);
        this.createStts(track, stbl);
        this.createStss(track, stbl);
        this.createStsc(track, stbl);
        this.createStsz(track, stbl);
        this.createStco(track, stbl);
        return stbl;
    }

    private void createStsd(Track track, SampleTableBox stbl) {
        stbl.addBox((Box)track.getSampleDescriptionBox());
    }

    private void createStts(Track track, SampleTableBox stbl) {
        TimeToSampleBox.Entry lastEntry = null;
        ArrayList<TimeToSampleBox.Entry> entries = new ArrayList<TimeToSampleBox.Entry>();
        for (long delta : track.getSampleDurations()) {
            if (lastEntry != null && lastEntry.getDelta() == delta) {
                lastEntry.setCount(lastEntry.getCount() + 1L);
                continue;
            }
            lastEntry = new TimeToSampleBox.Entry(1L, delta);
            entries.add(lastEntry);
        }
        TimeToSampleBox stts = new TimeToSampleBox();
        stts.setEntries(entries);
        stbl.addBox((Box)stts);
    }

    private void createStss(Track track, SampleTableBox stbl) {
        long[] syncSamples = track.getSyncSamples();
        if (syncSamples != null && syncSamples.length > 0) {
            SyncSampleBox stss = new SyncSampleBox();
            stss.setSampleNumber(syncSamples);
            stbl.addBox((Box)stss);
        }
    }

    private void createStsc(Track track, SampleTableBox stbl) {
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries(new LinkedList());
        int lastChunkNumber = 1;
        int lastSampleCount = 0;
        int previousWritedChunkCount = -1;
        int samplesCount = track.getSamples().size();
        for (int a = 0; a < samplesCount; ++a) {
            Sample sample = track.getSamples().get(a);
            long offset = sample.getOffset();
            long size = sample.getSize();
            long lastOffset = offset + size;
            ++lastSampleCount;
            boolean write = false;
            if (a != samplesCount - 1) {
                Sample nextSample = track.getSamples().get(a + 1);
                if (lastOffset != nextSample.getOffset()) {
                    write = true;
                }
            } else {
                write = true;
            }
            if (!write) continue;
            if (previousWritedChunkCount != lastSampleCount) {
                stsc.getEntries().add(new SampleToChunkBox.Entry((long)lastChunkNumber, (long)lastSampleCount, 1L));
                previousWritedChunkCount = lastSampleCount;
            }
            lastSampleCount = 0;
            ++lastChunkNumber;
        }
        stbl.addBox((Box)stsc);
    }

    private void createStsz(Track track, SampleTableBox stbl) {
        SampleSizeBox stsz = new SampleSizeBox();
        stsz.setSampleSizes(this.track2SampleSizes.get(track));
        stbl.addBox((Box)stsz);
    }

    private void createStco(Track track, SampleTableBox stbl) {
        ArrayList<Long> chunksOffsets = new ArrayList<Long>();
        long lastOffset = -1L;
        for (Sample sample : track.getSamples()) {
            long offset = sample.getOffset();
            if (lastOffset != -1L && lastOffset != offset) {
                lastOffset = -1L;
            }
            if (lastOffset == -1L) {
                chunksOffsets.add(offset);
            }
            lastOffset = offset + sample.getSize();
        }
        long[] chunkOffsetsLong = new long[chunksOffsets.size()];
        for (int a = 0; a < chunksOffsets.size(); ++a) {
            chunkOffsetsLong[a] = (Long)chunksOffsets.get(a);
        }
        StaticChunkOffsetBox stco = new StaticChunkOffsetBox();
        stco.setChunkOffsets(chunkOffsetsLong);
        stbl.addBox((Box)stco);
    }

    private static class InterleaveChunkMdat
    implements Box {
        private Container parent;
        private long contentSize = 0x40000000L;
        private long dataOffset = 0L;

        private InterleaveChunkMdat() {
        }

        public Container getParent() {
            return this.parent;
        }

        public long getOffset() {
            return this.dataOffset;
        }

        void setDataOffset(long offset) {
            this.dataOffset = offset;
        }

        public void setParent(Container parent) {
            this.parent = parent;
        }

        void setContentSize(long contentSize) {
            this.contentSize = contentSize;
        }

        long getContentSize() {
            return this.contentSize;
        }

        public String getType() {
            return "mdat";
        }

        public long getSize() {
            return 16L + this.contentSize;
        }

        private boolean isSmallBox(long contentSize) {
            return contentSize + 8L < 0x100000000L;
        }

        public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) {
        }

        public void getBox(WritableByteChannel writableByteChannel) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(16);
            long size = this.getSize();
            if (this.isSmallBox(size)) {
                IsoTypeWriter.writeUInt32((ByteBuffer)bb, (long)size);
            } else {
                IsoTypeWriter.writeUInt32((ByteBuffer)bb, (long)1L);
            }
            bb.put(IsoFile.fourCCtoBytes((String)"mdat"));
            if (this.isSmallBox(size)) {
                bb.put(new byte[8]);
            } else {
                IsoTypeWriter.writeUInt64((ByteBuffer)bb, (long)size);
            }
            bb.rewind();
            writableByteChannel.write(bb);
        }
    }
}

