/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.util.Log;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.Compressor$WhenMappings;
import com.abedelazizshe.lightcompressorlibrary.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.OutputSurface;
import com.abedelazizshe.lightcompressorlibrary.Result;
import com.abedelazizshe.lightcompressorlibrary.VideoQuality;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ,\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J \u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00101\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u00102\u001a\u00020\u000eH\u0002J0\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0002J(\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020?H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006@"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/Compressor;", "", "()V", "FRAME_RATE", "", "INVALID_BITRATE", "", "I_FRAME_INTERVAL", "MIME_TYPE", "MIN_BITRATE", "MIN_HEIGHT", "", "MIN_WIDTH", "isRunning", "", "()Z", "setRunning", "(Z)V", "compressVideo", "Lcom/abedelazizshe/lightcompressorlibrary/Result;", "source", "destination", "quality", "Lcom/abedelazizshe/lightcompressorlibrary/VideoQuality;", "isMinBitRateEnabled", "keepOriginalResolution", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "getBitrate", "bitrate", "getFrameRate", "format", "Landroid/media/MediaFormat;", "getIFrameIntervalRate", "printException", "", "exception", "Ljava/lang/Exception;", "processAudio", "extractor", "Landroid/media/MediaExtractor;", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "selectTrack", "isVideo", "setOutputFileParameters", "outputFormat", "colorFormat", "newBitrate", "frameRate", "iFrameInterval", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/Mp4Movie;", "rotation", "newWidth", "newHeight", "cacheFile", "Ljava/io/File;", "lightcompressor_release"})
public final class Compressor {
    private static final int MIN_BITRATE = 2000000;
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 360.0;
    private static final int FRAME_RATE = 30;
    private static final int I_FRAME_INTERVAL = 15;
    private static final String MIME_TYPE = "video/avc";
    private static final String INVALID_BITRATE = "The provided bitrate is smaller than what is needed for compressiontry to set isMinBitRateEnabled to false";
    private static boolean isRunning;
    public static final Compressor INSTANCE;

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Result compressVideo(@NotNull String source, @NotNull String destination, @NotNull VideoQuality quality, boolean isMinBitRateEnabled, boolean keepOriginalResolution, @NotNull CompressionProgressListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)quality, (String)"quality");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(source);
        v0 = mediaMetadataRetriever.extractMetadata(19);
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"mediaMetadataRetriever.e\u2026ETADATA_KEY_VIDEO_HEIGHT)");
        var9_8 = v0;
        var10_10 = false;
        height = Integer.parseInt(var9_8);
        v1 = mediaMetadataRetriever.extractMetadata(18);
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"mediaMetadataRetriever.e\u2026METADATA_KEY_VIDEO_WIDTH)");
        var10_11 = v1;
        var11_14 = false;
        width = Integer.parseInt(var10_11);
        v2 = mediaMetadataRetriever.extractMetadata(24);
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"mediaMetadataRetriever.e\u2026ADATA_KEY_VIDEO_ROTATION)");
        var11_15 = v2;
        var12_17 = false;
        rotation = Integer.parseInt(var11_15);
        v3 = mediaMetadataRetriever.extractMetadata(20);
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"mediaMetadataRetriever.e\u2026ver.METADATA_KEY_BITRATE)");
        var12_18 = v3;
        var13_20 = false;
        bitrate = Integer.parseInt(var12_18);
        v4 = mediaMetadataRetriever.extractMetadata(9);
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"mediaMetadataRetriever.e\u2026er.METADATA_KEY_DURATION)");
        var14_21 = v4;
        var15_23 = 0;
        duration = Long.parseLong(var14_21) * (long)1000;
        if (isMinBitRateEnabled && bitrate <= 2000000) {
            return new Result(false, "The provided bitrate is smaller than what is needed for compressiontry to set isMinBitRateEnabled to false");
        }
        newBitrate = this.getBitrate(bitrate, quality);
        var17_24 = this.generateWidthAndHeight(width, height, keepOriginalResolution);
        var15_23 = ((Number)var17_24.component1()).intValue();
        newHeight = ((Number)var17_24.component2()).intValue();
        switch (rotation) {
            case 90: 
            case 270: {
                tempHeight = newHeight;
                newHeight = newWidth;
                newWidth = tempHeight;
                v5 = 0;
                break;
            }
            case 180: {
                v5 = 0;
                break;
            }
            default: {
                v5 = rotation;
            }
        }
        rotation = v5;
        file = new File(source);
        if (!file.canRead()) {
            return new Result(false, "The source file cannot be accessed!");
        }
        noExceptions = true;
        if (newWidth == 0) return new Result(false, "Something went wrong, please try again");
        if (newHeight == 0) return new Result(false, "Something went wrong, please try again");
        cacheFile = new File(destination);
        try {
            bufferInfo = new MediaCodec.BufferInfo();
            movie = this.setUpMP4Movie(rotation, newWidth, newHeight, cacheFile);
            mediaMuxer = new MP4Builder().createMovie(movie);
            extractor = new MediaExtractor();
            extractor.setDataSource(file.toString());
            videoIndex = this.selectTrack(extractor, true);
            extractor.selectTrack(videoIndex);
            extractor.seekTo(0L, 0);
            v6 = extractor.getTrackFormat(videoIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"extractor.getTrackFormat(videoIndex)");
            inputFormat = v6;
            frameRate = this.getFrameRate(inputFormat);
            iFrameInterval = this.getIFrameIntervalRate(inputFormat);
            v7 = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"MediaFormat.createVideoF\u2026YPE, newWidth, newHeight)");
            outputFormat = v7;
            decoder = null;
            v8 = MediaCodec.createEncoderByType((String)"video/avc");
            Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"MediaCodec.createEncoderByType(MIME_TYPE)");
            encoder = v8;
            inputSurface = null;
            outputSurface = null;
            try {
                inputDone = false;
                outputDone = false;
                videoTrackIndex = -5;
                colorFormat = 2130708361;
                this.setOutputFileParameters(outputFormat, colorFormat, newBitrate, frameRate, iFrameInterval);
                encoder.configure(outputFormat, null, null, 1);
                inputSurface = new InputSurface(encoder.createInputSurface());
                inputSurface.makeCurrent();
                encoder.start();
                outputSurface = new OutputSurface();
                decoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
                decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                decoder.start();
                while (!outputDone) {
                    if (!inputDone) {
                        index = extractor.getSampleTrackIndex();
                        if (index == videoIndex) {
                            inputBufferIndex = decoder.dequeueInputBuffer(0L);
                            if (inputBufferIndex >= 0) {
                                v9 = inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                if (v9 == null) {
                                    Intrinsics.throwNpe();
                                }
                                chunkSize = extractor.readSampleData((ByteBuffer)v9, 0);
                                if (chunkSize < 0) {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                    inputDone = true;
                                } else {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                    extractor.advance();
                                }
                            }
                        } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(0L)) >= 0) {
                            decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                            inputDone = true;
                        }
                    }
                    decoderOutputAvailable = true;
                    encoderOutputAvailable = true;
lbl122:
                    // 6 sources

                    while (decoderOutputAvailable || encoderOutputAvailable) {
                        if (Compressor.isRunning) ** GOTO lbl-1000
                        listener.onProgressCancelled();
                        inputBuffer = new Result(false, "The compression has been stopped!");
                        ** GOTO lbl167
                    }
                }
                ** GOTO lbl283
            }
            catch (Exception exception) {
                try {
                    this.printException(exception);
                    noExceptions = false;
                }
                catch (Throwable exception) {
                    extractor.unselectTrack(videoIndex);
                    v10 = decoder;
                    if (v10 != null) {
                        v10.stop();
                        v11 = Unit.INSTANCE;
                    } else {
                        v11 = null;
                    }
                    v12 = decoder;
                    if (v12 != null) {
                        v12.release();
                        v13 = Unit.INSTANCE;
                    } else {
                        v13 = null;
                    }
                    encoder.stop();
                    encoder.release();
                    v14 = inputSurface;
                    if (v14 != null) {
                        v14.release();
                        v15 = Unit.INSTANCE;
                    } else {
                        v15 = null;
                    }
                    v16 = outputSurface;
                    if (v16 != null) {
                        v16.release();
                        v17 = Unit.INSTANCE;
                    } else {
                        v17 = null;
                    }
                    v18 = mediaMuxer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"mediaMuxer");
                    this.processAudio(extractor, v18, bufferInfo);
                    throw exception;
                }
lbl167:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                v19 = decoder;
                if (v19 != null) {
                    v19.stop();
                    v20 = Unit.INSTANCE;
                } else {
                    v20 = null;
                }
                v21 = decoder;
                if (v21 != null) {
                    v21.release();
                    v22 = Unit.INSTANCE;
                } else {
                    v22 = null;
                }
                encoder.stop();
                encoder.release();
                inputSurface.release();
                outputSurface.release();
                v23 = mediaMuxer;
                Intrinsics.checkExpressionValueIsNotNull((Object)v23, (String)"mediaMuxer");
                this.processAudio(extractor, v23, bufferInfo);
                return inputBuffer;
lbl-1000:
                // 1 sources

                {
                    block69: {
                        encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 0L);
                        if (encoderStatus == -1) {
                            encoderOutputAvailable = false;
                        } else if (encoderStatus == -2) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)encoder.getOutputFormat(), (String)"encoder.outputFormat");
                            if (videoTrackIndex == -5) {
                                videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                            }
                        } else if (encoderStatus != -3) {
                            if (encoderStatus < 0) {
                                throw (Throwable)new RuntimeException("unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                            }
                            if (encoder.getOutputBuffer(encoderStatus) == null) throw (Throwable)new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                            Intrinsics.checkExpressionValueIsNotNull((Object)encodedData, (String)"encoder.getOutputBuffer(\u2026$encoderStatus was null\")");
                            if (bufferInfo.size > 1) {
                                if ((bufferInfo.flags & 2) == 0) {
                                    mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                } else if (videoTrackIndex == -5) {
                                    csd = new byte[bufferInfo.size];
                                    var42_61 = encodedData;
                                    var43_64 = false;
                                    var44_66 = 0;
                                    $this$apply = var42_61;
                                    $i$a$-apply-Compressor$compressVideo$1 = false;
                                    $this$apply.limit(bufferInfo.offset + bufferInfo.size);
                                    $this$apply.position(bufferInfo.offset);
                                    $this$apply.get(csd);
                                    sps = null;
                                    pps = null;
                                    var44_66 = bufferInfo.size - 1;
                                    var45_67 = false;
                                    while (var44_66 >= 0 && a > 3) {
                                        if (csd[a] == 1 && csd[a - true] == 0 && csd[a - 2] == 0 && csd[a - 3] == 0) {
                                            sps = ByteBuffer.allocate((int)(a - 3));
                                            pps = ByteBuffer.allocate(bufferInfo.size - (a - 3));
                                            v24 = sps;
                                            if (v24 == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            v24.put(csd, 0, (int)(a - 3)).position(0);
                                            v25 = pps;
                                            if (v25 == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            v25.put(csd, (int)(a - 3), bufferInfo.size - (a - 3)).position(0);
                                            break;
                                        }
                                        --a;
                                    }
                                    newFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
                                    if (sps != null && pps != null) {
                                        newFormat.setByteBuffer("csd-0", sps);
                                        newFormat.setByteBuffer("csd-1", pps);
                                    }
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            }
                            outputDone = (bufferInfo.flags & 4) != 0;
                            encoder.releaseOutputBuffer(encoderStatus, false);
                        }
                        if (encoderStatus != -1) ** GOTO lbl122
                        decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 0L);
                        if (decoderStatus != -1) break block69;
                        decoderOutputAvailable = false;
                        ** GOTO lbl122
                    }
                    if (decoderStatus == -3 || decoderStatus == -2) ** GOTO lbl122
                    if (decoderStatus < 0) {
                        throw (Throwable)new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
                    }
                    doRender = bufferInfo.size != 0;
                    decoder.releaseOutputBuffer(decoderStatus, doRender);
                    if (doRender) {
                        try {
                            outputSurface.awaitNewImage();
                            outputSurface.drawImage();
                            inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                            listener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                            inputSurface.swapBuffers();
                        }
                        catch (Exception e) {
                            Log.e((String)"Compressor", (String)e.getMessage());
                        }
                    }
                    if ((bufferInfo.flags & 4) == 0) ** GOTO lbl122
                    decoderOutputAvailable = false;
                    encoder.signalEndOfInputStream();
                    ** GOTO lbl122
                }
lbl283:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                v26 = decoder;
                if (v26 != null) {
                    v26.stop();
                    v27 = Unit.INSTANCE;
                } else {
                    v27 = null;
                }
                v28 = decoder;
                if (v28 != null) {
                    v28.release();
                    v29 = Unit.INSTANCE;
                } else {
                    v29 = null;
                }
                encoder.stop();
                encoder.release();
                inputSurface.release();
                outputSurface.release();
                v30 = mediaMuxer;
                Intrinsics.checkExpressionValueIsNotNull((Object)v30, (String)"mediaMuxer");
                this.processAudio(extractor, v30, bufferInfo);
                extractor.unselectTrack(videoIndex);
                v31 = decoder;
                if (v31 != null) {
                    v31.stop();
                    v32 = Unit.INSTANCE;
                } else {
                    v32 = null;
                }
                v33 = decoder;
                if (v33 != null) {
                    v33.release();
                    v34 = Unit.INSTANCE;
                } else {
                    v34 = null;
                }
                encoder.stop();
                encoder.release();
                v35 = inputSurface;
                if (v35 != null) {
                    v35.release();
                    v36 = Unit.INSTANCE;
                } else {
                    v36 = null;
                }
                v37 = outputSurface;
                if (v37 != null) {
                    v37.release();
                    v38 = Unit.INSTANCE;
                }
                v38 = null;
            }
            extractor.release();
            try {
                mediaMuxer.finishMovie();
                return new Result(true, null);
            }
            catch (Exception e) {
                this.printException(e);
                return new Result(true, null);
            }
        }
        catch (Exception exception) {
            this.printException(exception);
        }
        return new Result(true, null);
    }

    private final void printException(Exception exception) {
        String message = "An error has occurred!";
        String string = exception.getMessage();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            message = it;
        }
        Log.e((String)"Compressor", (String)message);
    }

    private final int getBitrate(int bitrate, VideoQuality quality) {
        int n;
        switch (Compressor$WhenMappings.$EnumSwitchMapping$0[quality.ordinal()]) {
            case 1: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.1));
                break;
            }
            case 2: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.2));
                break;
            }
            case 3: {
                n = MathKt.roundToInt((double)((double)bitrate * 0.3));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final Pair<Integer, Integer> generateWidthAndHeight(double width, double height, boolean keepOriginalResolution) {
        if (keepOriginalResolution) {
            return new Pair((Object)MathKt.roundToInt((double)width), (Object)MathKt.roundToInt((double)height));
        }
        double newWidth = 0.0;
        double newHeight = 0.0;
        if (width >= (double)1920 || height >= (double)1920) {
            newWidth = width * 0.5;
            newHeight = height * 0.5;
        } else if (width >= (double)1280 || height >= (double)1280) {
            newWidth = width * 0.75;
            newHeight = height * 0.75;
        } else if (width >= (double)960 || height >= (double)960) {
            newWidth = 608.0;
            newHeight = 342.0;
        } else {
            newWidth = width * 0.9;
            newHeight = height * 0.9;
        }
        return new Pair((Object)(2 * MathKt.roundToInt((double)(newWidth / (double)2))), (Object)(2 * MathKt.roundToInt((double)(newHeight / (double)2))));
    }

    private final Mp4Movie setUpMP4Movie(int rotation, int newWidth, int newHeight, File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$apply = mp4Movie;
        boolean bl3 = false;
        $this$apply.setCacheFile(cacheFile);
        $this$apply.setRotation(rotation);
        $this$apply.setSize(newWidth, newHeight);
        return movie;
    }

    private final void setOutputFileParameters(MediaFormat outputFormat, int colorFormat, int newBitrate, int frameRate, int iFrameInterval) {
        MediaFormat mediaFormat = outputFormat;
        boolean bl = false;
        boolean bl2 = false;
        MediaFormat $this$apply = mediaFormat;
        boolean bl3 = false;
        $this$apply.setInteger("color-format", colorFormat);
        $this$apply.setInteger("bitrate", newBitrate);
        $this$apply.setInteger("frame-rate", frameRate);
        $this$apply.setInteger("i-frame-interval", iFrameInterval);
    }

    /*
     * WARNING - void declaration
     */
    private final int selectTrack(MediaExtractor extractor, boolean isVideo) {
        int numTracks = extractor.getTrackCount();
        int n = 0;
        int n2 = numTracks;
        while (n < n2) {
            MediaFormat format;
            void i;
            Intrinsics.checkExpressionValueIsNotNull((Object)extractor.getTrackFormat((int)i), (String)"extractor.getTrackFormat(i)");
            String mime = format.getString("mime");
            if (isVideo) {
                String string = mime;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mime");
                if (StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null)) {
                    return (int)i;
                }
            } else {
                String string = mime;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mime");
                if (StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null)) {
                    return (int)i;
                }
            }
            ++i;
        }
        return -5;
    }

    private final void processAudio(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        int audioIndex = this.selectTrack(extractor, false);
        if (audioIndex >= 0) {
            extractor.selectTrack(audioIndex);
            MediaFormat mediaFormat = extractor.getTrackFormat(audioIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)mediaFormat, (String)"extractor.getTrackFormat(audioIndex)");
            MediaFormat audioFormat = mediaFormat;
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size < 0) continue;
                    MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec.BufferInfo $this$apply = bufferInfo2;
                    boolean bl3 = false;
                    $this$apply.presentationTimeUs = extractor.getSampleTime();
                    $this$apply.offset = 0;
                    $this$apply.flags = extractor.getSampleFlags();
                    mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                    extractor.advance();
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private final int getFrameRate(MediaFormat format) {
        return format.containsKey("frame-rate") ? format.getInteger("frame-rate") : 30;
    }

    private final int getIFrameIntervalRate(MediaFormat format) {
        return format.containsKey("i-frame-interval") ? format.getInteger("i-frame-interval") : 15;
    }

    private Compressor() {
    }

    static {
        Compressor compressor;
        INSTANCE = compressor = new Compressor();
        isRunning = true;
    }
}

