/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.SampleImpl;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.authoring.tracks.CleanInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractH26XTrack
extends AbstractTrack {
    static int BUFFER = 67107840;
    private DataSource dataSource;
    protected long[] decodingTimes;
    protected List<CompositionTimeToSample.Entry> ctts = new ArrayList<CompositionTimeToSample.Entry>();
    protected List<SampleDependencyTypeBox.Entry> sdtp = new ArrayList<SampleDependencyTypeBox.Entry>();
    protected List<Integer> stss = new ArrayList<Integer>();
    TrackMetaData trackMetaData = new TrackMetaData();

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    public AbstractH26XTrack(DataSource dataSource) {
        super(dataSource.toString());
        this.dataSource = dataSource;
    }

    protected ByteBuffer findNextNal(LookAhead la) throws IOException {
        try {
            while (!la.nextThreeEquals001()) {
                la.discardByte();
            }
            la.discardNext3AndMarkStart();
            while (!la.nextThreeEquals000or001orEof()) {
                la.discardByte();
            }
            return la.getNal();
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    protected Sample createSampleObject(List<? extends ByteBuffer> nals) {
        byte[] sizeInfo = new byte[nals.size() * 4];
        ByteBuffer sizeBuf = ByteBuffer.wrap(sizeInfo);
        for (ByteBuffer byteBuffer : nals) {
            sizeBuf.putInt(byteBuffer.remaining());
        }
        ByteBuffer[] byteBufferArray = new ByteBuffer[nals.size() * 2];
        int i = 0;
        while (i < nals.size()) {
            byteBufferArray[2 * i] = ByteBuffer.wrap(sizeInfo, i * 4, 4);
            byteBufferArray[2 * i + 1] = nals.get(i);
            ++i;
        }
        return new SampleImpl(byteBufferArray);
    }

    @Override
    public long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public long[] getSyncSamples() {
        long[] returns = new long[this.stss.size()];
        int i = 0;
        while (i < this.stss.size()) {
            returns[i] = this.stss.get(i).intValue();
            ++i;
        }
        return returns;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sdtp;
    }

    static InputStream cleanBuffer(InputStream is) {
        return new CleanInputStream(is);
    }

    protected static byte[] toArray(ByteBuffer buf) {
        buf = buf.duplicate();
        byte[] b = new byte[buf.remaining()];
        buf.get(b, 0, b.length);
        return b;
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    public static class LookAhead {
        long bufferStartPos = 0L;
        int inBufferPos = 0;
        DataSource dataSource;
        ByteBuffer buffer;
        long start;

        public void fillBuffer() throws IOException {
            this.buffer = this.dataSource.map(this.bufferStartPos, Math.min(this.dataSource.size() - this.bufferStartPos, (long)BUFFER));
        }

        public LookAhead(DataSource dataSource) throws IOException {
            this.dataSource = dataSource;
            this.fillBuffer();
        }

        public boolean nextThreeEquals001() throws IOException {
            if (this.buffer.limit() - this.inBufferPos >= 3) {
                return this.buffer.get(this.inBufferPos) == 0 && this.buffer.get(this.inBufferPos + 1) == 0 && this.buffer.get(this.inBufferPos + 2) == 1;
            }
            if (this.bufferStartPos + (long)this.inBufferPos + 3L >= this.dataSource.size()) {
                throw new EOFException();
            }
            return false;
        }

        public boolean nextThreeEquals000or001orEof() throws IOException {
            if (this.buffer.limit() - this.inBufferPos >= 3) {
                return this.buffer.get(this.inBufferPos) == 0 && this.buffer.get(this.inBufferPos + 1) == 0 && (this.buffer.get(this.inBufferPos + 2) == 0 || this.buffer.get(this.inBufferPos + 2) == 1);
            }
            if (this.bufferStartPos + (long)this.inBufferPos + 3L > this.dataSource.size()) {
                return this.bufferStartPos + (long)this.inBufferPos == this.dataSource.size();
            }
            this.bufferStartPos = this.start;
            this.inBufferPos = 0;
            this.fillBuffer();
            return this.nextThreeEquals000or001orEof();
        }

        public void discardByte() {
            ++this.inBufferPos;
        }

        public void discardNext3AndMarkStart() {
            this.inBufferPos += 3;
            this.start = this.bufferStartPos + (long)this.inBufferPos;
        }

        public ByteBuffer getNal() {
            if (this.start >= this.bufferStartPos) {
                this.buffer.position((int)(this.start - this.bufferStartPos));
                ByteBuffer sample = this.buffer.slice();
                ((Buffer)sample).limit((int)((long)this.inBufferPos - (this.start - this.bufferStartPos)));
                return sample;
            }
            throw new RuntimeException("damn! NAL exceeds buffer");
        }
    }
}

