/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.util.Log;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.OutputSurface;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u000bH\u0002J \u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0002J(\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00060"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/Compressor;", "", "()V", "MIME_TYPE", "", "MIN_BITRATE", "", "MIN_HEIGHT", "", "MIN_WIDTH", "isRunning", "", "()Z", "setRunning", "(Z)V", "compressVideo", "source", "destination", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "getBitrate", "bitrate", "processAudio", "", "extractor", "Landroid/media/MediaExtractor;", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "selectTrack", "isVideo", "setOutputFileParameters", "outputFormat", "Landroid/media/MediaFormat;", "colorFormat", "newBitrate", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/Mp4Movie;", "rotation", "newWidth", "newHeight", "cacheFile", "Ljava/io/File;", "lightcompressor_release"})
public final class Compressor {
    private static final int MIN_BITRATE = 2000000;
    private static final double MIN_HEIGHT = 640.0;
    private static final double MIN_WIDTH = 360.0;
    private static final String MIME_TYPE = "video/avc";
    private static boolean isRunning;
    public static final Compressor INSTANCE;

    public final boolean isRunning() {
        return isRunning;
    }

    public final void setRunning(boolean bl) {
        isRunning = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean compressVideo(@NotNull String source, @NotNull String destination, @NotNull CompressionProgressListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(source);
        v0 = mediaMetadataRetriever.extractMetadata(19);
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"mediaMetadataRetriever.e\u2026ETADATA_KEY_VIDEO_HEIGHT)");
        var6_5 = v0;
        var7_7 = false;
        height = Integer.parseInt(var6_5);
        v1 = mediaMetadataRetriever.extractMetadata(18);
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"mediaMetadataRetriever.e\u2026METADATA_KEY_VIDEO_WIDTH)");
        var7_8 = v1;
        var8_11 = false;
        width = Integer.parseInt(var7_8);
        v2 = mediaMetadataRetriever.extractMetadata(24);
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"mediaMetadataRetriever.e\u2026ADATA_KEY_VIDEO_ROTATION)");
        var8_12 = v2;
        var9_14 = false;
        rotation = Integer.parseInt(var8_12);
        v3 = mediaMetadataRetriever.extractMetadata(20);
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"mediaMetadataRetriever.e\u2026ver.METADATA_KEY_BITRATE)");
        var9_15 = v3;
        var10_17 = false;
        bitrate = Integer.parseInt(var9_15);
        v4 = mediaMetadataRetriever.extractMetadata(9);
        Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"mediaMetadataRetriever.e\u2026er.METADATA_KEY_DURATION)");
        var11_18 = v4;
        var12_20 = 0;
        duration = Long.parseLong(var11_18) * (long)1000;
        if (bitrate <= 2000000) return false;
        if ((double)height <= 640.0) return false;
        if ((double)width <= 360.0) {
            return false;
        }
        newBitrate = this.getBitrate(bitrate);
        var14_21 = this.generateWidthAndHeight(width, height);
        var12_20 = ((Number)var14_21.component1()).intValue();
        newHeight = ((Number)var14_21.component2()).intValue();
        switch (rotation) {
            case 90: 
            case 270: {
                tempHeight = newHeight;
                newHeight = newWidth;
                newWidth = tempHeight;
                v5 = 0;
                break;
            }
            case 180: {
                v5 = 0;
                break;
            }
            default: {
                v5 = rotation;
            }
        }
        rotation = v5;
        file = new File(source);
        if (!file.canRead()) {
            return false;
        }
        noExceptions = true;
        if (newWidth == 0) return false;
        if (newHeight == 0) return false;
        cacheFile = new File(destination);
        try {
            bufferInfo = new MediaCodec.BufferInfo();
            movie = this.setUpMP4Movie(rotation, newWidth, newHeight, cacheFile);
            mediaMuxer = new MP4Builder().createMovie(movie);
            extractor = new MediaExtractor();
            extractor.setDataSource(file.toString());
            if (newWidth == width) {
                if (newHeight == height) return false;
            }
            videoIndex = this.selectTrack(extractor, true);
            extractor.selectTrack(videoIndex);
            extractor.seekTo(0L, 0);
            inputFormat = extractor.getTrackFormat(videoIndex);
            v6 = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"MediaFormat.createVideoF\u2026YPE, newWidth, newHeight)");
            outputFormat = v6;
            decoder = null;
            v7 = MediaCodec.createEncoderByType((String)"video/avc");
            Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"MediaCodec.createEncoderByType(MIME_TYPE)");
            encoder = v7;
            inputSurface = null;
            outputSurface = null;
            try {
                inputDone = false;
                outputDone = false;
                videoTrackIndex = -5;
                colorFormat = 2130708361;
                this.setOutputFileParameters(outputFormat, colorFormat, newBitrate);
                encoder.configure(outputFormat, null, null, 1);
                inputSurface = new InputSurface(encoder.createInputSurface());
                inputSurface.makeCurrent();
                encoder.start();
                outputSurface = new OutputSurface();
                decoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
                decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                decoder.start();
                while (!outputDone) {
                    if (!inputDone) {
                        index = extractor.getSampleTrackIndex();
                        if (index == videoIndex) {
                            inputBufferIndex = decoder.dequeueInputBuffer(0L);
                            if (inputBufferIndex >= 0) {
                                inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                chunkSize = extractor.readSampleData(inputBuffer, 0);
                                if (chunkSize < 0) {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                    inputDone = true;
                                } else {
                                    decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                    extractor.advance();
                                }
                            }
                        } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(0L)) >= 0) {
                            decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                            inputDone = true;
                        }
                    }
                    decoderOutputAvailable = true;
                    encoderOutputAvailable = true;
lbl119:
                    // 6 sources

                    while (decoderOutputAvailable || encoderOutputAvailable) {
                        if (Compressor.isRunning) ** GOTO lbl-1000
                        listener.onProgressCancelled();
                        inputBuffer = false;
                        ** GOTO lbl165
                    }
                }
                ** GOTO lbl280
            }
            catch (Exception exception) {
                try {
                    Log.e((String)"Compressor", (String)exception.getMessage());
                    noExceptions = false;
                }
                catch (Throwable var28_42) {
                    extractor.unselectTrack(videoIndex);
                    v8 = decoder;
                    if (v8 != null) {
                        v8.stop();
                        v9 = Unit.INSTANCE;
                    } else {
                        v9 = null;
                    }
                    v10 = decoder;
                    if (v10 != null) {
                        v10.release();
                        v11 = Unit.INSTANCE;
                    } else {
                        v11 = null;
                    }
                    encoder.stop();
                    encoder.release();
                    v12 = inputSurface;
                    if (v12 != null) {
                        v12.release();
                        v13 = Unit.INSTANCE;
                    } else {
                        v13 = null;
                    }
                    v14 = outputSurface;
                    if (v14 != null) {
                        v14.release();
                        v15 = Unit.INSTANCE;
                    } else {
                        v15 = null;
                    }
                    v16 = mediaMuxer;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"mediaMuxer");
                    this.processAudio(extractor, v16, bufferInfo);
                    throw var28_42;
                }
lbl165:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                v17 = decoder;
                if (v17 != null) {
                    v17.stop();
                    v18 = Unit.INSTANCE;
                } else {
                    v18 = null;
                }
                v19 = decoder;
                if (v19 != null) {
                    v19.release();
                    v20 = Unit.INSTANCE;
                } else {
                    v20 = null;
                }
                encoder.stop();
                encoder.release();
                inputSurface.release();
                outputSurface.release();
                v21 = mediaMuxer;
                Intrinsics.checkExpressionValueIsNotNull((Object)v21, (String)"mediaMuxer");
                this.processAudio(extractor, v21, bufferInfo);
                return inputBuffer;
lbl-1000:
                // 1 sources

                {
                    block69: {
                        encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 0L);
                        if (encoderStatus == -1) {
                            encoderOutputAvailable = false;
                        } else if (encoderStatus == -2) {
                            newFormat = encoder.getOutputFormat();
                            if (videoTrackIndex == -5) {
                                videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                            }
                        } else if (encoderStatus != -3) {
                            if (encoderStatus < 0) {
                                throw (Throwable)new RuntimeException("unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                            }
                            if (encoder.getOutputBuffer(encoderStatus) == null) throw (Throwable)new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                            if (bufferInfo.size > 1) {
                                if ((bufferInfo.flags & 2) == 0) {
                                    mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                } else if (videoTrackIndex == -5) {
                                    csd = new byte[bufferInfo.size];
                                    var37_57 = encodedData;
                                    var38_60 = false;
                                    var39_62 = 0;
                                    $this$apply = var37_57;
                                    $i$a$-apply-Compressor$compressVideo$1 = false;
                                    $this$apply.limit(bufferInfo.offset + bufferInfo.size);
                                    $this$apply.position(bufferInfo.offset);
                                    $this$apply.get(csd);
                                    sps = null;
                                    pps = null;
                                    var39_62 = bufferInfo.size - 1;
                                    var40_63 = false;
                                    while (var39_62 >= 0 && a > 3) {
                                        if (csd[a] == 1 && csd[a - true] == 0 && csd[a - 2] == 0 && csd[a - 3] == 0) {
                                            sps = ByteBuffer.allocate((int)(a - 3));
                                            pps = ByteBuffer.allocate(bufferInfo.size - (a - 3));
                                            v22 = sps;
                                            if (v22 == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            v22.put(csd, 0, (int)(a - 3)).position(0);
                                            v23 = pps;
                                            if (v23 == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            v23.put(csd, (int)(a - 3), bufferInfo.size - (a - 3)).position(0);
                                            break;
                                        }
                                        --a;
                                    }
                                    newFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)newWidth, (int)newHeight);
                                    if (sps != null && pps != null) {
                                        newFormat.setByteBuffer("csd-0", sps);
                                        newFormat.setByteBuffer("csd-1", pps);
                                    }
                                    videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                }
                            }
                            outputDone = (bufferInfo.flags & 4) != 0;
                            encoder.releaseOutputBuffer(encoderStatus, false);
                        }
                        if (encoderStatus != -1) ** GOTO lbl119
                        decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 0L);
                        if (decoderStatus != -1) break block69;
                        decoderOutputAvailable = false;
                        ** GOTO lbl119
                    }
                    if (decoderStatus == -3 || decoderStatus == -2) ** GOTO lbl119
                    if (decoderStatus < 0) {
                        throw (Throwable)new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
                    }
                    doRender = bufferInfo.size != 0;
                    decoder.releaseOutputBuffer(decoderStatus, doRender);
                    if (doRender) {
                        try {
                            outputSurface.awaitNewImage();
                            outputSurface.drawImage();
                            inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                            listener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                            inputSurface.swapBuffers();
                        }
                        catch (Exception e) {
                            Log.e((String)"Compressor", (String)e.getMessage());
                        }
                    }
                    if ((bufferInfo.flags & 4) == 0) ** GOTO lbl119
                    decoderOutputAvailable = false;
                    encoder.signalEndOfInputStream();
                    ** GOTO lbl119
                }
lbl280:
                // 1 sources

                extractor.unselectTrack(videoIndex);
                v24 = decoder;
                if (v24 != null) {
                    v24.stop();
                    v25 = Unit.INSTANCE;
                } else {
                    v25 = null;
                }
                v26 = decoder;
                if (v26 != null) {
                    v26.release();
                    v27 = Unit.INSTANCE;
                } else {
                    v27 = null;
                }
                encoder.stop();
                encoder.release();
                inputSurface.release();
                outputSurface.release();
                v28 = mediaMuxer;
                Intrinsics.checkExpressionValueIsNotNull((Object)v28, (String)"mediaMuxer");
                this.processAudio(extractor, v28, bufferInfo);
                extractor.unselectTrack(videoIndex);
                v29 = decoder;
                if (v29 != null) {
                    v29.stop();
                    v30 = Unit.INSTANCE;
                } else {
                    v30 = null;
                }
                v31 = decoder;
                if (v31 != null) {
                    v31.release();
                    v32 = Unit.INSTANCE;
                } else {
                    v32 = null;
                }
                encoder.stop();
                encoder.release();
                v33 = inputSurface;
                if (v33 != null) {
                    v33.release();
                    v34 = Unit.INSTANCE;
                } else {
                    v34 = null;
                }
                v35 = outputSurface;
                if (v35 != null) {
                    v35.release();
                    v36 = Unit.INSTANCE;
                }
                v36 = null;
            }
            extractor.release();
            try {
                mediaMuxer.finishMovie();
                return true;
            }
            catch (Exception e) {
                Log.e((String)"Compressor", (String)e.getMessage());
                return true;
            }
        }
        catch (Exception exception) {
            Log.e((String)"Compressor", (String)exception.getMessage());
        }
        return true;
    }

    private final int getBitrate(int bitrate) {
        return bitrate >= 15000000 ? 2000000 : (bitrate >= 8000000 ? 1500000 : (bitrate >= 4000000 ? 1000000 : 750000));
    }

    private final Pair<Integer, Integer> generateWidthAndHeight(double width, double height) {
        double newWidth = 0.0;
        double newHeight = 0.0;
        if (width >= (double)1920 || height >= (double)1920) {
            newWidth = width * 0.5;
            newHeight = height * 0.5;
        } else if (width >= (double)1280 || height >= (double)1280) {
            newWidth = width * 0.75;
            newHeight = height * 0.75;
        } else if (width >= (double)960 || height >= (double)960) {
            newWidth = 640.0;
            newHeight = 360.0;
        } else {
            newWidth = width;
            newHeight = height;
        }
        return new Pair((Object)(2 * MathKt.roundToInt((double)(newWidth / (double)2))), (Object)(2 * MathKt.roundToInt((double)(newHeight / (double)2))));
    }

    private final Mp4Movie setUpMP4Movie(int rotation, int newWidth, int newHeight, File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$apply = mp4Movie;
        boolean bl3 = false;
        $this$apply.setCacheFile(cacheFile);
        $this$apply.setRotation(rotation);
        $this$apply.setSize(newWidth, newHeight);
        return movie;
    }

    private final void setOutputFileParameters(MediaFormat outputFormat, int colorFormat, int newBitrate) {
        MediaFormat mediaFormat = outputFormat;
        boolean bl = false;
        boolean bl2 = false;
        MediaFormat $this$apply = mediaFormat;
        boolean bl3 = false;
        $this$apply.setInteger("color-format", colorFormat);
        $this$apply.setInteger("bitrate", newBitrate);
        $this$apply.setInteger("frame-rate", 30);
        $this$apply.setInteger("i-frame-interval", 15);
    }

    /*
     * WARNING - void declaration
     */
    private final int selectTrack(MediaExtractor extractor, boolean isVideo) {
        int numTracks = extractor.getTrackCount();
        int n = 0;
        int n2 = numTracks;
        while (n < n2) {
            void i;
            MediaFormat format = extractor.getTrackFormat((int)i);
            String mime = format.getString("mime");
            if (isVideo) {
                String string = mime;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mime");
                if (StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null)) {
                    return (int)i;
                }
            } else {
                String string = mime;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mime");
                if (StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null)) {
                    return (int)i;
                }
            }
            ++i;
        }
        return -5;
    }

    private final void processAudio(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        int audioIndex = this.selectTrack(extractor, false);
        if (audioIndex >= 0) {
            extractor.selectTrack(audioIndex);
            MediaFormat audioFormat = extractor.getTrackFormat(audioIndex);
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size < 0) continue;
                    MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec.BufferInfo $this$apply = bufferInfo2;
                    boolean bl3 = false;
                    $this$apply.presentationTimeUs = extractor.getSampleTime();
                    $this$apply.offset = 0;
                    $this$apply.flags = extractor.getSampleFlags();
                    mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                    extractor.advance();
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private Compressor() {
    }

    static {
        Compressor compressor;
        INSTANCE = compressor = new Compressor();
        isRunning = true;
    }
}

