/*
 * Decompiled with CFR 0.152.
 */
package com.abedelazizshe.lightcompressorlibrary;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.util.Log;
import com.abedelazizshe.lightcompressorlibrary.CompressionProgressListener;
import com.abedelazizshe.lightcompressorlibrary.InputSurface;
import com.abedelazizshe.lightcompressorlibrary.MP4Builder;
import com.abedelazizshe.lightcompressorlibrary.Mp4Movie;
import com.abedelazizshe.lightcompressorlibrary.OutputSurface;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\nH\u0002J \u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006H\u0002J(\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/abedelazizshe/lightcompressorlibrary/Compressor;", "", "()V", "MIME_TYPE", "", "MIN_BITRATE", "", "MIN_HEIGHT", "MIN_WIDTH", "compressVideo", "", "source", "destination", "listener", "Lcom/abedelazizshe/lightcompressorlibrary/CompressionProgressListener;", "generateWidthAndHeight", "Lkotlin/Pair;", "width", "height", "getBitrate", "bitrate", "processAudio", "", "extractor", "Landroid/media/MediaExtractor;", "mediaMuxer", "Lcom/abedelazizshe/lightcompressorlibrary/MP4Builder;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "selectTrack", "isVideo", "setOutputFileParameters", "outputFormat", "Landroid/media/MediaFormat;", "colorFormat", "newBitrate", "setUpMP4Movie", "Lcom/abedelazizshe/lightcompressorlibrary/Mp4Movie;", "rotation", "newWidth", "newHeight", "cacheFile", "Ljava/io/File;", "lightcompressor_release"})
public final class Compressor {
    private static final int MIN_BITRATE = 2000000;
    private static final int MIN_HEIGHT = 640;
    private static final int MIN_WIDTH = 360;
    private static final String MIME_TYPE = "video/avc";
    public static final Compressor INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean compressVideo(@NotNull String source, @NotNull String destination, @NotNull CompressionProgressListener listener) {
        block66: {
            int n;
            int newWidth;
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
            Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
            MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
            mediaMetadataRetriever.setDataSource(source);
            String string = mediaMetadataRetriever.extractMetadata(19);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mediaMetadataRetriever.e\u2026ETADATA_KEY_VIDEO_HEIGHT)");
            String string2 = string;
            boolean bl = false;
            int height = Integer.parseInt(string2);
            String string3 = mediaMetadataRetriever.extractMetadata(18);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mediaMetadataRetriever.e\u2026METADATA_KEY_VIDEO_WIDTH)");
            String string4 = string3;
            boolean bl2 = false;
            int width = Integer.parseInt(string4);
            String string5 = mediaMetadataRetriever.extractMetadata(24);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"mediaMetadataRetriever.e\u2026ADATA_KEY_VIDEO_ROTATION)");
            String string6 = string5;
            boolean bl3 = false;
            int rotation = Integer.parseInt(string6);
            String string7 = mediaMetadataRetriever.extractMetadata(20);
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"mediaMetadataRetriever.e\u2026ver.METADATA_KEY_BITRATE)");
            String string8 = string7;
            boolean bl4 = false;
            int bitrate = Integer.parseInt(string8);
            String string9 = mediaMetadataRetriever.extractMetadata(9);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"mediaMetadataRetriever.e\u2026er.METADATA_KEY_DURATION)");
            String string10 = string9;
            int n2 = 0;
            long duration = Long.parseLong(string10) * (long)1000;
            if (bitrate <= 2000000 || height <= 640 || width <= 360) {
                return false;
            }
            int newBitrate = this.getBitrate(bitrate);
            Pair<Integer, Integer> pair = this.generateWidthAndHeight(width, height);
            n2 = ((Number)pair.component1()).intValue();
            int newHeight = ((Number)pair.component2()).intValue();
            switch (rotation) {
                case 90: 
                case 270: {
                    int tempHeight = newHeight;
                    newHeight = newWidth;
                    newWidth = tempHeight;
                    n = 0;
                    break;
                }
                case 180: {
                    n = 0;
                    break;
                }
                default: {
                    n = rotation;
                }
            }
            rotation = n;
            File file = new File(source);
            if (!file.canRead()) {
                return false;
            }
            boolean noExceptions = true;
            if (newWidth == 0 || newHeight == 0) break block66;
            File cacheFile = new File(destination);
            try {
                MediaExtractor extractor;
                MP4Builder mediaMuxer;
                block65: {
                    block67: {
                        Unit unit;
                        Unit unit2;
                        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                        Mp4Movie movie = this.setUpMP4Movie(rotation, newWidth, newHeight, cacheFile);
                        mediaMuxer = new MP4Builder().createMovie(movie);
                        extractor = new MediaExtractor();
                        extractor.setDataSource(file.toString());
                        if (newWidth == width && newHeight == height) break block67;
                        int videoIndex = this.selectTrack(extractor, true);
                        extractor.selectTrack(videoIndex);
                        extractor.seekTo(0L, 0);
                        MediaFormat inputFormat = extractor.getTrackFormat(videoIndex);
                        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)newWidth, (int)newHeight);
                        Intrinsics.checkExpressionValueIsNotNull((Object)mediaFormat, (String)"MediaFormat.createVideoF\u2026YPE, newWidth, newHeight)");
                        MediaFormat outputFormat = mediaFormat;
                        MediaCodec decoder = null;
                        MediaCodec mediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
                        Intrinsics.checkExpressionValueIsNotNull((Object)mediaCodec, (String)"MediaCodec.createEncoderByType(MIME_TYPE)");
                        MediaCodec encoder = mediaCodec;
                        InputSurface inputSurface = null;
                        OutputSurface outputSurface = null;
                        try {
                            boolean inputDone = false;
                            boolean outputDone = false;
                            int videoTrackIndex = -5;
                            int colorFormat = 2130708361;
                            this.setOutputFileParameters(outputFormat, colorFormat, newBitrate);
                            encoder.configure(outputFormat, null, null, 1);
                            inputSurface = new InputSurface(encoder.createInputSurface());
                            inputSurface.makeCurrent();
                            encoder.start();
                            outputSurface = new OutputSurface();
                            decoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
                            decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                            decoder.start();
                            while (!outputDone) {
                                if (!inputDone) {
                                    int inputBufferIndex;
                                    int index = extractor.getSampleTrackIndex();
                                    if (index == videoIndex) {
                                        inputBufferIndex = decoder.dequeueInputBuffer(0L);
                                        if (inputBufferIndex >= 0) {
                                            ByteBuffer inputBuffer = decoder.getInputBuffer(inputBufferIndex);
                                            int chunkSize = extractor.readSampleData(inputBuffer, 0);
                                            if (chunkSize < 0) {
                                                decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                                inputDone = true;
                                            } else {
                                                decoder.queueInputBuffer(inputBufferIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                                extractor.advance();
                                            }
                                        }
                                    } else if (index == -1 && (inputBufferIndex = decoder.dequeueInputBuffer(0L)) >= 0) {
                                        decoder.queueInputBuffer(inputBufferIndex, 0, 0, 0L, 4);
                                        inputDone = true;
                                    }
                                }
                                boolean decoderOutputAvailable = true;
                                boolean encoderOutputAvailable = true;
                                while (decoderOutputAvailable || encoderOutputAvailable) {
                                    int encoderStatus = encoder.dequeueOutputBuffer(bufferInfo, 0L);
                                    if (encoderStatus == -1) {
                                        encoderOutputAvailable = false;
                                    } else if (encoderStatus == -2) {
                                        MediaFormat newFormat = encoder.getOutputFormat();
                                        if (videoTrackIndex == -5) {
                                            videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                        }
                                    } else if (encoderStatus != -3) {
                                        if (encoderStatus < 0) {
                                            throw (Throwable)new RuntimeException("unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                                        }
                                        if (encoder.getOutputBuffer(encoderStatus) == null) {
                                            throw (Throwable)new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                                        }
                                        if (bufferInfo.size > 1) {
                                            ByteBuffer encodedData;
                                            if ((bufferInfo.flags & 2) == 0) {
                                                mediaMuxer.writeSampleData(videoTrackIndex, encodedData, bufferInfo, false);
                                            } else if (videoTrackIndex == -5) {
                                                void a;
                                                byte[] csd = new byte[bufferInfo.size];
                                                ByteBuffer byteBuffer = encodedData;
                                                boolean bl5 = false;
                                                int n3 = 0;
                                                ByteBuffer $this$apply = byteBuffer;
                                                boolean bl6 = false;
                                                $this$apply.limit(bufferInfo.offset + bufferInfo.size);
                                                $this$apply.position(bufferInfo.offset);
                                                $this$apply.get(csd);
                                                ByteBuffer sps = null;
                                                ByteBuffer pps = null;
                                                n3 = bufferInfo.size - 1;
                                                boolean bl7 = false;
                                                while (n3 >= 0 && a > 3) {
                                                    if (csd[a] == 1 && csd[a - true] == 0 && csd[a - 2] == 0 && csd[a - 3] == 0) {
                                                        sps = ByteBuffer.allocate((int)(a - 3));
                                                        pps = ByteBuffer.allocate(bufferInfo.size - (a - 3));
                                                        ByteBuffer byteBuffer2 = sps;
                                                        if (byteBuffer2 == null) {
                                                            Intrinsics.throwNpe();
                                                        }
                                                        byteBuffer2.put(csd, 0, (int)(a - 3)).position(0);
                                                        ByteBuffer byteBuffer3 = pps;
                                                        if (byteBuffer3 == null) {
                                                            Intrinsics.throwNpe();
                                                        }
                                                        byteBuffer3.put(csd, (int)(a - 3), bufferInfo.size - (a - 3)).position(0);
                                                        break;
                                                    }
                                                    --a;
                                                }
                                                MediaFormat newFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)newWidth, (int)newHeight);
                                                if (sps != null && pps != null) {
                                                    newFormat.setByteBuffer("csd-0", sps);
                                                    newFormat.setByteBuffer("csd-1", pps);
                                                }
                                                videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                            }
                                        }
                                        outputDone = (bufferInfo.flags & 4) != 0;
                                        encoder.releaseOutputBuffer(encoderStatus, false);
                                    }
                                    if (encoderStatus != -1) continue;
                                    int decoderStatus = decoder.dequeueOutputBuffer(bufferInfo, 0L);
                                    if (decoderStatus == -1) {
                                        decoderOutputAvailable = false;
                                        continue;
                                    }
                                    if (decoderStatus == -3 || decoderStatus == -2) continue;
                                    if (decoderStatus < 0) {
                                        throw (Throwable)new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
                                    }
                                    boolean doRender = bufferInfo.size != 0;
                                    decoder.releaseOutputBuffer(decoderStatus, doRender);
                                    if (doRender) {
                                        try {
                                            outputSurface.awaitNewImage();
                                            outputSurface.drawImage();
                                            inputSurface.setPresentationTime(bufferInfo.presentationTimeUs * (long)1000);
                                            listener.onProgressChanged((float)bufferInfo.presentationTimeUs / (float)duration * (float)100);
                                            inputSurface.swapBuffers();
                                        }
                                        catch (Exception e) {
                                            Log.e((String)"Compressor", (String)e.getMessage());
                                        }
                                    }
                                    if ((bufferInfo.flags & 4) == 0) continue;
                                    decoderOutputAvailable = false;
                                    encoder.signalEndOfInputStream();
                                }
                            }
                        }
                        catch (Exception exception) {
                            Unit unit3;
                            Unit unit4;
                            Unit unit5;
                            Unit unit6;
                            try {
                                Log.e((String)"Compressor", (String)exception.getMessage());
                                noExceptions = false;
                            }
                            catch (Throwable throwable) {
                                Unit unit7;
                                Unit unit8;
                                Unit unit9;
                                Unit unit10;
                                extractor.unselectTrack(videoIndex);
                                MediaCodec mediaCodec2 = decoder;
                                if (mediaCodec2 != null) {
                                    mediaCodec2.stop();
                                    unit10 = Unit.INSTANCE;
                                } else {
                                    unit10 = null;
                                }
                                MediaCodec mediaCodec3 = decoder;
                                if (mediaCodec3 != null) {
                                    mediaCodec3.release();
                                    unit9 = Unit.INSTANCE;
                                } else {
                                    unit9 = null;
                                }
                                encoder.stop();
                                encoder.release();
                                InputSurface inputSurface2 = inputSurface;
                                if (inputSurface2 != null) {
                                    inputSurface2.release();
                                    unit8 = Unit.INSTANCE;
                                } else {
                                    unit8 = null;
                                }
                                OutputSurface outputSurface2 = outputSurface;
                                if (outputSurface2 != null) {
                                    outputSurface2.release();
                                    unit7 = Unit.INSTANCE;
                                } else {
                                    unit7 = null;
                                }
                                MP4Builder mP4Builder = mediaMuxer;
                                Intrinsics.checkExpressionValueIsNotNull((Object)mP4Builder, (String)"mediaMuxer");
                                this.processAudio(extractor, mP4Builder, bufferInfo);
                                throw throwable;
                            }
                            extractor.unselectTrack(videoIndex);
                            MediaCodec mediaCodec4 = decoder;
                            if (mediaCodec4 != null) {
                                mediaCodec4.stop();
                                unit6 = Unit.INSTANCE;
                            } else {
                                unit6 = null;
                            }
                            MediaCodec mediaCodec5 = decoder;
                            if (mediaCodec5 != null) {
                                mediaCodec5.release();
                                unit5 = Unit.INSTANCE;
                            } else {
                                unit5 = null;
                            }
                            encoder.stop();
                            encoder.release();
                            InputSurface inputSurface3 = inputSurface;
                            if (inputSurface3 != null) {
                                inputSurface3.release();
                                unit4 = Unit.INSTANCE;
                            } else {
                                unit4 = null;
                            }
                            OutputSurface outputSurface3 = outputSurface;
                            if (outputSurface3 != null) {
                                outputSurface3.release();
                                unit3 = Unit.INSTANCE;
                            } else {
                                unit3 = null;
                            }
                            break block65;
                        }
                        extractor.unselectTrack(videoIndex);
                        MediaCodec mediaCodec6 = decoder;
                        if (mediaCodec6 != null) {
                            mediaCodec6.stop();
                            unit2 = Unit.INSTANCE;
                        } else {
                            unit2 = null;
                        }
                        MediaCodec mediaCodec7 = decoder;
                        if (mediaCodec7 != null) {
                            mediaCodec7.release();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        encoder.stop();
                        encoder.release();
                        inputSurface.release();
                        outputSurface.release();
                        MP4Builder mP4Builder = mediaMuxer;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mP4Builder, (String)"mediaMuxer");
                        this.processAudio(extractor, mP4Builder, bufferInfo);
                        break block65;
                    }
                    return false;
                }
                extractor.release();
                try {
                    mediaMuxer.finishMovie();
                }
                catch (Exception e) {
                    Log.e((String)"Compressor", (String)e.getMessage());
                }
            }
            catch (Exception exception) {
                Log.e((String)"Compressor", (String)exception.getMessage());
            }
            return true;
        }
        return false;
    }

    private final int getBitrate(int bitrate) {
        return bitrate >= 15000000 ? 2000000 : (bitrate >= 8000000 ? 1500000 : (bitrate >= 4000000 ? 1000000 : 750000));
    }

    private final Pair<Integer, Integer> generateWidthAndHeight(int width, int height) {
        int newWidth = 0;
        int newHeight = 0;
        if (width >= 1920 || height >= 1920) {
            newWidth = (int)((double)width * 0.5);
            newHeight = (int)((double)height * 0.5);
        } else if (width >= 1280 || height >= 1280) {
            newWidth = (int)((double)width * 0.75);
            newHeight = (int)((double)height * 0.75);
        } else if (width >= 960 || height >= 960) {
            newWidth = 640;
            newHeight = 360;
        } else {
            newWidth = width;
            newHeight = height;
        }
        return new Pair((Object)newWidth, (Object)newHeight);
    }

    private final Mp4Movie setUpMP4Movie(int rotation, int newWidth, int newHeight, File cacheFile) {
        Mp4Movie movie;
        Mp4Movie mp4Movie = movie = new Mp4Movie();
        boolean bl = false;
        boolean bl2 = false;
        Mp4Movie $this$apply = mp4Movie;
        boolean bl3 = false;
        $this$apply.setCacheFile(cacheFile);
        $this$apply.setRotation(rotation);
        $this$apply.setSize(newWidth, newHeight);
        return movie;
    }

    private final void setOutputFileParameters(MediaFormat outputFormat, int colorFormat, int newBitrate) {
        MediaFormat mediaFormat = outputFormat;
        boolean bl = false;
        boolean bl2 = false;
        MediaFormat $this$apply = mediaFormat;
        boolean bl3 = false;
        $this$apply.setInteger("color-format", colorFormat);
        $this$apply.setInteger("bitrate", newBitrate);
        $this$apply.setInteger("frame-rate", 30);
        $this$apply.setInteger("i-frame-interval", 15);
    }

    /*
     * WARNING - void declaration
     */
    private final int selectTrack(MediaExtractor extractor, boolean isVideo) {
        int numTracks = extractor.getTrackCount();
        int n = 0;
        int n2 = numTracks;
        while (n < n2) {
            void i;
            MediaFormat format = extractor.getTrackFormat((int)i);
            String mime = format.getString("mime");
            if (isVideo) {
                String string = mime;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mime");
                if (StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null)) {
                    return (int)i;
                }
            } else {
                String string = mime;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mime");
                if (StringsKt.startsWith$default((String)string, (String)"audio/", (boolean)false, (int)2, null)) {
                    return (int)i;
                }
            }
            ++i;
        }
        return -5;
    }

    private final void processAudio(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo bufferInfo) {
        int audioIndex = this.selectTrack(extractor, false);
        if (audioIndex >= 0) {
            extractor.selectTrack(audioIndex);
            MediaFormat audioFormat = extractor.getTrackFormat(audioIndex);
            int muxerTrackIndex = mediaMuxer.addTrack(audioFormat, true);
            int maxBufferSize = audioFormat.getInteger("max-input-size");
            boolean inputDone = false;
            extractor.seekTo(0L, 0);
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            while (!inputDone) {
                int index = extractor.getSampleTrackIndex();
                if (index == audioIndex) {
                    bufferInfo.size = extractor.readSampleData(buffer, 0);
                    if (bufferInfo.size < 0) continue;
                    MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec.BufferInfo $this$apply = bufferInfo2;
                    boolean bl3 = false;
                    $this$apply.presentationTimeUs = extractor.getSampleTime();
                    $this$apply.offset = 0;
                    $this$apply.flags = extractor.getSampleFlags();
                    mediaMuxer.writeSampleData(muxerTrackIndex, buffer, bufferInfo, true);
                    extractor.advance();
                    continue;
                }
                if (index != -1) continue;
                inputDone = true;
            }
            extractor.unselectTrack(audioIndex);
        }
    }

    private Compressor() {
    }

    static {
        Compressor compressor;
        INSTANCE = compressor = new Compressor();
    }
}

