/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.JSON;
import apijson.JSONResponse;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONCreator;
import apijson.framework.AssertUtil;
import apijson.framework.BaseModel;
import apijson.orm.AbstractFunctionParser;
import apijson.orm.JSONRequest;
import apijson.orm.script.JavaScriptExecutor;
import apijson.orm.script.ScriptExecutor;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.rmi.ServerException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import unitauto.MethodUtil;

public class APIJSONFunctionParser
extends AbstractFunctionParser {
    public static final String TAG = "APIJSONFunctionParser";
    @NotNull
    public static APIJSONCreator<? extends Object> APIJSON_CREATOR = new APIJSONCreator();
    @NotNull
    public static final String[] ALL_METHODS = new String[]{RequestMethod.GET.name(), RequestMethod.HEAD.name(), RequestMethod.GETS.name(), RequestMethod.HEADS.name(), RequestMethod.POST.name(), RequestMethod.PUT.name(), RequestMethod.DELETE.name()};
    private HttpSession session;

    public APIJSONFunctionParser() {
        this(null);
    }

    public APIJSONFunctionParser(HttpSession session) {
        this(null, null, 0, null, session);
    }

    public APIJSONFunctionParser(RequestMethod method, String tag, int version, JSONObject curObj, HttpSession session) {
        super(method, tag, version, curObj);
        this.setSession(session);
    }

    public HttpSession getSession() {
        return this.session;
    }

    public APIJSONFunctionParser setSession(HttpSession session) {
        this.session = session;
        return this;
    }

    public APIJSONFunctionParser setMethod(RequestMethod method) {
        super.setMethod(method);
        return this;
    }

    public APIJSONFunctionParser setTag(String tag) {
        super.setTag(tag);
        return this;
    }

    public APIJSONFunctionParser setVersion(int version) {
        super.setVersion(version);
        return this;
    }

    public static JSONObject init() throws ServerException {
        return APIJSONFunctionParser.init(false);
    }

    public static JSONObject init(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONFunctionParser.init(shutdownWhenServerError, null);
    }

    public static <T> JSONObject init(APIJSONCreator<T> creator) throws ServerException {
        return APIJSONFunctionParser.init(false, creator);
    }

    public static <T> JSONObject init(boolean shutdownWhenServerError, APIJSONCreator<T> creator) throws ServerException {
        return APIJSONFunctionParser.init(shutdownWhenServerError, creator, null);
    }

    public static <T> JSONObject init(boolean shutdownWhenServerError, APIJSONCreator<T> creator, JSONObject table) throws ServerException {
        JSONArray list;
        int size;
        JSONObject function;
        if (creator == null) {
            creator = APIJSON_CREATOR;
        }
        APIJSON_CREATOR = creator;
        boolean isAll = table == null || table.isEmpty();
        JSONObject request = new JSONObject();
        JSONRequest item = new JSONRequest();
        Object object = function = isAll ? new JSONRequest() : table;
        if (!Log.DEBUG) {
            function.put(APIJSONConstant.KEY_DEBUG, (Object)0);
        }
        item.put(APIJSONConstant.FUNCTION_, (Object)function);
        if (ENABLE_SCRIPT_FUNCTION) {
            JSONRequest script = new JSONRequest();
            script.put("name@", (Object)"/Function/name");
            script.put("simple", (Object)0);
            item.put(APIJSONConstant.SCRIPT_, (Object)script);
        }
        request.putAll((Map)item.toArray(0, 0));
        JSONObject response = creator.createParser().setMethod(RequestMethod.GET).setNeedVerify(true).parseResponse(request);
        if (!JSONResponse.isSuccess((JSONObject)response)) {
            APIJSONFunctionParser.onServerError("\n\n\n\n\n !!!! \u67e5\u8be2\u8fdc\u7a0b\u51fd\u6570\u5f02\u5e38 !!!\n" + response.getString(JSONResponse.KEY_MSG) + "\n\n\n\n\n", shutdownWhenServerError);
        }
        if (isAll || SCRIPT_EXECUTOR_MAP.get("js") == null) {
            JavaScriptExecutor javaScriptExecutor = new JavaScriptExecutor();
            javaScriptExecutor.init();
            SCRIPT_EXECUTOR_MAP.put("js", javaScriptExecutor);
            SCRIPT_EXECUTOR_MAP.put("JavaScript", javaScriptExecutor);
            SCRIPT_EXECUTOR_MAP.put("javascript", javaScriptExecutor);
        }
        HashMap scriptMap = new HashMap();
        JSONArray scriptList = response.getJSONArray("[]");
        if (scriptList != null && !scriptList.isEmpty()) {
            LinkedHashMap<String, JSONObject> newMap = new LinkedHashMap<String, JSONObject>();
            for (int i = 0; i < scriptList.size(); ++i) {
                String s;
                JSONObject item2 = scriptList.getJSONObject(i);
                JSONObject jSONObject = item2 = item2 == null ? null : item2.getJSONObject(APIJSONConstant.SCRIPT_);
                if (item2 == null) continue;
                String n = item2.getString("name");
                if (!StringUtil.isName((String)n)) {
                    APIJSONFunctionParser.onServerError("Script \u8868\u5b57\u6bb5 name \u7684\u503c " + n + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a\u5408\u6cd5\u7684\u65b9\u6cd5\u540d\u5b57\u7b26\u4e32\uff01", shutdownWhenServerError);
                }
                if (StringUtil.isEmpty((String)(s = item2.getString("script")), (boolean)true)) {
                    APIJSONFunctionParser.onServerError("Script \u8868\u5b57\u6bb5 script \u7684\u503c " + s + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
                }
                newMap.put(n, item2);
            }
            scriptMap = newMap;
        }
        int n = size = (list = scriptList) == null ? 0 : list.size();
        if (isAll && size <= 0) {
            Log.w((String)TAG, (String)"init isAll && size <= 0\uff0c\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u8fdc\u7a0b\u51fd\u6570");
            return response;
        }
        if (isAll) {
            FUNCTION_MAP = new LinkedHashMap();
        }
        Map newMap = FUNCTION_MAP;
        for (int i = 0; i < size; ++i) {
            JSONObject item3 = list.getJSONObject(i);
            JSONObject jSONObject = item3 = item3 == null ? null : item3.getJSONObject(APIJSONConstant.FUNCTION_);
            if (item3 == null) continue;
            JSONObject demo = JSON.parseObject((String)item3.getString("demo"));
            if (demo == null) {
                APIJSONFunctionParser.onServerError("\u5b57\u6bb5 demo \u7684\u503c\u5fc5\u987b\u4e3a\u5408\u6cd5\u4e14\u975e null \u7684 JSONObejct \u5b57\u7b26\u4e32\uff01", shutdownWhenServerError);
            }
            String name = item3.getString("name");
            if (!demo.containsKey((Object)"result()")) {
                demo.put("result()", (Object)APIJSONFunctionParser.getFunctionCall(name, item3.getString("arguments")));
            }
            if (item3.get((Object)"language") != null) {
                String language = item3.getString("language");
                if (SCRIPT_EXECUTOR_MAP.get(language) == null) {
                    APIJSONFunctionParser.onServerError("\u627e\u4e0d\u5230\u811a\u672c\u8bed\u8a00 " + language + " \u5bf9\u5e94\u7684\u6267\u884c\u5f15\u64ce\uff01\u8bf7\u5148\u4f9d\u8d56\u76f8\u5173\u5e93\u5e76\u5728\u540e\u7aef APIJSONFunctionParser \u4e2d\u6ce8\u518c\uff01", shutdownWhenServerError);
                }
                ScriptExecutor scriptExecutor = (ScriptExecutor)SCRIPT_EXECUTOR_MAP.get(language);
                scriptExecutor.load(name, ((JSONObject)scriptMap.get(name)).getString("script"));
            }
            newMap.put(name, item3);
            String[] methods = StringUtil.split((String)item3.getString("methods"));
            if (methods == null || methods.length <= 0) {
                methods = ALL_METHODS;
            }
            demo.put("tag", item3.get((Object)"tag"));
            demo.put("version", item3.get((Object)"version"));
            for (String method : methods) {
                JSONObject r = APIJSON_CREATOR.createParser().setMethod(RequestMethod.valueOf((String)method)).setNeedVerify(false).parseResponse(demo);
                if (JSONResponse.isSuccess((JSONObject)r)) continue;
                APIJSONFunctionParser.onServerError(JSONResponse.getMsg((JSONObject)r), shutdownWhenServerError);
            }
        }
        return response;
    }

    protected static void onServerError(String msg, boolean shutdown) throws ServerException {
        Log.e((String)TAG, (String)("\n\u8fdc\u7a0b\u51fd\u6570\u6587\u6863\u6d4b\u8bd5\u672a\u901a\u8fc7\uff01\n\u8bf7\u65b0\u589e demo \u91cc\u7684\u51fd\u6570\uff0c\u6216\u4fee\u6539 Function \u8868\u91cc\u7684 demo \u4e3a\u5df2\u6709\u7684\u51fd\u6570\u793a\u4f8b\uff01\n\u4fdd\u8bc1\u524d\u7aef\u770b\u5230\u7684\u8fdc\u7a0b\u51fd\u6570\u6587\u6863\u662f\u6b63\u786e\u7684\uff01\uff01\uff01\n\n\u539f\u56e0\uff1a\n" + msg));
        if (!shutdown) {
            throw new ServerException(msg);
        }
        System.exit(1);
    }

    public static void test() throws Exception {
        APIJSONFunctionParser.test(null);
    }

    public static void test(APIJSONFunctionParser function) throws Exception {
        int i0 = 1;
        int i1 = -2;
        JSONObject request = new JSONObject();
        request.put("id", (Object)10);
        request.put("i0", (Object)i0);
        request.put("i1", (Object)i1);
        JSONArray arr = new JSONArray();
        arr.add((Object)new JSONObject());
        request.put("arr", (Object)arr);
        JSONArray array = new JSONArray();
        array.add((Object)1);
        array.add((Object)2);
        array.add((Object)4);
        array.add((Object)10);
        request.put("array", (Object)array);
        request.put("position", (Object)1);
        request.put("@position", (Object)0);
        request.put("key", (Object)"key");
        JSONObject object = new JSONObject();
        object.put("key", (Object)"success");
        request.put("object", (Object)object);
        if (function == null) {
            function = new APIJSONFunctionParser(null, null, 1, null, null);
        }
        Log.i((String)TAG, (String)("count([1,2,4,10]) = " + function.invoke("countArray(array)", request)));
        AssertUtil.assertEqual(4, function.invoke("countArray(array)", request));
        Log.i((String)TAG, (String)("isContain([1,2,4,10], 10) = " + function.invoke("isContain(array,id)", request)));
        AssertUtil.assertEqual(true, function.invoke("isContain(array,id)", request));
        Log.i((String)TAG, (String)("getFromArray([1,2,4,10], 0) = " + function.invoke("getFromArray(array,@position)", request)));
        AssertUtil.assertEqual(1, function.invoke("getFromArray(array,@position)", request));
        Log.i((String)TAG, (String)("getFromObject({key:\"success\"}, key) = " + function.invoke("getFromObject(object,key)", request)));
        AssertUtil.assertEqual("success", function.invoke("getFromObject(object,key)", request));
    }

    public JSONObject getFunctionDemo(@NotNull JSONObject curObj) {
        JSONObject demo = JSON.parseObject((String)curObj.getString("demo"));
        if (demo == null) {
            demo = new JSONObject();
        }
        if (!demo.containsKey((Object)"result()")) {
            demo.put("result()", (Object)APIJSONFunctionParser.getFunctionCall(curObj.getString("name"), curObj.getString("arguments")));
        }
        return demo;
    }

    public String getFunctionDetail(@NotNull JSONObject curObj) {
        return APIJSONFunctionParser.getFunctionCall(curObj.getString("name"), curObj.getString("arguments")) + ": " + StringUtil.getTrimedString((String)curObj.getString("detail"));
    }

    private static String getFunctionCall(String name, String arguments) {
        return name + "(" + StringUtil.getTrimedString((String)arguments) + ")";
    }

    public double plus(@NotNull JSONObject curObj, String i0, String i1) {
        return curObj.getDoubleValue(i0) + curObj.getDoubleValue(i1);
    }

    public double minus(@NotNull JSONObject curObj, String i0, String i1) {
        return curObj.getDoubleValue(i0) - curObj.getDoubleValue(i1);
    }

    public double multiply(@NotNull JSONObject curObj, String i0, String i1) {
        return curObj.getDoubleValue(i0) * curObj.getDoubleValue(i1);
    }

    public double divide(@NotNull JSONObject curObj, String i0, String i1) {
        return curObj.getDoubleValue(i0) / curObj.getDoubleValue(i1);
    }

    public double plus(@NotNull JSONObject curObj, Number n0, Number n1) {
        return n0.doubleValue() + n1.doubleValue();
    }

    public double minus(@NotNull JSONObject curObj, Number n0, Number n1) {
        return n0.doubleValue() - n1.doubleValue();
    }

    public double multiply(@NotNull JSONObject curObj, Number n0, Number n1) {
        return n0.doubleValue() * n1.doubleValue();
    }

    public double divide(@NotNull JSONObject curObj, Number n0, Number n1) {
        return n0.doubleValue() / n1.doubleValue();
    }

    public boolean isArrayEmpty(@NotNull JSONObject curObj, String array) {
        return BaseModel.isEmpty(curObj.getJSONArray(array));
    }

    public boolean isObjectEmpty(@NotNull JSONObject curObj, String object) {
        return BaseModel.isEmpty(curObj.getJSONObject(object));
    }

    public boolean isContain(@NotNull JSONObject curObj, String array, String value) {
        List list = com.alibaba.fastjson.JSON.parseArray((String)curObj.getString(array), String.class);
        return list != null && list.contains(curObj.getString(value));
    }

    public boolean isContainKey(@NotNull JSONObject curObj, String object, String key) {
        return BaseModel.isContainKey(curObj.getJSONObject(object), curObj.getString(key));
    }

    public boolean isContainValue(@NotNull JSONObject curObj, String object, String value) {
        return BaseModel.isContainValue(curObj.getJSONObject(object), curObj.get((Object)value));
    }

    public int countArray(@NotNull JSONObject curObj, String array) {
        return BaseModel.count(curObj.getJSONArray(array));
    }

    public int countObject(@NotNull JSONObject curObj, String object) {
        return BaseModel.count(curObj.getJSONObject(object));
    }

    public Object getFromArray(@NotNull JSONObject curObj, String array, String position) {
        int p;
        try {
            p = Integer.parseInt(position);
        }
        catch (Exception e) {
            p = curObj.getIntValue(position);
        }
        return BaseModel.get(curObj.getJSONArray(array), p);
    }

    public Object getFromObject(@NotNull JSONObject curObj, String object, String key) {
        return BaseModel.get(curObj.getJSONObject(object), curObj.getString(key));
    }

    public Object removeIndex(@NotNull JSONObject curObj, String position) {
        int p;
        try {
            p = Integer.parseInt(position);
        }
        catch (Exception e) {
            p = curObj.getIntValue(position);
        }
        curObj.remove((Object)p);
        return null;
    }

    public Object removeKey(@NotNull JSONObject curObj, String key) {
        curObj.remove((Object)key);
        return null;
    }

    public boolean booleanValue(@NotNull JSONObject curObj, String value) {
        return curObj.getBooleanValue(value);
    }

    public int intValue(@NotNull JSONObject curObj, String value) {
        return curObj.getIntValue(value);
    }

    public long longValue(@NotNull JSONObject curObj, String value) {
        return curObj.getLongValue(value);
    }

    public float floatValue(@NotNull JSONObject curObj, String value) {
        return curObj.getFloatValue(value);
    }

    public double doubleValue(@NotNull JSONObject curObj, String value) {
        return curObj.getDoubleValue(value);
    }

    public Object getWithDefault(@NotNull JSONObject curObj, String value, String defaultValue) {
        Object v = curObj.get((Object)value);
        return v == null ? curObj.get((Object)defaultValue) : v;
    }

    public String getMethodArguments(@NotNull JSONObject curObj) throws IllegalArgumentException, ClassNotFoundException, IOException {
        return this.getMethodArguments(curObj, "methodArgs");
    }

    public String getMethodArguments(@NotNull JSONObject curObj, String methodArgsKey) throws IllegalArgumentException, ClassNotFoundException, IOException {
        List methodArgs;
        String argsStr;
        JSONObject obj = curObj.getJSONObject("request");
        String string = argsStr = obj == null ? null : obj.getString(methodArgsKey);
        if (StringUtil.isEmpty((String)argsStr, (boolean)true)) {
            argsStr = curObj.getString(methodArgsKey);
        }
        if ((methodArgs = JSON.parseArray((String)APIJSONFunctionParser.removeComment(argsStr), MethodUtil.Argument.class)) == null || methodArgs.isEmpty()) {
            return "";
        }
        String s = "";
        for (int i = 0; i < methodArgs.size(); ++i) {
            String sn;
            MethodUtil.Argument arg = (MethodUtil.Argument)methodArgs.get(i);
            String string2 = sn = arg == null ? null : arg.getType();
            if (sn == null) {
                String string3 = sn = arg.getValue() == null ? Object.class.getSimpleName() : MethodUtil.trimType(arg.getValue().getClass());
            }
            if (i > 0) {
                s = s + ",";
            }
            s = s + sn;
        }
        return s;
    }

    @Deprecated
    public String getMethodDefination(@NotNull JSONObject curObj) throws IllegalArgumentException {
        return this.getMethodDefination(curObj, "method", "arguments", "genericType", "genericExceptions", "Java");
    }

    public String getMethodDefinition(@NotNull JSONObject curObj) throws IllegalArgumentException {
        return this.getMethodDefinition(curObj, "method", "arguments", "genericType", "genericExceptions", "Java");
    }

    @Deprecated
    public String getMethodDefination(@NotNull JSONObject curObj, String method, String arguments, String type, String exceptions, String language) throws IllegalArgumentException {
        return this.getMethodDefinition(curObj, method, arguments, type, exceptions, language);
    }

    public String getMethodDefinition(@NotNull JSONObject curObj, String method, String arguments, String type, String exceptions, String language) throws IllegalArgumentException {
        String n = curObj.getString(method);
        if (StringUtil.isEmpty((String)n, (boolean)true)) {
            throw new NullPointerException("getMethodDefination  StringUtil.isEmpty(methodArgs, true) !");
        }
        String a = curObj.getString(arguments);
        String t = curObj.getString(type);
        String e = curObj.getString(exceptions);
        if (language == null) {
            language = "";
        }
        switch (language) {
            case "TypeScript": {
                return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : ": " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
            }
            case "Go": {
                return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : " " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
            }
        }
        return n + "(" + (StringUtil.isEmpty((String)a, (boolean)true) ? "" : a) + ")" + (StringUtil.isEmpty((String)t, (boolean)true) ? "" : ": " + t) + (StringUtil.isEmpty((String)e, (boolean)true) ? "" : " throws " + e);
    }

    public String getMethodRequest(@NotNull JSONObject curObj) {
        String req = curObj.getString("request");
        if (!StringUtil.isEmpty((String)req, (boolean)true)) {
            return req;
        }
        req = "{";
        Boolean isStatic = curObj.getBoolean("static");
        String methodArgs = curObj.getString("methodArgs");
        String classArgs = curObj.getString("classArgs");
        boolean comma = false;
        if (isStatic != null && isStatic.booleanValue()) {
            req = req + "\n    \"static\": true";
            comma = true;
        }
        if (!StringUtil.isEmpty((String)methodArgs, (boolean)true)) {
            req = req + (comma ? "," : "") + "\n    \"methodArgs\": " + methodArgs;
            comma = true;
        }
        if (!StringUtil.isEmpty((String)classArgs, (boolean)true)) {
            req = req + (comma ? "," : "") + "\n    \"classArgs\": " + classArgs;
        }
        req = req + "\n}";
        return req;
    }

    public static String removeComment(String json) {
        return json == null ? null : json.replaceAll("(//.*)|(/\\*[\\s\\S]*?\\*/)", "");
    }
}

