/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.RequestMethod;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONCreator;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.Join;
import apijson.orm.SQLConfig;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.List;

public class APIJSONSQLConfig
extends AbstractSQLConfig {
    public static final String TAG = "APIJSONSQLConfig";
    public static AbstractSQLConfig.Callback<? extends Object> SIMPLE_CALLBACK;
    public static APIJSONCreator<? extends Object> APIJSON_CREATOR;

    public String getDBVersion() {
        if (this.isMySQL()) {
            return "5.7.22";
        }
        if (this.isPostgreSQL()) {
            return "9.6.15";
        }
        if (this.isSQLServer()) {
            return "2016";
        }
        if (this.isOracle()) {
            return "18c";
        }
        return null;
    }

    @JSONField(serialize=false)
    public String getDBUri() {
        if (this.isMySQL()) {
            return "jdbc:mysql://localhost:3306";
        }
        if (this.isPostgreSQL()) {
            return "jdbc:postgresql://localhost:5432/postgres";
        }
        if (this.isSQLServer()) {
            return "jdbc:jtds:sqlserver://localhost:1433/pubs;instance=SQLEXPRESS";
        }
        if (this.isOracle()) {
            return "jdbc:oracle:thin:@localhost:1521:orcl";
        }
        return null;
    }

    @JSONField(serialize=false)
    public String getDBAccount() {
        if (this.isMySQL()) {
            return "root";
        }
        if (this.isPostgreSQL()) {
            return "postgres";
        }
        if (this.isSQLServer()) {
            return "sa";
        }
        if (this.isOracle()) {
            return "scott";
        }
        return null;
    }

    @JSONField(serialize=false)
    public String getDBPassword() {
        if (this.isMySQL()) {
            return "apijson";
        }
        if (this.isPostgreSQL()) {
            return null;
        }
        if (this.isSQLServer()) {
            return "apijson@123";
        }
        if (this.isOracle()) {
            return "tiger";
        }
        return null;
    }

    public String getConfigDatabase() {
        return this.getDatabase();
    }

    public String getConfigSchema() {
        return this.getSchema();
    }

    public boolean isConfigTable() {
        return CONFIG_TABLE_LIST.contains(this.getTable());
    }

    public String getSQLDatabase() {
        String db = this.isConfigTable() ? this.getConfigDatabase() : super.getSQLDatabase();
        return db == null ? DEFAULT_DATABASE : db;
    }

    public String getSQLSchema() {
        String sch = this.isConfigTable() ? this.getConfigSchema() : super.getSQLSchema();
        return sch == null ? DEFAULT_SCHEMA : sch;
    }

    public String getIdKey() {
        return SIMPLE_CALLBACK.getIdKey(this.getDatabase(), this.getSchema(), this.getDatasource(), this.getTable());
    }

    public String getUserIdKey() {
        return SIMPLE_CALLBACK.getUserIdKey(this.getDatabase(), this.getSchema(), this.getDatasource(), this.getTable());
    }

    public APIJSONSQLConfig() {
        this(RequestMethod.GET);
    }

    public APIJSONSQLConfig(RequestMethod method) {
        super(method);
    }

    public APIJSONSQLConfig(RequestMethod method, String table) {
        super(method, table);
    }

    public APIJSONSQLConfig(RequestMethod method, int count, int page) {
        super(method, count, page);
    }

    public static SQLConfig newSQLConfig(RequestMethod method, String table, String alias, JSONObject request, List<Join> joinList, boolean isProcedure) throws Exception {
        return APIJSONSQLConfig.newSQLConfig((RequestMethod)method, (String)table, (String)alias, (JSONObject)request, joinList, (boolean)isProcedure, SIMPLE_CALLBACK);
    }

    static {
        DEFAULT_DATABASE = "MYSQL";
        DEFAULT_SCHEMA = "sys";
        APIJSON_CREATOR = new APIJSONCreator();
        SIMPLE_CALLBACK = new AbstractSQLConfig.SimpleCallback<Object>(){

            public SQLConfig getSQLConfig(RequestMethod method, String database, String schema, String datasource, String table) {
                SQLConfig config = APIJSON_CREATOR.createSQLConfig();
                config.setMethod(method);
                config.setDatabase(database);
                config.setDatasource(datasource);
                config.setSchema(schema);
                config.setTable(table);
                return config;
            }

            public String getUserIdKey(String database, String schema, String datasource, String table) {
                return "User".equals(table) || "Privacy".equals(table) ? APIJSONConstant.ID : APIJSONConstant.USER_ID;
            }
        };
    }
}

