/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.NotNull;
import apijson.framework.APIJSONController;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONFunctionParser;
import apijson.framework.APIJSONParser;
import apijson.framework.APIJSONSQLConfig;
import apijson.framework.APIJSONVerifier;
import java.rmi.ServerException;

public class APIJSONApplication {
    @NotNull
    public static APIJSONCreator DEFAULT_APIJSON_CREATOR = new APIJSONCreator();

    public static void init() throws ServerException {
        APIJSONApplication.init(true, DEFAULT_APIJSON_CREATOR);
    }

    public static void init(boolean shutdownWhenServerError) throws ServerException {
        APIJSONApplication.init(shutdownWhenServerError, DEFAULT_APIJSON_CREATOR);
    }

    public static void init(@NotNull APIJSONCreator creator) throws ServerException {
        APIJSONApplication.init(true, creator);
    }

    public static void init(boolean shutdownWhenServerError, @NotNull APIJSONCreator creator) throws ServerException {
        System.out.println("\n\n\n\n\n<<<<<<<<<<<<<<<<<<<<<<<<< APIJSON \u5f00\u59cb\u542f\u52a8 >>>>>>>>>>>>>>>>>>>>>>>>\n");
        DEFAULT_APIJSON_CREATOR = creator;
        APIJSONSQLConfig.APIJSON_CREATOR = creator;
        APIJSONParser.APIJSON_CREATOR = creator;
        APIJSONController.APIJSON_CREATOR = creator;
        System.out.println("\n\n\n\u5f00\u59cb\u521d\u59cb\u5316: \u6743\u9650\u6821\u9a8c\u914d\u7f6e <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
        try {
            APIJSONVerifier.initAccess(shutdownWhenServerError, creator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n\u5b8c\u6210\u521d\u59cb\u5316: \u6743\u9650\u6821\u9a8c\u914d\u7f6e >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        System.out.println("\n\n\n\u5f00\u59cb\u521d\u59cb\u5316: \u8fdc\u7a0b\u51fd\u6570\u914d\u7f6e <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
        try {
            APIJSONFunctionParser.init(shutdownWhenServerError, creator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n\u5b8c\u6210\u521d\u59cb\u5316: \u8fdc\u7a0b\u51fd\u6570\u914d\u7f6e >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        System.out.println("\u5f00\u59cb\u6d4b\u8bd5: \u8fdc\u7a0b\u51fd\u6570 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
        try {
            APIJSONFunctionParser.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n\u5b8c\u6210\u6d4b\u8bd5: \u8fdc\u7a0b\u51fd\u6570 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        System.out.println("\n\n\n\u5f00\u59cb\u521d\u59cb\u5316: \u8bf7\u6c42\u7ed3\u6784\u6821\u9a8c\u914d\u7f6e <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
        try {
            APIJSONVerifier.initRequest(shutdownWhenServerError, creator);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n\u5b8c\u6210\u521d\u59cb\u5316: \u8bf7\u6c42\u7ed3\u6784\u6821\u9a8c\u914d\u7f6e >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        System.out.println("\n\n\n\u5f00\u59cb\u6d4b\u8bd5: Request \u548c Response \u7684\u6570\u636e\u7ed3\u6784\u6821\u9a8c <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
        try {
            APIJSONVerifier.testStructure();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n\u5b8c\u6210\u6d4b\u8bd5: Request \u548c Response \u7684\u6570\u636e\u7ed3\u6784\u6821\u9a8c >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        System.out.println("\n\n<<<<<<<<<<<<<<<<<<<<<<<<< APIJSON \u542f\u52a8\u5b8c\u6210\uff0c\u8bd5\u8bd5\u8c03\u7528\u81ea\u52a8\u5316 API \u5427 ^_^ >>>>>>>>>>>>>>>>>>>>>>>>\n");
    }
}

