/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.NotNull;
import apijson.RequestMethod;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONFunctionParser;
import apijson.framework.APIJSONObjectParser;
import apijson.framework.APIJSONVerifier;
import apijson.orm.AbstractParser;
import apijson.orm.FunctionParser;
import apijson.orm.Parser;
import apijson.orm.SQLConfig;
import apijson.orm.SQLExecutor;
import apijson.orm.Verifier;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class APIJSONParser
extends AbstractParser<Long> {
    public static final String TAG = "APIJSONParser";
    @NotNull
    public static APIJSONCreator APIJSON_CREATOR = new APIJSONCreator();
    private HttpSession session;
    private FunctionParser functionParser;

    public APIJSONParser() {
    }

    public APIJSONParser(RequestMethod method) {
        super(method);
    }

    public APIJSONParser(RequestMethod method, boolean needVerify) {
        super(method, needVerify);
    }

    public HttpSession getSession() {
        return this.session;
    }

    public APIJSONParser setSession(HttpSession session) {
        this.session = session;
        this.setVisitor(APIJSONVerifier.getVisitor(session));
        return this;
    }

    public Parser<Long> createParser() {
        return APIJSON_CREATOR.createParser();
    }

    public FunctionParser createFunctionParser() {
        return APIJSON_CREATOR.createFunctionParser();
    }

    public Verifier<Long> createVerifier() {
        return APIJSON_CREATOR.createVerifier();
    }

    public SQLConfig createSQLConfig() {
        return APIJSON_CREATOR.createSQLConfig();
    }

    public SQLExecutor createSQLExecutor() {
        return APIJSON_CREATOR.createSQLExecutor();
    }

    public JSONObject parseResponse(JSONObject request) {
        if (this.session != null && request != null) {
            if (request.get((Object)"format") == null) {
                request.put("format", this.session.getAttribute("format"));
            }
            if (request.get((Object)"defaults") == null) {
                Set set;
                JSONObject defaults = (JSONObject)this.session.getAttribute("defaults");
                Set set2 = set = defaults == null ? null : defaults.entrySet();
                if (set != null) {
                    for (Map.Entry e : set) {
                        if (e == null || request.get(e.getKey()) != null) continue;
                        request.put((String)e.getKey(), e.getValue());
                    }
                }
            }
        }
        return super.parseResponse(request);
    }

    public FunctionParser getFunctionParser() {
        return this.functionParser;
    }

    public Object onFunctionParse(String key, String function, String parentPath, String currentName, JSONObject currentObject) throws Exception {
        if (this.functionParser == null) {
            this.functionParser = this.createFunctionParser();
            this.functionParser.setMethod(this.getMethod());
            this.functionParser.setTag(this.getTag());
            this.functionParser.setVersion(this.getVersion());
            this.functionParser.setRequest(this.requestObject);
            if (this.functionParser instanceof APIJSONFunctionParser) {
                ((APIJSONFunctionParser)this.functionParser).setSession(this.getSession());
            }
        }
        this.functionParser.setKey(key);
        this.functionParser.setParentPath(parentPath);
        this.functionParser.setCurrentName(currentName);
        this.functionParser.setCurrentObject(currentObject);
        return this.functionParser.invoke(function, currentObject);
    }

    public APIJSONObjectParser createObjectParser(JSONObject request, String parentPath, String name, SQLConfig arrayConfig, boolean isSubquery) throws Exception {
        return new APIJSONObjectParser(this.getSession(), request, parentPath, name, arrayConfig, isSubquery){}.setMethod(this.getMethod()).setParser(this);
    }

    public void onVerifyContent() throws Exception {
        HttpSession session = this.getSession();
        if (session != null && this.requestObject.get((Object)"version") == null) {
            this.requestObject.put("version", session.getAttribute("version"));
        }
        super.onVerifyContent();
    }
}

