/*
 * Decompiled with CFR 0.152.
 */
package apijson.column;

import apijson.RequestMethod;
import apijson.StringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class ColumnUtil {
    public static SortedMap<Integer, Map<String, List<String>>> VERSIONED_TABLE_COLUMN_MAP;
    public static SortedMap<Integer, Map<String, Map<String, String>>> VERSIONED_KEY_COLUMN_MAP;
    private static SortedMap<Integer, Map<String, Map<String, String>>> VERSIONED_COLUMN_KEY_MAP;
    public static final Comparator<Integer> DESC_COMPARATOR;

    public static void init() {
        Set<Map.Entry<Integer, Map<String, List<String>>>> allSet;
        VERSIONED_COLUMN_KEY_MAP.clear();
        Set<Map.Entry<Integer, Map<String, Map<String, String>>>> set = VERSIONED_KEY_COLUMN_MAP.entrySet();
        if (set != null && !set.isEmpty()) {
            TreeMap<Integer, Map<String, Map<String, String>>> map = new TreeMap<Integer, Map<String, Map<String, String>>>(DESC_COMPARATOR);
            for (Map.Entry<Integer, Map<String, Object>> entry : set) {
                Map<String, Object> tableKeyColumnMap = entry == null ? null : entry.getValue();
                Set<Map.Entry<String, Object>> tableKeyColumnSet = tableKeyColumnMap == null ? null : tableKeyColumnMap.entrySet();
                if (tableKeyColumnSet == null || tableKeyColumnSet.isEmpty()) continue;
                HashMap tableColumnKeyMap = new HashMap();
                for (Map.Entry<String, Object> tableKeyColumnEntry : tableKeyColumnSet) {
                    Map keyColumnMap = tableKeyColumnEntry == null ? null : (Map)tableKeyColumnEntry.getValue();
                    Set keyColumnSet = keyColumnMap == null ? null : keyColumnMap.entrySet();
                    if (keyColumnSet == null || keyColumnSet.isEmpty()) continue;
                    HashMap<String, String> columnKeyMap = new HashMap<String, String>();
                    for (Map.Entry keyColumnEntry : keyColumnSet) {
                        if (keyColumnEntry == null) continue;
                        columnKeyMap.put((String)keyColumnEntry.getValue(), (String)keyColumnEntry.getKey());
                    }
                    tableColumnKeyMap.put(tableKeyColumnEntry.getKey(), columnKeyMap);
                }
                map.put(entry.getKey(), tableColumnKeyMap);
            }
            VERSIONED_COLUMN_KEY_MAP = map;
        }
        if ((allSet = VERSIONED_TABLE_COLUMN_MAP.entrySet()) != null && !allSet.isEmpty()) {
            for (Map.Entry<Integer, Map<String, Object>> entry : allSet) {
                Map<String, Object> tableKeyColumnMap;
                Set<Map.Entry<String, Object>> tableKeyColumnSet;
                LinkedHashMap keyColumnMap = (LinkedHashMap)VERSIONED_KEY_COLUMN_MAP.get(entry.getKey());
                if (keyColumnMap == null) {
                    keyColumnMap = new LinkedHashMap();
                    VERSIONED_KEY_COLUMN_MAP.put(entry.getKey(), keyColumnMap);
                }
                if ((tableKeyColumnSet = (tableKeyColumnMap = entry == null ? null : entry.getValue()) == null ? null : tableKeyColumnMap.entrySet()) == null || tableKeyColumnSet.isEmpty()) continue;
                for (Map.Entry<String, Object> tableKeyColumnEntry : tableKeyColumnSet) {
                    List list = tableKeyColumnEntry == null ? null : (List)tableKeyColumnEntry.getValue();
                    if (list == null || list.isEmpty()) continue;
                    LinkedHashMap<String, String> kcm = (LinkedHashMap<String, String>)keyColumnMap.get(tableKeyColumnEntry.getKey());
                    if (kcm == null) {
                        kcm = new LinkedHashMap<String, String>();
                        keyColumnMap.put(tableKeyColumnEntry.getKey(), kcm);
                    }
                    for (String column : list) {
                        if (column == null) continue;
                        kcm.putIfAbsent(column, column);
                    }
                }
            }
        }
    }

    public static List<String> compatInputColumn(List<String> columns, String table, RequestMethod method) {
        return ColumnUtil.compatInputColumn(columns, table, method, null, false);
    }

    public static List<String> compatInputColumn(List<String> columns, String table, RequestMethod method, Integer version, boolean throwWhenNoKey) {
        List allColumns;
        String[] keys;
        String[] stringArray = keys = columns == null ? null : columns.toArray(new String[0]);
        if (keys == null || keys.length <= 0) {
            return columns != null ? columns : (List)ColumnUtil.getClosestValue(VERSIONED_TABLE_COLUMN_MAP, version, table);
        }
        ArrayList<String> exceptColumns = new ArrayList<String>();
        ArrayList<String> newColumns = new ArrayList<String>();
        Map keyColumnMap = (Map)ColumnUtil.getClosestValue(VERSIONED_KEY_COLUMN_MAP, version, table);
        boolean isEmpty = keyColumnMap == null || keyColumnMap.isEmpty();
        String q = "`";
        for (int i = 0; i < keys.length; ++i) {
            String expression = keys[i];
            int start = expression.indexOf("(");
            int end = expression.lastIndexOf(")");
            if (start >= 0 && start < end) {
                String[] ks = StringUtil.split((String)expression.substring(start + 1, end));
                Object expr = expression.substring(0, start + 1);
                for (int j = 0; j < ks.length; ++j) {
                    String nck;
                    String ck = ks[j];
                    boolean hasQuote = false;
                    if (ck.endsWith("`") && (nck = ck.substring(0, ck.length() - 1)).lastIndexOf("`") == 0) {
                        ck = nck.substring(1);
                        hasQuote = true;
                    }
                    String rc = null;
                    if (hasQuote || StringUtil.isName((String)ck)) {
                        String string = rc = isEmpty ? null : (String)keyColumnMap.get(ck);
                        if (rc == null && !isEmpty && throwWhenNoKey) {
                            throw new NullPointerException(table + ":{ @column: value } \u7684 value \u4e2d " + ck + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20\u540e\u7aef\u672a\u6388\u6743\u8bbf\u95ee\u7684\u5b57\u6bb5\u540d\uff01");
                        }
                    }
                    expr = (String)expr + (j <= 0 ? "" : ",") + (hasQuote ? q : "") + (rc == null ? ck : rc) + (hasQuote ? q : "");
                }
                newColumns.add((String)expr + expression.substring(end));
                continue;
            }
            String[] ckeys = StringUtil.split((String)expression);
            if (ckeys == null || ckeys.length <= 0) continue;
            for (int j = 0; j < ckeys.length; ++j) {
                String nck;
                String rc;
                String ck = ckeys[j];
                if (ck.startsWith("!")) {
                    if (ck.length() <= 1) {
                        throw new IllegalArgumentException("@column:value \u7684 value \u4e2d " + ck + " \u4e0d\u5408\u6cd5\uff01 !column \u4e0d\u5141\u8bb8 column \u4e3a\u7a7a\u5b57\u7b26\u4e32\uff01column,!column2,!column3,column4:alias4 \u4e2d\u6240\u6709 column \u5fc5\u987b\u7b26\u5408\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
                    }
                    String c = ck.substring(1);
                    if (!StringUtil.isName((String)c)) {
                        throw new IllegalArgumentException("@column:value \u7684 value \u4e2d " + c + " \u4e0d\u5408\u6cd5\uff01 column,!column2,!column3,column4:alias4 \u4e2d\u6240\u6709 column \u5fc5\u987b\u7b26\u5408\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
                    }
                    rc = isEmpty ? null : (String)keyColumnMap.get(c);
                    exceptColumns.add(rc == null ? c : rc);
                    continue;
                }
                boolean hasQuote = false;
                if (ck.endsWith("`") && (nck = ck.substring(0, ck.length() - 1)).lastIndexOf("`") == 0) {
                    ck = nck.substring(1);
                    hasQuote = true;
                }
                rc = null;
                if (hasQuote || StringUtil.isName((String)ck)) {
                    String string = rc = isEmpty ? null : (String)keyColumnMap.get(ck);
                    if (rc == null && !isEmpty && throwWhenNoKey) {
                        throw new NullPointerException(table + ":{ @column: value } \u7684 value \u4e2d " + ck + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20\u540e\u7aef\u672a\u6388\u6743\u8bbf\u95ee\u7684\u5b57\u6bb5\u540d\uff01");
                    }
                }
                newColumns.add(rc == null ? ck : rc);
            }
        }
        List list = allColumns = exceptColumns == null || exceptColumns.isEmpty() ? null : (List)ColumnUtil.getClosestValue(VERSIONED_TABLE_COLUMN_MAP, version, table);
        if (allColumns != null && !allColumns.isEmpty()) {
            for (String c : allColumns) {
                if (c == null || exceptColumns.contains(c)) continue;
                newColumns.add(c);
            }
        }
        return newColumns;
    }

    public static String compatInputKey(String key, String table, RequestMethod method) {
        return ColumnUtil.compatInputKey(key, table, method, null, false);
    }

    public static String compatInputKey(String key, String table, RequestMethod method, Integer version, boolean throwWhenNoKey) {
        String alias;
        Map keyColumnMap = (Map)ColumnUtil.getClosestValue(VERSIONED_KEY_COLUMN_MAP, version, table);
        boolean isEmpty = keyColumnMap == null || keyColumnMap.isEmpty();
        String string = alias = isEmpty ? null : (String)keyColumnMap.get(key);
        if (alias == null) {
            if (!isEmpty && throwWhenNoKey) {
                throw new NullPointerException(table + ":{} \u4e2d\u4e0d\u5141\u8bb8\u4f20 " + key + " \uff01");
            }
            return key;
        }
        return alias;
    }

    public static String compatOutputKey(String key, String table, RequestMethod method) {
        return ColumnUtil.compatOutputKey(key, table, method, null);
    }

    public static String compatOutputKey(String key, String table, RequestMethod method, Integer version) {
        Map columnKeyMap = (Map)ColumnUtil.getClosestValue(VERSIONED_COLUMN_KEY_MAP, version, table);
        String alias = columnKeyMap == null || columnKeyMap.isEmpty() ? null : (String)columnKeyMap.get(key);
        return alias == null ? key : alias;
    }

    public static <T> T getClosestValue(SortedMap<Integer, Map<String, T>> versionedMap, Integer version, String table) {
        T m;
        boolean isEmpty = versionedMap == null || versionedMap.isEmpty();
        Map<String, T> map = isEmpty || version == null ? null : (Map<String, T>)versionedMap.get(version);
        T t = m = map == null ? null : (T)map.get(table);
        if (!isEmpty && m == null) {
            Set<Map.Entry<Integer, Map<String, T>>> set = versionedMap.entrySet();
            T lm = null;
            for (Map.Entry<Integer, Map<String, T>> entry : set) {
                Map<String, T> val = entry.getValue();
                m = val == null ? null : (T)val.get(table);
                if (m == null) continue;
                if (version == null || version == 0) {
                    return m;
                }
                Integer key = entry.getKey();
                if (key == null) {
                    lm = m;
                    map = val;
                    continue;
                }
                if (version < key) break;
                versionedMap.put(version, val);
                return m;
            }
            if (lm != null) {
                m = lm;
            }
            if (map != null) {
                versionedMap.put(version, map);
            }
        }
        return m;
    }

    public static String concat(String database, String schema, String datasource, String table) {
        return database + "-" + schema + "-" + datasource + "-" + table;
    }

    static {
        DESC_COMPARATOR = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        };
        VERSIONED_TABLE_COLUMN_MAP = new TreeMap<Integer, Map<String, List<String>>>(DESC_COMPARATOR);
        VERSIONED_KEY_COLUMN_MAP = new TreeMap<Integer, Map<String, Map<String, String>>>(DESC_COMPARATOR);
        VERSIONED_COLUMN_KEY_MAP = new TreeMap<Integer, Map<String, Map<String, String>>>(DESC_COMPARATOR);
    }
}

