/*
 * Decompiled with CFR 0.152.
 */
package cn.thens.okbinder2;

import android.os.IBinder;
import android.os.Parcel;
import android.util.SparseArray;
import cn.thens.okbinder2.OkBinder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OkBinderParcel {
    private static final int VAL_DEFAULT = 1;
    private static final int VAL_LIST = 2;
    private static final int VAL_SPARSE_ARRAY = 3;
    private static final int VAL_MAP = 4;
    private static final int VAL_OK_BINDER = 5;
    private static final int VAL_ARRAY = 6;

    public static void write(Parcel parcel, Object v) {
        if (v == null) {
            parcel.writeInt(1);
            parcel.writeValue(null);
        } else if (v instanceof List) {
            parcel.writeInt(2);
            List val = (List)v;
            parcel.writeInt(val.size());
            for (Object o : val) {
                OkBinderParcel.write(parcel, o);
            }
        } else if (v instanceof SparseArray) {
            parcel.writeInt(3);
            SparseArray val = (SparseArray)v;
            int size = val.size();
            parcel.writeInt(size);
            for (int i = 0; i < size; ++i) {
                parcel.writeInt(val.keyAt(i));
                OkBinderParcel.write(parcel, val.valueAt(i));
            }
        } else if (v instanceof Map) {
            parcel.writeInt(4);
            Map val = (Map)v;
            Set entries = val.entrySet();
            parcel.writeInt(entries.size());
            for (Map.Entry e : entries) {
                OkBinderParcel.write(parcel, e.getKey());
                OkBinderParcel.write(parcel, e.getValue());
            }
        } else if (v.getClass().isArray()) {
            parcel.writeInt(6);
            Class<?> componentType = v.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                parcel.writeString("");
                parcel.writeValue(v);
                return;
            }
            parcel.writeString(componentType.getName());
            Object[] val = (Object[])v;
            parcel.writeInt(val.length);
            for (Object o : val) {
                OkBinderParcel.write(parcel, o);
            }
        } else {
            Class<?> okBinderInterface = OkBinder.getOkBinderInterface(v);
            if (okBinderInterface != null) {
                parcel.writeInt(5);
                parcel.writeString(okBinderInterface.getName());
                parcel.writeValue((Object)OkBinder.create(okBinderInterface, v));
                return;
            }
            parcel.writeInt(1);
            parcel.writeValue(v);
        }
    }

    public static Object read(Parcel parcel, ClassLoader loader) throws ClassNotFoundException {
        int type = parcel.readInt();
        switch (type) {
            case 2: {
                ArrayList<Object> outVal = new ArrayList<Object>();
                int size = parcel.readInt();
                for (int i = 0; i < size; ++i) {
                    outVal.add(OkBinderParcel.read(parcel, loader));
                }
                return outVal;
            }
            case 3: {
                SparseArray outVal = new SparseArray();
                int size = parcel.readInt();
                for (int i = 0; i < size; ++i) {
                    int key = parcel.readInt();
                    Object value = OkBinderParcel.read(parcel, loader);
                    outVal.put(key, value);
                }
                return outVal;
            }
            case 4: {
                HashMap<Object, Object> outVal = new HashMap<Object, Object>();
                int size = parcel.readInt();
                for (int i = 0; i < size; ++i) {
                    Object key = OkBinderParcel.read(parcel, loader);
                    Object value = OkBinderParcel.read(parcel, loader);
                    outVal.put(key, value);
                }
                return outVal;
            }
            case 5: {
                Class<?> serviceClass = loader.loadClass(parcel.readString());
                IBinder binder = (IBinder)parcel.readValue(loader);
                return OkBinder.proxy(serviceClass, binder);
            }
            case 6: {
                String componentName = parcel.readString();
                boolean isPrimitiveComponent = "".equals(componentName);
                if (isPrimitiveComponent) {
                    return parcel.readValue(loader);
                }
                Class<?> componentClass = loader.loadClass(componentName);
                int size = parcel.readInt();
                Object[] outputVal = (Object[])Array.newInstance(componentClass, size);
                for (int i = 0; i < size; ++i) {
                    outputVal[i] = OkBinderParcel.read(parcel, loader);
                }
                return outputVal;
            }
        }
        return parcel.readValue(loader);
    }
}

