/*
 * Decompiled with CFR 0.152.
 */
package com.chinodev.androidneomorphframelayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.core.content.ContextCompat;
import com.chinodev.androidneomorphframelayout.R;

public class NeomorphFrameLayout
extends FrameLayout {
    private String SHAPE_TYPE;
    private String SHADOW_TYPE;
    private int CORNER_RADIUS;
    private int ELEVATION;
    private int HIGHLIGHT_COLOR;
    private int SHADOW_COLOR;
    private int BACKGROUND_COLOR;
    private int LAYER_TYPE;
    private boolean SHADOW_VISIBLE;
    private int SHAPE_PADDING = 0;
    private final String SHAPE_TYPE_RECTANGLE = "1";
    private final String SHAPE_TYPE_CIRCLE = "2";
    private final String SHADOW_TYPE_OUTER = "1";
    private final String SHADOW_TYPE_INNER = "2";
    private Paint basePaint;
    private Paint paintShadow;
    private Paint paintHighLight;
    private Path basePath;
    private Path pathShadow;
    private Path pathHighlight;
    private RectF rectangle;

    public NeomorphFrameLayout(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public NeomorphFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public NeomorphFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.getAttrs(context, attrs);
        this.initPaints();
        this.rectangle = new RectF((float)this.SHAPE_PADDING, (float)this.SHAPE_PADDING, (float)(this.getWidth() - this.SHAPE_PADDING), (float)(this.getHeight() - this.SHAPE_PADDING));
    }

    public void getAttrs(Context context, AttributeSet attrs) {
        int defaultElevation = (int)context.getResources().getDimension(R.dimen.neomorph_view_elevation);
        int defaultCornerRadius = (int)context.getResources().getDimension(R.dimen.neomorph_view_corner_radius);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.NeomorphFrameLayout);
            this.SHAPE_TYPE = a.getString(R.styleable.NeomorphFrameLayout_neomorph_view_type);
            if (this.SHAPE_TYPE == null) {
                this.SHAPE_TYPE = "1";
            }
            this.SHADOW_TYPE = a.getString(R.styleable.NeomorphFrameLayout_neomorph_shadow_type);
            if (this.SHADOW_TYPE == null) {
                this.SHADOW_TYPE = "1";
            }
            this.ELEVATION = a.getDimensionPixelSize(R.styleable.NeomorphFrameLayout_neomorph_elevation, defaultElevation);
            this.CORNER_RADIUS = a.getDimensionPixelSize(R.styleable.NeomorphFrameLayout_neomorph_corner_radius, defaultCornerRadius);
            this.BACKGROUND_COLOR = a.getColor(R.styleable.NeomorphFrameLayout_neomorph_background_color, ContextCompat.getColor((Context)context, (int)R.color.neomorph_background_color));
            this.SHADOW_COLOR = a.getColor(R.styleable.NeomorphFrameLayout_neomorph_shadow_color, ContextCompat.getColor((Context)context, (int)R.color.neomorph_shadow_color));
            this.HIGHLIGHT_COLOR = a.getColor(R.styleable.NeomorphFrameLayout_neomorph_highlight_color, ContextCompat.getColor((Context)context, (int)R.color.neomorph_highlight_color));
            this.SHADOW_VISIBLE = a.getBoolean(R.styleable.NeomorphFrameLayout_neomorph_shadow_visible, true);
            String layerType = a.getString(R.styleable.NeomorphFrameLayout_neomorph_layer_type);
            this.LAYER_TYPE = layerType == null || layerType.equals("1") ? 1 : 2;
            a.recycle();
        } else {
            this.SHAPE_TYPE = "rectangle";
            this.ELEVATION = defaultElevation;
            this.CORNER_RADIUS = defaultCornerRadius;
            this.BACKGROUND_COLOR = ContextCompat.getColor((Context)context, (int)R.color.neomorph_background_color);
            this.SHADOW_COLOR = ContextCompat.getColor((Context)context, (int)R.color.neomorph_shadow_color);
            this.HIGHLIGHT_COLOR = ContextCompat.getColor((Context)context, (int)R.color.neomorph_highlight_color);
            this.LAYER_TYPE = 1;
            this.SHADOW_VISIBLE = true;
            this.SHADOW_TYPE = "1";
        }
    }

    private void initPaints() {
        this.basePaint = new Paint(1);
        this.paintShadow = new Paint(1);
        this.paintHighLight = new Paint(1);
        this.basePaint.setColor(this.BACKGROUND_COLOR);
        this.paintShadow.setColor(this.BACKGROUND_COLOR);
        this.paintHighLight.setColor(this.BACKGROUND_COLOR);
        if (this.SHADOW_VISIBLE) {
            this.paintShadow.setShadowLayer((float)this.ELEVATION, (float)this.ELEVATION, (float)this.ELEVATION, this.SHADOW_COLOR);
            this.paintHighLight.setShadowLayer((float)this.ELEVATION, (float)(-this.ELEVATION), (float)(-this.ELEVATION), this.HIGHLIGHT_COLOR);
        }
        this.basePath = new Path();
        this.pathHighlight = new Path();
        this.pathShadow = new Path();
        this.SHAPE_PADDING = this.ELEVATION * 2;
        this.setWillNotDraw(false);
        this.setLayerType(this.LAYER_TYPE, null);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.rectangle = new RectF((float)this.SHAPE_PADDING, (float)this.SHAPE_PADDING, (float)(this.getWidth() - this.SHAPE_PADDING), (float)(this.getHeight() - this.SHAPE_PADDING));
        this.resetPath(w, h);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setPadding(this.SHAPE_PADDING, this.SHAPE_PADDING, this.SHAPE_PADDING, this.SHAPE_PADDING);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        switch (this.SHADOW_TYPE) {
            case "2": {
                canvas.clipPath(this.basePath);
                break;
            }
        }
        if (this.SHADOW_VISIBLE) {
            this.paintShadow.setAlpha(155);
            this.paintHighLight.setAlpha(155);
        } else {
            this.paintShadow.setAlpha(0);
            this.paintHighLight.setAlpha(0);
        }
        canvas.drawPath(this.basePath, this.basePaint);
        canvas.drawPath(this.pathShadow, this.paintShadow);
        canvas.drawPath(this.pathHighlight, this.paintHighLight);
    }

    private void resetPath(int w, int h) {
        this.basePath.reset();
        this.pathHighlight.reset();
        this.pathShadow.reset();
        switch (this.SHAPE_TYPE) {
            case "2": {
                int maxDiameter = this.getWidth() < this.getHeight() ? this.getWidth() : this.getHeight();
                int radius = maxDiameter / 2 - this.SHAPE_PADDING;
                this.basePath.addCircle((float)(w / 2), (float)(h / 2), (float)radius, Path.Direction.CW);
                this.pathHighlight.addCircle((float)(w / 2), (float)(h / 2), (float)radius, Path.Direction.CW);
                this.pathShadow.addCircle((float)(w / 2), (float)(h / 2), (float)radius, Path.Direction.CW);
                break;
            }
            default: {
                this.basePath.addRoundRect(this.rectangle, (float)this.CORNER_RADIUS, (float)this.CORNER_RADIUS, Path.Direction.CW);
                this.pathHighlight.addRoundRect(this.rectangle, (float)this.CORNER_RADIUS, (float)this.CORNER_RADIUS, Path.Direction.CW);
                this.pathShadow.addRoundRect(this.rectangle, (float)this.CORNER_RADIUS, (float)this.CORNER_RADIUS, Path.Direction.CW);
            }
        }
        if (this.SHADOW_TYPE.equals("2")) {
            if (!this.pathHighlight.isInverseFillType()) {
                this.pathHighlight.toggleInverseFillType();
            }
            if (!this.pathShadow.isInverseFillType()) {
                this.pathShadow.toggleInverseFillType();
            }
        }
        this.basePath.close();
        this.pathHighlight.close();
        this.pathShadow.close();
    }

    public void setShadowInner() {
        this.SHADOW_VISIBLE = true;
        this.SHADOW_TYPE = "2";
        this.initPaints();
        this.resetPath(this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public void setShadowOuter() {
        this.SHADOW_VISIBLE = true;
        this.SHADOW_TYPE = "1";
        this.initPaints();
        this.resetPath(this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public void switchShadowType() {
        this.SHADOW_VISIBLE = true;
        this.SHADOW_TYPE = this.SHADOW_TYPE.equals("2") ? "1" : "2";
        this.initPaints();
        this.resetPath(this.getWidth(), this.getHeight());
        this.invalidate();
    }

    public void setShadowNone() {
        this.SHADOW_VISIBLE = false;
        this.initPaints();
        this.resetPath(this.getWidth(), this.getHeight());
        this.invalidate();
    }
}

