/*
 * Decompiled with CFR 0.152.
 */
package winium.elements.desktop;

import java.util.HashMap;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import winium.elements.desktop.DesktopElement;

public class DataGrid
extends DesktopElement {
    static final String FIND_DATA_GRID_CELL = "findDataGridCell";
    static final String GET_DATA_GRID_COLUMN_COUNT = "getDataGridColumnCount";
    static final String GET_DATA_GRID_ROW_COUNT = "getDataGridRowCount";
    static final String SCROLL_TO_DATA_GRID_CELL = "scrollToDataGridCell";
    static final String SELECT_DATA_GRID_CELL = "selectDataGridCell";

    private Response callDataGridCellCommand(String command, int row, int column) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", this.getId());
        parameters.put("row", row);
        parameters.put("column", column);
        return this.execute(command, parameters);
    }

    public DataGrid(WebElement element) {
        super(element);
    }

    public int getColumnCount() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", this.getId());
        Response response = this.execute(GET_DATA_GRID_COLUMN_COUNT, parameters);
        return Integer.parseInt(response.getValue().toString());
    }

    public int getRowCount() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("id", this.getId());
        Response response = this.execute(GET_DATA_GRID_ROW_COUNT, parameters);
        return Integer.parseInt(response.getValue().toString());
    }

    public RemoteWebElement find(int row, int column) {
        return this.createRemoteWebElementFromResponse(this.callDataGridCellCommand(FIND_DATA_GRID_CELL, row, column));
    }

    public void scrollTo(int row, int column) {
        this.callDataGridCellCommand(SCROLL_TO_DATA_GRID_CELL, row, column);
    }

    public void select(int row, int column) {
        this.callDataGridCellCommand(SELECT_DATA_GRID_CELL, row, column);
    }
}

